/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.springframework.ide.eclipse.core.SpringCore;

public class SpringCorePreferences {
    private final String propertyNamespace;
    private IEclipsePreferences preferences;

    private SpringCorePreferences(IProject project, String qualifier) {
        this.propertyNamespace = String.valueOf(qualifier) + '.';
        this.preferences = this.getEclipsePreferences(project, qualifier);
    }

    public static SpringCorePreferences getProjectPreferences(IProject project) {
        return SpringCorePreferences.getProjectPreferences(project, "org.springframework.ide.eclipse.core");
    }

    public static SpringCorePreferences getProjectPreferences(IProject project, String qualifier) {
        return new SpringCorePreferences(project, qualifier);
    }

    private IEclipsePreferences getEclipsePreferences(IProject project, String qualifier) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        return node;
    }

    public void putString(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        try {
            this.preferences.put(String.valueOf(this.propertyNamespace) + key, value);
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            SpringCore.log(e);
        }
    }

    public void putBoolean(String key, boolean value) {
        if (key == null) {
            return;
        }
        try {
            this.preferences.putBoolean(String.valueOf(this.propertyNamespace) + key, value);
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            SpringCore.log(e);
        }
    }

    public String getString(String key, String defaultValue) {
        return this.preferences.get(String.valueOf(this.propertyNamespace) + key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.preferences.getBoolean(String.valueOf(this.propertyNamespace) + key, defaultValue);
    }

    public IEclipsePreferences getProjectPreferences() {
        return this.preferences;
    }
}

