/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core;

import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCorePreferences;

public abstract class PersistablePreferenceObjectSupport {
    private boolean isEnabledByDefault = true;

    protected abstract String getPreferenceId();

    protected boolean hasProjectSpecificOptions(IProject project) {
        return SpringCorePreferences.getProjectPreferences(project).getBoolean("enable.project.preferences", false);
    }

    public boolean isEnabled(IProject project) {
        if (project != null && this.hasProjectSpecificOptions(project)) {
            return SpringCorePreferences.getProjectPreferences(project).getBoolean(this.getPreferenceId(), this.isEnabledByDefault);
        }
        return SpringCore.getDefault().getPluginPreferences().getBoolean(this.getPreferenceIdForPluginPreference());
    }

    public boolean isEnabledByDefault() {
        return this.isEnabledByDefault;
    }

    public void setEnabled(boolean isEnabled, IProject project) {
        if (project != null) {
            SpringCorePreferences.getProjectPreferences(project).putBoolean(this.getPreferenceId(), isEnabled);
        } else {
            SpringCore.getDefault().getPluginPreferences().setValue(this.getPreferenceIdForPluginPreference(), isEnabled);
        }
        this.onEnablementChanged(isEnabled, project);
    }

    private String getPreferenceIdForPluginPreference() {
        return "org.springframework.ide.eclipse.core." + this.getPreferenceId();
    }

    protected void setEnabledByDefault(boolean isEnabledByDefault) {
        this.isEnabledByDefault = isEnabledByDefault;
        SpringCore.getDefault().getPluginPreferences().setDefault(this.getPreferenceIdForPluginPreference(), this.isEnabledByDefault);
    }

    protected void onEnablementChanged(boolean isEnabled, IProject project) {
    }
}

