/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springframework.ide.eclipse.boot.core.StarterId;
import org.springframework.ide.eclipse.boot.core.internal.SpringBootProject;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenSpringBootProject
extends SpringBootProject {
    private static final List<SpringBootStarter> NO_STARTERS = Arrays.asList(new SpringBootStarter[0]);
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");
    private IProject project;

    public MavenSpringBootProject(IProject project) {
        Assert.isNotNull((Object)project);
        this.project = project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public List<SpringBootStarter> getKnownStarters() throws CoreException {
        MavenProject mp = this.getMavenProject();
        DependencyManagement depMan = mp.getDependencyManagement();
        if (depMan != null) {
            List deps = depMan.getDependencies();
            return this.getStarters(deps);
        }
        return NO_STARTERS;
    }

    private MavenProject getMavenProject() throws CoreException {
        IMavenProjectRegistry pr = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade mpf = pr.getProject(this.project);
        MavenProject mp = mpf.getMavenProject((IProgressMonitor)new NullProgressMonitor());
        return mp;
    }

    private IFile getPomFile() {
        return this.project.getFile((IPath)new Path("pom.xml"));
    }

    @Override
    public List<SpringBootStarter> getBootStarters() throws CoreException {
        return this.getStarters(this.getMavenProject().getDependencies());
    }

    private List<SpringBootStarter> getStarters(List<Dependency> deps) {
        if (deps != null) {
            ArrayList<SpringBootStarter> starters = new ArrayList<SpringBootStarter>();
            for (Dependency _dep : deps) {
                MavenCoordinates dep = new MavenCoordinates(_dep.getGroupId(), _dep.getArtifactId(), _dep.getVersion());
                if (!SpringBootStarter.isStarter(dep)) continue;
                starters.add(new SpringBootStarter(dep));
            }
            return starters;
        }
        return NO_STARTERS;
    }

    @Override
    public void removeStarter(SpringBootStarter starter) throws CoreException {
        try {
            List<SpringBootStarter> starters = this.getBootStarters();
            boolean changed = starters.remove(starter);
            if (changed) {
                this.setStarters(starters);
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.coreException((Throwable)e);
        }
    }

    @Override
    public void addStarter(SpringBootStarter starter) throws CoreException {
        try {
            List<SpringBootStarter> starters = this.getBootStarters();
            boolean changed = starters.add(starter);
            if (changed) {
                this.setStarters(starters);
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.coreException((Throwable)e);
        }
    }

    private String getManagedVersion(MavenCoordinates dep) {
        try {
            List deps;
            DependencyManagement managedDeps = this.getMavenProject().getDependencyManagement();
            if (managedDeps != null && (deps = managedDeps.getDependencies()) != null && !deps.isEmpty()) {
                for (Dependency d : deps) {
                    if (!"jar".equals(d.getType()) || !dep.getArtifactId().equals(d.getArtifactId()) || !dep.getGroupId().equals(d.getGroupId())) continue;
                    return d.getVersion();
                }
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return null;
    }

    private void debug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    @Override
    public void addMavenDependency(final MavenCoordinates dep, final boolean preferManagedVersion) throws CoreException {
        try {
            IFile file = this.getPomFile();
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(file, new PomEdits.Operation(){

                public void process(Document document) {
                    Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencies"});
                    if (depsEl != null) {
                        String version = dep.getVersion();
                        String managedVersion = MavenSpringBootProject.this.getManagedVersion(dep);
                        if (managedVersion != null && (preferManagedVersion || managedVersion.equals(version))) {
                            version = null;
                        }
                        PomHelper.createDependency((Element)depsEl, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)version);
                    }
                }
            })});
        }
        catch (Throwable e) {
            throw ExceptionUtil.coreException((Throwable)e);
        }
    }

    @Override
    public void setStarters(Collection<SpringBootStarter> _starters) throws CoreException {
        try {
            final HashSet<StarterId> starters = new HashSet<StarterId>();
            for (SpringBootStarter s : _starters) {
                starters.add(s.getId());
            }
            IFile file = this.getPomFile();
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(file, new PomEdits.Operation(){

                public void process(Document document) {
                    Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencies"});
                    List children = PomEdits.findChilds((Element)depsEl, (String)"dependency");
                    for (Element c : children) {
                        StarterId id;
                        boolean keep;
                        String aid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)c, (String)"artifactId"));
                        String gid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)c, (String)"groupId"));
                        if (aid == null || gid == null || !aid.startsWith("spring-boot-starter-") || (keep = starters.remove(id = new StarterId(gid, aid)))) continue;
                        depsEl.removeChild(c);
                    }
                    for (StarterId s : starters) {
                        PomHelper.createDependency((Element)depsEl, (String)s.getGroupId(), (String)s.getArtifactId(), null);
                    }
                }
            })});
        }
        catch (Throwable e) {
            throw ExceptionUtil.coreException((Throwable)e);
        }
    }

    @Override
    public String getBootVersion() {
        try {
            return this.getBootVersion(this.getMavenProject().getDependencies());
        }
        catch (Exception e) {
            BootActivator.log(e);
            return SpringBootCore.getDefaultBootVersion();
        }
    }

    private String getBootVersion(List<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            if (!dep.getArtifactId().startsWith("spring-boot") || !dep.getGroupId().equals("org.springframework.boot")) continue;
            return dep.getVersion();
        }
        return SpringBootCore.getDefaultBootVersion();
    }
}

