/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Deque;
import java.util.LinkedList;

public class NoMainMethodInAbstractClassCheck
extends Check {
    public static final String MSG_KEY = "avoid.main.method.in.abstract.class";
    private Deque<DetailAST> mObjBlockTokensStack = new LinkedList<DetailAST>();

    public final int[] getDefaultTokens() {
        return new int[]{14, 9};
    }

    public final void visitToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            if (this.isNotInnerClass(aAST)) {
                this.mObjBlockTokensStack.clear();
            }
            if (NoMainMethodInAbstractClassCheck.hasAbstractModifier(aAST)) {
                this.mObjBlockTokensStack.push(aAST.findFirstToken(6));
            }
        } else if (this.isChildOfCurrentObjBlockToken(aAST) && NoMainMethodInAbstractClassCheck.isMainMethod(aAST)) {
            this.log(aAST.getLineNo(), MSG_KEY, new Object[0]);
            this.mObjBlockTokensStack.pop();
        }
    }

    private boolean isNotInnerClass(DetailAST aClassDefAST) {
        boolean result = true;
        DetailAST objBlockAST = aClassDefAST.getParent();
        for (DetailAST currentObjBlock : this.mObjBlockTokensStack) {
            if (objBlockAST != currentObjBlock) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean isChildOfCurrentObjBlockToken(DetailAST aMethodDefAST) {
        DetailAST objBlockAST = this.mObjBlockTokensStack.peek();
        return objBlockAST != null && aMethodDefAST.getParent() == objBlockAST;
    }

    private static boolean hasAbstractModifier(DetailAST aClassDefAST) {
        boolean result = false;
        if (NoMainMethodInAbstractClassCheck.hasChildToken(aClassDefAST, 5)) {
            DetailAST modifiers = aClassDefAST.findFirstToken(5);
            result = NoMainMethodInAbstractClassCheck.hasChildToken(modifiers, 40);
        }
        return result;
    }

    private static boolean isMainMethod(DetailAST aMethodAST) {
        boolean result = true;
        String methodName = NoMainMethodInAbstractClassCheck.getIdentifier(aMethodAST);
        result = "main".equals(methodName) ? NoMainMethodInAbstractClassCheck.isVoidType(aMethodAST) && NoMainMethodInAbstractClassCheck.isMainMethodModifiers(aMethodAST) && NoMainMethodInAbstractClassCheck.isMainMethodParameters(aMethodAST) : false;
        return result;
    }

    private static String getIdentifier(DetailAST aAST) {
        DetailAST ident = aAST.findFirstToken(58);
        if (ident != null) {
            return ident.getText();
        }
        return null;
    }

    private static boolean isMainMethodModifiers(DetailAST aMethodAST) {
        boolean result = false;
        if (NoMainMethodInAbstractClassCheck.hasChildToken(aMethodAST, 5)) {
            DetailAST modifiers = aMethodAST.findFirstToken(5);
            result = NoMainMethodInAbstractClassCheck.hasChildToken(modifiers, 62) && NoMainMethodInAbstractClassCheck.hasChildToken(modifiers, 64);
        }
        return result;
    }

    private static boolean isVoidType(DetailAST aMethodAST) {
        boolean result = true;
        DetailAST methodTypeAST = null;
        if (NoMainMethodInAbstractClassCheck.hasChildToken(aMethodAST, 13)) {
            methodTypeAST = aMethodAST.findFirstToken(13);
            result = NoMainMethodInAbstractClassCheck.hasChildToken(methodTypeAST, 49);
        }
        return result;
    }

    private static boolean isMainMethodParameters(DetailAST aMethodAST) {
        DetailAST params = aMethodAST.findFirstToken(20);
        return NoMainMethodInAbstractClassCheck.hasOnlyStringArrayParameter(params) || NoMainMethodInAbstractClassCheck.hasOnlyStringEllipsisParameter(params);
    }

    private static boolean hasOnlyStringArrayParameter(DetailAST aParametersAST) {
        boolean result = true;
        if (aParametersAST.getChildCount(21) != 1) {
            result = false;
        } else {
            DetailAST parameterDefinitionAST = aParametersAST.findFirstToken(21);
            DetailAST parameterTypeAST = parameterDefinitionAST.findFirstToken(13);
            if (NoMainMethodInAbstractClassCheck.hasChildToken(parameterTypeAST, 17)) {
                DetailAST arrayDeclaratorAST = parameterTypeAST.findFirstToken(17);
                String parameterName = NoMainMethodInAbstractClassCheck.getIdentifier(arrayDeclaratorAST);
                result = "String".equals(parameterName);
            } else {
                result = false;
            }
        }
        return result;
    }

    private static boolean hasOnlyStringEllipsisParameter(DetailAST aParametersAST) {
        boolean result = true;
        if (aParametersAST.getChildCount(21) != 1) {
            result = false;
        } else {
            DetailAST parameterDefinitionAST = aParametersAST.findFirstToken(21);
            if (NoMainMethodInAbstractClassCheck.hasChildToken(parameterDefinitionAST, 171)) {
                DetailAST parameterTypeAST = parameterDefinitionAST.findFirstToken(13);
                String parameterName = NoMainMethodInAbstractClassCheck.getIdentifier(parameterTypeAST);
                result = "String".equals(parameterName);
            } else {
                result = false;
            }
        }
        return result;
    }

    private static boolean hasChildToken(DetailAST aAST, int aTokenType) {
        return aAST.findFirstToken(aTokenType) != null;
    }
}

