/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class UnnecessaryParenthesesExtendedCheck
extends Check {
    private static final int MIN_CHILDREN_FOR_MATCH = 3;
    private static final int MAX_QUOTED_LENGTH = 25;
    private boolean mIgnoreCalculationOfBooleanVariables;
    private boolean mIgnoreCalculationOfBooleanVariablesWithReturn;
    private boolean mIgnoreCalculationOfBooleanVariablesWithAssert;
    private static final int[] LITERALS = new int[]{142, 140, 137, 141, 139, 135, 134, 133};
    private static final int[] ASSIGNMENTS = new int[]{80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    private static final int[] EQUALS = new int[]{116, 115, 110, 111, 112};
    private DetailAST mParentToSkip;
    private int mAssignDepth;

    public int[] getDefaultTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    }

    public void visitToken(DetailAST aAST) {
        int type = aAST.getType();
        boolean surrounded = UnnecessaryParenthesesExtendedCheck.isSurrounded(aAST);
        DetailAST parent = aAST.getParent();
        if (type == 80 && parent.getType() == 160) {
            return;
        }
        if (surrounded && type == 58) {
            this.mParentToSkip = aAST.getParent();
            this.log(aAST, "unnecessary.paren.ident", new Object[]{aAST.getText()});
            return;
        }
        if (surrounded && UnnecessaryParenthesesExtendedCheck.inTokenList(type, LITERALS)) {
            this.mParentToSkip = aAST.getParent();
            if (type == 139) {
                this.log(aAST, "unnecessary.paren.string", new Object[]{UnnecessaryParenthesesExtendedCheck.chopString(aAST.getText())});
            } else {
                this.log(aAST, "unnecessary.paren.literal", new Object[]{aAST.getText()});
            }
            return;
        }
        if (UnnecessaryParenthesesExtendedCheck.inTokenList(type, ASSIGNMENTS)) {
            ++this.mAssignDepth;
            DetailAST last = aAST.getLastChild();
            if (last.getType() == 77) {
                DetailAST subtree = aAST.getFirstChild().getNextSibling().getNextSibling();
                int subtreeType = subtree.getType();
                if (!this.mIgnoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(subtreeType, EQUALS)) {
                    this.log(aAST, "unnecessary.paren.assign", new Object[0]);
                }
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        int type = aAST.getType();
        DetailAST parent = aAST.getParent();
        if (type == 80 && parent.getType() == 160) {
            return;
        }
        if (type == 28) {
            if (this.mParentToSkip != aAST && UnnecessaryParenthesesExtendedCheck.exprSurrounded(aAST)) {
                if (this.mAssignDepth >= 1) {
                    if (!this.mIgnoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(aAST), EQUALS)) {
                        this.log(aAST, "unnecessary.paren.assign", new Object[0]);
                    }
                } else if (aAST.getParent().getType() == 88) {
                    if (!this.mIgnoreCalculationOfBooleanVariablesWithReturn || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(aAST), EQUALS)) {
                        this.log(aAST, "unnecessary.paren.return", new Object[0]);
                    }
                } else if (aAST.getParent().getType() == 151) {
                    if (!this.mIgnoreCalculationOfBooleanVariablesWithAssert || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(aAST), EQUALS)) {
                        this.log(aAST, "unnecessary.paren.expr", new Object[0]);
                    }
                } else if (!this.mIgnoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(aAST), EQUALS)) {
                    this.log(aAST, "unnecessary.paren.expr", new Object[0]);
                }
            }
            this.mParentToSkip = null;
        } else if (UnnecessaryParenthesesExtendedCheck.inTokenList(type, ASSIGNMENTS)) {
            --this.mAssignDepth;
        }
        super.leaveToken(aAST);
    }

    private static boolean isSurrounded(DetailAST aAST) {
        DetailAST prev = aAST.getPreviousSibling();
        DetailAST next = aAST.getNextSibling();
        return prev != null && prev.getType() == 76 && next != null && next.getType() == 77;
    }

    private static boolean exprSurrounded(DetailAST aAST) {
        if (aAST.getType() != 28) {
            throw new IllegalArgumentException("Not an expression node.");
        }
        boolean surrounded = false;
        if (aAST.getChildCount() >= 3) {
            DetailAST n1 = aAST.getFirstChild();
            DetailAST nn = aAST.getLastChild();
            surrounded = n1.getType() == 76 && nn.getType() == 77;
        }
        return surrounded;
    }

    private static boolean inTokenList(int aType, int[] aTokens) {
        boolean found = false;
        for (int i = 0; i < aTokens.length && !found; ++i) {
            found = aTokens[i] == aType;
        }
        return found;
    }

    private static String chopString(String aString) {
        if (aString.length() > 25) {
            return aString.substring(0, 25) + "...\"";
        }
        return aString;
    }

    private static int subtreeType(DetailAST aAST) {
        DetailAST subtree = aAST.getFirstChild().getNextSibling();
        return subtree.getType();
    }

    public final void setIgnoreCalculationOfBooleanVariables(boolean aIgnoreCalculationOfBooleanVariables) {
        this.mIgnoreCalculationOfBooleanVariables = aIgnoreCalculationOfBooleanVariables;
    }

    public final void setIgnoreCalculationOfBooleanVariablesWithReturn(boolean aIgnoreCalculationOfBooleanVariablesWithReturn) {
        this.mIgnoreCalculationOfBooleanVariablesWithReturn = aIgnoreCalculationOfBooleanVariablesWithReturn;
    }

    public final void setIgnoreCalculationOfBooleanVariablesWithAssert(boolean aIgnoreCalculationOfBooleanVariablesWithAssert) {
        this.mIgnoreCalculationOfBooleanVariablesWithAssert = aIgnoreCalculationOfBooleanVariablesWithAssert;
    }
}

