/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.reporting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.prefs.BackingStoreException;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.GoogleAnalyticsUrlStrategy;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.ISubclipseEclipseEnvironment;
import org.tigris.subversion.subclipse.tools.usage.http.HttpGetRequest;
import org.tigris.subversion.subclipse.tools.usage.internal.SubclipseToolsUsageActivator;
import org.tigris.subversion.subclipse.tools.usage.preferences.GlobalUsageSettings;
import org.tigris.subversion.subclipse.tools.usage.preferences.UsageReportPreferences;
import org.tigris.subversion.subclipse.tools.usage.reporting.ReportingMessages;
import org.tigris.subversion.subclipse.tools.usage.reporting.UsageReportEnablementDialog;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.FocusPoint;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.IFocusPoint;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.PluginLogger;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.SuffixFocusPoint;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.Tracker;
import org.tigris.subversion.subclipse.tools.usage.util.StatusUtils;

public class UsageReport {
    private IFocusPoint focusPoint;
    private GlobalUsageSettings globalSettings;
    private ISubclipseEclipseEnvironment eclipseEnvironment = SubclipseToolsUsageActivator.getDefault().getSubclipseEclipseEnvironment();

    public UsageReport() throws InvalidSyntaxException {
        this.focusPoint = new SuffixFocusPoint("tools", this.eclipseEnvironment.getSubclipseVersion()).setChild(new FocusPoint("usage").setChild(new FocusPoint("action").setChild(new FocusPoint("wsstartup"))));
        this.globalSettings = new GlobalUsageSettings((Plugin)SubclipseToolsUsageActivator.getDefault());
    }

    public void report() {
        new ReportingJob().schedule();
    }

    private void askUser() {
        UsageReportEnablementDialog dialog = new UsageReportEnablementDialog(true, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (dialog.open() == 0) {
            UsageReportPreferences.setEnabled(dialog.isReportEnabled());
            UsageReportPreferences.setAskUser(false);
            this.flushPreferences();
        }
    }

    private void flushPreferences() {
        try {
            UsageReportPreferences.flush();
        }
        catch (BackingStoreException e) {
            IStatus status = StatusUtils.getErrorStatus("org.tigris.subversion.subclipse.tools.usage", ReportingMessages.UsageReport_Error_SavePreferences, e, null);
            SubclipseToolsUsageActivator.getDefault().getLog().log(status);
        }
    }

    private void doReport() {
        if (UsageReportPreferences.isEnabled()) {
            GoogleAnalyticsUrlStrategy urlBuildingStrategy = new GoogleAnalyticsUrlStrategy(this.eclipseEnvironment);
            PluginLogger loggingAdapter = new PluginLogger((Plugin)SubclipseToolsUsageActivator.getDefault());
            Tracker tracker = new Tracker(urlBuildingStrategy, new HttpGetRequest(this.eclipseEnvironment.getUserAgent(), loggingAdapter), loggingAdapter);
            tracker.trackAsynchronously(this.focusPoint);
        }
    }

    private class ReportingJob
    extends Job {
        private ReportingJob() {
            super(ReportingMessages.UsageReport_Reporting_Usage);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask(ReportingMessages.UsageReport_Querying_Enablement, 2);
            if (UsageReport.this.globalSettings.isReportingEnabled()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                if (UsageReportPreferences.isAskUser()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.askUserAndReport();
                } else {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    UsageReport.this.doReport();
                }
                monitor.worked(2);
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        private void askUserAndReport() {
            AskUserJob askUserJob = new AskUserJob();
            askUserJob.addJobChangeListener(new IJobChangeListener(){

                public void sleeping(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void running(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    UsageReport.this.doReport();
                }

                public void awake(IJobChangeEvent event) {
                }

                public void aboutToRun(IJobChangeEvent event) {
                }
            });
            askUserJob.setUser(true);
            askUserJob.setPriority(20);
            askUserJob.schedule();
        }
    }

    private class AskUserJob
    extends UIJob {
        private AskUserJob() {
            super(ReportingMessages.UsageReport_Asking_User);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            UsageReport.this.askUser();
            return Status.OK_STATUS;
        }
    }
}

