/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.batch.ui.editor.hyperlink.batch;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.HyperlinkUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NodeElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StepReferenceHyperlinkCalculator
implements IHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        if (node.getOwnerDocument() != null && node.getOwnerDocument().getDocumentElement() != null) {
            return this.searchStepElements(target, node.getOwnerDocument().getDocumentElement(), textViewer, hyperlinkRegion);
        }
        return null;
    }

    private IHyperlink searchStepElements(String name, Node node, ITextViewer textViewer, IRegion hyperlinkRegion) {
        NodeList children = node.getChildNodes();
        IHyperlink link = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if ("step".equals(child.getLocalName()) && name.equals(BeansEditorUtils.getAttribute((Node)child, (String)"id"))) {
                IRegion region = HyperlinkUtils.getHyperlinkRegion((Node)child);
                link = new NodeElementHyperlink(hyperlinkRegion, region, textViewer);
            }
            if (link == null && child.hasChildNodes()) {
                link = this.searchStepElements(name, child, textViewer, hyperlinkRegion);
            }
            ++i;
        }
        return link;
    }
}

