/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.CompositeCommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IFrameworkCommand;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.JavaParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterKind;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist.JavaContentAssistUIAdapter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.BooleanParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IProjectSelectionChangeListener;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IUIChangeListener;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.ParameterEditorFactory;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.UIEvent;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard.AbstractGenericWizardPage;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard.GenericCommandWizard;

public class GenericWizardCommandParametersPage
extends AbstractGenericWizardPage
implements IUIChangeListener {
    private IFrameworkCommand command;
    private Point longestLabelWidth;
    private List<IProjectSelectionChangeListener> projectSelectionListeners;
    public static final String RESERVED_KEYBOARD_SHORTCUTS = "BbNnFf";
    private StringBuffer mneumonicsKeyBoardShortcuts = new StringBuffer().append("BbNnFf");
    private static final char NON_MNEUMONIC = '\u0000';

    public GenericWizardCommandParametersPage(IFrameworkCommand command) {
        super("Configure command parameters");
        this.setDescription("Configure the command parameters. Finishing the wizard will execute the command. Required fields must have values before the wizard can complete.");
        this.command = command;
        if (command != null) {
            this.setTitle(command.getCommandDescriptor().getName());
        }
        this.projectSelectionListeners = new ArrayList<IProjectSelectionChangeListener>();
    }

    public IFrameworkCommand getCommand() {
        return this.command;
    }

    @Override
    protected Composite createPageArea(Composite parent) {
        if (this.command == null) {
            this.setErrorMessage("No command specified. Please select a command first");
            return parent;
        }
        List parameters = this.command.getParameters();
        if (parameters == null) {
            return parent;
        }
        Composite parameterArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parameterArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parameterArea);
        if (this.groupRequiredParameters()) {
            ArrayList<ICommandParameter> requiredParameters = new ArrayList<ICommandParameter>();
            ArrayList<ICommandParameter> optionalParameters = new ArrayList<ICommandParameter>();
            for (ICommandParameter parameter : parameters) {
                boolean isMandatory = parameter.getParameterDescriptor().isMandatory();
                if (isMandatory) {
                    requiredParameters.add(parameter);
                    continue;
                }
                optionalParameters.add(parameter);
            }
            if (!requiredParameters.isEmpty()) {
                this.createParameterEditors(parameterArea, "Required Parameters", requiredParameters);
            }
            if (!optionalParameters.isEmpty()) {
                this.createParameterEditors(parameterArea, "Optional Parameters", optionalParameters);
            }
        } else {
            this.createParameterEditors(parameterArea, "Parameters", parameters);
        }
        this.checkPageComplete(false);
        return parameterArea;
    }

    protected Composite createParameterEditors(Composite parent, String groupLabel, List<ICommandParameter> parameters) {
        Group parameterGroup = new Group(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)parameterGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parameterGroup);
        parameterGroup.setText(groupLabel);
        ScrolledComposite scrolledParameterArea = new ScrolledComposite((Composite)parameterGroup, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolledParameterArea);
        scrolledParameterArea.setFont(parent.getFont());
        scrolledParameterArea.setExpandHorizontal(true);
        scrolledParameterArea.setExpandVertical(true);
        Composite editorContent = new Composite((Composite)scrolledParameterArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(this.getEditorAreaWidthMargin(), this.getEditorAreaHeightMargin()).spacing(-1, this.getVerticalEditorControlSpacing()).applyTo(editorContent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorContent);
        this.createEditors(editorContent, parameters);
        scrolledParameterArea.setContent((Control)editorContent);
        scrolledParameterArea.setMinSize(editorContent.computeSize(-1, -1));
        return scrolledParameterArea;
    }

    protected boolean groupRequiredParameters() {
        return this.getGenericCommandWizard().groupRequiredParameters();
    }

    protected String getControlLabelWithKeyboardShortcut(String label) {
        if (label == null || label.length() == 0) {
            return label;
        }
        char possibleMneumonic = '\u0000';
        int mneumonicLocation = 0;
        while (mneumonicLocation < label.length()) {
            if (!this.isMneumonicShortcutAssigned(label.charAt(mneumonicLocation))) {
                possibleMneumonic = label.charAt(mneumonicLocation);
                this.mneumonicsKeyBoardShortcuts.append(possibleMneumonic);
                break;
            }
            ++mneumonicLocation;
        }
        if (possibleMneumonic != '\u0000') {
            String keyBoardShortCutLabel = new StringBuffer(label).insert(mneumonicLocation, '&').toString();
            return keyBoardShortCutLabel;
        }
        return label;
    }

    protected boolean isMneumonicShortcutAssigned(char ch) {
        int i = 0;
        while (i < this.mneumonicsKeyBoardShortcuts.length()) {
            if (this.mneumonicsKeyBoardShortcuts.charAt(i) == ch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createEditors(Composite parent, List<ICommandParameter> parameters) {
        if (parameters == null) {
            return;
        }
        int createdElementIndex = 0;
        while (createdElementIndex < parameters.size()) {
            ICommandParameter parameter = parameters.get(createdElementIndex);
            ParameterKind kind = parameter.getParameterDescriptor().getParameterKind();
            if (kind == null) continue;
            switch (kind) {
                case COMPOSITE: {
                    this.createCompositeEditor(parent, (CompositeCommandParameter)parameter);
                    break;
                }
                default: {
                    createdElementIndex = this.createEditor(parent, parameters, createdElementIndex, null, true);
                }
            }
            ++createdElementIndex;
        }
    }

    protected int createEditor(Composite parent, List<ICommandParameter> parameters, int currentIndex, List<IParameterEditor> editorList, boolean showLabel) {
        if (parameters != null && currentIndex >= 0 && currentIndex < parameters.size()) {
            ICommandParameter parameter = parameters.get(currentIndex);
            IParameterEditor editor = null;
            ParameterKind kind = parameter.getParameterDescriptor().getParameterKind();
            switch (kind) {
                case BOOLEAN: {
                    currentIndex = this.addBooleanEditors(parent, parameters, currentIndex, editorList);
                    break;
                }
                case BASE: {
                    editor = this.getTextEditor(parameter, showLabel);
                    break;
                }
                case JAVA_TYPE: {
                    editor = this.getJavaEditor(parameter, showLabel);
                    break;
                }
                case COMBO: {
                    editor = this.getComboEditor(parameter, showLabel);
                }
            }
            if (editor != null) {
                this.addAndConfigureEditor(parent, editor, editorList);
            }
        }
        return currentIndex;
    }

    protected void addLabel(IParameterEditor editor, Composite parent) {
        if (editor == null || parent == null) {
            return;
        }
        ICommandParameterDescriptor parameter = editor.getParameterDescriptor();
        String parameterName = this.getControlLabelWithKeyboardShortcut(parameter.getName());
        Label parameterNameLabel = new Label(parent, 8);
        parameterNameLabel.setText(String.valueOf(parameterName) + ": ");
        parameterNameLabel.setToolTipText(parameter.getDescription());
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)parameterNameLabel);
        Point labelSize = this.getLongestLabelSize();
        if (labelSize != null) {
            int widthHint;
            GridData data = (GridData)parameterNameLabel.getLayoutData();
            int heightHint = labelSize.y;
            if (heightHint > 0) {
                data.heightHint = heightHint;
            }
            if ((widthHint = labelSize.x) > 0) {
                data.widthHint = widthHint;
            }
        }
    }

    @Override
    public void handleUIEvent(UIEvent event) {
        if ((event.getType() & UIEvent.VALUE_SET) == UIEvent.VALUE_SET) {
            this.checkPageComplete(true);
        }
    }

    protected void createCompositeEditor(Composite parent, CompositeCommandParameter compositeParameter) {
        List childParameters = compositeParameter.getParameters();
        if (!childParameters.isEmpty()) {
            ArrayList<IParameterEditor> childEditors = new ArrayList<IParameterEditor>();
            int lastCreatedIndex = 0;
            while (lastCreatedIndex < childParameters.size()) {
                boolean showLabel = lastCreatedIndex == 0;
                lastCreatedIndex = this.createEditor(parent, childParameters, lastCreatedIndex, childEditors, showLabel);
                ++lastCreatedIndex;
            }
            new CompositeParameterController(childEditors).start();
        }
    }

    protected void checkPageComplete(boolean setErrorMessage) {
        boolean isPageComplete = true;
        this.setErrorMessage(null);
        List parameters = this.getCommand().getParameters();
        if (parameters != null) {
            StringBuffer bufferMessage = new StringBuffer();
            bufferMessage.append("Missing required value for: ");
            boolean first = true;
            for (ICommandParameter parameter : parameters) {
                if (!parameter.getParameterDescriptor().isMandatory() || parameter.hasValue()) continue;
                if (first) {
                    first = false;
                } else {
                    bufferMessage.append(", ");
                }
                bufferMessage.append(parameter.getParameterDescriptor().getName());
                isPageComplete &= false;
            }
            if (!isPageComplete && setErrorMessage) {
                this.setErrorMessage(bufferMessage.toString());
            }
        }
        this.setPageComplete(isPageComplete);
    }

    protected int addBooleanEditors(Composite parent, List<ICommandParameter> parameters, int booleanEditorIndex, List<IParameterEditor> editors) {
        if (parameters == null || booleanEditorIndex < 0 || booleanEditorIndex >= parameters.size()) {
            return -1;
        }
        if (parameters.get(booleanEditorIndex).getParameterDescriptor().getParameterKind() != ParameterKind.BOOLEAN) {
            return -1;
        }
        Composite booleanArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(booleanArea);
        GridData booleanAreaData = new GridData(4, 4, false, false);
        booleanAreaData.horizontalIndent = this.getNonLabelControlIndentation();
        booleanArea.setLayoutData((Object)booleanAreaData);
        int consecutiveBooleanIndex = booleanEditorIndex;
        while (consecutiveBooleanIndex < parameters.size()) {
            ICommandParameter parameter = parameters.get(consecutiveBooleanIndex);
            if (parameter.getParameterDescriptor().getParameterKind() != ParameterKind.BOOLEAN) break;
            IParameterEditor editor = ParameterEditorFactory.getBooleanParameterEditor(parameter);
            if (editor == null) continue;
            this.addAndConfigureEditor(booleanArea, editor, editors);
            booleanEditorIndex = consecutiveBooleanIndex++;
        }
        return booleanEditorIndex;
    }

    protected void addAndConfigureEditor(Composite parent, IParameterEditor editor, List<IParameterEditor> editorList) {
        editor.addUIChangeListener(this);
        this.createEditorControl(parent, editor);
        if (editor.getParameterDescriptor().getParameterKind() == ParameterKind.BOOLEAN) {
            Button button = ((BooleanParameterEditor)editor).getButtonControl();
            String buttonText = button.getText();
            button.setText(this.getControlLabelWithKeyboardShortcut(buttonText));
        }
        if (editorList != null) {
            editorList.add(editor);
        }
    }

    protected IParameterEditor getTextEditor(ICommandParameter parameter, boolean showLabel) {
        if (parameter == null) {
            return null;
        }
        IParameterEditor editor = ParameterEditorFactory.getParameterEditor(parameter, showLabel);
        return editor;
    }

    protected IParameterEditor getJavaEditor(ICommandParameter parameter, boolean showLabel) {
        if (parameter == null) {
            return null;
        }
        if (parameter.getParameterDescriptor().getParameterKind() != ParameterKind.JAVA_TYPE) {
            return null;
        }
        GenericCommandWizard wizard = this.getGenericCommandWizard();
        ICommandParameterDescriptor descriptor = parameter.getParameterDescriptor();
        JavaContentAssistUIAdapter adapter = wizard != null && descriptor instanceof JavaParameterDescriptor ? wizard.getJavaContentAssistUIAdapter((JavaParameterDescriptor)descriptor) : null;
        IParameterEditor editor = ParameterEditorFactory.getJavaParameterEditor(parameter, adapter, showLabel);
        if (adapter instanceof IProjectSelectionChangeListener) {
            JavaContentAssistUIAdapter listener = adapter;
            this.projectSelectionListeners.add(listener);
            listener.projectSelectionChanged(wizard.getSelectedProject());
        }
        return editor;
    }

    @Override
    protected void setProjectInWizard(IProject selectedProject) {
        super.setProjectInWizard(selectedProject);
        for (IProjectSelectionChangeListener listener : this.projectSelectionListeners) {
            listener.projectSelectionChanged(selectedProject);
        }
    }

    protected void createEditorControl(Composite parent, IParameterEditor editor) {
        if (editor == null) {
            return;
        }
        Composite editorRow = new Composite(parent, 0);
        boolean requiresLabel = editor.requiresParameterNameLabel();
        int columns = requiresLabel ? 2 : 1;
        GridLayoutFactory.fillDefaults().numColumns(columns).margins(0, 0).spacing(this.getHorizontalEditorControlSpacing(), -1).applyTo(editorRow);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)editorRow);
        GridData editorControlsGridData = new GridData(4, 0x1000000, true, false);
        if (editor.requiresParameterNameLabel()) {
            this.addLabel(editor, editorRow);
        } else if (editor.getParameterDescriptor().getParameterKind() != ParameterKind.BOOLEAN) {
            editorControlsGridData.horizontalIndent = this.getNonLabelControlIndentation();
        }
        Composite editorControls = new Composite(editorRow, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(editorControls);
        editorControls.setLayoutData((Object)editorControlsGridData);
        editor.createControls(editorControls);
    }

    protected int getNonLabelControlIndentation() {
        return this.getLongestLabelSize().x + this.getHorizontalEditorControlSpacing();
    }

    protected IParameterEditor getComboEditor(ICommandParameter parameter, boolean showLabel) {
        IParameterEditor editor = ParameterEditorFactory.getParameterEditor(parameter, showLabel);
        return editor;
    }

    protected Point getLongestLabelSize() {
        if (this.longestLabelWidth != null) {
            return this.longestLabelWidth;
        }
        int length = -1;
        int charLength = 0;
        List parameters = this.getCommand().getParameters();
        if (parameters != null) {
            for (ICommandParameter parameter : parameters) {
                int nameLength;
                String name;
                ParameterKind kind = parameter.getParameterDescriptor().getParameterKind();
                if (kind == ParameterKind.BOOLEAN || (name = parameter.getParameterDescriptor().getName()) == null || (nameLength = name.length()) <= charLength) continue;
                charLength = nameLength;
            }
        }
        if (charLength > 0) {
            Shell control = this.getShell();
            GC gc = new GC((Drawable)control);
            Font requiredLabelFont = this.getRequiredParameterFont();
            gc.setFont(requiredLabelFont != null ? requiredLabelFont : control.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            length = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)charLength);
            gc.dispose();
        }
        this.longestLabelWidth = new Point(length, -1);
        this.longestLabelWidth.x += this.getLabelNameSeparatorOffset();
        return this.longestLabelWidth;
    }

    protected Font getRequiredParameterFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    }

    protected int getLabelNameSeparatorOffset() {
        return 5;
    }

    protected int getEditorAreaWidthMargin() {
        return 5;
    }

    protected int getEditorAreaHeightMargin() {
        return 10;
    }

    protected int getHorizontalEditorControlSpacing() {
        return 4;
    }

    protected int getVerticalEditorControlSpacing() {
        return 5;
    }

    public static class CompositeParameterController
    implements IUIChangeListener {
        private List<IParameterEditor> editors;

        public CompositeParameterController(List<IParameterEditor> editors) {
            this.editors = editors;
        }

        public void start() {
            if (this.editors != null) {
                for (IParameterEditor editor : this.editors) {
                    editor.addUIChangeListener(this);
                }
            }
        }

        @Override
        public void handleUIEvent(UIEvent event) {
            if ((event.getType() & UIEvent.CLEAR_VALUE_EVENT) == UIEvent.CLEAR_VALUE_EVENT) {
                IUIChangeListener notifier = event.getNotifier();
                if (this.editors != null) {
                    UIEvent clearControlEvent = new UIEvent(null, this, UIEvent.CLEAR_VALUE_EVENT);
                    for (IParameterEditor editor : this.editors) {
                        if (notifier == editor || !(editor instanceof IUIChangeListener)) continue;
                        ((IUIChangeListener)((Object)editor)).handleUIEvent(clearControlEvent);
                    }
                }
            }
        }
    }
}

