/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins;

import org.springsource.ide.eclipse.commons.frameworks.core.internal.plugins.PluginVersion;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.ITreeElement;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.PluginOperation;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.PluginState;

public abstract class AbstractTreeElement
implements ITreeElement {
    private PluginVersion version;
    private PluginState state;

    public AbstractTreeElement(PluginVersion version) {
        this.version = version;
    }

    @Override
    public PluginVersion getVersionModel() {
        return this.version;
    }

    @Override
    public void setState(PluginState state) {
        this.state = state;
    }

    @Override
    public PluginState getPluginState() {
        return this.state;
    }

    @Override
    public boolean isValidOperation(PluginOperation type) {
        if (type == null) {
            return false;
        }
        boolean isValid = false;
        PluginState currentState = this.getPluginState();
        switch (type) {
            case INSTALL: {
                isValid = this.canHandleInstall(currentState);
                break;
            }
            case UNINSTALL: {
                isValid = this.canHandleUninstall(currentState);
                break;
            }
            case UPDATE: {
                isValid = this.canHandleUpdate(currentState);
            }
        }
        return isValid;
    }

    @Override
    public void performOperation(PluginOperation type) {
        if (!this.isValidOperation(type)) {
            return;
        }
        PluginState currentState = this.getPluginState();
        switch (type) {
            case INSTALL: {
                this.handleInstall(currentState);
                break;
            }
            case UNINSTALL: {
                this.handleUninstall(currentState);
                break;
            }
            case UPDATE: {
                this.handleUpdate(currentState);
            }
        }
    }

    protected abstract boolean canHandleInstall(PluginState var1);

    protected abstract boolean canHandleUninstall(PluginState var1);

    protected abstract boolean canHandleUpdate(PluginState var1);

    protected abstract void handleInstall(PluginState var1);

    protected abstract void handleUninstall(PluginState var1);

    protected abstract void handleUpdate(PluginState var1);
}

