/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors;

import java.util.ArrayList;
import java.util.List;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IUIChangeListener;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.UIEvent;

public abstract class AbstractParameterEditor
implements IParameterEditor,
IUIChangeListener {
    private ICommandParameter parameter;
    private List<IUIChangeListener> listeners;
    private boolean requiresLabel;

    public AbstractParameterEditor(ICommandParameter parameter, boolean requiresLabel) {
        this.parameter = parameter;
        this.requiresLabel = requiresLabel;
    }

    @Override
    public boolean requiresParameterNameLabel() {
        return this.requiresLabel;
    }

    @Override
    public IUIChangeListener addUIChangeListener(IUIChangeListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<IUIChangeListener>();
        }
        if (this.listeners.contains(listener)) {
            return null;
        }
        this.listeners.add(listener);
        return listener;
    }

    @Override
    public IUIChangeListener removeUIChangeListener(IUIChangeListener listener) {
        if (this.listeners != null && this.listeners.remove(listener)) {
            return listener;
        }
        return null;
    }

    @Override
    public ICommandParameterDescriptor getParameterDescriptor() {
        return this.parameter.getParameterDescriptor();
    }

    @Override
    public ICommandParameter getParameter() {
        return this.parameter;
    }

    protected void setParameterValueAndNotifyClear(Object value) {
        this.setParameterValue(value, UIEvent.VALUE_SET | UIEvent.CLEAR_VALUE_EVENT);
    }

    protected void setParameterValue(Object value, int eventType) {
        ICommandParameter parameter = this.getParameter();
        if (parameter != null) {
            parameter.setValue(value);
            this.notifyListeners(value, eventType);
        }
    }

    protected void notifyListeners(Object eventData, int type) {
        UIEvent event = new UIEvent(eventData, this, type);
        if (this.listeners != null) {
            for (IUIChangeListener listener : this.listeners) {
                listener.handleUIEvent(event);
            }
        }
    }

    @Override
    public void handleUIEvent(UIEvent event) {
        if ((event.getType() & UIEvent.CLEAR_VALUE_EVENT) == UIEvent.CLEAR_VALUE_EVENT) {
            this.setParameterValue(null, UIEvent.VALUE_SET);
            this.clearControls();
        }
    }

    protected abstract void clearControls();
}

