/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.IConversionConstants;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion.LegacyProjectsJob;

public class LegacyProjectListener
implements IResourceChangeListener,
IConversionConstants {
    public static final LegacyProjectListener LISTENER = new LegacyProjectListener();

    private boolean shouldPerformCheck() {
        return FrameworkCoreActivator.getDefault().getPreferenceStore().getBoolean("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.autocheck");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        List<IProject> projects;
        if (event.getType() == 1 && !(projects = this.getProjects(event.getDelta())).isEmpty() && this.shouldPerformCheck()) {
            LegacyProjectsJob job = new LegacyProjectsJob(projects, false);
            job.schedule();
        }
    }

    private List<IProject> getProjects(IResourceDelta delta) {
        final ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta innerDelta) throws CoreException {
                    IProject project;
                    if (innerDelta.getKind() == 1 && innerDelta.getResource().getType() == 4 && LegacyProjectsJob.isLegacyProject(project = (IProject)innerDelta.getResource(), false)) {
                        projects.add(project);
                    }
                    return innerDelta.getResource().getType() == 8;
                }
            });
        }
        catch (CoreException e) {
            FrameworkCoreActivator.getDefault().getLog().log(e.getStatus());
        }
        return projects;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)LISTENER);
    }
}

