/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist.IProjectContentAssistProcessor;

public class JavaProjectPackageCompletionProcessor
implements IProjectContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private CompletionProposalComparator proposalComparator = new CompletionProposalComparator();
    private ILabelProvider labelProvider;
    private IJavaProject project;
    private char[] proposalAutoActivationSet;

    public JavaProjectPackageCompletionProcessor() {
        this((ILabelProvider)new JavaElementLabelProvider(256));
    }

    public JavaProjectPackageCompletionProcessor(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    @Override
    public IJavaProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IJavaProject project) {
        this.project = project;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.proposalAutoActivationSet == null) {
            IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
            String triggers = preferenceStore.getString("content_assist_autoactivation_triggers_java");
            this.proposalAutoActivationSet = triggers.toCharArray();
        }
        return this.proposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        IPackageFragmentRoot[] roots;
        if (this.project == null) {
            return null;
        }
        String input = contentAssistSubjectControl.getDocument().get();
        ICompletionProposal[] foundProposals = null;
        try {
            roots = this.project.getAllPackageFragmentRoots();
            if (roots == null) {
                return null;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        ArrayList<JavaCompletionProposal> proposals = new ArrayList<JavaCompletionProposal>();
        String prefix = input.substring(0, documentOffset);
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            try {
                IClasspathEntry entry = root.getRawClasspathEntry();
                if (entry.getEntryKind() == 3) {
                    IJavaElement[] children;
                    IJavaElement[] iJavaElementArray = children = root.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragment packageFragment;
                        String packName;
                        IJavaElement child = iJavaElementArray[n4];
                        if (child instanceof IPackageFragment && (packName = (packageFragment = (IPackageFragment)child).getElementName()).startsWith(prefix)) {
                            Image image = this.labelProvider.getImage((Object)packageFragment);
                            JavaCompletionProposal proposal = new JavaCompletionProposal(packName, 0, input.length(), image, this.labelProvider.getText((Object)packageFragment), 0);
                            proposals.add(proposal);
                        }
                        ++n4;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n2;
        }
        foundProposals = proposals.toArray(new ICompletionProposal[proposals.size()]);
        Arrays.sort(foundProposals, this.proposalComparator);
        return foundProposals;
    }
}

