/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.actions;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.utils.ProjectFilter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.utils.SelectionUtils;

public abstract class AbstractActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final String DEBUG_CLASS = null;
    protected List<IProject> selectedProjects;
    protected IWorkbenchPart part;

    protected void debug(String msg) {
        if (this.getClass().getName().equals(DEBUG_CLASS)) {
            System.err.println(msg);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    protected IWorkbench getWorkbench() {
        IWorkbenchPartSite site;
        if (this.part != null && (site = this.part.getSite()) != null) {
            return site.getWorkbenchWindow().getWorkbench();
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel == null) {
            return;
        }
        List<IProject> newSelectedProjects = SelectionUtils.getProjects(sel, new ProjectFilter(){

            @Override
            public boolean isAcceptable(IProject project) {
                return AbstractActionDelegate.this.shouldAddToProjectList(project);
            }
        });
        if (!newSelectedProjects.isEmpty()) {
            this.debug(this + ":" + newSelectedProjects.toString());
            this.selectedProjects = newSelectedProjects;
        }
        if (this.selectedProjects == null || this.selectedProjects.isEmpty()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }

    protected boolean shouldAddToProjectList(IProject project) {
        return project != null && project.exists() && project.isAccessible();
    }

    protected List<IProject> getSelectedProjects() {
        return this.selectedProjects;
    }

    protected Shell getShell() {
        Shell shell = null;
        if (this.part != null) {
            shell = this.part.getSite().getShell();
        }
        if (shell == null) {
            shell = Display.getDefault().getActiveShell();
        }
        return shell;
    }
}

