/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.plugin.inappbrowser;

import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.IBrowserFunction;

public class ExecScriptFunction
implements IBrowserFunction {
    private IBrowser browser;
    private IBrowser inAppBrowser;

    public ExecScriptFunction(IBrowser browser, IBrowser inAppBrowser) {
        this.browser = browser;
        this.inAppBrowser = inAppBrowser;
    }

    public Object function(Object[] arguments) {
        String code = null;
        String successCallBackName = null;
        String failCallBackName = null;
        if (arguments != null) {
            if (arguments.length > 0 && arguments[0] != null) {
                code = arguments[0].toString();
            }
            if (arguments.length > 1 && arguments[1] != null) {
                successCallBackName = arguments[1].toString();
            }
            if (arguments.length > 2 && arguments[2] != null) {
                failCallBackName = arguments[2].toString();
            }
            if (code != null) {
                this.executeCode(code, successCallBackName, failCallBackName);
            } else if (failCallBackName != null) {
                this.processCallBackFunction(failCallBackName);
            }
        }
        return null;
    }

    private void executeCode(String code, String successCallBackName, String failCallBackName) {
        boolean codeSuccessfullyExecuted = false;
        codeSuccessfullyExecuted = this.inAppBrowser.execute("(function(){var f = function(){" + code + "};" + "if (document.readyState === 'complete') {" + "f();" + "} else {" + "window.addEventListener('load', f);" + "}" + "})()");
        if (successCallBackName != null && codeSuccessfullyExecuted) {
            this.processCallBackFunction(successCallBackName);
        } else if (failCallBackName != null) {
            this.processCallBackFunction(failCallBackName);
        }
        this.deleteCallBacksFromWindowProperties(successCallBackName, failCallBackName);
    }

    private void processCallBackFunction(String callBackName) {
        this.browser.execute("(window['" + callBackName + "']())()");
    }

    private void deleteCallBacksFromWindowProperties(String successCallBackName, String failCallBackName) {
        this.browser.execute("(function(){delete window['" + successCallBackName + "'];" + "delete window['" + failCallBackName + "'];" + "})()");
    }
}

