/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.model.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferencesStorage;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;
import org.jboss.tools.vpe.cordovasim.CordovaSimLogger;
import org.jboss.tools.vpe.cordovasim.model.preferences.CordovaSimSpecificPreferences;
import org.jboss.tools.vpe.cordovasim.util.CordovaSimResourcesUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CordavaSimSpecificPreferencesStorage
extends SpecificPreferencesStorage {
    private static final int CURRENT_CONFIG_VERSION = 11;
    private static final String SPECIFIC_PREFERENCES_FILE = "cordovaSpecificPreferences.xml";
    private static final String DEFAULT_SPECIFIC_PREFERENCES_RESOURCE = "config/cordovaSpecificPreferences.xml";
    private static final String PREFERENCES_CORDOVASIM = "cordovasim";
    private static final String PREFERENCES_CORDOVA = "cordova";
    private static final String PREFERENCES_CORDOVA_LOCATION = "cordovaLocation";
    private static final String PREFERENCES_CORDOVA_SIZE = "size";
    private static final String PREFERENCES_WIDTH = "width";
    private static final String PREFERENCES_HEIGHT = "height";
    private static final String PREFERENCES_SHOW_UNSUPPORTED_PLUGINS_POP_UP = "showUnsupportedPluginsPopUp";
    public static CordavaSimSpecificPreferencesStorage INSTANCE = new CordavaSimSpecificPreferencesStorage();

    protected SpecificPreferencesStorage getInstance() {
        return INSTANCE;
    }

    protected SpecificPreferences load(InputStream is) {
        int configVersion = 0;
        String selectedDeviceId = null;
        int orientationAngle = 0;
        Point currentlocation = null;
        boolean useSkins = true;
        boolean enableLiveReload = false;
        int liveReloadPort = 35729;
        boolean enableTouchEvents = false;
        boolean showUnsupportedPluginsPopUp = true;
        Point cordovaBrowserLocation = null;
        Point cordovaBrowserSize = null;
        boolean isJavaFx = true;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(is);
            document.getDocumentElement().normalize();
            configVersion = Integer.parseInt(document.getDocumentElement().getAttribute("version"));
            if (configVersion == 11) {
                Node node = document.getElementsByTagName("selectedDeviceId").item(0);
                if (!PreferencesUtil.isNullOrEmpty((Node)node)) {
                    selectedDeviceId = node.getTextContent();
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName("useSkins").item(0)))) {
                    useSkins = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName("enableLiveReload").item(0)))) {
                    enableLiveReload = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName("liveReloadPort").item(0)))) {
                    liveReloadPort = Integer.parseInt(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName("enableTouchEvents").item(0)))) {
                    enableTouchEvents = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName(PREFERENCES_SHOW_UNSUPPORTED_PLUGINS_POP_UP).item(0)))) {
                    showUnsupportedPluginsPopUp = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName("orientationAngle").item(0)))) {
                    orientationAngle = Integer.parseInt(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName("javafx").item(0)))) {
                    isJavaFx = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName("location").item(0))) && node.getNodeType() == 1) {
                    Element location = (Element)node;
                    Node x = location.getElementsByTagName("x").item(0);
                    Node y = location.getElementsByTagName("y").item(0);
                    if (!PreferencesUtil.isNullOrEmpty((Node)x) && !PreferencesUtil.isNullOrEmpty((Node)y)) {
                        currentlocation = new Point(Integer.parseInt(x.getTextContent()), Integer.parseInt(y.getTextContent()));
                    }
                }
                if (!PreferencesUtil.isNullOrEmpty((Node)(node = document.getElementsByTagName(PREFERENCES_CORDOVA).item(0))) && node.getNodeType() == 1) {
                    Node size;
                    Element cordova = (Element)node;
                    Node location = cordova.getElementsByTagName(PREFERENCES_CORDOVA_LOCATION).item(0);
                    if (!PreferencesUtil.isNullOrEmpty((Node)location) && location.getNodeType() == 1) {
                        Element cordovaLocation = (Element)location;
                        Node x = cordovaLocation.getElementsByTagName("x").item(0);
                        Node y = cordovaLocation.getElementsByTagName("y").item(0);
                        if (!PreferencesUtil.isNullOrEmpty((Node)x) && !PreferencesUtil.isNullOrEmpty((Node)y)) {
                            cordovaBrowserLocation = new Point(Integer.parseInt(x.getTextContent()), Integer.parseInt(y.getTextContent()));
                        }
                    }
                    if (!PreferencesUtil.isNullOrEmpty((Node)(size = cordova.getElementsByTagName(PREFERENCES_CORDOVA_SIZE).item(0))) && size.getNodeType() == 1) {
                        Element cordovaSize = (Element)size;
                        Node width = cordovaSize.getElementsByTagName(PREFERENCES_WIDTH).item(0);
                        Node height = cordovaSize.getElementsByTagName(PREFERENCES_HEIGHT).item(0);
                        if (!PreferencesUtil.isNullOrEmpty((Node)width) && !PreferencesUtil.isNullOrEmpty((Node)height)) {
                            cordovaBrowserSize = new Point(Integer.parseInt(width.getTextContent()), Integer.parseInt(height.getTextContent()));
                        }
                    }
                }
                CordovaSimSpecificPreferences cordovaSimSpecificPreferences = new CordovaSimSpecificPreferences(selectedDeviceId, useSkins, enableLiveReload, liveReloadPort, enableTouchEvents, orientationAngle, currentlocation, cordovaBrowserLocation, cordovaBrowserSize, isJavaFx, showUnsupportedPluginsPopUp);
                return cordovaSimSpecificPreferences;
            }
        }
        catch (SAXException e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
        catch (FactoryConfigurationError e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                CordovaSimLogger.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    protected SpecificPreferences createBlankPreferences() {
        return new CordovaSimSpecificPreferences(null, true, false, 35729, false, 0, null, null, null, false, true);
    }

    protected void save(SpecificPreferences sp, File file) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(PREFERENCES_CORDOVASIM);
            rootElement.setAttribute("version", String.valueOf(11));
            doc.appendChild(rootElement);
            Element selectedDevice = doc.createElement("selectedDeviceId");
            selectedDevice.setTextContent(String.valueOf(sp.getSelectedDeviceId()));
            rootElement.appendChild(selectedDevice);
            Element location = doc.createElement("location");
            Element locationX = doc.createElement("x");
            Element locationY = doc.createElement("y");
            Point currentLocation = sp.getLocation();
            locationX.setTextContent(String.valueOf(currentLocation.x));
            locationY.setTextContent(String.valueOf(currentLocation.y));
            location.appendChild(locationX);
            location.appendChild(locationY);
            rootElement.appendChild(location);
            Element orientationAngle = doc.createElement("orientationAngle");
            orientationAngle.setTextContent(String.valueOf(sp.getOrientationAngle()));
            rootElement.appendChild(orientationAngle);
            Element useSkins = doc.createElement("useSkins");
            useSkins.setTextContent(String.valueOf(sp.getUseSkins()));
            rootElement.appendChild(useSkins);
            Element enableLiveReload = doc.createElement("enableLiveReload");
            enableLiveReload.setTextContent(String.valueOf(sp.isEnableLiveReload()));
            rootElement.appendChild(enableLiveReload);
            Element liveReloadPort = doc.createElement("liveReloadPort");
            liveReloadPort.setTextContent(String.valueOf(sp.getLiveReloadPort()));
            rootElement.appendChild(liveReloadPort);
            Element enableTouchEvents = doc.createElement("enableTouchEvents");
            enableTouchEvents.setTextContent(String.valueOf(sp.isEnableTouchEvents()));
            rootElement.appendChild(enableTouchEvents);
            Element isJavaFx = doc.createElement("javafx");
            isJavaFx.setTextContent(String.valueOf(sp.isJavaFx()));
            rootElement.appendChild(isJavaFx);
            Element showUnsupportedPluginsPopUp = doc.createElement(PREFERENCES_SHOW_UNSUPPORTED_PLUGINS_POP_UP);
            boolean needToShowPopUp = ((CordovaSimSpecificPreferences)sp).showUnsupportedPluginsPopUp();
            showUnsupportedPluginsPopUp.setTextContent(String.valueOf(needToShowPopUp));
            rootElement.appendChild(showUnsupportedPluginsPopUp);
            Element cordova = doc.createElement(PREFERENCES_CORDOVA);
            Element cordovaLocation = doc.createElement(PREFERENCES_CORDOVA_LOCATION);
            Element cordovaLocationX = doc.createElement("x");
            Element cordovaLocationY = doc.createElement("y");
            Point currentCordovaBrowserLocation = ((CordovaSimSpecificPreferences)sp).getCordovaBrowserLocation();
            cordovaLocationX.setTextContent(String.valueOf(currentCordovaBrowserLocation.x));
            cordovaLocationY.setTextContent(String.valueOf(currentCordovaBrowserLocation.y));
            cordovaLocation.appendChild(cordovaLocationX);
            cordovaLocation.appendChild(cordovaLocationY);
            Element cordovaSize = doc.createElement(PREFERENCES_CORDOVA_SIZE);
            Element cordovaSizeWidth = doc.createElement(PREFERENCES_WIDTH);
            Element cordovaSizeHeight = doc.createElement(PREFERENCES_HEIGHT);
            Point currentCordovaBrowserSize = ((CordovaSimSpecificPreferences)sp).getCordovaBrowserSize();
            cordovaSizeWidth.setTextContent(String.valueOf(currentCordovaBrowserSize.x));
            cordovaSizeHeight.setTextContent(String.valueOf(currentCordovaBrowserSize.y));
            cordovaSize.appendChild(cordovaSizeWidth);
            cordovaSize.appendChild(cordovaSizeHeight);
            cordova.appendChild(cordovaLocation);
            cordova.appendChild(cordovaSize);
            rootElement.appendChild(cordova);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.newTransformer().transform(new DOMSource(doc), new StreamResult(file));
        }
        catch (ParserConfigurationException e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
        catch (TransformerException e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
    }

    protected String getFileName() {
        return SPECIFIC_PREFERENCES_FILE;
    }

    protected InputStream getDefaultPreferencesFileAsStream() {
        return CordovaSimResourcesUtil.getResourceAsStream(DEFAULT_SPECIFIC_PREFERENCES_RESOURCE);
    }
}

