/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.cordovasim.CordovaSimLogger;

public class CordovaSimArgs {
    private static String rootFolder;
    private static String homeUrl;
    private static String cordovaVersion;
    private static int port;
    private static boolean restartRequired;

    public static void parseArgs(String[] args) {
        int versionParameterIndex;
        int configurationParameterIndex;
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(args));
        boolean bl = BrowserSimArgs.standalone = !params.contains("-not-standalone");
        if (!BrowserSimArgs.standalone) {
            params.remove("-not-standalone");
        }
        if ((configurationParameterIndex = params.indexOf("-configuration")) >= 0) {
            params.remove(configurationParameterIndex);
            BrowserSimArgs.cofigurationFolder = (String)params.remove(configurationParameterIndex);
        }
        if ((versionParameterIndex = params.indexOf("-version")) >= 0) {
            params.remove(versionParameterIndex);
            cordovaVersion = (String)params.remove(versionParameterIndex);
        } else {
            cordovaVersion = "3.1.0";
        }
        if (params.size() > 0) {
            homeUrl = (String)params.remove(params.size() - 1);
            try {
                port = CordovaSimArgs.getPortFromURL(homeUrl);
            }
            catch (MalformedURLException e) {
                CordovaSimLogger.logError(e.getMessage(), e);
            }
        } else {
            homeUrl = "";
        }
        rootFolder = params.size() > 0 ? (String)params.remove(params.size() - 1) : ".";
        try {
            ServerSocket socket = new ServerSocket(0);
            BrowserSimArgs.debuggerPort = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            CordovaSimLogger.logError(e.getMessage(), e);
        }
    }

    public static String getRootFolder() {
        return rootFolder;
    }

    public static int getPort() {
        return port;
    }

    public static String getCordovaVersion() {
        return cordovaVersion;
    }

    public static boolean isRestartRequired() {
        return restartRequired;
    }

    public static void setRestartRequired(boolean restartRequired) {
        CordovaSimArgs.restartRequired = restartRequired;
    }

    public static String getHomeUrl() {
        return homeUrl;
    }

    private static int getPortFromURL(String homeUrl) throws MalformedURLException {
        URL url = new URL(homeUrl);
        return url.getPort();
    }
}

