/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.modifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class ModifierOrderQuickfix
extends AbstractASTResolution {
    private static final List MODIFIER_ORDER = Arrays.asList(Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.PROTECTED_KEYWORD, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD, Modifier.ModifierKeyword.VOLATILE_KEYWORD, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, Modifier.ModifierKeyword.NATIVE_KEYWORD, Modifier.ModifierKeyword.STRICTFP_KEYWORD);
    private static final int JAVADOC_COMMENT_LENGTH = 6;

    public static List reOrderModifiers(List modifiers) {
        ArrayList<ASTNode> copies = new ArrayList<ASTNode>();
        for (ASTNode mod : modifiers) {
            copies.add(ASTNode.copySubtree((AST)mod.getAST(), (ASTNode)mod));
        }
        Collections.sort(copies, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (!(arg0 instanceof Modifier) || !(arg1 instanceof Modifier)) {
                    return 0;
                }
                Modifier m1 = (Modifier)arg0;
                Modifier m2 = (Modifier)arg1;
                int modifierIndex1 = MODIFIER_ORDER.indexOf(m1.getKeyword());
                int modifierIndex2 = MODIFIER_ORDER.indexOf(m2.getKeyword());
                return new Integer(modifierIndex1).compareTo(new Integer(modifierIndex2));
            }
        });
        return copies;
    }

    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            public boolean visit(MethodDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            public boolean visit(FieldDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            public boolean visit(AnnotationTypeMemberDeclaration node) {
                return this.visitBodyDecl((BodyDeclaration)node);
            }

            private boolean visitBodyDecl(BodyDeclaration node) {
                int pos = node.getStartPosition() + (node.getJavadoc() != null ? node.getJavadoc().getLength() + 6 : 0);
                if (ModifierOrderQuickfix.this.containsPosition(lineInfo, pos)) {
                    List reorderedModifiers = ModifierOrderQuickfix.reOrderModifiers(node.modifiers());
                    node.modifiers().clear();
                    node.modifiers().addAll(reorderedModifiers);
                }
                return true;
            }
        };
    }

    public String getDescription() {
        return Messages.ModifierOrderQuickfix_description;
    }

    public String getLabel() {
        return Messages.ModifierOrderQuickfix_label;
    }

    public Image getImage() {
        return CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.CORRECTION_CHANGE);
    }
}

