/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties.filter;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.jobs.RunCheckstyleOnFilesJob;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.projectconfig.filters.UnOpenedFilesFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckFileOnOpenPartListener
implements IPartListener2 {
    public void partsOpened(Collection<IWorkbenchPartReference> parts) {
        ArrayList<IFile> filesToCheck = new ArrayList<IFile>();
        for (IWorkbenchPartReference partRef : parts) {
            IFile editorFile = this.getEditorFile(partRef);
            if (editorFile != null) {
                UnOpenedFilesFilter.addOpenedFile((IFile)editorFile);
            }
            if (editorFile == null || !this.isFileAffected(editorFile)) continue;
            filesToCheck.add(editorFile);
        }
        RunCheckstyleOnFilesJob job = new RunCheckstyleOnFilesJob(filesToCheck);
        job.schedule();
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.partsOpened(Collections.singleton(partRef));
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IFile editorFile = this.getEditorFile(partRef);
        if (editorFile != null) {
            UnOpenedFilesFilter.removeOpenedFile((IFile)editorFile);
        }
        if (editorFile != null && this.isFileAffected(editorFile)) {
            try {
                editorFile.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, 2);
            }
            catch (CoreException e) {
                CheckstyleLog.log((Throwable)e);
            }
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    private IFile getEditorFile(IWorkbenchPartReference partRef) {
        if (!(partRef instanceof IEditorReference)) {
            return null;
        }
        IFile file = null;
        IWorkbenchPart part = partRef.getPart(false);
        IEditorInput input = null;
        if (part != null && part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            input = editor.getEditorInput();
        } else {
            IEditorReference editRef = (IEditorReference)partRef;
            input = this.getRestoredInput(editRef);
        }
        if (input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        }
        return file;
    }

    private IEditorInput getRestoredInput(IEditorReference e) {
        IMemento editorMem = null;
        editorMem = CheckstyleUIPlugin.isE3() ? this.getMementoE3(e) : this.getMementoE4(e);
        if (editorMem == null) {
            return null;
        }
        IMemento inputMem = editorMem.getChild("input");
        String factoryID = null;
        if (inputMem != null) {
            factoryID = inputMem.getString("factoryID");
        }
        if (factoryID == null) {
            return null;
        }
        IAdaptable input = null;
        IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
        if (factory == null) {
            return null;
        }
        input = factory.createElement(inputMem);
        if (input == null) {
            return null;
        }
        if (!(input instanceof IEditorInput)) {
            return null;
        }
        return (IEditorInput)input;
    }

    private IMemento getMementoE4(IEditorReference e) {
        try {
            Method getModelMethod = e.getClass().getMethod("getModel", new Class[0]);
            getModelMethod.setAccessible(true);
            Object model = getModelMethod.invoke((Object)e, null);
            Method getPersistedStateMethod = model.getClass().getMethod("getPersistedState", new Class[0]);
            getPersistedStateMethod.setAccessible(true);
            Map state = (Map)getPersistedStateMethod.invoke(model, null);
            String memento = (String)state.get("memento");
            if (memento != null) {
                try {
                    return XMLMemento.createReadRoot((Reader)new StringReader(memento));
                }
                catch (WorkbenchException e1) {
                    CheckstyleLog.log((Throwable)e1);
                }
            }
        }
        catch (NoSuchMethodException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        catch (SecurityException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        catch (IllegalAccessException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        catch (InvocationTargetException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        return null;
    }

    private IMemento getMementoE3(IEditorReference e) {
        try {
            Method getMementoMethod = e.getClass().getMethod("getMemento", new Class[0]);
            getMementoMethod.setAccessible(true);
            IMemento memento = (IMemento)getMementoMethod.invoke((Object)e, null);
            return memento;
        }
        catch (NoSuchMethodException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        catch (SecurityException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        catch (IllegalAccessException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        catch (InvocationTargetException e1) {
            CheckstyleLog.log((Throwable)e1);
        }
        return null;
    }

    private boolean isFileAffected(IFile file) {
        boolean affected = false;
        IProject project = file.getProject();
        try {
            if (project.isAccessible() && project.hasNature("net.sf.eclipsecs.core.CheckstyleNature")) {
                IProjectConfiguration config = ProjectConfigurationFactory.getConfiguration((IProject)project);
                boolean unOpenedFilesFilterActive = false;
                boolean filtered = false;
                List filters = config.getFilters();
                for (IFilter filter : filters) {
                    if (filter instanceof UnOpenedFilesFilter && ((UnOpenedFilesFilter)filter).isEnabled()) {
                        unOpenedFilesFilterActive = true;
                    }
                    if (!filter.isEnabled() || filter instanceof UnOpenedFilesFilter) continue;
                    boolean bl = filtered = filtered || !filter.accept((Object)file);
                }
                affected = unOpenedFilesFilterActive && !filtered;
            }
        }
        catch (CoreException e) {
            CheckstyleLog.log((Throwable)e);
        }
        catch (CheckstylePluginException e) {
            CheckstyleLog.log((Throwable)e);
        }
        return affected;
    }
}

