/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetAbstractBase;
import net.sf.eclipsecs.ui.util.regex.RegExContentAssistProcessor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contentassist.ContentAssistHandler;

public class ConfigPropertyWidgetRegex
extends ConfigPropertyWidgetAbstractBase {
    private Composite mContents;
    private Text mTextWidget;
    private Text mRegexTestWidget;
    private final String mDefaultMessage = Messages.ConfigPropertyWidgetRegex_msgRegexTestString;
    private final Color mRedColor;
    private final Color mGreenColor;
    private Color mTextBgColor;

    public ConfigPropertyWidgetRegex(Composite parent, ConfigProperty prop) {
        super(parent, prop);
        this.mGreenColor = new Color((Device)parent.getDisplay(), 219, 235, 204);
        this.mRedColor = new Color((Device)parent.getDisplay(), 255, 225, 225);
    }

    protected Control getValueWidget(Composite parent) {
        if (this.mContents == null) {
            this.mContents = new Composite(parent, 0);
            this.mContents.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(2, true);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.mContents.setLayout((Layout)layout);
            this.mTextWidget = new Text(this.mContents, 2052);
            this.mTextWidget.setLayoutData((Object)new GridData(768));
            this.mTextWidget.addKeyListener((KeyListener)new RegexTestListener());
            this.mTextBgColor = this.mTextWidget.getBackground();
            ContentAssistHandler.createHandlerForText((Text)this.mTextWidget, (SubjectControlContentAssistant)this.createContentAssistant());
            String initValue = this.getInitValue();
            if (initValue != null) {
                this.mTextWidget.setText(initValue);
            }
            this.mRegexTestWidget = new Text(this.mContents, 2052);
            this.mRegexTestWidget.setLayoutData((Object)new GridData(768));
            this.mRegexTestWidget.setText(this.mDefaultMessage);
            this.mRegexTestWidget.addKeyListener((KeyListener)new RegexTestListener());
            this.mRegexTestWidget.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            if (ConfigPropertyWidgetRegex.this.mRegexTestWidget.getText().equals(ConfigPropertyWidgetRegex.this.mDefaultMessage)) {
                                ConfigPropertyWidgetRegex.this.mRegexTestWidget.selectAll();
                            }
                        }
                    });
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }
        return this.mTextWidget;
    }

    public String getValue() {
        String result = this.mTextWidget.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void restorePropertyDefault() {
        ConfigPropertyMetadata metadata = this.getConfigProperty().getMetaData();
        String defaultValue = metadata.getOverrideDefault() != null ? metadata.getOverrideDefault() : metadata.getDefaultValue();
        this.mTextWidget.setText(defaultValue != null ? defaultValue : "");
    }

    public void validate() throws CheckstylePluginException {
        try {
            Pattern.compile(this.mTextWidget.getText());
        }
        catch (PatternSyntaxException e) {
            CheckstylePluginException.rethrow((Throwable)e, (String)e.getLocalizedMessage());
        }
    }

    private void testRegex() {
        if (this.mDefaultMessage.equals(this.mRegexTestWidget.getText())) {
            return;
        }
        try {
            Pattern pattern = Pattern.compile(this.mTextWidget.getText());
            Matcher matcher = pattern.matcher(this.mRegexTestWidget.getText());
            if (matcher.find()) {
                this.mRegexTestWidget.setBackground(this.mGreenColor);
            } else {
                this.mRegexTestWidget.setBackground(this.mRedColor);
            }
            this.mTextWidget.setBackground(this.mTextBgColor);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.mTextWidget.setBackground(this.mRedColor);
        }
    }

    private SubjectControlContentAssistant createContentAssistant() {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(CheckstyleUIPlugin.getDefault().getDialogSettings());
        RegExContentAssistProcessor processor = new RegExContentAssistProcessor(true);
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }

    private class RegexTestListener
    implements KeyListener {
        private RegexTestListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            ConfigPropertyWidgetRegex.this.testRegex();
        }
    }
}

