/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.cpd2.CPDViewLabelProvider2;
import net.sourceforge.pmd.eclipse.ui.views.cpd2.CPDViewTooltipListener2;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class CPDView2
extends ViewPart
implements IPropertyListener {
    private TreeViewer treeViewer;
    private TreeNodeContentProvider contentProvider;
    private CPDViewLabelProvider2 labelProvider;
    private int[] columnWidths;
    private Listener measureListener;
    private Listener resizeListener;
    private Color classColor;
    private Color packageColor;
    private Map<String, int[]> nameWidthsByName;
    private TreeColumn messageColumn;
    private static final int SpanColumnWidth = 50;
    private static final int MAX_MATCHES = 100;
    private static final int xGap = 6;
    private static final String TabEquivalent = "    ";
    public static final int SourceColumnIdx = 1;

    private static List<Match> asList(Iterator<Match> matchIter) {
        ArrayList<Match> matches = new ArrayList<Match>(100);
        int count = 0;
        while (matchIter.hasNext() && count < 100) {
            matches.add(matchIter.next());
            ++count;
        }
        Collections.sort(matches, Match.MATCHES_COMPARATOR);
        Collections.reverse(matches);
        return matches;
    }

    public static String[] partsOf(String fullName) {
        int pos = fullName.lastIndexOf(46);
        return new String[]{fullName.substring(0, pos + 1), fullName.substring(pos + 1)};
    }

    public static String[] sourceLinesFrom(Match match, boolean trimLeadingWhitespace) {
        int trimDepth;
        String text = match.getSourceCodeSlice().replaceAll("\t", TabEquivalent);
        StringTokenizer lines = new StringTokenizer(text, "\n");
        ArrayList<String> sourceLines = new ArrayList<String>();
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            sourceLines.add(line);
        }
        String[] lineArr = new String[sourceLines.size()];
        lineArr = sourceLines.toArray(lineArr);
        if (trimLeadingWhitespace && (trimDepth = StringUtil.maxCommonLeadingWhitespaceForAll((String[])lineArr)) > 0) {
            lineArr = StringUtil.trimStartOn((String[])lineArr, (int)trimDepth);
        }
        return lineArr;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.contentProvider = new TreeNodeContentProvider();
        this.labelProvider = new CPDViewLabelProvider2();
        this.measureListener = new Listener(){

            public void handleEvent(Event event) {
                CPDView2.this.captureColumnWidths();
            }
        };
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                int width = ((CPDView2)CPDView2.this).treeViewer.getTree().getBounds().width;
                CPDView2.this.messageColumn.setWidth(width - 50);
                CPDView2.this.captureColumnWidths();
                CPDView2.this.treeViewer.refresh();
            }
        };
        this.nameWidthsByName = new HashMap<String, int[]>();
    }

    public int widthOf(int columnIndex) {
        if (this.columnWidths == null) {
            this.captureColumnWidths();
        }
        return this.columnWidths[columnIndex];
    }

    private void captureColumnWidths() {
        TreeColumn[] columns = this.treeViewer.getTree().getColumns();
        this.columnWidths = new int[columns.length];
        int i = 0;
        while (i < this.columnWidths.length) {
            this.columnWidths[i] = columns[i].getWidth();
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        int treeStyle = 66306;
        this.treeViewer = new TreeViewer(parent, treeStyle);
        this.treeViewer.setUseHashlookup(true);
        Tree tree = this.treeViewer.getTree();
        tree.addListener(10, this.measureListener);
        tree.addListener(11, this.resizeListener);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.addPainters(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.addDeleteListener(this.treeViewer.getControl());
        this.createColumns(tree);
        CPDViewTooltipListener2 tooltipListener = new CPDViewTooltipListener2(this);
        tree.addListener(5, (Listener)tooltipListener);
        tree.addListener(32, (Listener)tooltipListener);
        tree.addListener(3, (Listener)tooltipListener);
        Display disp = tree.getDisplay();
        this.classColor = disp.getSystemColor(9);
        this.packageColor = disp.getSystemColor(15);
    }

    protected void addDeleteListener(Control control) {
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.character == '\u007f') {
                    CPDView2.this.removeSelectedItems();
                }
            }
        });
    }

    private void removeSelectedItems() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object[] items = selection.toArray();
        this.treeViewer.remove(items);
    }

    public int inColumn(Point point) {
        if (this.columnWidths == null) {
            return -1;
        }
        int pos = 0;
        int i = 0;
        while (i < this.columnWidths.length) {
            if (pos < point.x && pos + this.columnWidths[i] > point.x) {
                return i;
            }
            pos += this.columnWidths[i];
            ++i;
        }
        return -1;
    }

    public int[] widthsFor(String name) {
        return this.nameWidthsByName.get(name);
    }

    private void paintName(GC gc, int x, int y, String name, int rightEdge, int descent, int cellWidth) {
        String[] parts = CPDView2.partsOf(name);
        int packageWidth = 0;
        int classWidth = 0;
        int[] widths = this.nameWidthsByName.get(name);
        if (widths != null) {
            packageWidth = widths[0];
            classWidth = widths[1];
        } else {
            gc.setFont(this.treeViewer.getTree().getFont());
            packageWidth = gc.stringExtent((String)parts[0]).x;
            classWidth = gc.stringExtent((String)parts[1]).x;
            this.nameWidthsByName.put(name, new int[]{packageWidth, classWidth});
        }
        int drawX = x + rightEdge - classWidth - 6;
        gc.setForeground(this.classColor);
        gc.drawText(parts[1], drawX, y + descent, false);
        drawX = x + rightEdge - classWidth - packageWidth - 6;
        gc.setForeground(this.packageColor);
        gc.drawText(parts[0], drawX, y + descent, false);
    }

    private void addPainters(Tree tree) {
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.index != 1) {
                    return;
                }
                Object item = ((TreeNode)event.item.getData()).getValue();
                String[] names = null;
                if (!(item instanceof Match)) {
                    return;
                }
                names = CPDViewLabelProvider2.sourcesFor((Match)item);
                int descent = event.gc.getFontMetrics().getDescent();
                int colWidth = CPDView2.this.widthOf(1);
                int cellWidth = colWidth / names.length;
                int i = 0;
                while (i < names.length) {
                    int rightEdge = colWidth - cellWidth * i;
                    CPDView2.this.paintName(event.gc, event.x, event.y, names[i], rightEdge, descent, cellWidth);
                    ++i;
                }
            }
        };
        Listener measureListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.index != 1) {
                    return;
                }
                event.width = 400;
                event.height = 24;
            }
        };
        tree.addListener(42, paintListener);
        tree.addListener(41, measureListener);
    }

    private void createColumns(Tree tree) {
        TreeColumn plusColumn = new TreeColumn(tree, 131072);
        plusColumn.setText("Spans");
        plusColumn.setWidth(50);
        this.messageColumn = new TreeColumn(tree, 16384);
        this.messageColumn.addListener(10, this.measureListener);
        this.messageColumn.setText("Source");
        this.messageColumn.setWidth(500);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setData(Iterator<Match> matches) {
        ArrayList<TreeNode> elements = new ArrayList<TreeNode>();
        if (matches != null) {
            for (Match match : CPDView2.asList(matches)) {
                TreeNode matchNode = new TreeNode((Object)match);
                elements.add(matchNode);
                String[] lines = CPDView2.sourceLinesFrom(match, true);
                TreeNode[] children = new TreeNode[lines.length];
                int j = 0;
                while (j < lines.length) {
                    String line = lines[j];
                    if (line == null) {
                        System.out.println();
                    }
                    children[j] = new TreeNode((Object)line);
                    children[j].setParent(matchNode);
                    ++j;
                }
                matchNode.setChildren(children);
            }
        }
        this.treeViewer.setInput((Object)elements.toArray(new TreeNode[elements.size()]));
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1111 && source instanceof Iterator) {
            Iterator iter = (Iterator)source;
            boolean hasResults = iter.hasNext();
            this.setData(iter);
            if (!hasResults) {
                MessageBox box = new MessageBox(this.treeViewer.getControl().getShell());
                box.setText(this.getString("dialog.cpd.no_results.header"));
                box.setMessage(this.getString("dialog.cpd.no_results.body"));
                box.open();
            }
        }
    }
}

