/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.eclipse.ui.views.ChangeEvaluator;
import net.sourceforge.pmd.eclipse.ui.views.ChangeRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import net.sourceforge.pmd.eclipse.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ViolationOverviewContentProvider
implements ITreeContentProvider,
IStructuredContentProvider,
IResourceChangeListener {
    private static final Log LOG = LogFactory.getLog(ViolationOverviewContentProvider.class);
    protected boolean filterPackages;
    private final ViolationOverview violationView;
    private TreeViewer treeViewer;
    private RootRecord root;
    private ChangeEvaluator changeEvaluator;

    public ViolationOverviewContentProvider(ViolationOverview view) {
        this.violationView = view;
        this.treeViewer = view.getViewer();
    }

    public void dispose() {
        if (this.root != null) {
            IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)this.root.getResource();
            workspaceRoot.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot || parentElement instanceof RootRecord) {
            return this.getChildrenOfRoot();
        }
        if (parentElement instanceof PackageRecord) {
            return this.getChildrenOfPackage((PackageRecord)parentElement);
        }
        if (parentElement instanceof FileRecord) {
            return this.getChildrenOfFile((FileRecord)parentElement);
        }
        if (parentElement instanceof MarkerRecord) {
            return this.getChildrenOfMarker((MarkerRecord)parentElement);
        }
        return Util.EMPTY_ARRAY;
    }

    private Object[] getChildrenOfFile(FileRecord record) {
        return record.getChildren();
    }

    private Object[] getChildrenOfMarker(MarkerRecord record) {
        record.updateChildren();
        return record.getChildren();
    }

    private Object[] getChildrenOfPackage(PackageRecord record) {
        if (this.violationView.getShowType() == 3) {
            HashMap<String, AbstractPMDRecord> markers = new HashMap<String, AbstractPMDRecord>();
            List<AbstractPMDRecord> files = record.getChildrenAsList();
            for (AbstractPMDRecord fileRec : files) {
                List<AbstractPMDRecord> newMarkers = fileRec.getChildrenAsList();
                for (AbstractPMDRecord markerRec : newMarkers) {
                    markers.put(markerRec.getName(), markerRec);
                }
            }
            return markers.values().toArray(new MarkerRecord[markers.size()]);
        }
        return record.getChildren();
    }

    private Object[] getChildrenOfRoot() {
        List<AbstractPMDRecord> projects = this.root.getChildrenAsList();
        ProjectRecord[] projectArray = new ProjectRecord[projects.size()];
        projects.toArray(projectArray);
        ArrayList<AbstractPMDRecord> packages = new ArrayList<AbstractPMDRecord>();
        ProjectRecord[] projectRecordArray = projectArray;
        int n = projectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectRecord element = projectRecordArray[n2];
            if (element.isProjectOpen()) {
                packages.addAll(element.getChildrenAsList());
            }
            ++n2;
        }
        switch (this.violationView.getShowType()) {
            case 1: 
            case 3: {
                return packages.toArray();
            }
            case 2: {
                ArrayList<AbstractPMDRecord> files = new ArrayList<AbstractPMDRecord>();
                for (AbstractPMDRecord packageRec : packages) {
                    files.addAll(packageRec.getChildrenAsList());
                }
                return files.toArray();
            }
        }
        return Util.EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        AbstractPMDRecord parent = null;
        AbstractPMDRecord record = (AbstractPMDRecord)element;
        switch (this.violationView.getShowType()) {
            case 2: {
                if (element instanceof FileRecord) {
                    parent = this.root;
                    break;
                }
                parent = record.getParent();
                break;
            }
            case 3: {
                if (element instanceof FileToMarkerRecord) {
                    parent = record.getParent();
                    break;
                }
                if (element instanceof PackageRecord) {
                    parent = this.root;
                    break;
                }
                if (!(element instanceof MarkerRecord)) break;
                parent = record.getParent().getParent();
                break;
            }
            case 1: {
                parent = element instanceof PackageRecord ? this.root : record.getParent();
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = true;
        switch (this.violationView.getShowType()) {
            case 1: 
            case 2: {
                hasChildren ^= element instanceof MarkerRecord;
                break;
            }
            case 3: {
                hasChildren ^= element instanceof FileToMarkerRecord;
            }
        }
        if (hasChildren) {
            hasChildren = this.getChildren(element).length > 0;
        }
        return hasChildren;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        LOG.debug((Object)"ViolationOverview inputChanged");
        this.treeViewer = (TreeViewer)viewer;
        IWorkspaceRoot workspaceRoot = null;
        if (this.root != null) {
            LOG.debug((Object)"remove current listener");
            workspaceRoot = (IWorkspaceRoot)this.root.getResource();
            workspaceRoot.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (newInput instanceof IWorkspaceRoot) {
            LOG.debug((Object)"the new input is a workspace root");
            workspaceRoot = (IWorkspaceRoot)newInput;
            this.root = new RootRecord(workspaceRoot);
            workspaceRoot.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        } else if (newInput instanceof RootRecord) {
            LOG.debug((Object)"the new input is a root record");
            this.root = (RootRecord)newInput;
            workspaceRoot = (IWorkspaceRoot)this.root.getResource();
            workspaceRoot.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.changeEvaluator = new ChangeEvaluator(this.root);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final ChangeRecord<AbstractPMDRecord> changes = this.changeEvaluator.changeRecordFor(event);
        this.treeViewer.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ViolationOverviewContentProvider.this.updateViewer(changes);
            }
        });
    }

    protected void updateViewer(ChangeRecord<AbstractPMDRecord> changes) {
        if (changes.hasRemovals()) {
            this.treeViewer.cancelEditing();
            this.treeViewer.remove(changes.removals.toArray());
        }
        for (AbstractPMDRecord addedRec : changes.additions) {
            if (addedRec instanceof FileRecord) {
                this.treeViewer.add((Object)addedRec.getParent(), (Object)addedRec);
                continue;
            }
            this.treeViewer.add((Object)this.root, (Object)addedRec);
        }
        if (changes.hasChanges()) {
            this.treeViewer.update(changes.changes.toArray(), null);
        }
        this.violationView.refresh();
    }
}

