/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.quickfix;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.eclipse.ui.quickfix.AbstractFix;

public class SearchAndReplace
extends AbstractFix {
    private final String searchStr;
    private final String replaceStr;
    private final Pattern pattern;

    public SearchAndReplace(String searchString, String replacement) {
        super("Search & replace");
        this.searchStr = searchString;
        this.replaceStr = replacement;
        this.pattern = Pattern.compile(this.searchStr);
    }

    @Override
    public String fix(String sourceCode, int lineNumber) {
        Matcher matcher = this.pattern.matcher(sourceCode);
        return matcher.replaceAll(this.replaceStr);
    }
}

