/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleTableViewerSorter;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPageBean;
import net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPageController;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.PropertyPage;

public class PMDPropertyPage
extends PropertyPage {
    private PMDPropertyPageController controller;
    private PMDPropertyPageBean model;
    private Button enablePMDButton;
    protected TableViewer availableRulesTableViewer;
    private IWorkingSet selectedWorkingSet;
    private Label selectedWorkingSetLabel;
    private Button deselectWorkingSetButton;
    private Button includeDerivedFilesButton;
    private Button violationsAsErrorsButton;
    private Button fullBuildEnabledButton;
    protected Button ruleSetStoredInProjectButton;
    protected Text ruleSetFileText;
    protected Button ruleSetBrowseButton;
    private Collection<Control> activeControls = new ArrayList<Control>();
    private final RuleTableViewerSorter availableRuleTableViewerSorter = new RuleTableViewerSorter(RuleTableViewerSorter.RULE_DEFAULT_COMPARATOR);
    private static final Logger log = Logger.getLogger(PMDPropertyPage.class);

    protected Control createContents(Composite parent) {
        log.info((Object)"PMD properties editing requested");
        this.controller = new PMDPropertyPageController(this.getShell());
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        this.controller.setProject(project);
        this.model = this.controller.getPropertyPageBean();
        Composite composite = null;
        this.noDefaultAndApplyButton();
        if (project.isAccessible() && this.model != null) {
            composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            this.enablePMDButton = this.buildEnablePMDButton(composite);
            Label separator = new Label(composite, 262);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            separator.setLayoutData((Object)data);
            this.includeDerivedFilesButton = this.buildIncludeDerivedFilesButton(composite);
            separator = new Label(composite, 262);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            separator.setLayoutData((Object)data);
            this.violationsAsErrorsButton = this.buildViolationsAsErrorsButton(composite);
            this.fullBuildEnabledButton = this.buildFullBuildEnabledButton(composite);
            separator = new Label(composite, 262);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            separator.setLayoutData((Object)data);
            this.selectedWorkingSetLabel = this.buildSelectedWorkingSetLabel(composite);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.selectedWorkingSetLabel.setLayoutData((Object)data);
            Composite workingSetPanel = new Composite(composite, 0);
            RowLayout rowLayout = new RowLayout();
            rowLayout.type = 256;
            rowLayout.justify = true;
            rowLayout.pack = false;
            rowLayout.wrap = false;
            workingSetPanel.setLayout((Layout)rowLayout);
            this.buildSelectWorkingSetButton(workingSetPanel);
            this.deselectWorkingSetButton = this.buildDeselectWorkingSetButton(workingSetPanel);
            separator = new Label(composite, 262);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            separator.setLayoutData((Object)data);
            this.buildLabel(composite, "property.label.select_rule");
            Table availableRulesTable = this.buildAvailableRulesTableViewer(composite);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.heightHint = 50;
            availableRulesTable.setLayoutData((Object)data);
            Composite ruleSetPanel = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            ruleSetPanel.setLayout((Layout)gridLayout);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            ruleSetPanel.setLayoutData((Object)data);
            this.ruleSetStoredInProjectButton = this.buildStoreRuleSetInProjectButton(ruleSetPanel);
            this.ruleSetFileText = this.buildRuleSetFileText(ruleSetPanel);
            this.ruleSetBrowseButton = this.buildRuleSetBrowseButton(ruleSetPanel);
            data = new GridData(4, 0, true, false);
            this.ruleSetFileText.setLayoutData((Object)data);
            this.refreshRuleSetInProject();
            this.adjustControls();
        } else {
            this.setValid(false);
        }
        log.debug((Object)"Property page created");
        return composite;
    }

    private void adjustControls() {
        boolean isEnabled = this.enablePMDButton.getSelection();
        SWTUtil.setEnabled(this.activeControls, isEnabled);
        if (isEnabled) {
            this.deselectWorkingSetButton.setEnabled(this.selectedWorkingSet != null);
        }
    }

    private Button newCheckButton(Composite parent, String labelKey) {
        Button button = new Button(parent, 32);
        button.setText(this.getMessage(labelKey));
        this.activeControls.add((Control)button);
        return button;
    }

    private Button buildEnablePMDButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(this.getMessage("property.button.enable"));
        button.setSelection(this.model.isPmdEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PMDPropertyPage.this.adjustControls();
            }
        });
        return button;
    }

    private Button buildIncludeDerivedFilesButton(Composite parent) {
        Button button = this.newCheckButton(parent, "property.button.include_derived_files");
        button.setSelection(this.model.isIncludeDerivedFiles());
        return button;
    }

    private Button buildViolationsAsErrorsButton(Composite parent) {
        Button button = this.newCheckButton(parent, "property.button.violations_as_errors");
        button.setSelection(this.model.violationsAsErrors());
        return button;
    }

    private Button buildFullBuildEnabledButton(Composite parent) {
        Button button = this.newCheckButton(parent, "property.button.full_build_enabled");
        button.setSelection(this.model.isFullBuildEnabled());
        return button;
    }

    private Button buildStoreRuleSetInProjectButton(Composite parent) {
        Button button = this.newCheckButton(parent, "property.button.store_ruleset_project");
        button.setSelection(this.model.isRuleSetStoredInProject());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PMDPropertyPage.this.refreshRuleSetInProject();
            }
        });
        return button;
    }

    private Text buildRuleSetFileText(Composite parent) {
        Text text = new Text(parent, 2052);
        String ruleSetFile = this.model.getRuleSetFile();
        if (ruleSetFile != null) {
            text.setText(ruleSetFile);
        }
        this.activeControls.add((Control)text);
        return text;
    }

    private Button buildRuleSetBrowseButton(Composite parent) {
        Button button = this.newPushButton(parent, "property.button.ruleset_browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(PMDPropertyPage.this.getShell(), 4096);
                String path = fileDialog.open();
                if (path != null) {
                    PMDPropertyPage.this.ruleSetFileText.setText(path);
                }
            }
        });
        return button;
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        label.setText(msgKey == null ? "" : this.getMessage(msgKey));
        this.activeControls.add((Control)label);
        return label;
    }

    private Label buildSelectedWorkingSetLabel(Composite parent) {
        this.selectedWorkingSet = this.model.getProjectWorkingSet();
        Label label = new Label(parent, 0);
        label.setText(this.selectedWorkingSet == null ? this.getMessage("property.label.no_workingset") : String.valueOf(this.getMessage("property.label.selected_workingset")) + this.selectedWorkingSet.getName());
        this.activeControls.add((Control)label);
        return label;
    }

    private Table buildAvailableRulesTableViewer(Composite parent) {
        this.availableRulesTableViewer = new TableViewer(parent, 68388);
        Table ruleTable = this.availableRulesTableViewer.getTable();
        this.addColumnTo(ruleTable, 16384, true, "preference.ruleset.column.language", 90, RuleTableViewerSorter.RULE_LANGUAGE_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, true, "preference.ruleset.column.ruleset_name", 110, RuleTableViewerSorter.RULE_RULESET_NAME_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, true, "preference.ruleset.column.rule_name", 170, RuleTableViewerSorter.RULE_NAME_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, false, "preference.ruleset.column.since", 40, RuleTableViewerSorter.RULE_SINCE_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, false, "preference.ruleset.column.priority", 80, RuleTableViewerSorter.RULE_PRIORITY_COMPARATOR);
        this.addColumnTo(ruleTable, 16384, true, "preference.ruleset.column.description", 300, RuleTableViewerSorter.RULE_DESCRIPTION_COMPARATOR);
        ruleTable.setLinesVisible(true);
        ruleTable.setHeaderVisible(true);
        this.availableRulesTableViewer.setContentProvider((IContentProvider)new RuleSetContentProvider());
        this.availableRulesTableViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.availableRulesTableViewer.setSorter((ViewerSorter)this.availableRuleTableViewerSorter);
        this.availableRulesTableViewer.setColumnProperties(new String[]{"language", "ruleSetname", "ruleName", "since", "priority", "description"});
        this.populateAvailableRulesTable();
        this.activeControls.add((Control)ruleTable);
        return ruleTable;
    }

    private void addColumnTo(Table table, int alignment, boolean resizable, String textKey, int width, final Comparator<Rule> comparator) {
        TableColumn newColumn = new TableColumn(table, alignment);
        newColumn.setResizable(resizable);
        newColumn.setText(this.getMessage(textKey));
        newColumn.setWidth(width);
        if (comparator != null) {
            newColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PMDPropertyPage.this.availableRuleTableViewerSorter.setComparator(comparator);
                    PMDPropertyPage.this.refresh();
                }
            });
        }
    }

    private Button newPushButton(Composite parent, String labelKey) {
        Button button = new Button(parent, 8);
        button.setText(this.getMessage(labelKey));
        this.activeControls.add((Control)button);
        return button;
    }

    private void buildSelectWorkingSetButton(Composite parent) {
        Button workingSetButton = this.newPushButton(parent, "property.button.select_workingset");
        workingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PMDPropertyPage.this.selectWorkingSet();
            }
        });
    }

    private Button buildDeselectWorkingSetButton(Composite parent) {
        Button button = this.newPushButton(parent, "property.button.deselect_workingset");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PMDPropertyPage.this.deselectWorkingSet();
            }
        });
        return button;
    }

    private void populateAvailableRulesTable() {
        this.availableRulesTableViewer.setInput((Object)this.controller.getAvailableRules());
        RuleSet activeRuleSet = this.model.getProjectRuleSet();
        if (activeRuleSet != null) {
            TableItem[] itemList;
            Collection activeRules = activeRuleSet.getRules();
            TableItem[] tableItemArray = itemList = this.availableRulesTableViewer.getTable().getItems();
            int n = itemList.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem element2 = tableItemArray[n2];
                Object rule = element2.getData();
                if (activeRules.contains(rule)) {
                    element2.setChecked(true);
                }
                ++n2;
            }
        }
    }

    public boolean performOk() {
        log.info((Object)"Properties editing accepted");
        this.model.setPmdEnabled(this.enablePMDButton.getSelection());
        this.model.setProjectWorkingSet(this.selectedWorkingSet);
        this.model.setProjectRuleSet(this.getProjectRuleSet());
        this.model.setRuleSetStoredInProject(this.ruleSetStoredInProjectButton.getSelection());
        this.model.setRuleSetFile(this.ruleSetFileText.getText());
        this.model.setIncludeDerivedFiles(this.includeDerivedFilesButton.getSelection());
        this.model.setViolationsAsErrors(this.violationsAsErrorsButton.getSelection());
        this.model.setFullBuildEnabled(this.fullBuildEnabledButton.getSelection());
        return this.controller.performOk();
    }

    public boolean performCancel() {
        log.info((Object)"Properties editing canceled");
        return super.performCancel();
    }

    private RuleSet getProjectRuleSet() {
        TableItem[] rulesList;
        RuleSet ruleSet = new RuleSet();
        TableItem[] tableItemArray = rulesList = this.availableRulesTableViewer.getTable().getItems();
        int n = rulesList.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem element2 = tableItemArray[n2];
            if (element2.getChecked()) {
                Rule rule = (Rule)element2.getData();
                ruleSet.addRule(rule);
            }
            ++n2;
        }
        RuleSet activeRuleSet = this.model.getProjectRuleSet();
        ruleSet.addExcludePatterns((Collection)activeRuleSet.getExcludePatterns());
        ruleSet.addIncludePatterns((Collection)activeRuleSet.getIncludePatterns());
        return ruleSet;
    }

    protected void selectWorkingSet() {
        log.info((Object)"Select working set");
        this.setSelectedWorkingSet(this.controller.selectWorkingSet(this.selectedWorkingSet));
    }

    protected void deselectWorkingSet() {
        log.info((Object)"Deselect working set");
        this.setSelectedWorkingSet(null);
    }

    private void setSelectedWorkingSet(IWorkingSet workingSet) {
        this.selectedWorkingSet = workingSet;
        this.selectedWorkingSetLabel.setText(this.selectedWorkingSet == null ? this.getMessage("property.label.no_workingset") : String.valueOf(this.getMessage("property.label.selected_workingset")) + this.selectedWorkingSet.getName());
        this.deselectWorkingSetButton.setEnabled(this.selectedWorkingSet != null);
    }

    private String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    protected void refresh() {
        try {
            try {
                TableItem[] items;
                this.availableRulesTableViewer.getControl().setRedraw(false);
                Collection rules = this.getProjectRuleSet().getRules();
                this.availableRulesTableViewer.refresh();
                TableItem[] tableItemArray = items = this.availableRulesTableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (rules.contains(item.getData())) {
                        item.setChecked(true);
                    }
                    ++n2;
                }
            }
            catch (ClassCastException e) {
                PMDPlugin.getDefault().logError("Ignoring exception while refreshing table", e);
                this.availableRulesTableViewer.getControl().setRedraw(true);
            }
        }
        finally {
            this.availableRulesTableViewer.getControl().setRedraw(true);
        }
    }

    protected void refreshRuleSetInProject() {
        Table ruleTable = this.availableRulesTableViewer.getTable();
        if (this.ruleSetStoredInProjectButton.getSelection()) {
            ruleTable.setEnabled(false);
            this.ruleSetBrowseButton.setEnabled(true);
            this.ruleSetFileText.setEnabled(true);
        } else {
            ruleTable.setEnabled(true);
            this.ruleSetBrowseButton.setEnabled(false);
            this.ruleSetFileText.setEnabled(false);
        }
    }
}

