/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.ui.ColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.ModifyListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.AbstractTableManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.FormatManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleGroup;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueFormatter;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.views.ChangeRecord;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public abstract class AbstractTreeTableManager<T>
extends AbstractTableManager<T> {
    protected ContainerCheckedTreeViewer treeViewer;
    private Button selectAllButton;
    private Button unSelectAllButton;
    private ModifyListener modifyListener;
    private Label activeCountLabel;
    private Label activeCountIssue;
    private ChangeRecord<T> changes;
    private Map<Integer, List<Listener>> paintListeners = new HashMap<Integer, List<Listener>>();

    protected static AbstractTableManager.ColumnWidthAdapter adapterFor(final TreeColumn column) {
        return new AbstractTableManager.ColumnWidthAdapter(){

            @Override
            public int width() {
                return column.getWidth();
            }

            @Override
            public void width(int newWidth) {
                column.setWidth(newWidth);
            }

            @Override
            public Display display() {
                return column.getDisplay();
            }

            @Override
            public void setData(String key, Object value) {
                column.setData(key, value);
            }

            @Override
            public Object getData(String key) {
                return column.getData(key);
            }
        };
    }

    public AbstractTreeTableManager(String theWidgetId, IPreferences thePreferences, ColumnDescriptor[] theColumns) {
        super(theWidgetId, thePreferences, theColumns);
    }

    public Tree getControl() {
        return this.treeViewer.getTree();
    }

    @Override
    protected String idFor(Object column) {
        return ((TreeColumn)column).getToolTipText();
    }

    protected void removed(Collection<T> items) {
        if (this.changes == null) {
            this.changes = new ChangeRecord();
        }
        this.changes.removed(items);
        this.updateCheckControls();
    }

    protected void added(T item) {
        if (this.changes == null) {
            this.changes = new ChangeRecord();
        }
        this.changes.added(item);
        this.updateCheckControls();
    }

    protected Map<Integer, List<Listener>> paintListeners() {
        return this.paintListeners;
    }

    protected void createCheckBoxColumn(Tree tree) {
        TreeColumn tc = new TreeColumn(tree, 0);
        Image image = new Image((Device)Display.getCurrent(), 15, 15);
        GC gc = new GC((Drawable)image);
        Point textExtent = gc.textExtent("m");
        gc.dispose();
        image.dispose();
        tc.setWidth(textExtent.x * 4);
        tc.setResizable(true);
        tc.pack();
        tc.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AbstractTreeTableManager.this.sortByCheckedItems();
            }
        });
    }

    protected Tree cleanupRuleTree() {
        Tree tree = this.treeViewer.getTree();
        tree.clearAll(true);
        while (tree.getColumns().length > 0) {
            tree.getColumns()[0].dispose();
        }
        for (Map.Entry<Integer, List<Listener>> entry : this.paintListeners.entrySet()) {
            int eventCode = entry.getKey();
            List<Listener> listeners = entry.getValue();
            for (Listener listener : listeners) {
                tree.removeListener(eventCode, listener);
            }
            listeners.clear();
        }
        return tree;
    }

    protected abstract boolean isQualifiedItem(Object var1);

    @Override
    protected abstract void saveItemSelections();

    public int activeItemCount() {
        Object[] checkedItems = this.treeViewer.getCheckedElements();
        int count = 0;
        Object[] objectArray = checkedItems;
        int n = checkedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (this.isQualifiedItem(item)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    protected CheckboxTreeViewer treeViewer() {
        return this.treeViewer;
    }

    public ChangeRecord<T> changes() {
        return this.changes;
    }

    protected Button newImageButton(Composite parent, String imageId, String toolTipId) {
        Button button = new Button(parent, 16392);
        button.setImage(ResourceManager.imageFor(imageId));
        button.setToolTipText(this.getMessage(toolTipId));
        button.setEnabled(true);
        return button;
    }

    protected Button buildSelectAllButton(Composite parent) {
        Button button = this.newImageButton(parent, "icons/checkAll.png", "preference.ruleset.button.tooltip.check.all");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTreeTableManager.this.setAllItemsActive();
            }
        });
        return button;
    }

    protected Button buildUnselectAllButton(Composite parent) {
        Button button = this.newImageButton(parent, "icons/uncheckAll.png", "preference.ruleset.button.tooltip.uncheck.all");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTreeTableManager.this.preferences.getActiveRuleNames().clear();
                AbstractTreeTableManager.this.treeViewer().setCheckedElements(new Object[0]);
                AbstractTreeTableManager.this.setModified();
                AbstractTreeTableManager.this.updateCheckControls();
            }
        });
        return button;
    }

    protected abstract String nameFor(Object var1);

    private void check(TreeItem item, boolean checked) {
        item.setChecked(checked);
        Object itemData = item.getData();
        if (itemData == null || itemData instanceof RuleGroup) {
            return;
        }
        String name = this.nameFor(itemData);
        this.isActive(name, checked);
        this.updateCheckControls();
        this.setModified();
    }

    protected abstract void selectedItems(Object[] var1);

    protected abstract void updateTooltipFor(TreeItem var1, int var2);

    public static int columnIndexAt(TreeItem item, int xPosition) {
        TreeColumn[] cols = item.getParent().getColumns();
        Rectangle bounds = null;
        int i = 0;
        while (i < cols.length) {
            bounds = item.getBounds(i);
            if (bounds.x < xPosition && xPosition < bounds.x + bounds.width) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void buildTreeViewer(Composite parent) {
        int treeStyle = 68386;
        this.treeViewer = new ContainerCheckedTreeViewer(parent, treeStyle);
        final Tree tree = this.treeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                AbstractTreeTableManager.this.selectedItems(selection.toArray());
            }
        });
        this.addDeleteListener((Control)tree);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.character == ' ') {
                    AbstractTreeTableManager.this.toggleSelectedItems();
                }
            }
        });
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    boolean checked = item.getChecked();
                    AbstractTreeTableManager.this.checkItems(item, checked);
                    AbstractTreeTableManager.this.checkPath(item.getParentItem(), checked, false);
                }
            }
        });
        tree.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = tree.getItem(point);
                if (item != null) {
                    int columnIndex = AbstractTreeTableManager.columnIndexAt(item, event.x);
                    AbstractTreeTableManager.this.updateTooltipFor(item, columnIndex);
                }
            }
        });
        this.setupMenusFor((Control)tree);
    }

    @Override
    protected int headerHeightFor(Control control) {
        return ((Tree)control).getHeaderHeight();
    }

    @Override
    protected void setMenu(Control control, Menu menu) {
        ((Tree)control).setMenu(menu);
    }

    @Override
    protected Rectangle clientAreaFor(Control control) {
        return ((Tree)control).getClientArea();
    }

    public void updated(Object item) {
        this.treeViewer.update(item, null);
    }

    protected void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        this.check(item, checked);
        item.setGrayed(grayed);
        this.checkPath(item.getParentItem(), checked, grayed);
    }

    protected void checkItems(TreeItem item, boolean checked) {
        TreeItem[] items;
        item.setGrayed(false);
        this.check(item, checked);
        TreeItem[] treeItemArray = items = item.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item2 = treeItemArray[n2];
            this.checkItems(item2, checked);
            ++n2;
        }
        this.updateCheckControls();
    }

    private void toggleSelectedItems() {
        System.out.println("TODO: toggle selected items");
    }

    protected void buildActiveCountWidgets(Composite parent) {
        this.activeCountLabel = new Label(parent, 0);
        this.activeCountLabel.setText("---");
        GridData data = new GridData(64, 2, true, false, 1, 1);
        this.activeCountLabel.setAlignment(131072);
        this.activeCountLabel.setLayoutData((Object)data);
        this.activeCountIssue = new Label(parent, 0);
        data = new GridData(64, 2, true, false, 1, 1);
        this.activeCountIssue.setAlignment(131072);
        this.activeCountIssue.setLayoutData((Object)data);
    }

    protected void activeCountDetails(String msg, Image image) {
        if (this.activeCountLabel == null) {
            return;
        }
        this.activeCountLabel.setText(msg);
        this.activeCountIssue.setImage(image);
        this.activeCountIssue.getParent().pack();
        this.activeCountLabel.getParent().pack();
    }

    protected void buildCheckButtons(Composite parent) {
        this.selectAllButton = this.buildSelectAllButton(parent);
        this.unSelectAllButton = this.buildUnselectAllButton(parent);
    }

    @Override
    protected AbstractTableManager.ColumnWidthAdapter columnAdapterFor(ColumnDescriptor desc) {
        TreeColumn column = this.columnFor(desc);
        return AbstractTreeTableManager.adapterFor(column);
    }

    protected void redrawTable() {
        this.redrawTable("-", -1);
    }

    @Override
    protected void redrawTable(String sortColumnLabel, int sortDir) {
        TreeColumn sortColumn = this.columnFor(sortColumnLabel);
        this.treeViewer().getTree().setSortColumn(sortColumn);
        this.treeViewer().getTree().setSortDirection(sortDir);
    }

    private TreeColumn columnFor(String tooltipText) {
        TreeColumn[] treeColumnArray = this.treeViewer().getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            if (String.valueOf(column.getToolTipText()).equals(tooltipText)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    private TreeColumn columnFor(ColumnDescriptor desc) {
        TreeColumn[] treeColumnArray = this.treeViewer().getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            if (column.getData("descriptor") == desc) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    protected void formatValueOn(StringBuilder target, Object value, Class<?> datatype) {
        ValueFormatter formatter = FormatManager.formatterFor(datatype);
        if (formatter != null) {
            formatter.format(value, target);
            return;
        }
        target.append(value);
    }

    protected abstract void setAllItemsActive();

    protected abstract void sortByCheckedItems();

    public void modifyListener(ModifyListener theListener) {
        this.modifyListener = theListener;
    }

    protected void setModified() {
        if (this.modifyListener != null) {
            this.modifyListener.setModified();
        }
    }

    protected void updateButtonsFor(int selections, int totalSelections) {
        SWTUtil.setEnabled((Control)this.selectAllButton, selections < totalSelections);
        SWTUtil.setEnabled((Control)this.unSelectAllButton, selections > 0);
    }

    protected abstract void updateCheckControls();

    protected void refresh() {
        try {
            try {
                this.treeViewer().getControl().setRedraw(false);
                this.treeViewer().refresh();
            }
            catch (ClassCastException e) {
                plugin.logError("Ignoring exception while refreshing table", e);
                this.treeViewer().getControl().setRedraw(true);
            }
        }
        finally {
            this.treeViewer().getControl().setRedraw(true);
        }
    }
}

