/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectRecord
extends AbstractPMDRecord {
    private final IProject project;
    private final RootRecord parent;
    private AbstractPMDRecord[] children;

    public ProjectRecord(IProject project, RootRecord record) {
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        if (record == null) {
            throw new IllegalArgumentException("record cannot be null");
        }
        this.project = project;
        this.parent = record;
        this.children = project.isAccessible() ? this.createChildren() : EMPTY_RECORDS;
    }

    @Override
    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    @Override
    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    @Override
    protected final AbstractPMDRecord[] createChildren() {
        final HashSet packages = new HashSet();
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean visitChildren = false;
                    switch (resource.getType()) {
                        case 2: {
                            IJavaElement javaMember = JavaCore.create((IResource)resource);
                            if (javaMember == null) {
                                visitChildren = true;
                                break;
                            }
                            if (javaMember instanceof IPackageFragmentRoot) {
                                packages.addAll(ProjectRecord.this.createPackagesFromFragmentRoot((IPackageFragmentRoot)javaMember));
                            } else if (javaMember instanceof IPackageFragment && javaMember.getParent() instanceof IPackageFragmentRoot) {
                                IPackageFragment fragment = (IPackageFragment)javaMember;
                                packages.addAll(ProjectRecord.this.createPackagesFromFragmentRoot((IPackageFragmentRoot)fragment.getParent()));
                            }
                            visitChildren = false;
                            break;
                        }
                        case 4: {
                            visitChildren = true;
                            break;
                        }
                        default: {
                            visitChildren = false;
                        }
                    }
                    return visitChildren;
                }
            });
        }
        catch (CoreException ce) {
            PMDPlugin.getDefault().logError("message.error.core_exception" + this.toString(), ce);
        }
        return packages.toArray(new AbstractPMDRecord[packages.size()]);
    }

    protected final Set<PackageRecord> createPackagesFromFragmentRoot(IPackageFragmentRoot root) {
        HashSet<PackageRecord> packages = new HashSet<PackageRecord>();
        IJavaElement[] fragments = null;
        try {
            IJavaElement[] iJavaElementArray = fragments = root.getChildren();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement fragment = iJavaElementArray[n2];
                if (fragment instanceof IPackageFragment) {
                    packages.add(new PackageRecord((IPackageFragment)fragment, this));
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            PMDPlugin.getDefault().logError("message.error.javamodel_exception" + this.toString(), jme);
        }
        return packages;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public boolean isProjectOpen() {
        return this.project.isOpen();
    }

    @Override
    public int getResourceType() {
        return 4;
    }

    @Override
    public AbstractPMDRecord addResource(IResource resource) {
        AbstractPMDRecord addedResource = null;
        if (resource instanceof IFile) {
            IJavaElement javaMember = JavaCore.create((IResource)resource.getParent());
            if (javaMember instanceof IPackageFragmentRoot) {
                javaMember = ((IPackageFragmentRoot)javaMember).getPackageFragment("");
            }
            IPackageFragment fragment = (IPackageFragment)javaMember;
            int k = 0;
            while (k < this.children.length && addedResource == null) {
                PackageRecord packageRec = (PackageRecord)this.children[k];
                if (packageRec.getFragment().equals(fragment)) {
                    addedResource = packageRec.addResource(resource);
                }
                ++k;
            }
            if (addedResource == null) {
                PackageRecord packageRec = new PackageRecord(fragment, this);
                List<AbstractPMDRecord> packages = this.getChildrenAsList();
                packages.add(packageRec);
                this.children = new AbstractPMDRecord[packages.size()];
                packages.toArray(this.children);
                addedResource = packageRec.addResource(resource);
            }
        }
        return addedResource;
    }

    @Override
    public AbstractPMDRecord removeResource(IResource resource) {
        AbstractPMDRecord removedResource = null;
        if (resource instanceof IFile) {
            IJavaElement element = JavaCore.create((IResource)resource.getParent());
            IPackageFragment fragment = element instanceof IPackageFragment ? (IPackageFragment)element : ((IPackageFragmentRoot)element).getPackageFragment("");
            int k = 0;
            while (k < this.children.length && removedResource == null) {
                PackageRecord packageRec = (PackageRecord)this.children[k];
                if (packageRec.getFragment().equals(fragment)) {
                    AbstractPMDRecord fileRec = packageRec.removeResource(resource);
                    if (packageRec.getChildren().length == 0) {
                        List<AbstractPMDRecord> packages = this.getChildrenAsList();
                        packages.remove(packageRec);
                        this.children = new AbstractPMDRecord[packages.size()];
                        packages.toArray(this.children);
                    }
                    removedResource = fileRec;
                }
                ++k;
            }
        }
        return removedResource;
    }

    @Override
    public int getNumberOfViolationsToPriority(int prio, boolean invertMarkerAndFileRecords) {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getNumberOfViolationsToPriority(prio, invertMarkerAndFileRecords);
            ++n2;
        }
        return number;
    }

    @Override
    public int getLOC() {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getLOC();
            ++n2;
        }
        return number;
    }

    @Override
    public int getNumberOfMethods() {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getNumberOfMethods();
            ++n2;
        }
        return number;
    }
}

