/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.dialogs;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.preferences.br.EditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUIUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MethodEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPropertyDialog
extends TitleAreaDialog
implements SizeChangeListener {
    private Text nameField;
    private Text labelField;
    private Combo typeField;
    private Control[] factoryControls;
    private Composite dlgArea;
    private EditorFactory factory;
    private ValueChangeListener changeListener;
    private PropertySource propertySource;
    private PropertyDescriptor<?> descriptor;
    private Map<Class<?>, EditorFactory> editorFactoriesByValueType;
    private static final Class<?>[] validEditorTypes = new Class[]{String.class, Integer.class, Boolean.class, Class.class, Method.class};
    private static final Class<?> defaultEditorType = validEditorTypes[0];

    public static Map<Class<?>, EditorFactory> withOnly(Map<Class<?>, EditorFactory> factoriesByType, Class<?>[] legalTypeKeys) {
        HashMap results = new HashMap(legalTypeKeys.length);
        Class<?>[] classArray = legalTypeKeys;
        int n = legalTypeKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (factoriesByType.containsKey(type)) {
                results.put(type, factoriesByType.get(type));
            }
            ++n2;
        }
        return results;
    }

    public NewPropertyDialog(Shell parent, Map<Class<?>, EditorFactory> theEditorFactoriesByValueType, PropertySource theSource, ValueChangeListener theChangeListener) {
        super(parent);
        this.setShellStyle(68720);
        this.propertySource = theSource;
        this.changeListener = theChangeListener;
        this.editorFactoriesByValueType = NewPropertyDialog.withOnly(theEditorFactoriesByValueType, validEditorTypes);
    }

    public NewPropertyDialog(Shell parent, Map<Class<?>, EditorFactory> theEditorFactoriesByValueType, Rule theRule, PropertyDescriptor<?> theDescriptor, ValueChangeListener theChangeListener) {
        this(parent, theEditorFactoriesByValueType, (PropertySource)theRule, theChangeListener);
        this.descriptor = theDescriptor;
    }

    public boolean close() {
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SWTUtil.stringFor("dialog.preferences.add_new_property"));
        this.dlgArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 2;
        layout.marginTop = 1;
        this.dlgArea.setLayout((Layout)layout);
        this.dlgArea.setLayoutData((Object)new GridData(1808));
        this.buildLabel(this.dlgArea, "Name:");
        this.nameField = this.buildNameText(this.dlgArea);
        this.buildLabel(this.dlgArea, "Datatype:");
        this.typeField = this.buildTypeField(this.dlgArea);
        this.buildLabel(this.dlgArea, "Label:");
        this.labelField = this.buildLabelField(this.dlgArea);
        this.setPreferredName();
        this.setInitialType();
        this.dlgArea.pack();
        return this.dlgArea;
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.validateForm();
        return result;
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        label.setText(msgKey == null ? "" : SWTUtil.stringFor(msgKey));
        return label;
    }

    private void setFieldLayoutData(Control widget) {
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)data);
    }

    private Text buildNameText(Composite parent) {
        Text text = new Text(parent, 2052);
        this.setFieldLayoutData((Control)text);
        text.addVerifyListener(RuleUIUtil.RuleNameVerifier);
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewPropertyDialog.this.validateForm();
            }
        });
        return text;
    }

    private boolean isValidNewLabel(String labelCandidate) {
        return !StringUtil.isEmpty((String)labelCandidate);
    }

    private boolean isPreExistingLabel(String labelCandidate) {
        for (PropertyDescriptor desc : this.propertySource.getPropertyDescriptors()) {
            if (!desc.description().equalsIgnoreCase(labelCandidate)) continue;
            return false;
        }
        return true;
    }

    private Text buildLabelField(Composite parent) {
        Text text = new Text(parent, 2052);
        this.setFieldLayoutData((Control)text);
        text.addVerifyListener(RuleUIUtil.RuleLabelVerifier);
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewPropertyDialog.this.validateForm();
            }
        });
        return text;
    }

    private static String labelFor(Class<?> type) {
        return Util.signatureFor(type, MethodEditorFactory.UnwantedPrefixes);
    }

    private EditorFactory factoryFor(String label) {
        for (Map.Entry<Class<?>, EditorFactory> entry : this.editorFactoriesByValueType.entrySet()) {
            if (!label.equals(NewPropertyDialog.labelFor(entry.getKey()))) continue;
            return entry.getValue();
        }
        return null;
    }

    private Combo buildTypeField(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        this.setFieldLayoutData((Control)combo);
        Object[] labels = new String[this.editorFactoriesByValueType.size()];
        int i = 0;
        for (Map.Entry<Class<?>, EditorFactory> entry : this.editorFactoriesByValueType.entrySet()) {
            labels[i++] = NewPropertyDialog.labelFor(entry.getKey());
        }
        Arrays.sort(labels);
        combo.setItems((String[])labels);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIdx = combo.getSelectionIndex();
                EditorFactory factory = NewPropertyDialog.this.factoryFor(combo.getItem(selectionIdx));
                NewPropertyDialog.this.factory(factory);
            }
        });
        return combo;
    }

    private boolean ruleHasPropertyName(String name) {
        return this.propertySource.getPropertyDescriptor(name) != null;
    }

    private void setPreferredName() {
        String xpath = ((String)this.propertySource.getProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR)).trim();
        List<int[]> positions = Util.referencedNamePositionsIn(xpath, '$');
        List<String> names = Util.fragmentsWithin(xpath, positions);
        for (String name : names) {
            if (this.ruleHasPropertyName(name)) continue;
            this.nameField.setText(name);
            return;
        }
        this.nameField.setText("");
    }

    private void setInitialType() {
        String editorLabel = NewPropertyDialog.labelFor(defaultEditorType);
        this.typeField.select(Util.indexOf(this.typeField.getItems(), editorLabel));
        this.factory(this.factoryFor(editorLabel));
    }

    private void cleanFactoryStuff() {
        if (this.factoryControls != null) {
            Control[] controlArray = this.factoryControls;
            int n = this.factoryControls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
    }

    private void factory(EditorFactory theFactory) {
        this.factory = theFactory;
        this.descriptor = this.factory.createDescriptor("??", "??", null);
        this.labelField.setText(this.descriptor.description());
        this.cleanFactoryStuff();
        this.factoryControls = this.factory.createOtherControlsOn(this.dlgArea, this.descriptor, this.propertySource, this.changeListener, this);
        this.dlgArea.getShell().layout();
        this.dlgArea.pack();
        this.dlgArea.getParent().pack();
    }

    protected void okPressed() {
        if (this.validateForm()) {
            this.descriptor = this.newDescriptor();
            super.okPressed();
        }
    }

    private boolean validateForm() {
        boolean isOk = this.validateName() && this.validateLabel();
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(isOk);
        }
        return isOk;
    }

    private boolean validateName() {
        String name = this.nameField.getText().trim();
        if (StringUtil.isEmpty((String)name)) {
            this.setErrorMessage("A property name is required");
            return false;
        }
        if (this.ruleHasPropertyName(name)) {
            this.setErrorMessage("'" + name + "' is already used by another property");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean validateLabel() {
        String label = this.labelField.getText().trim();
        if (StringUtil.isEmpty((String)label)) {
            this.setErrorMessage("A descriptive label is required");
            return false;
        }
        if (!this.isValidNewLabel(label)) {
            this.setErrorMessage("Invalid label");
            return false;
        }
        if (!this.isPreExistingLabel(label)) {
            this.setErrorMessage("Label text must differ from other label text");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public PropertyDescriptor<?> descriptor() {
        return this.descriptor;
    }

    private PropertyDescriptor<?> newDescriptor() {
        return this.factory.createDescriptor(this.nameField.getText().trim(), this.labelField.getText().trim(), this.factoryControls);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    @Override
    public void addedRows(int newRowCount) {
        this.dlgArea.pack();
        this.dlgArea.getParent().pack();
        System.out.println("rows added: " + newRowCount);
    }
}

