/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.runtime.PMDRuntimeConstants;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class RuleLabelDecorator
implements ILightweightLabelDecorator {
    private Collection<ILabelProviderListener> listeners;
    private Map<Integer, ImageDescriptor> overlaysByPriority;

    public RuleLabelDecorator() {
        this.reloadDecorators();
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ILabelProviderListener>();
        }
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public void changed(Collection<IResource> resources) {
        if (this.listeners == null) {
            return;
        }
        LabelProviderChangedEvent lpce = new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray());
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(lpce);
        }
    }

    public void reloadDecorators() {
        this.overlaysByPriority = UISettings.markerImgDescriptorsByPriority();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof IResource)) {
            return;
        }
        IResource resource = (IResource)element;
        Set<Integer> range = null;
        try {
            range = MarkerUtil.priorityRangeOf(resource, PMDRuntimeConstants.RULE_MARKER_TYPES, 5);
        }
        catch (CoreException coreException) {
            return;
        }
        if (range.isEmpty()) {
            return;
        }
        Integer first = range.iterator().next();
        ImageDescriptor overlay = this.overlaysByPriority.get(first);
        try {
            boolean hasMarkers = MarkerUtil.hasAnyRuleMarkers(resource);
            if (hasMarkers) {
                decoration.addOverlay(overlay);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

