/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.properties.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.PMDNature;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.ProjectPropertiesTO;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.PropertiesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.RuleSpecTO;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class ProjectPropertiesManagerImpl
implements IProjectPropertiesManager {
    private static final Logger log = Logger.getLogger(ProjectPropertiesManagerImpl.class);
    private static final String PROPERTIES_FILE = ".pmd";
    private static final String PROPERTIES_MAPPING = "/net/sourceforge/pmd/eclipse/runtime/properties/impl/mapping.xml";
    private final Map<IProject, IProjectProperties> projectsProperties = new HashMap<IProject, IProjectProperties>();

    @Override
    public IProjectProperties loadProjectProperties(IProject project) throws PropertiesException {
        log.debug((Object)("Loading project properties for project " + project.getName()));
        try {
            IProjectProperties projectProperties = this.projectsProperties.get(project);
            if (projectProperties == null) {
                projectProperties = new PropertiesFactoryImpl().newProjectProperties(project, this);
                ProjectPropertiesTO to = this.readProjectProperties(project);
                this.fillProjectProperties(projectProperties, to);
                this.projectsProperties.put(project, projectProperties);
            }
            if (projectProperties.isRuleSetStoredInProject()) {
                this.loadRuleSetFromProject(projectProperties);
            } else {
                boolean needRebuild = this.synchronizeRuleSet(projectProperties);
                projectProperties.setNeedRebuild(projectProperties.isNeedRebuild() || needRebuild);
            }
            return projectProperties;
        }
        catch (CoreException e) {
            throw new PropertiesException("Core Exception when loading project properties for project " + project.getName(), e);
        }
    }

    @Override
    public void storeProjectProperties(IProjectProperties projectProperties) throws PropertiesException {
        log.debug((Object)("Storing project properties for project " + projectProperties.getProject().getName()));
        try {
            if (projectProperties.isPmdEnabled()) {
                PMDNature.addPMDNature(projectProperties.getProject(), null);
            } else {
                PMDNature.removePMDNature(projectProperties.getProject(), null);
            }
            this.writeProjectProperties(projectProperties.getProject(), this.fillTransferObject(projectProperties));
            this.projectsProperties.put(projectProperties.getProject(), projectProperties);
        }
        catch (CoreException e) {
            throw new PropertiesException("Core Exception when storing project properties for project " + projectProperties.getProject().getName(), e);
        }
    }

    @Override
    public void removeProjectProperties(IProject project) {
        this.projectsProperties.remove(project);
    }

    private void loadRuleSetFromProject(IProjectProperties projectProperties) throws PropertiesException {
        if (projectProperties.isRuleSetFileExist()) {
            log.debug((Object)("Loading ruleset from project ruleset file: " + projectProperties.getRuleSetFile()));
            try {
                RuleSetFactory factory = new RuleSetFactory();
                File ruleSetFile = projectProperties.getResolvedRuleSetFile();
                projectProperties.setProjectRuleSet(factory.createRuleSets(ruleSetFile.getPath()).getAllRuleSets()[0]);
            }
            catch (RuleSetNotFoundException e) {
                PMDPlugin.getDefault().logError("Project RuleSet cannot be loaded for project " + projectProperties.getProject().getName() + " using RuleSet file name " + projectProperties.getRuleSetFile() + ". Using the rules from properties.", e);
            }
        }
    }

    private ProjectPropertiesTO readProjectProperties(IProject project) throws PropertiesException {
        ProjectPropertiesTO projectProperties = null;
        InputStreamReader reader = null;
        try {
            try {
                Mapping mapping = new Mapping(this.getClass().getClassLoader());
                URL mappingSpecUrl = this.getClass().getResource(PROPERTIES_MAPPING);
                mapping.loadMapping(mappingSpecUrl);
                IFile propertiesFile = project.getFile(PROPERTIES_FILE);
                if (propertiesFile.exists() && propertiesFile.isAccessible()) {
                    reader = new InputStreamReader(propertiesFile.getContents());
                    Unmarshaller unmarshaller = new Unmarshaller(mapping);
                    projectProperties = (ProjectPropertiesTO)unmarshaller.unmarshal((Reader)reader);
                    ((Reader)reader).close();
                }
            }
            catch (MarshalException e) {
                throw new PropertiesException(e);
            }
            catch (ValidationException e) {
                throw new PropertiesException(e);
            }
            catch (IOException e) {
                throw new PropertiesException(e);
            }
            catch (MappingException e) {
                throw new PropertiesException(e);
            }
            catch (CoreException e) {
                throw new PropertiesException(e);
            }
        }
        finally {
            IOUtil.closeQuietly(reader);
        }
        return projectProperties;
    }

    private void fillProjectProperties(IProjectProperties projectProperties, ProjectPropertiesTO to) throws PropertiesException, CoreException {
        if (to == null) {
            log.info((Object)"Project properties not found. Use default.");
        } else {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            projectProperties.setProjectWorkingSet(workingSetManager.getWorkingSet(to.getWorkingSetName()));
            projectProperties.setRuleSetFile(to.getRuleSetFile());
            projectProperties.setRuleSetStoredInProject(to.isRuleSetStoredInProject());
            projectProperties.setPmdEnabled(projectProperties.getProject().hasNature("net.sourceforge.pmd.eclipse.plugin.pmdNature"));
            projectProperties.setIncludeDerivedFiles(to.isIncludeDerivedFiles());
            projectProperties.setViolationsAsErrors(to.isViolationsAsErrors());
            projectProperties.setFullBuildEnabled(to.isFullBuildEnabled());
            if (to.isRuleSetStoredInProject()) {
                this.loadRuleSetFromProject(projectProperties);
            } else {
                this.setRuleSetFromProperties(projectProperties, to.getRules());
            }
            log.debug((Object)"Project properties loaded");
        }
    }

    private void setRuleSetFromProperties(IProjectProperties projectProperties, RuleSpecTO[] rules) throws PropertiesException {
        RuleSet ruleSet = new RuleSet();
        RuleSet pluginRuleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        int n = rules == null ? 0 : rules.length;
        int i = 0;
        while (i < n) {
            try {
                Rule rule = pluginRuleSet.getRuleByName(rules[i].getName());
                ruleSet.addRule(rule);
            }
            catch (RuntimeException runtimeException) {
                log.debug((Object)("The rule " + rules[i].getName() + " cannot be found. ignore."));
            }
            ++i;
        }
        ruleSet.addExcludePatterns((Collection)pluginRuleSet.getExcludePatterns());
        ruleSet.addIncludePatterns((Collection)pluginRuleSet.getIncludePatterns());
        projectProperties.setProjectRuleSet(ruleSet);
    }

    private void writeProjectProperties(IProject project, ProjectPropertiesTO projectProperties) throws PropertiesException {
        StringWriter writer = null;
        try {
            try {
                LocalConfiguration.getInstance().getProperties().setProperty("org.exolab.castor.indent", "true");
                Mapping mapping = new Mapping(this.getClass().getClassLoader());
                URL mappingSpecUrl = this.getClass().getResource(PROPERTIES_MAPPING);
                mapping.loadMapping(mappingSpecUrl);
                writer = new StringWriter();
                Marshaller marshaller = new Marshaller((Writer)writer);
                marshaller.setMapping(mapping);
                marshaller.marshal((Object)projectProperties);
                writer.flush();
                IFile propertiesFile = project.getFile(PROPERTIES_FILE);
                if (propertiesFile.exists() && propertiesFile.isAccessible()) {
                    propertiesFile.setContents((InputStream)new ByteArrayInputStream(writer.toString().getBytes()), false, false, null);
                } else {
                    propertiesFile.create((InputStream)new ByteArrayInputStream(writer.toString().getBytes()), false, null);
                }
            }
            catch (MarshalException e) {
                throw new PropertiesException(e);
            }
            catch (ValidationException e) {
                throw new PropertiesException(e);
            }
            catch (IOException e) {
                throw new PropertiesException(e);
            }
            catch (MappingException e) {
                throw new PropertiesException(e);
            }
            catch (CoreException e) {
                throw new PropertiesException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(writer);
            throw throwable;
        }
        IOUtil.closeQuietly(writer);
    }

    private ProjectPropertiesTO fillTransferObject(IProjectProperties projectProperties) throws PropertiesException {
        ProjectPropertiesTO bean = new ProjectPropertiesTO();
        bean.setRuleSetStoredInProject(projectProperties.isRuleSetStoredInProject());
        bean.setRuleSetFile(projectProperties.getRuleSetFile());
        bean.setWorkingSetName(projectProperties.getProjectWorkingSet() == null ? null : projectProperties.getProjectWorkingSet().getName());
        bean.setIncludeDerivedFiles(projectProperties.isIncludeDerivedFiles());
        bean.setViolationsAsErrors(projectProperties.violationsAsErrors());
        bean.setFullBuildEnabled(projectProperties.isFullBuildEnabled());
        if (!projectProperties.isRuleSetStoredInProject()) {
            RuleSet ruleSet = projectProperties.getProjectRuleSet();
            ArrayList<RuleSpecTO> rules = new ArrayList<RuleSpecTO>();
            for (Rule rule : ruleSet.getRules()) {
                rules.add(new RuleSpecTO(rule.getName(), rule.getRuleSetName()));
            }
            bean.setRules(rules.toArray(new RuleSpecTO[rules.size()]));
            bean.setExcludePatterns(ruleSet.getExcludePatterns().toArray(new String[ruleSet.getExcludePatterns().size()]));
            bean.setIncludePatterns(ruleSet.getIncludePatterns().toArray(new String[ruleSet.getIncludePatterns().size()]));
        }
        return bean;
    }

    private boolean synchronizeRuleSet(IProjectProperties projectProperties) throws PropertiesException {
        log.debug((Object)"Synchronizing the project ruleset with the plugin ruleset");
        RuleSet pluginRuleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        RuleSet projectRuleSet = projectProperties.getProjectRuleSet();
        boolean flChanged = false;
        if (!projectRuleSet.getRules().equals(pluginRuleSet.getRules())) {
            log.debug((Object)"The project ruleset is different from the plugin ruleset; synchronizing.");
            Iterator i = projectRuleSet.getRules().iterator();
            while (i.hasNext()) {
                Rule projectRule = (Rule)i.next();
                Rule pluginRule = pluginRuleSet.getRuleByName(projectRule.getName());
                if (pluginRule != null) continue;
                log.debug((Object)("The rule " + projectRule.getName() + " is not defined in the plugin ruleset. Remove it."));
                i.remove();
            }
            RuleSet ruleSet = new RuleSet();
            ruleSet.setDescription(projectRuleSet.getDescription());
            ruleSet.setName(projectRuleSet.getName());
            for (Rule projectRule : projectRuleSet.getRules()) {
                Rule pluginRule = pluginRuleSet.getRuleByName(projectRule.getName());
                if (pluginRule == null) continue;
                ruleSet.addRule(pluginRule);
            }
            if (!ruleSet.getRules().equals(projectRuleSet.getRules())) {
                log.info((Object)"Set the project ruleset according to preferences.");
                projectProperties.setProjectRuleSet(ruleSet);
                flChanged = true;
            }
            log.debug((Object)("Ruleset for project " + projectProperties.getProject().getName() + " is now synchronized. " + (flChanged ? "Ruleset has changed" : "Ruleset has not changed")));
        }
        return flChanged;
    }
}

