/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import name.herlin.command.CommandException;
import name.herlin.command.Timer;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.DeltaVisitor;
import net.sourceforge.pmd.eclipse.runtime.cmd.MarkerInfo2;
import net.sourceforge.pmd.eclipse.runtime.cmd.ResourceVisitor;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReviewCodeCmd
extends AbstractDefaultCommand {
    private final List<ISchedulingRule> resources = new ArrayList<ISchedulingRule>();
    private IResourceDelta resourceDelta;
    private Map<IFile, Set<MarkerInfo2>> markersByFile = new HashMap<IFile, Set<MarkerInfo2>>();
    private boolean taskMarker;
    private boolean openPmdPerspective;
    private int ruleCount;
    private int fileCount;
    private long pmdDuration;
    private String onErrorIssue = null;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ReviewCodeCmd.class);

    public ReviewCodeCmd() {
        super("ReviewCode", "Run PMD on a list of workbench resources");
        this.setOutputProperties(true);
        this.setReadOnly(true);
        this.setTerminated(false);
    }

    public Set<IFile> markedFiles() {
        return this.markersByFile.keySet();
    }

    private RuleSet currentRules() {
        return new RuleSet();
    }

    private Map<Rule, String> misconfiguredRulesIn(RuleSet ruleset) {
        RuleSet ruleSet = this.currentRules();
        HashMap<Rule, String> faultsByRule = new HashMap<Rule, String>();
        for (Rule rule : ruleSet.getRules()) {
            String fault = rule.dysfunctionReason();
            if (!StringUtil.isNotEmpty((String)fault)) continue;
            faultsByRule.put(rule, fault);
        }
        return faultsByRule;
    }

    private boolean checkForMisconfiguredRules() {
        RuleSet ruleSet = this.currentRules();
        if (ruleSet.getRules().isEmpty()) {
            return true;
        }
        Map<Rule, String> faultsByRule = this.misconfiguredRulesIn(ruleSet);
        if (faultsByRule.isEmpty()) {
            return true;
        }
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Rule configuration problem", (String)"Continue anyways?");
    }

    @Override
    public void execute() throws CommandException {
        boolean doReview = this.checkForMisconfiguredRules();
        if (!doReview) {
            return;
        }
        log.info((Object)"ReviewCode command starting.");
        try {
            try {
                this.fileCount = 0;
                this.ruleCount = 0;
                this.pmdDuration = 0L;
                this.beginTask("PMD checking...", this.getStepCount());
                if (this.resources.isEmpty()) {
                    this.processResourceDelta();
                } else {
                    this.processResources();
                }
                IWorkspaceRunnable action = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ReviewCodeCmd.this.applyMarkers();
                    }
                };
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.run(action, this.getSchedulingRule(), 1, this.getMonitor());
                if (this.openPmdPerspective) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReviewCodeCmd.switchToPmdPerspective();
                        }
                    });
                }
            }
            catch (CoreException e) {
                throw new CommandException("Core exception when reviewing code", e);
            }
        }
        finally {
            log.info((Object)"ReviewCode command has ended.");
            this.setTerminated(true);
            this.done();
            if (this.fileCount > 0 && this.ruleCount > 0) {
                ReviewCodeCmd.logInfo("Review code command terminated. " + this.ruleCount + " rules were executed against " + this.fileCount + " files. Actual PMD duration is about " + this.pmdDuration + "ms, that is about " + (float)this.pmdDuration / (float)this.fileCount + " ms/file, " + (float)this.pmdDuration / (float)this.ruleCount + " ms/rule, " + (float)this.pmdDuration / (float)((long)this.fileCount * (long)this.ruleCount) + " ms/filerule");
            } else {
                ReviewCodeCmd.logInfo("Review code command terminated. " + this.ruleCount + " rules were executed against " + this.fileCount + " files. PMD was not executed.");
            }
        }
        PMDPlugin.getDefault().changedFiles(this.markedFiles());
    }

    public Map<IFile, Set<MarkerInfo2>> getMarkers() {
        return this.markersByFile;
    }

    public void setResources(Collection<ISchedulingRule> resources) {
        resources.clear();
        resources.addAll(resources);
    }

    public void addResource(IResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource parameter can not be null");
        }
        this.resources.add((ISchedulingRule)resource);
    }

    public void setResourceDelta(IResourceDelta resourceDelta) {
        this.resourceDelta = resourceDelta;
    }

    public void setTaskMarker(boolean taskMarker) {
        this.taskMarker = taskMarker;
    }

    public void setOpenPmdPerspective(boolean openPmdPerspective) {
        this.openPmdPerspective = openPmdPerspective;
    }

    @Override
    public void reset() {
        this.resources.clear();
        this.markersByFile = new HashMap<IFile, Set<MarkerInfo2>>();
        this.setTerminated(false);
        this.openPmdPerspective = false;
        this.onErrorIssue = null;
    }

    @Override
    public boolean isReadyToExecute() {
        return this.resources.size() != 0 || this.resourceDelta != null;
    }

    private ISchedulingRule getSchedulingRule() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceRuleFactory ruleFactory = workspace.getRuleFactory();
        ISchedulingRule rule = null;
        if (this.resources.isEmpty()) {
            rule = ruleFactory.markerRule((IResource)this.resourceDelta.getResource().getProject());
        } else {
            ISchedulingRule[] rules = new ISchedulingRule[this.resources.size()];
            int i = 0;
            while (i < rules.length) {
                rules[i] = ruleFactory.markerRule((IResource)this.resources.get(i));
                ++i;
            }
            rule = new MultiRule(this.resources.toArray(rules));
        }
        return rule;
    }

    private void processResources() throws CommandException {
        for (IResource iResource : this.resources) {
            if (iResource instanceof IProject) {
                this.processProject((IProject)iResource);
                continue;
            }
            this.processResource(iResource);
        }
    }

    private RuleSet rulesetFrom(IResource resource) throws PropertiesException, CommandException {
        IProject project = resource.getProject();
        IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(project);
        return this.filteredRuleSet(properties);
    }

    private void processResource(IResource resource) throws CommandException {
        try {
            IProject project = resource.getProject();
            IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(project);
            RuleSet ruleSet = this.rulesetFrom(resource);
            int targetCount = 0;
            if (resource.exists()) {
                targetCount = this.countResourceElement(resource);
            }
            if (properties.isFullBuildEnabled() || targetCount == 1) {
                this.setStepCount(targetCount);
                log.debug((Object)("Visiting resource " + resource.getName() + " : " + this.getStepCount()));
                if (resource.exists()) {
                    ResourceVisitor visitor = new ResourceVisitor();
                    visitor.setMonitor(this.getMonitor());
                    visitor.setRuleSet(ruleSet);
                    visitor.setAccumulator(this.markersByFile);
                    visitor.setUseTaskMarker(this.taskMarker);
                    visitor.setProjectProperties(properties);
                    resource.accept((IResourceVisitor)visitor);
                    this.ruleCount = ruleSet.getRules().size();
                    this.fileCount += visitor.getProcessedFilesCount();
                    this.pmdDuration += visitor.getActualPmdDuration();
                } else {
                    log.debug((Object)("Skipping resource " + resource.getName() + " because it doesn't exist."));
                }
            } else {
                log.debug((Object)("Skipping resource " + resource.getName() + " because of fullBuildEnabled flag"));
            }
            this.worked(1);
        }
        catch (PropertiesException e) {
            throw new CommandException(e);
        }
        catch (CoreException e) {
            throw new CommandException(e);
        }
    }

    private void processProject(IProject project) throws CommandException {
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                log.debug((Object)("Skipping non-Java natured project " + project.getName()));
                return;
            }
            this.setStepCount(this.countResourceElement((IResource)project));
            log.debug((Object)("Visiting  project " + project.getName() + " : " + this.getStepCount()));
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entrie = iClasspathEntryArray[n2];
                if (entrie.getEntryKind() == 3) {
                    IFolder sourceContainer = null;
                    try {
                        sourceContainer = root.getFolder(entrie.getPath());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        sourceContainer = root.getProject(entrie.getPath().toString());
                    }
                    if (sourceContainer == null) {
                        log.warn((Object)("Source container " + entrie.getPath() + " for project " + project.getName() + " is not valid"));
                    } else {
                        this.processResource((IResource)sourceContainer);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new CommandException(e);
        }
    }

    private void taskScope(int activeRuleCount, int totalRuleCount) {
        this.setTaskName("Checking with " + Integer.toString(activeRuleCount) + " out of " + Integer.toString(totalRuleCount) + " rules");
    }

    private RuleSet filteredRuleSet(IProjectProperties properties) throws CommandException, PropertiesException {
        RuleSet ruleSet = properties.getProjectRuleSet();
        IPreferences preferences = PMDPlugin.getDefault().getPreferencesManager().loadPreferences();
        Set<String> inactiveRuleNames = preferences.getInactiveRuleNames();
        RuleSet filteredRuleSet = RuleSetUtil.newCopyOf(ruleSet);
        if (preferences.getGlobalRuleManagement()) {
            RuleSetUtil.remove(filteredRuleSet, inactiveRuleNames);
        }
        filteredRuleSet.addExcludePatterns(preferences.activeExclusionPatterns());
        filteredRuleSet.addIncludePatterns(preferences.activeInclusionPatterns());
        filteredRuleSet.addExcludePatterns(properties.getBuildPathExcludePatterns());
        filteredRuleSet.addIncludePatterns(properties.getBuildPathIncludePatterns());
        this.taskScope(filteredRuleSet.getRules().size(), ruleSet.getRules().size());
        return filteredRuleSet;
    }

    private RuleSet rulesetFromResourceDelta() throws PropertiesException, CommandException {
        IResource resource = this.resourceDelta.getResource();
        IProject project = resource.getProject();
        IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(project);
        return this.filteredRuleSet(properties);
    }

    private void processResourceDelta() throws CommandException {
        try {
            IResource resource = this.resourceDelta.getResource();
            IProject project = resource.getProject();
            IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(project);
            RuleSet ruleSet = this.rulesetFromResourceDelta();
            int targetCount = this.countDeltaElement(this.resourceDelta);
            if (properties.isFullBuildEnabled() || targetCount == 1) {
                this.setStepCount(targetCount);
                log.debug((Object)("Visiting delta of resource " + resource.getName() + " : " + this.getStepCount()));
                DeltaVisitor visitor = new DeltaVisitor();
                visitor.setMonitor(this.getMonitor());
                visitor.setRuleSet(ruleSet);
                visitor.setAccumulator(this.markersByFile);
                visitor.setUseTaskMarker(this.taskMarker);
                visitor.setProjectProperties(properties);
                this.resourceDelta.accept((IResourceDeltaVisitor)visitor);
                this.ruleCount = ruleSet.getRules().size();
                this.fileCount += visitor.getProcessedFilesCount();
                this.pmdDuration += visitor.getActualPmdDuration();
            } else {
                log.debug((Object)("Skipping resource " + resource.getName() + " because of fullBuildEnabled flag"));
            }
        }
        catch (PropertiesException e) {
            throw new CommandException(e);
        }
        catch (CoreException e) {
            throw new CommandException(e);
        }
    }

    private void applyMarkers() {
        log.info((Object)"Processing marker directives");
        int violationCount = 0;
        Timer timer = new Timer();
        String currentFile = "";
        this.beginTask("PMD Applying markers", this.markersByFile.size());
        try {
            try {
                for (IFile file : this.markersByFile.keySet()) {
                    if (this.isCanceled()) {
                        break;
                    }
                    currentFile = file.getName();
                    MarkerUtil.deleteAllMarkersIn((IResource)file);
                    Set<MarkerInfo2> markerInfoSet = this.markersByFile.get(file);
                    for (MarkerInfo2 markerInfo : markerInfoSet) {
                        markerInfo.addAsMarkerTo(file);
                        ++violationCount;
                    }
                    this.worked(1);
                }
            }
            catch (CoreException e) {
                log.warn((Object)("CoreException when setting marker for file " + currentFile + " : " + e.getMessage()));
                timer.stop();
                int count = this.markersByFile.size();
                ReviewCodeCmd.logInfo(violationCount + " markers applied on " + count + " files in " + timer.getDuration() + "ms.");
                log.info((Object)("End of processing marker directives. " + violationCount + " violations for " + count + " files."));
            }
        }
        finally {
            timer.stop();
            int count = this.markersByFile.size();
            ReviewCodeCmd.logInfo(violationCount + " markers applied on " + count + " files in " + timer.getDuration() + "ms.");
            log.info((Object)("End of processing marker directives. " + violationCount + " violations for " + count + " files."));
        }
    }

    private int countResourceElement(IResource resource) {
        if (resource instanceof IFile) {
            return ReviewCodeCmd.isSuitable((IFile)resource) ? 1 : 0;
        }
        CountVisitor visitor = new CountVisitor();
        try {
            resource.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            ReviewCodeCmd.logError("Exception when counting elements of a project", e);
        }
        return visitor.count;
    }

    private int countDeltaElement(IResourceDelta delta) {
        CountVisitor visitor = new CountVisitor();
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException e) {
            ReviewCodeCmd.logError("Exception counting elemnts in a delta selection", e);
        }
        return visitor.count;
    }

    private static void switchToPmdPerspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveRegistry reg = workbench.getPerspectiveRegistry();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        window.getActivePage().setPerspective(reg.findPerspectiveWithId("net.sourceforge.pmd.eclipse.ui.views.pmdPerspective"));
    }

    private static boolean isSuitable(IFile file) {
        return ReviewCodeCmd.isLanguageFile(file, Language.JAVA);
    }

    private final class CountVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        public int count = 0;

        private CountVisitor() {
        }

        public boolean visit(IResource resource) {
            boolean fVisitChildren = true;
            ++this.count;
            if (resource instanceof IFile && ReviewCodeCmd.isSuitable((IFile)resource)) {
                fVisitChildren = false;
            }
            return fVisitChildren;
        }

        public boolean visit(IResourceDelta delta) {
            ++this.count;
            return true;
        }
    }
}

