/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.plugin;

import java.util.HashSet;
import java.util.Set;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FileChangeReviewer
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        HashSet<ResourceChange> itemsChanged = new HashSet<ResourceChange>();
        switch (event.getType()) {
            case 1: {
                this.changed(itemsChanged, event.getDelta(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        if (itemsChanged.isEmpty()) {
            return;
        }
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        cmd.reset();
        for (ResourceChange chg : itemsChanged) {
            cmd.addResource((IResource)chg.file);
        }
        try {
            cmd.performExecute();
        }
        catch (CommandException e) {
            PMDPlugin.getDefault().log(4, "Error processing code review upon file changes", e);
        }
    }

    private void changed(Set<ResourceChange> itemsChanged, IResourceDelta delta, IProgressMonitor monitor) {
        IResourceDelta grandkidDelta;
        int n;
        int n2;
        IResourceDelta[] iResourceDeltaArray;
        IResource rsc = delta.getResource();
        int flags = delta.getFlags();
        switch (delta.getKind()) {
            case 0: {
                return;
            }
            case 2: {
                iResourceDeltaArray = delta.getAffectedChildren();
                n2 = iResourceDeltaArray.length;
                n = 0;
                while (n < n2) {
                    grandkidDelta = iResourceDeltaArray[n];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.changed(itemsChanged, grandkidDelta, monitor);
                    ++n;
                }
            }
            case 1: {
                if (rsc instanceof IFile) {
                    this.added(itemsChanged, (IFile)rsc, flags, true);
                }
                iResourceDeltaArray = delta.getAffectedChildren();
                n2 = iResourceDeltaArray.length;
                n = 0;
                while (n < n2) {
                    grandkidDelta = iResourceDeltaArray[n];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.changed(itemsChanged, grandkidDelta, monitor);
                    ++n;
                }
            }
            case 4: {
                if (rsc instanceof IFile) {
                    this.changed(itemsChanged, (IFile)rsc, flags, true);
                }
                iResourceDeltaArray = delta.getAffectedChildren();
                n2 = iResourceDeltaArray.length;
                n = 0;
                while (n < n2) {
                    grandkidDelta = iResourceDeltaArray[n];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.changed(itemsChanged, grandkidDelta, monitor);
                    ++n;
                }
                break;
            }
        }
        iResourceDeltaArray = delta.getAffectedChildren();
        n2 = iResourceDeltaArray.length;
        n = 0;
        while (n < n2) {
            grandkidDelta = iResourceDeltaArray[n];
            if (monitor.isCanceled()) {
                return;
            }
            this.changed(itemsChanged, grandkidDelta, monitor);
            ++n;
        }
    }

    private void changed(Set<ResourceChange> itemsChanged, IFile rsc, int flags, boolean b) {
        if ((flags & 0x100) > 0) {
            itemsChanged.add(new ResourceChange(ChangeType.CHANGED, rsc, flags));
        }
    }

    private void added(Set<ResourceChange> itemsChanged, IFile rsc, int flags, boolean b) {
        itemsChanged.add(new ResourceChange(ChangeType.ADDED, rsc, flags));
    }

    private static enum ChangeType {
        ADDED,
        REMOVED,
        CHANGED;

    }

    private class ResourceChange {
        public final ChangeType resourceDeltaType;
        public final int flags;
        public final IFile file;

        private ResourceChange(ChangeType type, IFile theFile, int theFlags) {
            this.resourceDeltaType = type;
            this.file = theFile;
            this.flags = theFlags;
        }

        public int hashCode() {
            return this.resourceDeltaType.hashCode() + 13 + this.file.hashCode() + this.flags;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() == this.getClass()) {
                ResourceChange chg = (ResourceChange)other;
                return chg.file.equals((Object)this.file) && this.resourceDeltaType == chg.resourceDeltaType && this.flags == chg.flags;
            }
            return false;
        }
    }
}

