/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.jbosspackaging.configurators;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.wtp.ArtifactHelper;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.ide.eclipse.as.ui.mbeans.project.JBossSARFacetDataModelProvider;
import org.jboss.tools.maven.core.internal.project.facet.MavenFacetInstallDataModelProvider;
import org.jboss.tools.maven.jbosspackaging.configurators.JBossPackagingPluginConfiguration;

public class SarProjectConfigurator
extends AbstractProjectConfigurator {
    public static final IProjectFacet JBOSS_SAR_FACET;
    public static final IProjectFacetVersion JBOSS_SAR_FACET_VERSION_1_0;
    public static final ArtifactFilter SCOPE_FILTER_RUNTIME;
    protected static final IProjectFacet m2Facet;
    protected static final IProjectFacetVersion m2Version;

    static {
        SCOPE_FILTER_RUNTIME = new ScopeArtifactFilter("runtime");
        JBOSS_SAR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.sar");
        JBOSS_SAR_FACET_VERSION_1_0 = JBOSS_SAR_FACET.getVersion("1.0");
        m2Facet = ProjectFacetsManager.getProjectFacet((String)"jboss.m2");
        m2Version = m2Facet.getVersion("1.0");
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.markerManager.deleteMarkers((IResource)project, "org.jbosstools.maven.configuration.jboss.sar");
        if (!this.getExpectedPackage().equals(mavenProject.getPackaging())) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        LinkedHashSet actions = new LinkedHashSet();
        IMavenProjectFacade facade = request.getMavenProjectFacade();
        ResourceCleaner fileCleaner = new ResourceCleaner(project);
        this.addFoldersToClean(fileCleaner, facade);
        IPath source = facade.getResourceLocations()[0];
        WTPProjectsUtil.installJavaFacet(actions, (IProject)project, (IFacetedProject)facetedProject);
        if (!actions.isEmpty()) {
            facetedProject.modify(actions, monitor);
        }
        this.installSarFacet(facetedProject, source, monitor);
        this.installM2Facet(facetedProject, monitor);
        ModuleCoreNature.addModuleCoreNatureIfNecessary((IProject)project, (IProgressMonitor)monitor);
        SarProjectConfigurator.removeTestFolderLinks(project, mavenProject, monitor, "/");
        WTPProjectsUtil.setNonDependencyAttributeToContainer((IProject)project, (IProgressMonitor)monitor);
        WTPProjectsUtil.removeWTPClasspathContainer((IProject)project);
        fileCleaner.cleanUp();
    }

    public static void removeTestFolderLinks(IProject project, MavenProject mavenProject, IProgressMonitor monitor, String folder) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IPath location;
            IVirtualFolder jsrc = component.getRootFolder().getFolder(folder);
            IPath[] iPathArray = MavenProjectUtils.getSourceLocations((IProject)project, (List)mavenProject.getTestCompileSourceRoots());
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                location = iPathArray[n2];
                if (location != null) {
                    jsrc.removeLink(location, 0, monitor);
                }
                ++n2;
            }
            iPathArray = MavenProjectUtils.getResourceLocations((IProject)project, (List)mavenProject.getTestResources());
            n = iPathArray.length;
            n2 = 0;
            while (n2 < n) {
                location = iPathArray[n2];
                if (location != null) {
                    jsrc.removeLink(location, 0, monitor);
                }
                ++n2;
            }
        }
    }

    private void installM2Facet(IFacetedProject fproj, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(m2Facet)) {
            IDataModel config = (IDataModel)new MavenFacetInstallDataModelProvider().create();
            config.setBooleanProperty("mavenProjectExists", true);
            fproj.installProjectFacet(m2Version, (Object)config, monitor);
        }
    }

    private void installSarFacet(IFacetedProject fproj, IPath source, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(JBOSS_SAR_FACET)) {
            IProjectFacetVersion facetVersion = JBOSS_SAR_FACET_VERSION_1_0;
            IStatus status = facetVersion.getConstraint().check((Collection)fproj.getProjectFacets());
            if (status.isOK()) {
                IDataModel config = (IDataModel)new JBossSARFacetDataModelProvider().create();
                config.setProperty("JBoss.Project.Content_Folder", (Object)source.toPortableString());
                fproj.installProjectFacet(facetVersion, (Object)config, monitor);
            } else {
                this.addErrorMarker(fproj.getProject(), facetVersion + " can not be installed : " + status.getMessage());
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus st = iStatusArray[n2];
                    this.addErrorMarker(fproj.getProject(), st.getMessage());
                    ++n2;
                }
            }
        }
    }

    private void addErrorMarker(IProject project, String message) {
        this.markerManager.addMarker((IResource)project, "org.jbosstools.maven.configuration.jboss.sar", message, -1, 2);
    }

    protected String getExpectedPackage() {
        return "jboss-sar";
    }

    public void setModuleDependencies(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent sarComponent = ComponentCore.createComponent((IProject)project);
        if (sarComponent == null) {
            return;
        }
        LinkedHashSet<IVirtualReference> newRefs = new LinkedHashSet<IVirtualReference>();
        JBossPackagingPluginConfiguration config = new JBossPackagingPluginConfiguration(mavenProject);
        if (!config.isExcludeAll()) {
            Set artifacts = mavenProject.getArtifacts();
            for (Artifact artifact : artifacts) {
                IVirtualComponent depComponent;
                if ("pom".equals(artifact.getType()) || !SCOPE_FILTER_RUNTIME.include(artifact) || artifact.isOptional() || config.isExcluded(artifact)) continue;
                IMavenProjectFacade workspaceDependency = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                if (workspaceDependency != null && !workspaceDependency.getProject().equals((Object)project) && workspaceDependency.getFullPath(artifact.getFile()) != null) {
                    IProject depProject = workspaceDependency.getProject();
                    this.configureWtpUtil(workspaceDependency, monitor);
                    depComponent = ComponentCore.createComponent((IProject)depProject);
                } else {
                    String artifactPath = ArtifactHelper.getM2REPOVarPath((Artifact)artifact);
                    depComponent = ComponentCore.createArchiveComponent((IProject)sarComponent.getProject(), (String)artifactPath);
                }
                IVirtualReference reference = ComponentCore.createReference((IVirtualComponent)sarComponent, (IVirtualComponent)depComponent);
                reference.setArchiveName(config.mapFileName(artifact));
                reference.setRuntimePath((IPath)new Path(config.getLibDirectory()));
                newRefs.add(reference);
            }
        }
        IVirtualReference[] newRefsArray = new IVirtualReference[newRefs.size()];
        newRefs.toArray(newRefsArray);
        if (WTPProjectsUtil.hasChanged((IVirtualReference[])sarComponent.getReferences(), (IVirtualReference[])newRefsArray)) {
            sarComponent.setReferences(newRefsArray);
        }
    }

    protected void updateContainerAttributes(IProject project, IClasspathAttribute attributeToAdd, String attributeToDelete, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] cp = javaProject.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            if (5 == cp[i].getEntryKind() && MavenClasspathHelpers.isMaven2ClasspathContainer((IPath)cp[i].getPath())) {
                LinkedHashMap<String, IClasspathAttribute> attrs = new LinkedHashMap<String, IClasspathAttribute>();
                IClasspathAttribute[] iClasspathAttributeArray = cp[i].getExtraAttributes();
                int n = iClasspathAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathAttribute attr = iClasspathAttributeArray[n2];
                    if (!attr.getName().equals(attributeToDelete)) {
                        attrs.put(attr.getName(), attr);
                    }
                    ++n2;
                }
                attrs.put(attributeToAdd.getName(), attributeToAdd);
                IClasspathAttribute[] newAttrs = attrs.values().toArray(new IClasspathAttribute[attrs.size()]);
                cp[i] = JavaCore.newContainerEntry((IPath)cp[i].getPath(), (IAccessRule[])cp[i].getAccessRules(), (IClasspathAttribute[])newAttrs, (boolean)cp[i].isExported());
                break;
            }
            ++i;
        }
        javaProject.setRawClasspath(cp, monitor);
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        this.setModuleDependencies(event.getMavenProject().getProject(), event.getMavenProject().getMavenProject(), monitor);
    }

    protected void configureWtpUtil(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        IPath[] resourceRoots;
        IProject project = facade.getProject();
        MavenProject mavenProject = facade.getMavenProject();
        if (!WTPProjectsUtil.isJavaProject((IMavenProjectFacade)facade) || WTPProjectsUtil.isJavaEEProject((IProject)project) || WTPProjectsUtil.isQualifiedAsWebFragment((IMavenProjectFacade)facade)) {
            return;
        }
        IPath[] sourceRoots = MavenProjectUtils.getSourceLocations((IProject)project, (List)mavenProject.getCompileSourceRoots());
        if (!this.checkJavaConfiguration(project, sourceRoots, resourceRoots = MavenProjectUtils.getResourceLocations((IProject)project, (List)mavenProject.getResources()))) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        WTPProjectsUtil.installJavaFacet(actions, (IProject)project, (IFacetedProject)facetedProject);
        if (!facetedProject.hasProjectFacet(WTPProjectsUtil.UTILITY_FACET)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, WTPProjectsUtil.UTILITY_10, null));
        } else if (!facetedProject.hasProjectFacet(WTPProjectsUtil.UTILITY_10)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, WTPProjectsUtil.UTILITY_10, null));
        }
        if (!actions.isEmpty()) {
            ResourceCleaner fileCleaner = new ResourceCleaner(project);
            try {
                this.addFoldersToClean(fileCleaner, facade);
                facetedProject.modify(actions, monitor);
            }
            finally {
                fileCleaner.cleanUp();
            }
        }
        WTPProjectsUtil.fixMissingModuleCoreNature((IProject)project, (IProgressMonitor)monitor);
        SarProjectConfigurator.removeTestFolderLinks(project, mavenProject, monitor, "/");
        WTPProjectsUtil.setNonDependencyAttributeToContainer((IProject)project, (IProgressMonitor)monitor);
        WTPProjectsUtil.removeWTPClasspathContainer((IProject)project);
    }

    private boolean checkJavaConfiguration(IProject project, IPath[] sourceRoots, IPath[] resourceRoots) throws JavaModelException {
        IClasspathEntry mavenSource;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return false;
        }
        IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
        if (cpEntries == null) {
            return false;
        }
        HashSet<IPath> currentPaths = new HashSet<IPath>();
        IClasspathEntry[] iClasspathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (3 == entry.getEntryKind()) {
                currentPaths.add(entry.getPath().makeRelativeTo(project.getFullPath()));
            }
            ++n2;
        }
        iClasspathEntryArray = sourceRoots;
        n = sourceRoots.length;
        n2 = 0;
        while (n2 < n) {
            IFolder sourceFolder;
            mavenSource = iClasspathEntryArray[n2];
            if (mavenSource != null && !mavenSource.isEmpty() && (sourceFolder = project.getFolder((IPath)mavenSource)).exists() && !currentPaths.contains(mavenSource)) {
                return false;
            }
            ++n2;
        }
        iClasspathEntryArray = resourceRoots;
        n = resourceRoots.length;
        n2 = 0;
        while (n2 < n) {
            IFolder resourceFolder;
            mavenSource = iClasspathEntryArray[n2];
            if (mavenSource != null && !mavenSource.isEmpty() && (resourceFolder = project.getFolder((IPath)mavenSource)).exists() && !currentPaths.contains(mavenSource)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void addFoldersToClean(ResourceCleaner fileCleaner, IMavenProjectFacade facade) {
        IPath p;
        IPath[] iPathArray = facade.getCompileSourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(new IPath[]{p.append("META-INF/MANIFEST.MF")});
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getResourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(new IPath[]{p.append("META-INF/MANIFEST.MF")});
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getTestCompileSourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getTestResourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
    }
}

