/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.model;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansJavaConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;

public class BeansJavaConfigPackageChange
extends Change {
    private String oldPackageName;
    private String newPackageName;

    public BeansJavaConfigPackageChange(String oldPackageName, String newPackageName) {
        this.oldPackageName = oldPackageName;
        this.newPackageName = newPackageName;
    }

    public String getName() {
        return "Rename references to package '" + this.oldPackageName + "' in Spring project configurations";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (pm.isCanceled()) {
            return null;
        }
        for (IBeansProject project : BeansCorePlugin.getModel().getProjects()) {
            boolean updated = false;
            BeansProject beansProject = (BeansProject)project;
            for (IBeansConfigSet configSet : beansProject.getConfigSets()) {
                Set configs = configSet.getConfigs();
                for (IBeansConfig config : configs) {
                    IType configClass;
                    if (!(config instanceof BeansJavaConfig) || (configClass = ((BeansJavaConfig)config).getConfigClass()) == null || !configClass.getPackageFragment().getElementName().equals(this.oldPackageName)) continue;
                    ((BeansConfigSet)configSet).removeConfig(config.getElementName());
                    String newConfigClassName = String.valueOf(this.newPackageName) + "." + configClass.getTypeQualifiedName();
                    ((BeansConfigSet)configSet).addConfig("java:" + newConfigClassName);
                }
            }
            Set configs = beansProject.getConfigs();
            for (IBeansConfig config : configs) {
                IType configClass;
                if (!(config instanceof BeansJavaConfig) || (configClass = ((BeansJavaConfig)config).getConfigClass()) == null || !configClass.getPackageFragment().getElementName().equals(this.oldPackageName)) continue;
                beansProject.removeConfig(config.getElementName());
                String newConfigClassName = String.valueOf(this.newPackageName) + "." + configClass.getTypeQualifiedName();
                beansProject.addConfig("java:" + newConfigClassName, IBeansConfig.Type.MANUAL);
                updated = true;
            }
            if (!updated) continue;
            ((BeansProject)project).saveDescription();
            BeansModelLabelDecorator.update();
        }
        return null;
    }

    public Object getModifiedElement() {
        return null;
    }
}

