/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.jdt;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.springframework.ide.eclipse.beans.ui.refactoring.jdt.AbstractRenameRefactoringParticipant;
import org.springframework.ide.eclipse.beans.ui.refactoring.util.BeansRefactoringChangeUtils;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class BeansTypeRenameRefactoringParticipant
extends AbstractRenameRefactoringParticipant {
    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            IJavaProject javaProject = (IJavaProject)type.getAncestor(2);
            this.project = javaProject.getProject();
            if (SpringCoreUtils.isSpringProject((IResource)this.project)) {
                this.elements = new HashMap();
                this.elements.put(type, this.getArguments().getNewName());
                return true;
            }
        }
        return false;
    }

    protected void addChange(CompositeChange result, IResource resource, IProgressMonitor pm) throws CoreException {
        Change change;
        if (resource.exists() && (change = BeansRefactoringChangeUtils.createRenameChange((IFile)resource, this.getAffectedElements(), this.getNewNames(), pm)) != null) {
            result.add(change);
        }
    }

    protected String[] getNewNames() {
        String[] result = new String[this.elements.size()];
        Iterator iter = this.elements.keySet().iterator();
        int i = 0;
        while (i < this.elements.size()) {
            IType type = (IType)iter.next();
            String oldName = type.getFullyQualifiedName('$');
            int index = oldName.lastIndexOf(type.getElementName());
            StringBuffer buffer = new StringBuffer(oldName.substring(0, index));
            buffer.append(this.elements.get(type));
            result[i] = buffer.toString();
            ++i;
        }
        return result;
    }
}

