/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.jdt;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.springframework.ide.eclipse.beans.ui.refactoring.jdt.AbstractMoveRefactoringParticipant;
import org.springframework.ide.eclipse.beans.ui.refactoring.util.BeansRefactoringChangeUtils;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class BeansTypeMoveRefactoringParticipant
extends AbstractMoveRefactoringParticipant {
    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            IJavaProject javaProject = (IJavaProject)type.getAncestor(2);
            this.project = javaProject.getProject();
            if (SpringCoreUtils.isSpringProject((IResource)this.project)) {
                this.elements = new ArrayList();
                this.elements.add(element);
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return "Rename classes referenced in Spring Bean definitions";
    }

    protected void addChange(CompositeChange result, IResource resource, IProgressMonitor pm) throws CoreException {
        Change change;
        if (resource.exists() && (change = BeansRefactoringChangeUtils.createRenameChange((IFile)resource, this.getAffectedElements(), this.getNewNames(), pm)) != null) {
            result.add(change);
        }
    }

    protected IJavaElement[] getAffectedElements() {
        return this.elements.toArray(new IJavaElement[this.elements.size()]);
    }

    private String[] getNewNames() {
        Object destination = this.getArguments().getDestination();
        StringBuffer buffer = new StringBuffer();
        if (destination instanceof IPackageFragment) {
            buffer.append(((IPackageFragment)destination).getElementName());
            if (buffer.length() > 0) {
                buffer.append(".");
            }
        }
        String[] result = new String[this.elements.size()];
        int i = 0;
        while (i < this.elements.size()) {
            result[i] = String.valueOf(buffer.toString()) + ((IJavaElement)this.elements.get(i)).getElementName();
            ++i;
        }
        return result;
    }
}

