/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.subscriber.UpdateSynchronizeOperation;

public class UpdateSynchronizeAction
extends SynchronizeModelAction {
    private boolean confirm;

    public UpdateSynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    public UpdateSynchronizeAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        ArrayList<IResource> selectedResources = new ArrayList<IResource>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ISynchronizeModelElement) {
                selectedResources.add(((ISynchronizeModelElement)elements[i]).getResource());
            }
            ++i;
        }
        IResource[] resources = new IResource[selectedResources.size()];
        selectedResources.toArray(resources);
        UpdateSynchronizeOperation operation = new UpdateSynchronizeOperation(configuration, elements, resources);
        operation.setConfirmNeeded(this.confirm);
        return operation;
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                FastSyncInfoFilter.SyncInfoDirectionFilter filter = new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12});
                if (!filter.select(info)) {
                    return false;
                }
                IStructuredSelection selection = UpdateSynchronizeAction.this.getStructuredSelection();
                for (ISynchronizeModelElement element : selection) {
                    IResource resource = element.getResource();
                    if (resource == null || !resource.exists()) {
                        return true;
                    }
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    try {
                        if (svnResource.isManaged() && !svnResource.isAdded()) continue;
                        return false;
                    }
                    catch (SVNException sVNException) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

