/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IMarkerResolution;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class ChangeParameterTypeResolution
extends LinkedCorrectionProposal
implements IMarkerResolution {
    private SingleVariableDeclaration param;
    private String paramType;
    private String paramTypePackage;

    public ChangeParameterTypeResolution(SingleVariableDeclaration param, String paramType, String paramTypePackage, ICompilationUnit cu) {
        super("Change Parameter Type", cu, null, 0, null);
        this.param = param;
        this.paramType = paramType;
        this.paramTypePackage = paramTypePackage;
    }

    public String getLabel() {
        return "Change parameter type to " + this.paramTypePackage + "." + this.paramType;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.getCompilationUnit().getImport(String.valueOf(this.paramTypePackage) + this.paramType) == null) {
            ImportRewrite importRewrite = this.createImportRewrite(ASTResolving.findParentCompilationUnit((ASTNode)this.param));
            importRewrite.addImport(String.valueOf(this.paramTypePackage) + this.paramType);
        }
        AST ast = this.param.getAST();
        ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
        SimpleName newTypeName = ast.newSimpleName(this.paramType);
        SimpleType newType = ast.newSimpleType((Name)newTypeName);
        astRewrite.replace((ASTNode)this.param.getType(), (ASTNode)newType, null);
        return astRewrite;
    }

    public void run(IMarker marker) {
        IDocument document = QuickfixUtils.getDocument((IMarker)marker);
        if (document != null) {
            this.apply(document);
            try {
                marker.delete();
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.data.core", e.getMessage(), (Throwable)e));
            }
        }
    }
}

