(function(mod) {
    if (typeof exports == "object" && typeof module == "object") // CommonJS
        return mod(require("tern/lib/infer"), require("tern/lib/tern"));
    if (typeof define == "function" && define.amd) // AMD
        return define([ "tern/lib/infer", "tern/lib/tern" ], mod);
    mod(tern, tern);
})(function(infer, tern) {
    "use strict";
    
    tern.registerPlugin("gas", function(server, options) {
        server._gas = {};
        return { defs : defs };
    });
    
    var defs = {"!name":"gas","!define":{"base":{"Blob":{"!url":"http://developers.google.com/apps-script/reference/base/blob","!doc":"Blob A data interchange object for Apps Script services.","prototype":{"copyBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#copyBlob()","!doc":"Returns a copy of this blob."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBytes":{"!type":"fn() -> [byte]","!url":"http://developers.google.com/apps-script/reference/base/#getBytes()","!doc":"Gets the data stored in this blob."},"getContentType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/base/#getContentType()","!doc":"Gets the content type of the bytes in this blob."},"getDataAsString":{"!type":"fn(charset: string) -> string","!url":"http://developers.google.com/apps-script/reference/base/#getDataAsString(String)","!doc":"Gets the data of this blob as a string with the specified encoding."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/base/#getName()","!doc":"Gets the name of this blob."},"isGoogleType":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/base/#isGoogleType()","!doc":"Returns whether this blob is a Google Apps file (Sheets, Docs, etc.)."},"setBytes":{"!type":"fn(data: [byte]) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#setBytes(Byte)","!doc":"Sets the data stored in this blob."},"setContentType":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#setContentType(String)","!doc":"Sets the content type of the bytes in this blob."},"setContentTypeFromExtension":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#setContentTypeFromExtension()","!doc":"Sets the content type of the bytes in this blob based on the file extension."},"setDataFromString":{"!type":"fn(string: string, charset: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#setDataFromString(String,String)","!doc":"Sets the data of this blob from a string with the specified encoding."},"setName":{"!type":"fn(name: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#setName(String)","!doc":"Sets the name of this blob."}}},"Menu":{"!url":"http://developers.google.com/apps-script/reference/base/menu","!doc":"Menu A custom menu in an instance of the user interface for a Google App. A script can only interact with the UI for the current instance of an open document or form, and only if the script is container-bound to the document or form. For more information, see the guide to menus. // Add a custom menu to the active spreadsheet, including a separator and a sub-menu. function onOpen(e) { SpreadsheetApp.getUi() .createMenu('My Menu') .addItem('My Menu Item', 'myFunction') .addSeparator() .addSubMenu(SpreadsheetApp.getUi().createMenu('My Submenu') .addItem('One Submenu Item', 'mySecondFunction') .addItem('Another Submenu Item', 'myThirdFunction')) .addToUi(); }","prototype":{"addItem":{"!type":"fn(caption: string, functionName: string) -> +base.Menu","!url":"http://developers.google.com/apps-script/reference/base/#addItem(String,String)","!doc":"Adds an item to the menu."},"addSeparator":{"!type":"fn() -> +base.Menu","!url":"http://developers.google.com/apps-script/reference/base/#addSeparator()","!doc":"Adds a visual separator to the menu."},"addSubMenu":{"!type":"fn(menu: base.Menu) -> +base.Menu","!url":"http://developers.google.com/apps-script/reference/base/#addSubMenu(Menu)","!doc":"Adds a sub-menu to the menu."},"addToUi":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/base/#addToUi()","!doc":"Inserts the menu into the instance of the editor's user interface."}}},"PromptResponse":{"!url":"http://developers.google.com/apps-script/reference/base/prompt-response","!doc":"PromptResponse A response to a prompt dialog displayed in the user-interface environment for a Google App. The response contains any text the user entered in the dialog's input field and indicates which button the user clicked to dismiss the dialog. // Display a dialog box with a title, message, input field, and \"Yes\" and \"No\" buttons. The // user can also close the dialog by clicking the close button in its title bar. var ui = DocumentApp.getUi(); var response = ui.prompt('Getting to know you', 'May I know your name?', ui.ButtonSet.YES_NO); // Process the user's response. if (response.getSelectedButton() == ui.Button.YES) { Logger.log('The user\\'s name is %s.', response.getResponseText()); } else if (response.getSelectedButton() == ui.Button.NO) { Logger.log('The user didn\\'t want to provide a name.'); } else { Logger.log('The user clicked the close button in the dialog\\'s title bar.'); }","prototype":{"getResponseText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/base/#getResponseText()","!doc":"Gets the text that the user entered in the dialog's input field."},"getSelectedButton":{"!type":"fn() -> +base.Button","!url":"http://developers.google.com/apps-script/reference/base/#getSelectedButton()","!doc":"Gets the button that the user clicked to dismiss the dialog."}}},"Ui":{"!url":"http://developers.google.com/apps-script/reference/base/ui","!doc":"Ui An instance of the user-interface environment for a Google App that allows the script to add features like menus, dialogs, and sidebars. A script can only interact with the UI for the current instance of an open editor, and only if the script is container-bound to the editor. // Display a dialog box with a title, message, input field, and \"Yes\" and \"No\" buttons. The // user can also close the dialog by clicking the close button in its title bar. var ui = SpreadsheetApp.getUi(); var response = ui.prompt('Getting to know you', 'May I know your name?', ui.ButtonSet.YES_NO); // Process the user's response. if (response.getSelectedButton() == ui.Button.YES) { Logger.log('The user\\'s name is %s.', response.getResponseText()); } else if (response.getSelectedButton() == ui.Button.NO) { Logger.log('The user didn\\'t want to provide a name.'); } else { Logger.log('The user clicked the close button in the dialog\\'s title bar.'); }","prototype":{"Button":{"!type":"+base.Button","!doc":"An enum representing predetermined, localized dialog buttons returned by an alert or PromptResponse.getSelectedButton() to indicate which button in a dialog the user clicked."},"ButtonSet":{"!type":"+base.ButtonSet","!doc":"An enum representing predetermined, localized sets of one or more dialog buttons that can be added to an alert or a prompt."},"alert":{"!type":"fn(title: string, prompt: string, buttons: base.ButtonSet) -> +base.Button","!url":"http://developers.google.com/apps-script/reference/base/#alert(String,String,ButtonSet)","!doc":"Opens a dialog box in the user's editor with the given title, message, and set of buttons."},"createAddonMenu":{"!type":"fn() -> +base.Menu","!url":"http://developers.google.com/apps-script/reference/base/#createAddonMenu()","!doc":"Creates a builder that can be used to insert a sub-menu into the editor's Add-on menu."},"createMenu":{"!type":"fn(caption: string) -> +base.Menu","!url":"http://developers.google.com/apps-script/reference/base/#createMenu(String)","!doc":"Creates a builder that can be used to add a menu to the editor's user interface."},"prompt":{"!type":"fn(title: string, prompt: string, buttons: base.ButtonSet) -> +base.PromptResponse","!url":"http://developers.google.com/apps-script/reference/base/#prompt(String,String,ButtonSet)","!doc":"Opens an input dialog box in the user's editor with the given title, message, and set of buttons."},"showModalDialog":{"!type":"fn(userInterface: object, title: string)","!url":"http://developers.google.com/apps-script/reference/base/#showModalDialog(Object,String)","!doc":"Opens a modal dialog box in the user's editor with custom client-side content."},"showModelessDialog":{"!type":"fn(userInterface: object, title: string)","!url":"http://developers.google.com/apps-script/reference/base/#showModelessDialog(Object,String)","!doc":"Opens a modeless dialog box in the user's editor with custom client-side content."},"showSidebar":{"!type":"fn(userInterface: object)","!url":"http://developers.google.com/apps-script/reference/base/#showSidebar(Object)","!doc":"Opens a sidebar in the user's editor with custom client-side content."}}},"User":{"!url":"http://developers.google.com/apps-script/reference/base/user","!doc":"User Representation of a user, suitable for scripting.","prototype":{"getEmail":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/base/#getEmail()","!doc":"Gets the user's email address, if available."}}},"BlobSource":{"!url":"http://developers.google.com/apps-script/reference/base/blob-source","!doc":"BlobSource Interface for objects that can export their data as a Blob. Implementing classes NameBrief description AttachmentA Sites Attachment such as a file attached to a page. BlobA data interchange object for Apps Script services. ChartA Chart object, which can be embedded into documents, UI elements, or used as a static image. DocumentA document, containing rich text and elements such as tables and lists. EmbeddedChartRepresents a chart that has been embedded into a Spreadsheet. FileThis class contains methods to get information about the file and modify its contents. FileA file in Google Drive. GmailAttachmentAn attachment from Gmail. HTTPResponseThis class allows users to access specific information on HTTP responses. HtmlOutputAn HtmlOutput object that can be served from a script. InlineImageAn element representing an embedded image. JdbcBlobA JDBC Blob. JdbcClobA JDBC Clob. SpreadsheetThis class allows users to access and modify Google Sheets files. StaticMapAllows for the creation and decoration of static map images.","prototype":{"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/base/#getBlob()","!doc":"Return the data inside this object as a blob."}}},"Button":{"!url":"http://developers.google.com/apps-script/reference/base/button","!doc":"Button An enum representing predetermined, localized dialog buttons returned by an alert or PromptResponse.getSelectedButton() to indicate which button in a dialog the user clicked. These values cannot be set; to add buttons to an alert or prompt, use ButtonSet instead. // Display a dialog box with a message and \"Yes\" and \"No\" buttons. var ui = DocumentApp.getUi(); var response = ui.alert('Are you sure you want to continue?', ui.ButtonSet.YES_NO); // Process the user's response. if (response == ui.Button.YES) { Logger.log('The user clicked \"Yes.\"'); } else { Logger.log('The user clicked \"No\" or the dialog\\'s close button.'); }","prototype":{"CLOSE":{"!type":"string","!doc":"The standard close button displayed in every dialog's title bar. This button is not explicitly added to a dialog, and it cannot be removed."},"OK":{"!type":"string","!doc":"An \"OK\" button, indicating that an operation should proceed."},"CANCEL":{"!type":"string","!doc":"A \"Cancel\" button, indicating that an operation should not proceed."},"YES":{"!type":"string","!doc":"A \"Yes\" button, indicating a positive response to a question."},"NO":{"!type":"string","!doc":"A \"No\" button, indicating a negative response to a question."}}},"ButtonSet":{"!url":"http://developers.google.com/apps-script/reference/base/button-set","!doc":"ButtonSet An enum representing predetermined, localized sets of one or more dialog buttons that can be added to an alert or a prompt. To determine which button the user clicked, use Button. // Display a dialog box with a message and \"Yes\" and \"No\" buttons. var ui = DocumentApp.getUi(); var response = ui.alert('Are you sure you want to continue?', ui.ButtonSet.YES_NO); // Process the user's response. if (response == ui.Button.YES) { Logger.log('The user clicked \"Yes.\"'); } else { Logger.log('The user clicked \"No\" or the dialog\\'s close button.'); }","prototype":{"OK":{"!type":"string","!doc":"A single \"OK\" button, indicating an informational message that can only be dismissed."},"OK_CANCEL":{"!type":"string","!doc":"An \"OK\" button and a \"Cancel\" button, allowing the user to either proceed with or halt an operation."},"YES_NO":{"!type":"string","!doc":"A \"Yes\" button and a \"No\" button, allowing the user to answer a yes/no question."},"YES_NO_CANCEL":{"!type":"string","!doc":"A \"Yes\" button, a \"No\" button, and a \"Cancel\" button, allowing the user to either answer a yes/no question or halt an operation."}}},"Month":{"!url":"http://developers.google.com/apps-script/reference/base/month","!doc":"Month An enum representing the months of the year.","prototype":{"JANUARY":{"!type":"string","!doc":"January (month 1)."},"FEBRUARY":{"!type":"string","!doc":"February (month 2)."},"MARCH":{"!type":"string","!doc":"March (month 3)."},"APRIL":{"!type":"string","!doc":"April (month 4)."},"MAY":{"!type":"string","!doc":"May (month 5)."},"JUNE":{"!type":"string","!doc":"June (month 6)."},"JULY":{"!type":"string","!doc":"July (month 7)."},"AUGUST":{"!type":"string","!doc":"August (month 8)."},"SEPTEMBER":{"!type":"string","!doc":"September (month 9)."},"OCTOBER":{"!type":"string","!doc":"October (month 10)."},"NOVEMBER":{"!type":"string","!doc":"November (month 11)."},"DECEMBER":{"!type":"string","!doc":"December (month 12)."}}},"Weekday":{"!url":"http://developers.google.com/apps-script/reference/base/weekday","!doc":"Weekday An enum representing the days of the week.","prototype":{"SUNDAY":{"!type":"string","!doc":"Sunday."},"MONDAY":{"!type":"string","!doc":"Monday."},"TUESDAY":{"!type":"string","!doc":"Tuesday."},"WEDNESDAY":{"!type":"string","!doc":"Wednesday."},"THURSDAY":{"!type":"string","!doc":"Thursday."},"FRIDAY":{"!type":"string","!doc":"Friday."},"SATURDAY":{"!type":"string","!doc":"Saturday."}}}},"cache":{"Cache":{"!url":"http://developers.google.com/apps-script/reference/cache/cache","!doc":"A reference to a particular cache. This class allows you to insert, retrieve, and remove items from a cache. This can be particularly useful when you want frequent access to an expensive or slow resource. For example, say you have an RSS feed at example.com that takes 20 seconds to fetch, but you want to speed up access on an average request. function getRssFeed() { var cache = CacheService.getPublicCache(); var cached = cache.get(\"rss-feed-contents\"); if (cached != null) { return cached; } var result = UrlFetchApp.fetch(\"http://example.com/my-slow-rss-feed.xml\"); // takes 20 seconds var contents = result.getContentText(); cache.put(\"rss-feed-contents\", contents, 1500); // cache for 25 minutes return contents; } You'll still need to wait the 20 seconds if the item is not in the cache, but subsequent calls will be very fast until the item expires out of the cache in 25 minutes.","prototype":{"get":{"!type":"fn(key: string) -> string","!url":"http://developers.google.com/apps-script/reference/cache/#get(String)","!doc":"Gets the cached value for the given key, or null if none is found."},"getAll":{"!type":"fn(keys: [string]) -> object","!url":"http://developers.google.com/apps-script/reference/cache/#getAll(String)","!doc":"Returns a JavaScript Object containing all key/value pairs found in the cache for an array of keys."},"put":{"!type":"fn(key: string, value: string, expirationInSeconds: number)","!url":"http://developers.google.com/apps-script/reference/cache/#put(String,String,Integer)","!doc":"Adds a key/value pair to the cache, with an expiration time (in seconds)."},"putAll":{"!type":"fn(values: object, expirationInSeconds: number)","!url":"http://developers.google.com/apps-script/reference/cache/#putAll(Object,Integer)","!doc":"Adds a set of key/value pairs to the cache, with an expiration time (in seconds)."},"remove":{"!type":"fn(key: string)","!url":"http://developers.google.com/apps-script/reference/cache/#remove(String)","!doc":"Removes an entry from the cache using the given key."},"removeAll":{"!type":"fn(keys: [string])","!url":"http://developers.google.com/apps-script/reference/cache/#removeAll(String)","!doc":"Removes a set of entries from the cache."}}}},"calendar":{"Calendar":{"!url":"http://developers.google.com/apps-script/reference/calendar/calendar","!doc":"Calendar Represents a calendar that the user owns or is subscribed to.","prototype":{"createAllDayEvent":{"!type":"fn(title: string, date: date, options: object) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#createAllDayEvent(String,Date,Object)","!doc":"Creates a new all-day event."},"createAllDayEventSeries":{"!type":"fn(title: string, startDate: date, recurrence: calendar.EventRecurrence, options: object) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#createAllDayEventSeries(String,Date,EventRecurrence,Object)","!doc":"Creates a new all-day event series."},"createEvent":{"!type":"fn(title: string, startTime: date, endTime: date, options: object) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#createEvent(String,Date,Date,Object)","!doc":"Creates a new event."},"createEventFromDescription":{"!type":"fn(description: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#createEventFromDescription(String)","!doc":"Creates an event from a free-form description."},"createEventSeries":{"!type":"fn(title: string, startTime: date, endTime: date, recurrence: calendar.EventRecurrence, options: object) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#createEventSeries(String,Date,Date,EventRecurrence,Object)","!doc":"Creates a new event series."},"deleteCalendar":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/calendar/#deleteCalendar()","!doc":"Deletes the calendar permanently."},"getColor":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getColor()","!doc":"Gets the color of the calendar."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getDescription()","!doc":"Gets the description of the calendar."},"getEventSeriesById":{"!type":"fn(iCalId: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#getEventSeriesById(String)","!doc":"Gets the event series with the given ID."},"getEvents":{"!type":"fn(startTime: date, endTime: date, options: object) -> [+calendar.CalendarEvent]","!url":"http://developers.google.com/apps-script/reference/calendar/#getEvents(Date,Date,Object)","!doc":"Gets all events that occur within a given time range and meet the specified criteria."},"getEventsForDay":{"!type":"fn(date: date, options: object) -> [+calendar.CalendarEvent]","!url":"http://developers.google.com/apps-script/reference/calendar/#getEventsForDay(Date,Object)","!doc":"Gets all events that occur on a given day and meet specified criteria."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getId()","!doc":"Gets the ID of the calendar."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getName()","!doc":"Gets the name of the calendar."},"getTimeZone":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getTimeZone()","!doc":"Gets the time zone of the calendar."},"isHidden":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isHidden()","!doc":"Determines whether the calendar is hidden in the user interface."},"isMyPrimaryCalendar":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isMyPrimaryCalendar()","!doc":"Determines whether the calendar is the default calendar for the effective user."},"isOwnedByMe":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isOwnedByMe()","!doc":"Determines whether the calendar is owned by the effective user."},"isSelected":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isSelected()","!doc":"Determines whether the calendar's events are displayed in the user interface."},"setColor":{"!type":"fn(color: string) -> +calendar.Calendar","!url":"http://developers.google.com/apps-script/reference/calendar/#setColor(String)","!doc":"Sets the color of the calendar."},"setDescription":{"!type":"fn(description: string) -> +calendar.Calendar","!url":"http://developers.google.com/apps-script/reference/calendar/#setDescription(String)","!doc":"Sets the description of the calendar."},"setHidden":{"!type":"fn(hidden: bool) -> +calendar.Calendar","!url":"http://developers.google.com/apps-script/reference/calendar/#setHidden(Boolean)","!doc":"Sets whether the calendar is visible in the user interface."},"setName":{"!type":"fn(name: string) -> +calendar.Calendar","!url":"http://developers.google.com/apps-script/reference/calendar/#setName(String)","!doc":"Sets the name of the calendar."},"setSelected":{"!type":"fn(selected: bool) -> +calendar.Calendar","!url":"http://developers.google.com/apps-script/reference/calendar/#setSelected(Boolean)","!doc":"Sets whether the calendar's events are displayed in the user interface."},"setTimeZone":{"!type":"fn(timeZone: string) -> +calendar.Calendar","!url":"http://developers.google.com/apps-script/reference/calendar/#setTimeZone(String)","!doc":"Sets the time zone of the calendar."},"unsubscribeFromCalendar":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/calendar/#unsubscribeFromCalendar()","!doc":"Unsubscribes the user from the calendar."}}},"CalendarEvent":{"!url":"http://developers.google.com/apps-script/reference/calendar/calendar-event","!doc":"CalendarEvent Represents a single calendar event.","prototype":{"addEmailReminder":{"!type":"fn(minutesBefore: number) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#addEmailReminder(Integer)","!doc":"Adds a new email reminder to the event."},"addGuest":{"!type":"fn(email: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#addGuest(String)","!doc":"Adds a guest to the event."},"addPopupReminder":{"!type":"fn(minutesBefore: number) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#addPopupReminder(Integer)","!doc":"Adds a new popup reminder to the event."},"addSmsReminder":{"!type":"fn(minutesBefore: number) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#addSmsReminder(Integer)","!doc":"Adds a new SMS reminder to the event."},"anyoneCanAddSelf":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#anyoneCanAddSelf()","!doc":"Determines whether anyone can invite themselves."},"deleteEvent":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/calendar/#deleteEvent()","!doc":"Deletes the event."},"deleteTag":{"!type":"fn(key: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#deleteTag(String)","!doc":"Deletes a key/value tag from the event."},"getAllDayEndDate":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getAllDayEndDate()","!doc":"Gets the date on which this all-day calendar event ends."},"getAllDayStartDate":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getAllDayStartDate()","!doc":"Gets the date on which this all-day calendar event begins."},"getAllTagKeys":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/calendar/#getAllTagKeys()","!doc":"Gets all keys for tags that have been set on the event."},"getCreators":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/calendar/#getCreators()","!doc":"Gets the creators of the event."},"getDateCreated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getDateCreated()","!doc":"Gets the date the event was created."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getDescription()","!doc":"Gets the description of the event."},"getEmailReminders":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/calendar/#getEmailReminders()","!doc":"Gets the minute values for all email reminders for the event."},"getEndTime":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getEndTime()","!doc":"Gets the date and time at which this calendar event ends."},"getEventSeries":{"!type":"fn() -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#getEventSeries()","!doc":"Gets the series of recurring events that this event belongs to."},"getGuestByEmail":{"!type":"fn(email: string) -> +calendar.EventGuest","!url":"http://developers.google.com/apps-script/reference/calendar/#getGuestByEmail(String)","!doc":"Gets a guest by email address."},"getGuestList":{"!type":"fn(includeOwner: bool) -> [+calendar.EventGuest]","!url":"http://developers.google.com/apps-script/reference/calendar/#getGuestList(Boolean)","!doc":"Gets the guests for the event, potentially including the event owners."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getId()","!doc":"Gets the ID of the event."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getLastUpdated()","!doc":"Gets the date the event was last updated."},"getLocation":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getLocation()","!doc":"Gets the location of the event."},"getMyStatus":{"!type":"fn() -> +calendar.GuestStatus","!url":"http://developers.google.com/apps-script/reference/calendar/#getMyStatus()","!doc":"Gets the event status (attending, etc.) of the effective user."},"getOriginalCalendarId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getOriginalCalendarId()","!doc":"Get the ID of the calendar where this event was originally created."},"getPopupReminders":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/calendar/#getPopupReminders()","!doc":"Gets the minute values for all popup reminders for the event."},"getSmsReminders":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/calendar/#getSmsReminders()","!doc":"Gets the minute values for all SMS reminders for the event."},"getStartTime":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getStartTime()","!doc":"Gets the date and time at which this calendar event begins."},"getTag":{"!type":"fn(key: string) -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getTag(String)","!doc":"Gets a tag value of the event."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getTitle()","!doc":"Gets the title of the event."},"getVisibility":{"!type":"fn() -> +calendar.Visibility","!url":"http://developers.google.com/apps-script/reference/calendar/#getVisibility()","!doc":"Gets the visibility of the event."},"guestsCanInviteOthers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#guestsCanInviteOthers()","!doc":"Determines whether guests can invite other guests."},"guestsCanModify":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#guestsCanModify()","!doc":"Determines whether guests can modify the event."},"guestsCanSeeGuests":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#guestsCanSeeGuests()","!doc":"Determines whether guests can see other guests."},"isAllDayEvent":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isAllDayEvent()","!doc":"Determines whether this is an all-day event."},"isOwnedByMe":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isOwnedByMe()","!doc":"Determines whether the event is owned by the effective user."},"isRecurringEvent":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isRecurringEvent()","!doc":"Determines whether the event is part of an event series."},"removeAllReminders":{"!type":"fn() -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#removeAllReminders()","!doc":"Removes all reminders from the event."},"removeGuest":{"!type":"fn(email: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#removeGuest(String)","!doc":"Removes a guest from the event."},"resetRemindersToDefault":{"!type":"fn() -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#resetRemindersToDefault()","!doc":"Resets the reminders using the calendar's default settings."},"setAllDayDate":{"!type":"fn(date: date) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setAllDayDate(Date)","!doc":"Sets the date of the event."},"setAnyoneCanAddSelf":{"!type":"fn(anyoneCanAddSelf: bool) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setAnyoneCanAddSelf(Boolean)","!doc":"Sets whether non-guests can add themselves to the event."},"setDescription":{"!type":"fn(description: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setDescription(String)","!doc":"Sets the description of the event."},"setGuestsCanInviteOthers":{"!type":"fn(guestsCanInviteOthers: bool) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setGuestsCanInviteOthers(Boolean)","!doc":"Sets whether guests can invite other guests."},"setGuestsCanModify":{"!type":"fn(guestsCanModify: bool) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setGuestsCanModify(Boolean)","!doc":"Sets whether guests can modify the event."},"setGuestsCanSeeGuests":{"!type":"fn(guestsCanSeeGuests: bool) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setGuestsCanSeeGuests(Boolean)","!doc":"Sets whether guests can see other guests."},"setLocation":{"!type":"fn(location: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setLocation(String)","!doc":"Sets the location of the event."},"setMyStatus":{"!type":"fn(status: calendar.GuestStatus) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setMyStatus(GuestStatus)","!doc":"Sets the event status (attending, etc.) of the effective user."},"setTag":{"!type":"fn(key: string, value: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setTag(String,String)","!doc":"Sets a key/value tag on the event, for storing custom metadata."},"setTime":{"!type":"fn(startTime: date, endTime: date) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setTime(Date,Date)","!doc":"Sets the dates and times for the start and end of the event."},"setTitle":{"!type":"fn(title: string) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setTitle(String)","!doc":"Sets the title of the event."},"setVisibility":{"!type":"fn(visibility: calendar.Visibility) -> +calendar.CalendarEvent","!url":"http://developers.google.com/apps-script/reference/calendar/#setVisibility(Visibility)","!doc":"Sets the visibility of the event."}}},"CalendarEventSeries":{"!url":"http://developers.google.com/apps-script/reference/calendar/calendar-event-series","!doc":"CalendarEventSeries Represents a series of events (a recurring event).","prototype":{"addEmailReminder":{"!type":"fn(minutesBefore: number) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#addEmailReminder(Integer)","!doc":"Adds a new email reminder to the event."},"addGuest":{"!type":"fn(email: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#addGuest(String)","!doc":"Adds a guest to the event."},"addPopupReminder":{"!type":"fn(minutesBefore: number) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#addPopupReminder(Integer)","!doc":"Adds a new popup reminder to the event."},"addSmsReminder":{"!type":"fn(minutesBefore: number) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#addSmsReminder(Integer)","!doc":"Adds a new SMS reminder to the event."},"anyoneCanAddSelf":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#anyoneCanAddSelf()","!doc":"Determines whether anyone can invite themselves."},"deleteEventSeries":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/calendar/#deleteEventSeries()","!doc":"Deletes the event series."},"deleteTag":{"!type":"fn(key: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#deleteTag(String)","!doc":"Deletes a key/value tag from the event."},"getAllTagKeys":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/calendar/#getAllTagKeys()","!doc":"Gets all keys for tags that have been set on the event."},"getCreators":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/calendar/#getCreators()","!doc":"Gets the creators of the event."},"getDateCreated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getDateCreated()","!doc":"Gets the date the event was created."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getDescription()","!doc":"Gets the description of the event."},"getEmailReminders":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/calendar/#getEmailReminders()","!doc":"Gets the minute values for all email reminders for the event."},"getGuestByEmail":{"!type":"fn(email: string) -> +calendar.EventGuest","!url":"http://developers.google.com/apps-script/reference/calendar/#getGuestByEmail(String)","!doc":"Gets a guest by email address."},"getGuestList":{"!type":"fn(includeOwner: bool) -> [+calendar.EventGuest]","!url":"http://developers.google.com/apps-script/reference/calendar/#getGuestList(Boolean)","!doc":"Gets the guests for the event, potentially including the event owners."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getId()","!doc":"Gets the ID of the event."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/calendar/#getLastUpdated()","!doc":"Gets the date the event was last updated."},"getLocation":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getLocation()","!doc":"Gets the location of the event."},"getMyStatus":{"!type":"fn() -> +calendar.GuestStatus","!url":"http://developers.google.com/apps-script/reference/calendar/#getMyStatus()","!doc":"Gets the event status (attending, etc.) of the effective user."},"getOriginalCalendarId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getOriginalCalendarId()","!doc":"Get the ID of the calendar where this event was originally created."},"getPopupReminders":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/calendar/#getPopupReminders()","!doc":"Gets the minute values for all popup reminders for the event."},"getSmsReminders":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/calendar/#getSmsReminders()","!doc":"Gets the minute values for all SMS reminders for the event."},"getTag":{"!type":"fn(key: string) -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getTag(String)","!doc":"Gets a tag value of the event."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getTitle()","!doc":"Gets the title of the event."},"getVisibility":{"!type":"fn() -> +calendar.Visibility","!url":"http://developers.google.com/apps-script/reference/calendar/#getVisibility()","!doc":"Gets the visibility of the event."},"guestsCanInviteOthers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#guestsCanInviteOthers()","!doc":"Determines whether guests can invite other guests."},"guestsCanModify":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#guestsCanModify()","!doc":"Determines whether guests can modify the event."},"guestsCanSeeGuests":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#guestsCanSeeGuests()","!doc":"Determines whether guests can see other guests."},"isOwnedByMe":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/calendar/#isOwnedByMe()","!doc":"Determines whether the event is owned by the effective user."},"removeAllReminders":{"!type":"fn() -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#removeAllReminders()","!doc":"Removes all reminders from the event."},"removeGuest":{"!type":"fn(email: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#removeGuest(String)","!doc":"Removes a guest from the event."},"resetRemindersToDefault":{"!type":"fn() -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#resetRemindersToDefault()","!doc":"Resets the reminders using the calendar's default settings."},"setAnyoneCanAddSelf":{"!type":"fn(anyoneCanAddSelf: bool) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setAnyoneCanAddSelf(Boolean)","!doc":"Sets whether non-guests can add themselves to the event."},"setDescription":{"!type":"fn(description: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setDescription(String)","!doc":"Sets the description of the event."},"setGuestsCanInviteOthers":{"!type":"fn(guestsCanInviteOthers: bool) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setGuestsCanInviteOthers(Boolean)","!doc":"Sets whether guests can invite other guests."},"setGuestsCanModify":{"!type":"fn(guestsCanModify: bool) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setGuestsCanModify(Boolean)","!doc":"Sets whether guests can modify the event."},"setGuestsCanSeeGuests":{"!type":"fn(guestsCanSeeGuests: bool) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setGuestsCanSeeGuests(Boolean)","!doc":"Sets whether guests can see other guests."},"setLocation":{"!type":"fn(location: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setLocation(String)","!doc":"Sets the location of the event."},"setMyStatus":{"!type":"fn(status: calendar.GuestStatus) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setMyStatus(GuestStatus)","!doc":"Sets the event status (attending, etc.) of the effective user."},"setRecurrence":{"!type":"fn(recurrence: calendar.EventRecurrence, startTime: date, endTime: date) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setRecurrence(EventRecurrence,Date,Date)","!doc":"Sets the recurrence rules for this event series."},"setTag":{"!type":"fn(key: string, value: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setTag(String,String)","!doc":"Sets a key/value tag on the event, for storing custom metadata."},"setTitle":{"!type":"fn(title: string) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setTitle(String)","!doc":"Sets the title of the event."},"setVisibility":{"!type":"fn(visibility: calendar.Visibility) -> +calendar.CalendarEventSeries","!url":"http://developers.google.com/apps-script/reference/calendar/#setVisibility(Visibility)","!doc":"Sets the visibility of the event."}}},"EventGuest":{"!url":"http://developers.google.com/apps-script/reference/calendar/event-guest","!doc":"EventGuest Represents a guest of an event.","prototype":{"getAdditionalGuests":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/calendar/#getAdditionalGuests()","!doc":"Gets the number of additional people that this guest has said will attend."},"getEmail":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getEmail()","!doc":"Gets the email address of the guest."},"getGuestStatus":{"!type":"fn() -> +calendar.GuestStatus","!url":"http://developers.google.com/apps-script/reference/calendar/#getGuestStatus()","!doc":"Gets the status of the guest for the event."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/calendar/#getName()","!doc":"Gets the name of the guest."}}},"EventRecurrence":{"!url":"http://developers.google.com/apps-script/reference/calendar/event-recurrence","!doc":"EventRecurrence Represents the recurrence settings for an event series.","prototype":{"addDailyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addDailyExclusion()","!doc":"Adds a rule that excludes occurrences on a daily basis."},"addDailyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addDailyRule()","!doc":"Adds a rule that causes the event to recur on a daily basis."},"addDate":{"!type":"fn(date: date) -> +calendar.EventRecurrence","!url":"http://developers.google.com/apps-script/reference/calendar/#addDate(Date)","!doc":"Adds a rule that causes the event to recur on a specific date."},"addDateExclusion":{"!type":"fn(date: date) -> +calendar.EventRecurrence","!url":"http://developers.google.com/apps-script/reference/calendar/#addDateExclusion(Date)","!doc":"Adds a rule that excludes an occurrence for a specific date."},"addMonthlyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addMonthlyExclusion()","!doc":"Adds a rule that excludes occurrences on a monthly basis."},"addMonthlyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addMonthlyRule()","!doc":"Adds a rule that causes the event to recur on a monthly basis."},"addWeeklyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addWeeklyExclusion()","!doc":"Adds a rule that excludes occurrences on a weekly basis."},"addWeeklyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addWeeklyRule()","!doc":"Adds a rule that causes the event to recur on a weekly basis."},"addYearlyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addYearlyExclusion()","!doc":"Adds a rule that excludes occurrences on a yearly basis."},"addYearlyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addYearlyRule()","!doc":"Adds a rule that causes the event to recur on a yearly basis."},"setTimeZone":{"!type":"fn(timeZone: string) -> +calendar.EventRecurrence","!url":"http://developers.google.com/apps-script/reference/calendar/#setTimeZone(String)","!doc":"Sets the time zone for this recurrence."}}},"RecurrenceRule":{"!url":"http://developers.google.com/apps-script/reference/calendar/recurrence-rule","!doc":"RecurrenceRule Represents a recurrence rule for an event series. Note that this class also behaves like the EventRecurrence that it belongs to, allowing you to chain rule creation together like so: recurrence.addDailyRule().times(3).interval(2).addWeeklyExclusion().times(2); Modifiers like times(times) and interval(interval) are applied to the most recently added rule.","prototype":{"addDailyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addDailyExclusion()","!doc":"Adds a rule that excludes occurrences on a daily basis."},"addDailyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addDailyRule()","!doc":"Adds a rule that causes the event to recur on a daily basis."},"addDate":{"!type":"fn(date: date) -> +calendar.EventRecurrence","!url":"http://developers.google.com/apps-script/reference/calendar/#addDate(Date)","!doc":"Adds a rule that causes the event to recur on a specific date."},"addDateExclusion":{"!type":"fn(date: date) -> +calendar.EventRecurrence","!url":"http://developers.google.com/apps-script/reference/calendar/#addDateExclusion(Date)","!doc":"Adds a rule that excludes an occurrence for a specific date."},"addMonthlyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addMonthlyExclusion()","!doc":"Adds a rule that excludes occurrences on a monthly basis."},"addMonthlyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addMonthlyRule()","!doc":"Adds a rule that causes the event to recur on a monthly basis."},"addWeeklyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addWeeklyExclusion()","!doc":"Adds a rule that excludes occurrences on a weekly basis."},"addWeeklyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addWeeklyRule()","!doc":"Adds a rule that causes the event to recur on a weekly basis."},"addYearlyExclusion":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addYearlyExclusion()","!doc":"Adds a rule that excludes occurrences on a yearly basis."},"addYearlyRule":{"!type":"fn() -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#addYearlyRule()","!doc":"Adds a rule that causes the event to recur on a yearly basis."},"interval":{"!type":"fn(interval: number) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#interval(Integer)","!doc":"Configures the rule to only apply at this interval of the rule's time unit."},"onlyInMonth":{"!type":"fn(month: base.Month) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyInMonth(Month)","!doc":"Configures the rule to only apply to a specific month."},"onlyInMonths":{"!type":"fn(months: [base.Month]) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyInMonths(Month)","!doc":"Configures the rule to only apply to specific months."},"onlyOnMonthDay":{"!type":"fn(day: number) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnMonthDay(Integer)","!doc":"Configures the rule to only apply to a specific day of the month."},"onlyOnMonthDays":{"!type":"fn(days: [number]) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnMonthDays(Integer)","!doc":"Configures the rule to only apply to specific days of the month."},"onlyOnWeek":{"!type":"fn(week: number) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnWeek(Integer)","!doc":"Configures the rule to only apply to a specific week of the year."},"onlyOnWeekday":{"!type":"fn(day: base.Weekday) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnWeekday(Weekday)","!doc":"Configures the rule to only apply to a specific day of the week."},"onlyOnWeekdays":{"!type":"fn(days: [base.Weekday]) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnWeekdays(Weekday)","!doc":"Configures the rule to only apply to specific days of the week."},"onlyOnWeeks":{"!type":"fn(weeks: [number]) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnWeeks(Integer)","!doc":"Configures the rule to only apply to specific weeks of the year."},"onlyOnYearDay":{"!type":"fn(day: number) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnYearDay(Integer)","!doc":"Configures the rule to only apply to a specific day of the year."},"onlyOnYearDays":{"!type":"fn(days: [number]) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#onlyOnYearDays(Integer)","!doc":"Configures the rule to only apply to specific days of the year."},"setTimeZone":{"!type":"fn(timeZone: string) -> +calendar.EventRecurrence","!url":"http://developers.google.com/apps-script/reference/calendar/#setTimeZone(String)","!doc":"Sets the time zone for this recurrence."},"times":{"!type":"fn(times: number) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#times(Integer)","!doc":"Configures the rule to end after a given number of occurrences."},"until":{"!type":"fn(endDate: date) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#until(Date)","!doc":"Configures the rule to end on a given date (inclusive)."},"weekStartsOn":{"!type":"fn(day: base.Weekday) -> +calendar.RecurrenceRule","!url":"http://developers.google.com/apps-script/reference/calendar/#weekStartsOn(Weekday)","!doc":"Configures which day a week starts on, for the purposes of applying the rule."}}},"Color":{"!url":"http://developers.google.com/apps-script/reference/calendar/color","!doc":"Color An enum representing the named colors available in the Calendar service.","prototype":{"BLUE":{"!type":"string","!doc":"Blue (#2952A3)."},"BROWN":{"!type":"string","!doc":"Brown (#8D6F47)."},"CHARCOAL":{"!type":"string","!doc":"Charcoal (#4E5D6C)."},"CHESTNUT":{"!type":"string","!doc":"Chestnut (#865A5A)."},"GRAY":{"!type":"string","!doc":"Gray (#5A6986)."},"GREEN":{"!type":"string","!doc":"Green (#0D7813)."},"INDIGO":{"!type":"string","!doc":"Indigo (#5229A3)."},"LIME":{"!type":"string","!doc":"Lime (#528800)."},"MUSTARD":{"!type":"string","!doc":"Mustard (#88880E)."},"OLIVE":{"!type":"string","!doc":"Olive (#6E6E41)."},"ORANGE":{"!type":"string","!doc":"Orange (#BE6D00)."},"PINK":{"!type":"string","!doc":"Pink (#B1365F)."},"PLUM":{"!type":"string","!doc":"Plum (#705770)."},"PURPLE":{"!type":"string","!doc":"Purple (#7A367A)."},"RED":{"!type":"string","!doc":"Red (#A32929)."},"RED_ORANGE":{"!type":"string","!doc":"Red-Orange (#B1440E)."},"SEA_BLUE":{"!type":"string","!doc":"Sea Blue (#29527A)."},"SLATE":{"!type":"string","!doc":"Slate (#4A716C)."},"TEAL":{"!type":"string","!doc":"Teal (#28754E)."},"TURQOISE":{"!type":"string","!doc":"Turquoise (#1B887A)."},"YELLOW":{"!type":"string","!doc":"Yellow (#AB8B00)."}}},"GuestStatus":{"!url":"http://developers.google.com/apps-script/reference/calendar/guest-status","!doc":"GuestStatus An enum representing the statuses a guest can have for an event.","prototype":{"INVITED":{"!type":"string","!doc":"The guest has been invited, but has not indicated whether he or she will attend."},"MAYBE":{"!type":"string","!doc":"The guest has indicated he or she might attend."},"NO":{"!type":"string","!doc":"The guest has indicated he or she will not attend."},"OWNER":{"!type":"string","!doc":"The guest is the owner of the event."},"YES":{"!type":"string","!doc":"The guest has indicated he or she will attend."}}},"Visibility":{"!url":"http://developers.google.com/apps-script/reference/calendar/visibility","!doc":"Visibility An enum representing the visibility of an event.","prototype":{"CONFIDENTIAL":{"!type":"string","!doc":"The event is private. This value is provided for compatibility reasons."},"DEFAULT":{"!type":"string","!doc":"Uses the default visibility for events on the calendar."},"PRIVATE":{"!type":"string","!doc":"The event is private and only event attendees may view event details."},"PUBLIC":{"!type":"string","!doc":"The event is public and event details are visible to all readers of the calendar."}}}},"charts":{"AreaChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/area-chart-builder","!doc":"AreaChartBuilder Builder for area charts. For more details, see the Google Charts documentation. Here is an example that shows how to build an area chart. function doGet() { // Create a data table with some sample data. var sampleData = Charts.newDataTable() .addColumn(Charts.ColumnType.STRING, \"Month\") .addColumn(Charts.ColumnType.NUMBER, \"Dining\") .addColumn(Charts.ColumnType.NUMBER, \"Total\") .addRow([\"Jan\", 60, 520]) .addRow([\"Feb\", 50, 430]) .addRow([\"Mar\", 53, 440]) .addRow([\"Apr\", 70, 410]) .addRow([\"May\", 80, 390]) .addRow([\"Jun\", 60, 500]) .addRow([\"Jul\", 100, 450]) .addRow([\"Aug\", 140, 431]) .addRow([\"Sep\", 75, 488]) .addRow([\"Oct\", 70, 521]) .addRow([\"Nov\", 58, 388]) .addRow([\"Dec\", 63, 400]) .build(); var chart = Charts.newAreaChart() .setTitle('Yearly Spending') .setXAxisTitle('Month') .setYAxisTitle('Spending (USD)') .setDimensions(600, 500) .setStacked() .setColors(['red', 'green']) .setDataTable(sampleData) .build(); return UiApp.createApplication().add(chart); }","prototype":{"build":{"!type":"fn() -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds the chart."},"reverseCategories":{"!type":"fn() -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setDataSourceUrl":{"!type":"fn(url: string) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataSourceUrl(String)","!doc":"Sets the data source URL that will be used to pull data in from an external source, such as Google Sheets."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the data table which contains the lines for the chart, as well as the X-axis labels."},"setDataViewDefinition":{"!type":"fn(dataViewDefinition: charts.DataViewDefinition) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataViewDefinition(DataViewDefinition)","!doc":"Sets the data view definition to use for the chart."},"setDimensions":{"!type":"fn(width: number, height: number) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDimensions(Integer,Integer)","!doc":"Sets the dimensions for the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPointStyle":{"!type":"fn(style: charts.PointStyle) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setPointStyle(PointStyle)","!doc":"Sets the style for points in the line."},"setRange":{"!type":"fn(start: number, end: number) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setStacked":{"!type":"fn() -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setStacked()","!doc":"Uses stacked lines, meaning that line and bar values are stacked (accumulated)."},"setTitle":{"!type":"fn(chartTitle: string) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +charts.AreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"BarChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/bar-chart-builder","!doc":"BarChartBuilder Builder for bar charts. For more details, see the Google Charts documentation. Here is an example that shows how to build a bar chart. The data is imported from a Google spreadsheet. function doGet() { // Get sample data from a spreadsheet. var dataSourceUrl = 'https://docs.google.com/spreadsheet/tq?range=B1%3AC11' + '&key=0Aq4s9w_HxMs7dHpfX05JdmVSb1FpT21sbXd4NVE3UEE&gid=0&headers=-1'; var chartBuilder = Charts.newBarChart() .setTitle('Top Grossing Films in US and Canada') .setXAxisTitle('USD') .setYAxisTitle('Film') .setDimensions(600, 500) .setLegendPosition(Charts.Position.BOTTOM) .setDataSourceUrl(dataSourceUrl); var chart = chartBuilder.build(); return UiApp.createApplication().add(chart); }","prototype":{"build":{"!type":"fn() -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds the chart."},"reverseCategories":{"!type":"fn() -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"reverseDirection":{"!type":"fn() -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#reverseDirection()","!doc":"Reverses the direction in which the bars grow along the horizontal axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setDataSourceUrl":{"!type":"fn(url: string) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataSourceUrl(String)","!doc":"Sets the data source URL that will be used to pull data in from an external source, such as Google Sheets."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the data table which contains the lines for the chart, as well as the X-axis labels."},"setDataViewDefinition":{"!type":"fn(dataViewDefinition: charts.DataViewDefinition) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataViewDefinition(DataViewDefinition)","!doc":"Sets the data view definition to use for the chart."},"setDimensions":{"!type":"fn(width: number, height: number) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDimensions(Integer,Integer)","!doc":"Sets the dimensions for the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setRange":{"!type":"fn(start: number, end: number) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setStacked":{"!type":"fn() -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setStacked()","!doc":"Uses stacked lines, meaning that line and bar values are stacked (accumulated)."},"setTitle":{"!type":"fn(chartTitle: string) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +charts.BarChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"CategoryFilterBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/category-filter-builder","!doc":"CategoryFilterBuilder A builder for category filter controls. A category filter is a picker to choose one or more between a set of defined values. Given a column of type string, this control will filter out the rows that don't match any of the picked values. Here is an example that creates a table chart a binds a category filter to it. This allows the user to filter the data the table displays. function doGet() { var app = UiApp.createApplication(); var sampleData = Charts.newDataTable() .addColumn(Charts.ColumnType.STRING, \"Month\") .addColumn(Charts.ColumnType.NUMBER, \"Dining\") .addColumn(Charts.ColumnType.NUMBER, \"Total\") .addRow([\"Jan\", 60, 520]) .addRow([\"Feb\", 50, 430]) .addRow([\"Mar\", 53, 440]) .addRow([\"Apr\", 70, 410]) .addRow([\"May\", 80, 390]) .addRow([\"Jun\", 60, 500]) .addRow([\"Jul\", 100, 450]) .addRow([\"Aug\", 140, 431]) .addRow([\"Sep\", 75, 488]) .addRow([\"Oct\", 70, 521]) .addRow([\"Nov\", 58, 388]) .addRow([\"Dec\", 63, 400]) .build(); var chart = Charts.newTableChart() .setDimensions(600, 500) .build(); var categoryFilter = Charts.newCategoryFilter() .setFilterColumnLabel(\"Month\") .setAllowMultiple(true) .setSortValues(true) .setLabelStacking(Charts.Orientation.VERTICAL) .setCaption('Choose categories...') .setSortValues(true) .build(); var panel = app.createVerticalPanel().setSpacing(10); panel.add(categoryFilter).add(chart); var dashboard = Charts.newDashboardPanel() .setDataTable(sampleData) .bind(categoryFilter, chart) .build(); dashboard.add(panel); app.add(dashboard); return app; } For more details, see the Gviz documentation","prototype":{"build":{"!type":"fn() -> +charts.Control","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds a control."},"setAllowMultiple":{"!type":"fn(allowMultiple: bool) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setAllowMultiple(Boolean)","!doc":"Sets whether multiple values can be selected, rather than just one."},"setAllowNone":{"!type":"fn(allowNone: bool) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setAllowNone(Boolean)","!doc":"Sets whether the user is allowed not to choose any value."},"setAllowTyping":{"!type":"fn(allowTyping: bool) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setAllowTyping(Boolean)","!doc":"Sets whether the user is allowed to type in a text field to narrow down the list of possible choices (via an autocompleter), or not."},"setCaption":{"!type":"fn(caption: string) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setCaption(String)","!doc":"Sets the caption to display inside the value picker widget when no item is selected."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the control data table, which will be the control's underlying data model."},"setFilterColumnIndex":{"!type":"fn(columnIndex: number) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFilterColumnIndex(Integer)","!doc":"Sets the index of the data table column to filter on."},"setFilterColumnLabel":{"!type":"fn(columnLabel: string) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFilterColumnLabel(String)","!doc":"Sets the label of the data table column to filter on."},"setLabel":{"!type":"fn(label: string) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabel(String)","!doc":"Sets the label to display next to the slider."},"setLabelSeparator":{"!type":"fn(labelSeparator: string) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabelSeparator(String)","!doc":"Sets a separator string appended to the label, to visually separate the label from the category picker."},"setLabelStacking":{"!type":"fn(orientation: charts.Orientation) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabelStacking(Orientation)","!doc":"Sets whether the label should display above (vertical stacking) or beside (horizontal stacking) the input field."},"setSelectedValuesLayout":{"!type":"fn(layout: charts.PickerValuesLayout) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setSelectedValuesLayout(PickerValuesLayout)","!doc":"Sets how to display selected values, when multiple selection is allowed."},"setSortValues":{"!type":"fn(sortValues: bool) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setSortValues(Boolean)","!doc":"Sets whether the values to choose from should be sorted."},"setValues":{"!type":"fn(values: [string]) -> +charts.CategoryFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setValues(String)","!doc":"Sets the list of values (categories) the user can choose from."}}},"Chart":{"!url":"http://developers.google.com/apps-script/reference/charts/chart","!doc":"Chart A Chart object, which can be embedded into documents, UI elements, or used as a static image. For charts embedded in spreadsheets, see EmbeddedChart.","prototype":{"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/charts/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/charts/#getBlob()","!doc":"Return the data inside this object as a blob."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getId()","!doc":"Returns the id that has been assigned to this object."},"getOptions":{"!type":"fn() -> +charts.ChartOptions","!url":"http://developers.google.com/apps-script/reference/charts/#getOptions()","!doc":"Returns the options for this chart, such as height, colors, axes, etc."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getType()","!doc":"Gets the type of this object."},"setId":{"!type":"fn(id: string) -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#setId(String)","!doc":"Sets the id of this Chart to be used with UiApp."}}},"ChartOptions":{"!url":"http://developers.google.com/apps-script/reference/charts/chart-options","!doc":"ChartOptions Exposes options currently configured for a Chart, such as height, color, etc. Please see the visualization reference documentation for information on what options are available. Specific options for each chart can be found by clicking on the specific chart in the chart gallery. These options are immutable.","prototype":{"get":{"!type":"fn(option: string) -> object","!url":"http://developers.google.com/apps-script/reference/charts/#get(String)","!doc":"Returns a configured option for this chart."}}},"ColumnChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/column-chart-builder","!doc":"ColumnChartBuilder Builder for column charts. For more details, see the Google Charts documentation. This example shows how to create a column chart with data from a data table. function doGet() { var sampleData = Charts.newDataTable() .addColumn(Charts.ColumnType.STRING, \"Year\") .addColumn(Charts.ColumnType.NUMBER, \"Sales\") .addColumn(Charts.ColumnType.NUMBER, \"Expenses\") .addRow([\"2004\", 1000, 400]) .addRow([\"2005\", 1170, 460]) .addRow([\"2006\", 660, 1120]) .addRow([\"2007\", 1030, 540]) .addRow([\"2008\", 800, 600]) .addRow([\"2009\", 943, 678]) .addRow([\"2010\", 1020, 550]) .addRow([\"2011\", 910, 700]) .addRow([\"2012\", 1230, 840]) .build(); var chart = Charts.newColumnChart() .setTitle('Sales vs. Expenses') .setXAxisTitle('Year') .setYAxisTitle('Amount (USD)') .setDimensions(600, 500) .setDataTable(sampleData) .build(); return UiApp.createApplication().add(chart); }","prototype":{"build":{"!type":"fn() -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds the chart."},"reverseCategories":{"!type":"fn() -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setDataSourceUrl":{"!type":"fn(url: string) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataSourceUrl(String)","!doc":"Sets the data source URL that will be used to pull data in from an external source, such as Google Sheets."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the data table which contains the lines for the chart, as well as the X-axis labels."},"setDataViewDefinition":{"!type":"fn(dataViewDefinition: charts.DataViewDefinition) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataViewDefinition(DataViewDefinition)","!doc":"Sets the data view definition to use for the chart."},"setDimensions":{"!type":"fn(width: number, height: number) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDimensions(Integer,Integer)","!doc":"Sets the dimensions for the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setRange":{"!type":"fn(start: number, end: number) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setStacked":{"!type":"fn() -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setStacked()","!doc":"Uses stacked lines, meaning that line and bar values are stacked (accumulated)."},"setTitle":{"!type":"fn(chartTitle: string) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +charts.ColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"Control":{"!url":"http://developers.google.com/apps-script/reference/charts/control","!doc":"Control A user interface control object, that drives the data displayed by a DashboardPanel. A control can be embedded in a UI application. Controls are user interface widgets (category pickers, range sliders, autocompleters, etc.) users interact with in order to drive the data managed by a dashboard and the charts that are part of it. Controls collect user input and use the information to decide which of the data the dashboard is managing should be made available to the charts that are part of it. Given a data table, a control will filter out the data that doesn't comply with the conditions implied by its current state, and will expose the filtered data table as an output. For more details, see the Gviz documentation.","prototype":{"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getId()","!doc":"Returns the id that has been assigned to this object."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getType()","!doc":"Gets the type of this object."},"setId":{"!type":"fn(id: string) -> +charts.Control","!url":"http://developers.google.com/apps-script/reference/charts/#setId(String)","!doc":"Sets the id of this Control to be used with UiApp."}}},"DashboardPanel":{"!url":"http://developers.google.com/apps-script/reference/charts/dashboard-panel","!doc":"DashboardPanel A dashboard is a visual structure that enables the organization and management of multiple charts that share the same underlying data. Controls are user interface widgets (category pickers, range sliders, autocompleters, etc.) users interact with in order to drive the data managed by a dashboard and the charts that are part of it. For example, a string filter control is a simple text input field that lets the user filter data via string matching. Given a column and matching options, the control will filter out the rows that don't match the term that's in the input field. The Gviz API defines a dashboard as a set of charts and controls bound together. The bindings between the different components define the data flow, the state of the controls filters views of the data which propagate in the dashboard and are eventually visualized with charts. For more details, see the Gviz documentation. The dashboard panel has two purposes, one is being a container for the charts and controls objects that compose the dashboard, and the other is holding the data and use as an interface for binding controls to charts. Here's an example of creating a dashboard and showing it in a UI app: function doGet() { // Create a data table with some sample data. var data = Charts.newDataTable() .addColumn(Charts.ColumnType.STRING, \"Name\") .addColumn(Charts.ColumnType.NUMBER, \"Age\") .addRow([\"Michael\", 18]) .addRow([\"Elisa\", 12]) .addRow([\"John\", 20]) .addRow([\"Jessica\", 25]) .addRow([\"Aaron\", 14]) .addRow([\"Margareth\", 19]) .addRow([\"Miranda\", 22]) .addRow([\"May\", 20]) .build(); var chart = Charts.newBarChart() .setTitle(\"Ages\") .build(); var control = Charts.newStringFilter() .setFilterColumnLabel(\"Name\") .build(); // Bind the control to the chart in a dashboard panel. var dashboard = Charts.newDashboardPanel() .setDataTable(data) .bind(control, chart) .build(); var uiApp = UiApp.createApplication().setTitle(\"My Dashboard\"); var panel = uiApp.createHorizontalPanel() .setVerticalAlignment(UiApp.VerticalAlignment.MIDDLE) .setSpacing(50); panel.add(control); panel.add(chart); dashboard.add(panel); uiApp.add(dashboard); return uiApp; }","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +charts.DashboardPanel","!url":"http://developers.google.com/apps-script/reference/charts/#add(Widget)","!doc":"Add a widget to the DashboardPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getId()","!doc":"Returns the id that has been assigned to this object."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getType()","!doc":"Gets the type of this object."},"setId":{"!type":"fn(id: string) -> +charts.DashboardPanel","!url":"http://developers.google.com/apps-script/reference/charts/#setId(String)","!doc":"Sets the id of this DashboardPanel to be used with UiApp."}}},"DashboardPanelBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/dashboard-panel-builder","!doc":"DashboardPanelBuilder A builder for a dashboard panel object. For an example of how to use DashboardPanelBuilder, refer to DashboardPanel. For more details, see the Gviz documentation.","prototype":{"bind":{"!type":"fn(controls: [charts.Control], charts: [charts.Chart]) -> +charts.DashboardPanelBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#bind(Control,Chart)","!doc":"Binds multiple controls to multiple charts, so that the charts are redrawn whenever the controls collect a user interaction that affects the data managed by the dashboard."},"build":{"!type":"fn() -> +charts.DashboardPanel","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds a dashboard."},"setDataTable":{"!type":"fn(source: charts.DataTableSource) -> +charts.DashboardPanelBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the dashboard's data table, which will be the control's underlying data model."}}},"DataTable":{"!url":"http://developers.google.com/apps-script/reference/charts/data-table","!doc":"DataTable A Data Table to be used in charts. A DataTable can come from sources such as Google Sheets or specified data-table URLs, or can be filled in by hand. This class intentionally has no methods: a DataTable can be passed around, but not manipulated directly.","prototype":{}},"DataTableBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/data-table-builder","!doc":"DataTableBuilder Builder of DataTable objects. Building a data table consists of first specifying its columns, and then adding its rows, one at a time. Example: var data = Charts.newDataTable() .addColumn(Charts.ColumnType.STRING, \"Month\") .addColumn(Charts.ColumnType.NUMBER, \"In Store\") .addColumn(Charts.ColumnType.NUMBER, \"Online\") .addRow([\"January\", 10, 1]) .addRow([\"February\", 12, 1]) .addRow([\"March\", 20, 2]) .addRow([\"April\", 25, 3]) .addRow([\"May\", 30, 4]) .build();","prototype":{"addColumn":{"!type":"fn(type: charts.ColumnType, label: string) -> +charts.DataTableBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#addColumn(ColumnType,String)","!doc":"Adds a column to the data table."},"addRow":{"!type":"fn(values: [object]) -> +charts.DataTableBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#addRow(Object)","!doc":"Adds a row to the data table."},"build":{"!type":"fn() -> +charts.DataTable","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds and returns a data table."},"setValue":{"!type":"fn(row: number, column: number, value: object) -> +charts.DataTableBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setValue(Integer,Integer,Object)","!doc":"Sets a specific value in the table."}}},"DataViewDefinition":{"!url":"http://developers.google.com/apps-script/reference/charts/data-view-definition","!doc":"DataViewDefinition A data view definition for visualizing chart data. Data view definition can be set for charts to visualize a view derived from the given data table and not the data table itself. For example if the view definition of a chart states that the view columns are [0, 3], only the first and the third columns of the data table will be taken into consideration when drawing the chart. See DataViewDefinitionBuilder for an example on how to define and use a DataViewDefinition.","prototype":{}},"DataViewDefinitionBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/data-view-definition-builder","!doc":"DataViewDefinitionBuilder Builder for DataViewDefinition objects. Here's an example of using the builder. The data is imported from a Google spreadsheet. function doGet() { // This example creates two table charts side by side. One uses a data view definition to // restrict the number of displayed columns. var app = UiApp.createApplication(); // Get sample data from a spreadsheet. var dataSourceUrl = 'https://docs.google.com/spreadsheet/tq?range=A1%3AF' + '&key=0Aq4s9w_HxMs7dHpfX05JdmVSb1FpT21sbXd4NVE3UEE&gid=4&headers=-1'; // Create a chart to display all of the data. var originalChart = Charts.newTableChart() .setDimensions(600, 500) .setDataSourceUrl(dataSourceUrl) .build(); // Create another chart to display a subset of the data (only columns 1 and 4). var dataViewDefinition = Charts.newDataViewDefinition().setColumns([0, 3]); var limitedChart = Charts.newTableChart() .setDimensions(200, 500) .setDataSourceUrl(dataSourceUrl) .setDataViewDefinition(dataViewDefinition) .build(); var panel = app.createHorizontalPanel().setSpacing(15); panel.add(originalChart).add(limitedChart); return app.add(panel); }","prototype":{"build":{"!type":"fn() -> +charts.DataViewDefinition","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds and returns the data view definition object that was built using this builder."},"setColumns":{"!type":"fn(columns: [number]) -> +charts.DataViewDefinitionBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColumns(Integer)","!doc":"Sets the indexes of the column to include in the data view."}}},"LineChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/line-chart-builder","!doc":"LineChartBuilder Builder for line charts. For more details, see the Google Charts documentation. Here is an example that shows how to build a line chart. The data is imported from a Google spreadsheet. function doGet() { // Get sample data from a spreadsheet. var dataSourceUrl = 'https://docs.google.com/spreadsheet/tq?range=A1%3AG5' + '&key=0Aq4s9w_HxMs7dHpfX05JdmVSb1FpT21sbXd4NVE3UEE&gid=2&headers=-1'; var chartBuilder = Charts.newLineChart() .setTitle('Yearly Rainfall') .setXAxisTitle('Month') .setYAxisTitle('Rainfall (in)') .setDimensions(600, 500) .setCurveStyle(Charts.CurveStyle.SMOOTH) .setPointStyle(Charts.PointStyle.MEDIUM) .setDataSourceUrl(dataSourceUrl); var chart = chartBuilder.build(); return UiApp.createApplication().add(chart); }","prototype":{"build":{"!type":"fn() -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds the chart."},"reverseCategories":{"!type":"fn() -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setCurveStyle":{"!type":"fn(style: charts.CurveStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setCurveStyle(CurveStyle)","!doc":"Sets the style to use for curves in the chart."},"setDataSourceUrl":{"!type":"fn(url: string) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataSourceUrl(String)","!doc":"Sets the data source URL that will be used to pull data in from an external source, such as Google Sheets."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the data table which contains the lines for the chart, as well as the X-axis labels."},"setDataViewDefinition":{"!type":"fn(dataViewDefinition: charts.DataViewDefinition) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataViewDefinition(DataViewDefinition)","!doc":"Sets the data view definition to use for the chart."},"setDimensions":{"!type":"fn(width: number, height: number) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDimensions(Integer,Integer)","!doc":"Sets the dimensions for the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPointStyle":{"!type":"fn(style: charts.PointStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setPointStyle(PointStyle)","!doc":"Sets the style for points in the line."},"setRange":{"!type":"fn(start: number, end: number) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setTitle":{"!type":"fn(chartTitle: string) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +charts.LineChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"NumberRangeFilterBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/number-range-filter-builder","!doc":"NumberRangeFilterBuilder A builder for number range filter controls. A number range filter is a slider with two thumbs that lets the user select ranges of numeric values. Given a column of type number and matching options, this control will filter out the rows that don't match the range that was selected. This example creates a table chart bound to a number range filter: function doGet() { var app = UiApp.createApplication(); // Get sample data from a spreadsheet. var dataSourceUrl = 'https://docs.google.com/spreadsheet/tq?range=A1%3AF' + '&key=0Aq4s9w_HxMs7dHpfX05JdmVSb1FpT21sbXd4NVE3UEE&gid=4&headers=-1'; var data = SpreadsheetApp.openByUrl(dataSourceUrl).getSheetByName('US_GDP').getRange(\"A1:F\"); var chart = Charts.newTableChart() .setDimensions(600, 500) .build(); var numberRangeFilter = Charts.newNumberRangeFilter() .setFilterColumnLabel(\"Year\") .setShowRangeValues(true) .setLabel(\"Restrict year range\") .build(); var panel = app.createVerticalPanel().setSpacing(10); panel.add(numberRangeFilter).add(chart); // Create a new dashboard panel to bind the filter and chart together. var dashboard = Charts.newDashboardPanel() .setDataTable(data) .bind(numberRangeFilter, chart) .build(); dashboard.add(panel); app.add(dashboard); return app; } For more details, see the Gviz documentation","prototype":{"build":{"!type":"fn() -> +charts.Control","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds a control."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the control data table, which will be the control's underlying data model."},"setFilterColumnIndex":{"!type":"fn(columnIndex: number) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFilterColumnIndex(Integer)","!doc":"Sets the index of the data table column to filter on."},"setFilterColumnLabel":{"!type":"fn(columnLabel: string) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFilterColumnLabel(String)","!doc":"Sets the label of the data table column to filter on."},"setLabel":{"!type":"fn(label: string) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabel(String)","!doc":"Sets the label to display next to the slider."},"setLabelSeparator":{"!type":"fn(labelSeparator: string) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabelSeparator(String)","!doc":"Sets a separator string appended to the label, to visually separate the label from the category picker."},"setLabelStacking":{"!type":"fn(orientation: charts.Orientation) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabelStacking(Orientation)","!doc":"Sets whether the label should display above (vertical stacking) or beside (horizontal stacking) the input field."},"setMaxValue":{"!type":"fn(maxValue: number) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setMaxValue(Integer)","!doc":"Sets the maximum allowed value for the range lower extent."},"setMinValue":{"!type":"fn(minValue: number) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setMinValue(Integer)","!doc":"Sets the minimum allowed value for the range lower extent."},"setOrientation":{"!type":"fn(orientation: charts.Orientation) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOrientation(Orientation)","!doc":"Sets the slider orientation."},"setShowRangeValues":{"!type":"fn(showRangeValues: bool) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setShowRangeValues(Boolean)","!doc":"Sets whether to have labels next to the slider displaying extents of the selected range."},"setTicks":{"!type":"fn(ticks: number) -> +charts.NumberRangeFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTicks(Integer)","!doc":"Sets the number of ticks (fixed positions in a range bar) a number range filter slider thumbs can fall in."}}},"PieChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/pie-chart-builder","!doc":"PieChartBuilder A builder for pie charts. For more details, see the Google Charts documentation. Here is an example that shows how to build a pie chart. The data is imported from a Google spreadsheet. function doGet() { // Get sample data from a spreadsheet. var dataSourceUrl = 'https://docs.google.com/spreadsheet/tq?range=A1%3AB8' + '&key=0Aq4s9w_HxMs7dHpfX05JdmVSb1FpT21sbXd4NVE3UEE&gid=3&headers=-1'; var chartBuilder = Charts.newPieChart() .setTitle('World Population by Continent') .setDimensions(600, 500) .set3D() .setDataSourceUrl(dataSourceUrl); var chart = chartBuilder.build(); return UiApp.createApplication().add(chart); }","prototype":{"build":{"!type":"fn() -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds the chart."},"reverseCategories":{"!type":"fn() -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"set3D":{"!type":"fn() -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#set3D()","!doc":"Sets the chart to be three-dimensional."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setDataSourceUrl":{"!type":"fn(url: string) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataSourceUrl(String)","!doc":"Sets the data source URL that will be used to pull data in from an external source, such as Google Sheets."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the data table which contains the lines for the chart, as well as the X-axis labels."},"setDataViewDefinition":{"!type":"fn(dataViewDefinition: charts.DataViewDefinition) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataViewDefinition(DataViewDefinition)","!doc":"Sets the data view definition to use for the chart."},"setDimensions":{"!type":"fn(width: number, height: number) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDimensions(Integer,Integer)","!doc":"Sets the dimensions for the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setTitle":{"!type":"fn(chartTitle: string) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.PieChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."}}},"ScatterChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/scatter-chart-builder","!doc":"ScatterChartBuilder Builder for scatter charts. For more details, see the Google Charts documentation. Here is an example that shows how to build a scatter chart. The data is imported from a Google spreadsheet. function doGet() { // Get sample data from a spreadsheet. var dataSourceUrl = 'https://docs.google.com/spreadsheet/tq?range=C1%3AD' + '&key=0Aq4s9w_HxMs7dHpfX05JdmVSb1FpT21sbXd4NVE3UEE&gid=4&headers=-1'; var chartBuilder = Charts.newScatterChart() .setTitle('Adjusted GDP vs. U.S. Population') .setXAxisTitle('U.S. Population (millions)') .setYAxisTitle('Adjusted GDP ($ billions)') .setDimensions(600, 500) .setLegendPosition(Charts.Position.NONE) .setDataSourceUrl(dataSourceUrl); var chart = chartBuilder.build(); return UiApp.createApplication().add(chart); }","prototype":{"build":{"!type":"fn() -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds the chart."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setDataSourceUrl":{"!type":"fn(url: string) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataSourceUrl(String)","!doc":"Sets the data source URL that will be used to pull data in from an external source, such as Google Sheets."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the data table which contains the lines for the chart, as well as the X-axis labels."},"setDataViewDefinition":{"!type":"fn(dataViewDefinition: charts.DataViewDefinition) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataViewDefinition(DataViewDefinition)","!doc":"Sets the data view definition to use for the chart."},"setDimensions":{"!type":"fn(width: number, height: number) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDimensions(Integer,Integer)","!doc":"Sets the dimensions for the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPointStyle":{"!type":"fn(style: charts.PointStyle) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setPointStyle(PointStyle)","!doc":"Sets the style for points in the line."},"setTitle":{"!type":"fn(chartTitle: string) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisLogScale":{"!type":"fn() -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisLogScale()","!doc":"Makes the horizontal axis into a logarithmic scale (requires all values to be positive)."},"setXAxisRange":{"!type":"fn(start: number, end: number) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisRange(Number,Number)","!doc":"Sets the range for the horizontal axis of the chart."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisLogScale":{"!type":"fn() -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisLogScale()","!doc":"Makes the vertical axis into a logarithmic scale (requires all values to be positive)."},"setYAxisRange":{"!type":"fn(start: number, end: number) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisRange(Number,Number)","!doc":"Sets the range for the vertical axis of the chart."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +charts.ScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."}}},"StringFilterBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/string-filter-builder","!doc":"StringFilterBuilder A builder for string filter controls. A string filter is a simple text input field that lets the user filter data via string matching. Given a column of type string and matching options, this control will filter out the rows that don't match the term that's in the input field. This example creates a table chart and binds it to a string filter. Using the filter, it is possible to change the table chart to display a subset of its data. function doGet() { var app = UiApp.createApplication(); var sampleData = Charts.newDataTable() .addColumn(Charts.ColumnType.STRING, \"Month\") .addColumn(Charts.ColumnType.NUMBER, \"Dining\") .addColumn(Charts.ColumnType.NUMBER, \"Total\") .addRow([\"Jan\", 60, 520]) .addRow([\"Feb\", 50, 430]) .addRow([\"Mar\", 53, 440]) .addRow([\"Apr\", 70, 410]) .addRow([\"May\", 80, 390]) .addRow([\"Jun\", 60, 500]) .addRow([\"Jul\", 100, 450]) .addRow([\"Aug\", 140, 431]) .addRow([\"Sep\", 75, 488]) .addRow([\"Oct\", 70, 521]) .addRow([\"Nov\", 58, 388]) .addRow([\"Dec\", 63, 400]) .build(); var chart = Charts.newTableChart() .setDimensions(600, 500) .build(); var stringFilter = Charts.newStringFilter() .setFilterColumnLabel(\"Month\") .setRealtimeTrigger(true) .setCaseSensitive(true) .setLabel(\"Filter months shown\") .build(); var panel = app.createVerticalPanel().setSpacing(10); panel.add(stringFilter).add(chart); // Create a dashboard panel to bind the filter and the chart together. var dashboard = Charts.newDashboardPanel() .setDataTable(sampleData) .bind(stringFilter, chart) .build(); dashboard.add(panel); app.add(dashboard); return app; } For more details, see the Gviz documentation.","prototype":{"build":{"!type":"fn() -> +charts.Control","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds a control."},"setCaseSensitive":{"!type":"fn(caseSensitive: bool) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setCaseSensitive(Boolean)","!doc":"Sets whether matching should be case sensitive or not."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the control data table, which will be the control's underlying data model."},"setFilterColumnIndex":{"!type":"fn(columnIndex: number) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFilterColumnIndex(Integer)","!doc":"Sets the index of the data table column to filter on."},"setFilterColumnLabel":{"!type":"fn(columnLabel: string) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFilterColumnLabel(String)","!doc":"Sets the label of the data table column to filter on."},"setLabel":{"!type":"fn(label: string) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabel(String)","!doc":"Sets the label to display next to the slider."},"setLabelSeparator":{"!type":"fn(labelSeparator: string) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabelSeparator(String)","!doc":"Sets a separator string appended to the label, to visually separate the label from the category picker."},"setLabelStacking":{"!type":"fn(orientation: charts.Orientation) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setLabelStacking(Orientation)","!doc":"Sets whether the label should display above (vertical stacking) or beside (horizontal stacking) the input field."},"setMatchType":{"!type":"fn(matchType: charts.MatchType) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setMatchType(MatchType)","!doc":"Sets whether the control should match exact values only (MatchType.EXACT), prefixes starting from the beginning of the value (MatchType.PREFIX), or any substring (MatchType.ANY)."},"setRealtimeTrigger":{"!type":"fn(realtimeTrigger: bool) -> +charts.StringFilterBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setRealtimeTrigger(Boolean)","!doc":"Sets whether the control should match any time a key is pressed or only when the input field 'changes' (loss of focus or pressing the Enter key)."}}},"TableChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/table-chart-builder","!doc":"TableChartBuilder A builder for table charts. For more details, see the Google Charts documentation. Here is an example that shows how to build a table chart. The data is imported from a Google spreadsheet. function doGet() { // Get sample data from a spreadsheet. var dataSourceUrl = 'https://docs.google.com/spreadsheet/tq?range=A1%3AF' + '&key=0Aq4s9w_HxMs7dHpfX05JdmVSb1FpT21sbXd4NVE3UEE&gid=4&headers=-1'; var chartBuilder = Charts.newTableChart() .setDimensions(600, 500) .enablePaging(20) .setDataSourceUrl(dataSourceUrl); var chart = chartBuilder.build(); return UiApp.createApplication().add(chart); }","prototype":{"build":{"!type":"fn() -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds the chart."},"enablePaging":{"!type":"fn(pageSize: number, startPage: number) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#enablePaging(Integer,Integer)","!doc":"Enables paging, sets the number of rows in each page and the first table page to display (page numbers are zero based)."},"enableRtlTable":{"!type":"fn(rtlEnabled: bool) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#enableRtlTable(Boolean)","!doc":"Adds basic support for right-to-left languages (such as Arabic or Hebrew) by reversing the column order of the table, so that column zero is the right-most column, and the last column is the left-most column."},"enableSorting":{"!type":"fn(enableSorting: bool) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#enableSorting(Boolean)","!doc":"Sets whether to sort columns when the user clicks a column heading."},"setDataSourceUrl":{"!type":"fn(url: string) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataSourceUrl(String)","!doc":"Sets the data source URL that will be used to pull data in from an external source, such as Google Sheets."},"setDataTable":{"!type":"fn(table: charts.DataTableSource) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataTable(DataTableSource)","!doc":"Sets the data table which contains the lines for the chart, as well as the X-axis labels."},"setDataViewDefinition":{"!type":"fn(dataViewDefinition: charts.DataViewDefinition) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDataViewDefinition(DataViewDefinition)","!doc":"Sets the data view definition to use for the chart."},"setDimensions":{"!type":"fn(width: number, height: number) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setDimensions(Integer,Integer)","!doc":"Sets the dimensions for the chart."},"setFirstRowNumber":{"!type":"fn(number: number) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFirstRowNumber(Integer)","!doc":"Sets the row number for the first row in the data table."},"setInitialSortingAscending":{"!type":"fn(column: number) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setInitialSortingAscending(Integer)","!doc":"Sets the index of the column according to which the table should be initially sorted (ascending)."},"setInitialSortingDescending":{"!type":"fn(column: number) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setInitialSortingDescending(Integer)","!doc":"Sets the index of the column according to which the table should be initially sorted (descending)."},"setOption":{"!type":"fn(option: string, value: object) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"showRowNumberColumn":{"!type":"fn(showRowNumber: bool) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#showRowNumberColumn(Boolean)","!doc":"Sets whether to show the row number as the first column of the table."},"useAlternatingRowStyle":{"!type":"fn(alternate: bool) -> +charts.TableChartBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#useAlternatingRowStyle(Boolean)","!doc":"Sets whether alternating color style will be assigned to odd and even rows of a table chart."}}},"TextStyle":{"!url":"http://developers.google.com/apps-script/reference/charts/text-style","!doc":"TextStyle A text style configuration object. Used in charts options to configure text style for elements that accepts it, such as title, horizontal axis, vertical axis, legend and tooltip. // This example creates a chart specifying different text styles for the title and axes. function doGet() { var sampleData = Charts.newDataTable() .addColumn(Charts.ColumnType.STRING, \"Seasons\") .addColumn(Charts.ColumnType.NUMBER, \"Rainy Days\") .addRow([\"Winter\", 5]) .addRow([\"Spring\", 12]) .addRow([\"Summer\", 8]) .addRow([\"Fall\", 8]) .build(); var titleTextStyleBuilder = Charts.newTextStyle() .setColor('#0000FF').setFontSize(26).setFontName('Ariel'); var axisTextStyleBuilder = Charts.newTextStyle() .setColor('#3A3A3A').setFontSize(20).setFontName('Ariel'); var titleTextStyle = titleTextStyleBuilder.build(); var axisTextStyle = axisTextStyleBuilder.build(); var chart = Charts.newLineChart() .setTitleTextStyle(titleTextStyle) .setXAxisTitleTextStyle(axisTextStyle) .setYAxisTitleTextStyle(axisTextStyle) .setTitle('Rainy Days Per Season') .setXAxisTitle('Season') .setYAxisTitle('Number of Rainy Days') .setDataTable(sampleData) .build(); return UiApp.createApplication().add(chart); }","prototype":{"getColor":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getColor()","!doc":"Gets the color of the text style."},"getFontName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getFontName()","!doc":"Gets the font name of the text style."},"getFontSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/charts/#getFontSize()","!doc":"Gets the font size of the text style."}}},"TextStyleBuilder":{"!url":"http://developers.google.com/apps-script/reference/charts/text-style-builder","!doc":"TextStyleBuilder A builder used to create TextStyle objects. It allows configuration of the text's properties such as name, color, and size. The following example shows how to create a text style using the builder. For a more complete example, refer to the documentation for TextStyle. // Creates a new text style that uses 26-point, blue, Ariel font. var textStyleBuilder = Charts.newTextStyle() .setColor('#0000FF').setFontName('Ariel').setFontSize(26); var style = textStyleBuilder.build();","prototype":{"build":{"!type":"fn() -> +charts.TextStyle","!url":"http://developers.google.com/apps-script/reference/charts/#build()","!doc":"Builds and returns a text style configuration object that was built using this builder."},"setColor":{"!type":"fn(cssValue: string) -> +charts.TextStyleBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setColor(String)","!doc":"Sets the color of the text style."},"setFontName":{"!type":"fn(fontName: string) -> +charts.TextStyleBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFontName(String)","!doc":"Sets the font name of the text style"},"setFontSize":{"!type":"fn(fontSize: number) -> +charts.TextStyleBuilder","!url":"http://developers.google.com/apps-script/reference/charts/#setFontSize(Number)","!doc":"Sets the font size of the text style."}}},"DataTableSource":{"!url":"http://developers.google.com/apps-script/reference/charts/data-table-source","!doc":"DataTableSource Interface for objects that can represent their data as a DataTable. Implementing classes NameBrief description DataTableA Data Table to be used in charts. RangeAccess and modify spreadsheet ranges.","prototype":{"getDataTable":{"!type":"fn() -> +charts.DataTable","!url":"http://developers.google.com/apps-script/reference/charts/#getDataTable()","!doc":"Return the data inside this object as a DataTable."}}},"ChartType":{"!url":"http://developers.google.com/apps-script/reference/charts/chart-type","!doc":"ChartType Chart types supported by the Charts service.","prototype":{"AREA":{"!type":"string","!doc":"Area chart"},"BAR":{"!type":"string","!doc":"Bar chart"},"COLUMN":{"!type":"string","!doc":"Column chart"},"LINE":{"!type":"string","!doc":"Line chart"},"PIE":{"!type":"string","!doc":"Pie chart"},"SCATTER":{"!type":"string","!doc":"Scatter chart"},"TABLE":{"!type":"string","!doc":"Table chart"}}},"ColumnType":{"!url":"http://developers.google.com/apps-script/reference/charts/column-type","!doc":"ColumnType An enumeration of the valid data types for columns in a DataTable.","prototype":{"DATE":{"!type":"string","!doc":"Corresponds to date values."},"NUMBER":{"!type":"string","!doc":"Corresponds to number values."},"STRING":{"!type":"string","!doc":"Corresponds to string values."}}},"CurveStyle":{"!url":"http://developers.google.com/apps-script/reference/charts/curve-style","!doc":"CurveStyle An enumeration of the styles for curves in a chart.","prototype":{"NORMAL":{"!type":"string","!doc":"Straight lines without curve"},"SMOOTH":{"!type":"string","!doc":"The angles of the line will be smoothed"}}},"MatchType":{"!url":"http://developers.google.com/apps-script/reference/charts/match-type","!doc":"MatchType An enumeration of how a string value should be matched. Matching a string is a boolean operation. Given a string, a match term (string), and a match type, the operation will output true in the following cases: If the match type equals EXACT and the match term equals the string. If the match type equals PREFIX and the match term is a prefix of the string. If the match type equals ANY and the match term is a substring of the string. This enumeration can be used in by a string filter control to decide which rows to filter out of the data table. Given a column to filter on, leave only the rows that match the value entered in the filter input box, using one of the above matching types.","prototype":{"EXACT":{"!type":"string","!doc":"Match exact values only"},"PREFIX":{"!type":"string","!doc":"Match prefixes starting from the beginning of the value"},"ANY":{"!type":"string","!doc":"Match any substring"},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/charts/#getName()","!doc":"Returns the name of the MatchType to be used in the options JSON."}}},"Orientation":{"!url":"http://developers.google.com/apps-script/reference/charts/orientation","!doc":"Orientation An enumeration of the orientation of an object.","prototype":{"HORIZONTAL":{"!type":"string","!doc":"Horizontal orientation"},"VERTICAL":{"!type":"string","!doc":"Vertical orientation"}}},"PickerValuesLayout":{"!url":"http://developers.google.com/apps-script/reference/charts/picker-values-layout","!doc":"PickerValuesLayout An enumeration of how to display selected values in picker widget.","prototype":{"ASIDE":{"!type":"string","!doc":"Selected values will display in a single text line next to the value picker widget"},"BELOW":{"!type":"string","!doc":"Selected values will display in a single text line below the widget"},"BELOW_WRAPPING":{"!type":"string","!doc":"Similar to below, but entries that cannot fit in the picker will wrap to a new line"},"BELOW_STACKED":{"!type":"string","!doc":"Selected values will be displayed in a column below the widget"}}},"PointStyle":{"!url":"http://developers.google.com/apps-script/reference/charts/point-style","!doc":"PointStyle An enumeration of the styles of points in a line.","prototype":{"NONE":{"!type":"string","!doc":"Do not display line points"},"TINY":{"!type":"string","!doc":"Use tiny line points"},"MEDIUM":{"!type":"string","!doc":"Use medium sized line points"},"LARGE":{"!type":"string","!doc":"Use large sized line points"},"HUGE":{"!type":"string","!doc":"Use largest sized line points"}}},"Position":{"!url":"http://developers.google.com/apps-script/reference/charts/position","!doc":"Position An enumeration of legend positions within a chart.","prototype":{"TOP":{"!type":"string","!doc":"Above the chart."},"RIGHT":{"!type":"string","!doc":"To the right of the chart."},"BOTTOM":{"!type":"string","!doc":"Below the chart."},"NONE":{"!type":"string","!doc":"No legend is displayed."}}}},"contacts":{"AddressField":{"!url":"http://developers.google.com/apps-script/reference/contacts/address-field","!doc":"AddressField Address field in a contact.","prototype":{"deleteAddressField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteAddressField()","!doc":"Deletes this address field."},"getAddress":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getAddress()","!doc":"Get the address for this field."},"getLabel":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getLabel()","!doc":"Gets the label for this field."},"isPrimary":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/contacts/#isPrimary()","!doc":"Gets whether this is the primary field value."},"setAddress":{"!type":"fn(address: string) -> +contacts.AddressField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAddress(String)","!doc":"Sets the address of this field."},"setAsPrimary":{"!type":"fn() -> +contacts.AddressField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAsPrimary()","!doc":"Sets this field to primary."},"setLabel":{"!type":"fn(label: string) -> +contacts.AddressField","!url":"http://developers.google.com/apps-script/reference/contacts/#setLabel(String)","!doc":"Sets the label of this field."}}},"CompanyField":{"!url":"http://developers.google.com/apps-script/reference/contacts/company-field","!doc":"CompanyField Company field in a Contact.","prototype":{"deleteCompanyField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteCompanyField()","!doc":"Deletes this company field."},"getCompanyName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getCompanyName()","!doc":"Gets the company name."},"getJobTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getJobTitle()","!doc":"Gets the job title."},"isPrimary":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/contacts/#isPrimary()","!doc":"Gets whether this is the primary company."},"setAsPrimary":{"!type":"fn() -> +contacts.CompanyField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAsPrimary()","!doc":"Sets this company as the primary company, and unsets whatever company was previously primary."},"setCompanyName":{"!type":"fn(company: string) -> +contacts.CompanyField","!url":"http://developers.google.com/apps-script/reference/contacts/#setCompanyName(String)","!doc":"Sets the company name."},"setJobTitle":{"!type":"fn(title: string) -> +contacts.CompanyField","!url":"http://developers.google.com/apps-script/reference/contacts/#setJobTitle(String)","!doc":"Sets the job title."}}},"Contact":{"!url":"http://developers.google.com/apps-script/reference/contacts/contact","!doc":"Contact A Contact contains the name, address, and various contact details of a contact.","prototype":{"addAddress":{"!type":"fn(label: object, address: string) -> +contacts.AddressField","!url":"http://developers.google.com/apps-script/reference/contacts/#addAddress(Object,String)","!doc":"Adds an address to the contact with either a standard or custom label."},"addCompany":{"!type":"fn(company: string, title: string) -> +contacts.CompanyField","!url":"http://developers.google.com/apps-script/reference/contacts/#addCompany(String,String)","!doc":"Adds a company to the contact."},"addCustomField":{"!type":"fn(label: object, content: object) -> +contacts.CustomField","!url":"http://developers.google.com/apps-script/reference/contacts/#addCustomField(Object,Object)","!doc":"Adds a custom field to the contact with either an extended or custom label."},"addDate":{"!type":"fn(label: object, month: base.Month, day: number, year: number) -> +contacts.DateField","!url":"http://developers.google.com/apps-script/reference/contacts/#addDate(Object,Month,Integer,Integer)","!doc":"Adds a date to the contact with either an standard or custom label."},"addEmail":{"!type":"fn(label: object, address: string) -> +contacts.EmailField","!url":"http://developers.google.com/apps-script/reference/contacts/#addEmail(Object,String)","!doc":"Add an email address with a standard label (home, work, etc.) or a custom label"},"addIM":{"!type":"fn(label: object, address: string) -> +contacts.IMField","!url":"http://developers.google.com/apps-script/reference/contacts/#addIM(Object,String)","!doc":"Adds an IM address to the contact with either a standard or custom label."},"addPhone":{"!type":"fn(label: object, number: string) -> +contacts.PhoneField","!url":"http://developers.google.com/apps-script/reference/contacts/#addPhone(Object,String)","!doc":"Adds a phone number to the contact with either a standard or custom label."},"addToGroup":{"!type":"fn(group: contacts.ContactGroup) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#addToGroup(ContactGroup)","!doc":"Adds this contact to the given contact group."},"addUrl":{"!type":"fn(label: object, url: string) -> +contacts.UrlField","!url":"http://developers.google.com/apps-script/reference/contacts/#addUrl(Object,String)","!doc":"Adds a URL to the contact with either a standard or custom label."},"deleteContact":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteContact()","!doc":"Deletes this contact."},"getAddresses":{"!type":"fn(label: object) -> [+contacts.AddressField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getAddresses(Object)","!doc":"Gets all the addresses for this contact matching a particular field."},"getCompanies":{"!type":"fn() -> [+contacts.CompanyField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getCompanies()","!doc":"Gets all the companies for this contact."},"getContactGroups":{"!type":"fn() -> [+contacts.ContactGroup]","!url":"http://developers.google.com/apps-script/reference/contacts/#getContactGroups()","!doc":"Gets all the contact groups that contain this contact."},"getCustomFields":{"!type":"fn(label: object) -> [+contacts.CustomField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getCustomFields(Object)","!doc":"Gets all the custom fields for this contact matching a particular field."},"getDates":{"!type":"fn(label: object) -> [+contacts.DateField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getDates(Object)","!doc":"Gets all the dates for this contact matching a particular field."},"getEmails":{"!type":"fn(label: object) -> [+contacts.EmailField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getEmails(Object)","!doc":"Gets the email addresses for this contact matching a particular field."},"getFamilyName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getFamilyName()","!doc":"Gets the family name (last name) of the contact as a string."},"getFullName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getFullName()","!doc":"Gets the full name (given name and last name) of the contact as a string."},"getGivenName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getGivenName()","!doc":"Gets the given name (first name) of the contact as a string."},"getIMs":{"!type":"fn(label: object) -> [+contacts.IMField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getIMs(Object)","!doc":"Gets all the IM addresses for this contact matching a particular field."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getId()","!doc":"Returns the unique id of this contact."},"getInitials":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getInitials()","!doc":"Gets the contact's initials."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/contacts/#getLastUpdated()","!doc":"Gets the date this contact was last updated."},"getMaidenName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getMaidenName()","!doc":"Gets the maiden name of the contact as a string."},"getMiddleName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getMiddleName()","!doc":"Gets the middle name of the contact as a string."},"getNickname":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getNickname()","!doc":"Gets the nickname of the contact as a string."},"getNotes":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getNotes()","!doc":"Gets the notes associated with this contact, or an empty string if there are no notes."},"getPhones":{"!type":"fn(label: object) -> [+contacts.PhoneField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getPhones(Object)","!doc":"Gets all the phone numbers for this contact matching a particular field."},"getPrefix":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getPrefix()","!doc":"Gets the prefix to the contact's name."},"getPrimaryEmail":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getPrimaryEmail()","!doc":"Gets the primary email address of the contact as a string."},"getShortName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getShortName()","!doc":"Gets the short name of the contact as a string."},"getSuffix":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getSuffix()","!doc":"Gets the suffix to the contact's name."},"getUrls":{"!type":"fn(label: object) -> [+contacts.UrlField]","!url":"http://developers.google.com/apps-script/reference/contacts/#getUrls(Object)","!doc":"Gets all the URLs for this contact matching a particular field."},"removeFromGroup":{"!type":"fn(group: contacts.ContactGroup) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#removeFromGroup(ContactGroup)","!doc":"Removes this contact from the given contact group."},"setFamilyName":{"!type":"fn(familyName: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setFamilyName(String)","!doc":"Sets the family name (last name) of the contact."},"setFullName":{"!type":"fn(fullName: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setFullName(String)","!doc":"Sets the full name (given name and last name) of the contact."},"setGivenName":{"!type":"fn(givenName: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setGivenName(String)","!doc":"Sets the given name (first name) of the contact."},"setInitials":{"!type":"fn(initials: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setInitials(String)","!doc":"Sets the contact's initials."},"setMaidenName":{"!type":"fn(maidenName: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setMaidenName(String)","!doc":"Sets the maiden name of the contact."},"setMiddleName":{"!type":"fn(middleName: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setMiddleName(String)","!doc":"Sets the middle name of the contact."},"setNickname":{"!type":"fn(nickname: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setNickname(String)","!doc":"Sets the nickname of the contact."},"setNotes":{"!type":"fn(notes: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setNotes(String)","!doc":"Sets the notes associated with this contact."},"setPrefix":{"!type":"fn(prefix: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setPrefix(String)","!doc":"Sets the prefix to the contact's name."},"setShortName":{"!type":"fn(shortName: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setShortName(String)","!doc":"Sets the short name of the contact."},"setSuffix":{"!type":"fn(suffix: string) -> +contacts.Contact","!url":"http://developers.google.com/apps-script/reference/contacts/#setSuffix(String)","!doc":"Sets the suffix to the contact's name."}}},"ContactGroup":{"!url":"http://developers.google.com/apps-script/reference/contacts/contact-group","!doc":"ContactGroup A ContactGroup is is a group of contacts.","prototype":{"addContact":{"!type":"fn(contact: contacts.Contact) -> +contacts.ContactGroup","!url":"http://developers.google.com/apps-script/reference/contacts/#addContact(Contact)","!doc":"Adds the given contact to this group"},"deleteGroup":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteGroup()","!doc":"Deletes this contact group."},"getContacts":{"!type":"fn() -> [+contacts.Contact]","!url":"http://developers.google.com/apps-script/reference/contacts/#getContacts()","!doc":"Gets all the contacts in this contact group."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getId()","!doc":"Gets the id of this contact group."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getName()","!doc":"Gets the name of this contact group."},"isSystemGroup":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/contacts/#isSystemGroup()","!doc":"Gets a boolean value to determine whether this contact group is a system group (undeletable) or not."},"removeContact":{"!type":"fn(contact: contacts.Contact) -> +contacts.ContactGroup","!url":"http://developers.google.com/apps-script/reference/contacts/#removeContact(Contact)","!doc":"Removes the given contact from this group"},"setName":{"!type":"fn(name: string) -> +contacts.ContactGroup","!url":"http://developers.google.com/apps-script/reference/contacts/#setName(String)","!doc":"Sets the name of this contact group."}}},"CustomField":{"!url":"http://developers.google.com/apps-script/reference/contacts/custom-field","!doc":"CustomField A custom field in a Contact.","prototype":{"deleteCustomField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteCustomField()","!doc":"Deletes this field."},"getLabel":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getLabel()","!doc":"Gets the label for this field."},"getValue":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getValue()","!doc":"Gets the value of the field."},"setLabel":{"!type":"fn(label: string) -> +contacts.CustomField","!url":"http://developers.google.com/apps-script/reference/contacts/#setLabel(String)","!doc":"Sets the label of this field."},"setValue":{"!type":"fn(value: object) -> +contacts.CustomField","!url":"http://developers.google.com/apps-script/reference/contacts/#setValue(Object)","!doc":"Sets the value of this field."}}},"DateField":{"!url":"http://developers.google.com/apps-script/reference/contacts/date-field","!doc":"DateField A date field in a Contact.","prototype":{"deleteDateField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteDateField()","!doc":"Deletes this date."},"getDay":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/contacts/#getDay()","!doc":"Gets the day of the month for this date."},"getLabel":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getLabel()","!doc":"Gets the label for this field."},"getMonth":{"!type":"fn() -> +base.Month","!url":"http://developers.google.com/apps-script/reference/contacts/#getMonth()","!doc":"Gets the month for this date."},"getYear":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/contacts/#getYear()","!doc":"Gets the year for this date."},"setDate":{"!type":"fn(month: base.Month, day: number, year: number) -> +contacts.DateField","!url":"http://developers.google.com/apps-script/reference/contacts/#setDate(Month,Integer,Integer)","!doc":"Sets the date to this day."},"setLabel":{"!type":"fn(label: string) -> +contacts.DateField","!url":"http://developers.google.com/apps-script/reference/contacts/#setLabel(String)","!doc":"Sets the label of this field."}}},"EmailField":{"!url":"http://developers.google.com/apps-script/reference/contacts/email-field","!doc":"EmailField An email field in a Contact.","prototype":{"deleteEmailField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteEmailField()","!doc":"Deletes this email address from the Contact."},"getAddress":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getAddress()","!doc":"Get the address for this field."},"getDisplayName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getDisplayName()","!doc":"Returns the display name for this email address."},"getLabel":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getLabel()","!doc":"Gets the label for this field."},"isPrimary":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/contacts/#isPrimary()","!doc":"Gets whether this is the primary field value."},"setAddress":{"!type":"fn(address: string) -> +contacts.EmailField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAddress(String)","!doc":"Sets the address of this field."},"setAsPrimary":{"!type":"fn() -> +contacts.EmailField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAsPrimary()","!doc":"Sets this field to primary."},"setDisplayName":{"!type":"fn(name: string) -> +contacts.EmailField","!url":"http://developers.google.com/apps-script/reference/contacts/#setDisplayName(String)","!doc":"Sets the display name for this email address."},"setLabel":{"!type":"fn(label: string) -> +contacts.EmailField","!url":"http://developers.google.com/apps-script/reference/contacts/#setLabel(String)","!doc":"Sets the label of this field."}}},"IMField":{"!url":"http://developers.google.com/apps-script/reference/contacts/im-field","!doc":"IMField An instant messaging field in a Contact.","prototype":{"deleteIMField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteIMField()","!doc":"Deletes this instant messaging field."},"getAddress":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getAddress()","!doc":"Get the address for this field."},"getLabel":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getLabel()","!doc":"Gets the label for this field."},"isPrimary":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/contacts/#isPrimary()","!doc":"Gets whether this is the primary field value."},"setAddress":{"!type":"fn(address: string) -> +contacts.IMField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAddress(String)","!doc":"Sets the address of this field."},"setAsPrimary":{"!type":"fn() -> +contacts.IMField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAsPrimary()","!doc":"Sets this field to primary."},"setLabel":{"!type":"fn(label: string) -> +contacts.IMField","!url":"http://developers.google.com/apps-script/reference/contacts/#setLabel(String)","!doc":"Sets the label of this field."}}},"PhoneField":{"!url":"http://developers.google.com/apps-script/reference/contacts/phone-field","!doc":"PhoneField A phone number field in a Contact.","prototype":{"deletePhoneField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deletePhoneField()","!doc":"Deletes this phone number field."},"getLabel":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getLabel()","!doc":"Gets the label for this field."},"getPhoneNumber":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getPhoneNumber()","!doc":"Get the phone number for this field."},"isPrimary":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/contacts/#isPrimary()","!doc":"Gets whether this is the primary field value."},"setAsPrimary":{"!type":"fn() -> +contacts.PhoneField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAsPrimary()","!doc":"Sets this field to primary."},"setLabel":{"!type":"fn(label: string) -> +contacts.PhoneField","!url":"http://developers.google.com/apps-script/reference/contacts/#setLabel(String)","!doc":"Sets the label of this field."},"setPhoneNumber":{"!type":"fn(number: string) -> +contacts.PhoneField","!url":"http://developers.google.com/apps-script/reference/contacts/#setPhoneNumber(String)","!doc":"Sets the phone number for this field."}}},"UrlField":{"!url":"http://developers.google.com/apps-script/reference/contacts/url-field","!doc":"UrlField A URL field in a Contact.","prototype":{"deleteUrlField":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/contacts/#deleteUrlField()","!doc":"Deletes this URL field."},"getAddress":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/contacts/#getAddress()","!doc":"Get the address for this field."},"getLabel":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/contacts/#getLabel()","!doc":"Gets the label for this field."},"isPrimary":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/contacts/#isPrimary()","!doc":"Gets whether this is the primary field value."},"setAddress":{"!type":"fn(address: string) -> +contacts.UrlField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAddress(String)","!doc":"Sets the address of this field."},"setAsPrimary":{"!type":"fn() -> +contacts.UrlField","!url":"http://developers.google.com/apps-script/reference/contacts/#setAsPrimary()","!doc":"Sets this field to primary."},"setLabel":{"!type":"fn(label: string) -> +contacts.UrlField","!url":"http://developers.google.com/apps-script/reference/contacts/#setLabel(String)","!doc":"Sets the label of this field."}}},"ExtendedField":{"!url":"http://developers.google.com/apps-script/reference/contacts/extended-field","!doc":"ExtendedField An enum for extended contacts fields.","prototype":{"HOBBY":{"!type":"string","!doc":"the contact's hobby"},"MILEAGE":{"!type":"string","!doc":"the contact's mileage"},"LANGUAGE":{"!type":"string","!doc":"the contact's language"},"GENDER":{"!type":"string","!doc":"the contact's gender"},"BILLING_INFORMATION":{"!type":"string","!doc":"the contact's billing information"},"DIRECTORY_SERVER":{"!type":"string","!doc":"the contact's directory server"},"SENSITIVITY":{"!type":"string","!doc":"the contact's sensitivity"},"PRIORITY":{"!type":"string","!doc":"the contact's priority"},"HOME":{"!type":"string","!doc":"the contact's home information"},"WORK":{"!type":"string","!doc":"the contact's work information"},"USER":{"!type":"string","!doc":"the contact's user information"},"OTHER":{"!type":"string","!doc":"the contact's other information"}}},"Field":{"!url":"http://developers.google.com/apps-script/reference/contacts/field","!doc":"Field An enum for contacts fields.","prototype":{"FULL_NAME":{"!type":"string","!doc":"the contact's full name"},"GIVEN_NAME":{"!type":"string","!doc":"the contact's given (first) name"},"MIDDLE_NAME":{"!type":"string","!doc":"the contact's middle name"},"FAMILY_NAME":{"!type":"string","!doc":"the contact's family (last) name"},"MAIDEN_NAME":{"!type":"string","!doc":"the contact's maiden name"},"NICKNAME":{"!type":"string","!doc":"the contact's nickname"},"SHORT_NAME":{"!type":"string","!doc":"the contact's short name"},"INITIALS":{"!type":"string","!doc":"the contact's initials"},"PREFIX":{"!type":"string","!doc":"the prefix for the contact's name"},"SUFFIX":{"!type":"string","!doc":"the suffix for the contact's name"},"HOME_EMAIL":{"!type":"string","!doc":"the contact's home email address"},"WORK_EMAIL":{"!type":"string","!doc":"the contact's work email address"},"BIRTHDAY":{"!type":"string","!doc":"the contact's birthday"},"ANNIVERSARY":{"!type":"string","!doc":"the contact's anniversary"},"HOME_ADDRESS":{"!type":"string","!doc":"the contact's home address"},"WORK_ADDRESS":{"!type":"string","!doc":"the contact's work address"},"ASSISTANT_PHONE":{"!type":"string","!doc":"the contact's assistant's phone number"},"CALLBACK_PHONE":{"!type":"string","!doc":"the contact's callback phone number"},"MAIN_PHONE":{"!type":"string","!doc":"the contact's main phone number"},"PAGER":{"!type":"string","!doc":"the contact's pager number"},"HOME_FAX":{"!type":"string","!doc":"the contact's home fax number"},"WORK_FAX":{"!type":"string","!doc":"the contact's work fax number"},"HOME_PHONE":{"!type":"string","!doc":"the contact's home phone number"},"WORK_PHONE":{"!type":"string","!doc":"the contact's work phone number"},"MOBILE_PHONE":{"!type":"string","!doc":"the contact's mobile phone number"},"GOOGLE_VOICE":{"!type":"string","!doc":"the contact's Google Voice number"},"NOTES":{"!type":"string","!doc":"notes about the contact"},"GOOGLE_TALK":{"!type":"string","!doc":"the contact's Google Talk identifier"},"AIM":{"!type":"string","!doc":"the contact's AIM identifier"},"YAHOO":{"!type":"string","!doc":"the contact's Yahoo instant messaging identifier"},"SKYPE":{"!type":"string","!doc":"the contact's Skype identifier"},"QQ":{"!type":"string","!doc":"the contact's QQ identifer"},"MSN":{"!type":"string","!doc":"the contact's MSN identifier"},"ICQ":{"!type":"string","!doc":"the contact's ICQ identifier"},"JABBER":{"!type":"string","!doc":"the contact's Jabber identifier"},"BLOG":{"!type":"string","!doc":"the contact's blog URL"},"FTP":{"!type":"string","!doc":"the contact's FTP URL"},"PROFILE":{"!type":"string","!doc":"the contact's profile URL"},"HOME_PAGE":{"!type":"string","!doc":"the contact's home page URL"},"WORK_WEBSITE":{"!type":"string","!doc":"the contact's work website URL"},"HOME_WEBSITE":{"!type":"string","!doc":"the contact's home website URL"},"JOB_TITLE":{"!type":"string","!doc":"the contact's job title"},"COMPANY":{"!type":"string","!doc":"the contact's company"}}},"Gender":{"!url":"http://developers.google.com/apps-script/reference/contacts/gender","!doc":"Gender An enum for contact gender.","prototype":{"MALE":{"!type":"string","!doc":"male gender"},"FEMALE":{"!type":"string","!doc":"female gender"}}},"Priority":{"!url":"http://developers.google.com/apps-script/reference/contacts/priority","!doc":"Priority An enum for contact priority.","prototype":{"HIGH":{"!type":"string","!doc":"high priority"},"LOW":{"!type":"string","!doc":"low priority"},"NORMAL":{"!type":"string","!doc":"normal priority"}}},"Sensitivity":{"!url":"http://developers.google.com/apps-script/reference/contacts/sensitivity","!doc":"Sensitivity An enum for contact sensitivity.","prototype":{"CONFIDENTIAL":{"!type":"string","!doc":"confidential sensitivity"},"NORMAL":{"!type":"string","!doc":"normal sensitivity"},"PERSONAL":{"!type":"string","!doc":"personal sensitivity"},"PRIVATE":{"!type":"string","!doc":"private sensitivity"}}}},"content":{"TextOutput":{"!url":"http://developers.google.com/apps-script/reference/content/text-output","!doc":"TextOutput A TextOutput object that can be served from a script. Due to security considerations, scripts cannot directly return text content to a browser. Instead, the browser is redirected to googleusercontent.com, which will display it without any further sanitization or manipulation. You can return text content like this: function doGet() { return ContentService.createPlainTextOutput(\"hello world!\"); } There are also methods to serve JSON, RSS, and XML as TextOutputs; see the corresponding methods on ContentService.","prototype":{"append":{"!type":"fn(addedContent: string) -> +content.TextOutput","!url":"http://developers.google.com/apps-script/reference/content/#append(String)","!doc":"Appends new content to the content that will be served."},"clear":{"!type":"fn() -> +content.TextOutput","!url":"http://developers.google.com/apps-script/reference/content/#clear()","!doc":"Clears the current content."},"downloadAsFile":{"!type":"fn(filename: string) -> +content.TextOutput","!url":"http://developers.google.com/apps-script/reference/content/#downloadAsFile(String)","!doc":"Tells browsers to download rather than display this content."},"getContent":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/content/#getContent()","!doc":"Gets the content that will be served."},"getFileName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/content/#getFileName()","!doc":"Returns the file name to download this file as, or null if it should be displayed rather than downloaded."},"getMimeType":{"!type":"fn() -> +content.MimeType","!url":"http://developers.google.com/apps-script/reference/content/#getMimeType()","!doc":"Get the mime type this content will be served with."},"setContent":{"!type":"fn(content: string) -> +content.TextOutput","!url":"http://developers.google.com/apps-script/reference/content/#setContent(String)","!doc":"Sets the content that will be served."},"setMimeType":{"!type":"fn(mimeType: content.MimeType) -> +content.TextOutput","!url":"http://developers.google.com/apps-script/reference/content/#setMimeType(MimeType)","!doc":"Sets the mime type for content that will be served."}}},"MimeType":{"!url":"http://developers.google.com/apps-script/reference/content/mime-type","!doc":"MimeType An enum for mime types that can be served from a script.","prototype":{"ATOM":{"!type":"string","!doc":""},"CSV":{"!type":"string","!doc":""},"ICAL":{"!type":"string","!doc":""},"JAVASCRIPT":{"!type":"string","!doc":""},"JSON":{"!type":"string","!doc":""},"RSS":{"!type":"string","!doc":""},"TEXT":{"!type":"string","!doc":""},"VCARD":{"!type":"string","!doc":""},"XML":{"!type":"string","!doc":""}}}},"docslist":{"File":{"!url":"http://developers.google.com/apps-script/reference/docs-list/file","!doc":"File This class contains methods to get information about the file and modify its contents. // This example logs the file type of the first file var file = DocsList.getAllFiles()[0]; Logger.log(file.getFileType());","prototype":{"addEditor":{"!type":"fn(user: base.User) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#addEditor(User)","!doc":"Adds the given user to the list of editors for the File."},"addEditors":{"!type":"fn(emailAddresses: [string]) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the File."},"addToFolder":{"!type":"fn(parent: docslist.Folder)","!url":"http://developers.google.com/apps-script/reference/docs-list/#addToFolder(Folder)","!doc":"Adds the item to the given folder."},"addViewer":{"!type":"fn(user: base.User) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#addViewer(User)","!doc":"Adds the given user to the list of viewers for the File."},"addViewers":{"!type":"fn(emailAddresses: [string]) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#addViewers(String)","!doc":"Adds the given array of users to the list of viewers for the File."},"append":{"!type":"fn(contents: string)","!url":"http://developers.google.com/apps-script/reference/docs-list/#append(String)","!doc":"Appends the given string to the existing contents of the file."},"clear":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/docs-list/#clear()","!doc":"Clears all the contents of a document that is not of a Google Docs format."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/docs-list/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/docs-list/#getBlob()","!doc":"Return the data inside this object as a blob."},"getContentAsString":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getContentAsString()","!doc":"Returns the contents of any file that isn't a Google document type as a string."},"getDateCreated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/docs-list/#getDateCreated()","!doc":"Gets the date that this item was created."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getDescription()","!doc":"Returns the description of the item or null if a description doesn't exist."},"getEditors":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getEditors()","!doc":"Gets the list of editors for this File."},"getFileType":{"!type":"fn() -> +docslist.FileType","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFileType()","!doc":"Returns the FileType of the file."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getId()","!doc":"Returns the document ID associated with the item."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/docs-list/#getLastUpdated()","!doc":"Gets the date that this item was last updated."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getName()","!doc":"Returns the name of the item."},"getOwner":{"!type":"fn() -> +base.User","!url":"http://developers.google.com/apps-script/reference/docs-list/#getOwner()","!doc":"Gets the owner of the item."},"getParents":{"!type":"fn() -> [+docslist.Folder]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getParents()","!doc":"Returns the parent folders."},"getSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/docs-list/#getSize()","!doc":"Returns the amount of disk space used by the item."},"getThumbnail":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/docs-list/#getThumbnail()","!doc":"Returns the thumbnail image associated with this item, or null if no thumbnail exists."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getUrl()","!doc":"Returns a URL to access the particular item."},"getViewers":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getViewers()","!doc":"Gets the list of viewers and commenters for this File."},"isStarred":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/docs-list/#isStarred()","!doc":"Gets whether the item is starred."},"isTrashed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/docs-list/#isTrashed()","!doc":"Checks whether the item is trashed."},"makeCopy":{"!type":"fn(newName: string) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#makeCopy(String)","!doc":"Returns a copy of the current file with the given name."},"removeEditor":{"!type":"fn(user: base.User) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the File."},"removeFromFolder":{"!type":"fn(parent: docslist.Folder)","!url":"http://developers.google.com/apps-script/reference/docs-list/#removeFromFolder(Folder)","!doc":"Removes this object from the given folder."},"removeViewer":{"!type":"fn(user: base.User) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#removeViewer(User)","!doc":"Removes the given user from the list of viewers and commenters for the File."},"rename":{"!type":"fn(newName: string)","!url":"http://developers.google.com/apps-script/reference/docs-list/#rename(String)","!doc":"Rename the item."},"replace":{"!type":"fn(contents: string)","!url":"http://developers.google.com/apps-script/reference/docs-list/#replace(String)","!doc":"Replaces the contents of the file with the contents provided."},"setDescription":{"!type":"fn(description: string)","!url":"http://developers.google.com/apps-script/reference/docs-list/#setDescription(String)","!doc":"Update's the item's description."},"setStarred":{"!type":"fn(starred: bool)","!url":"http://developers.google.com/apps-script/reference/docs-list/#setStarred(Boolean)","!doc":"Sets the item's starred status in drive."},"setTrashed":{"!type":"fn(trash: bool)","!url":"http://developers.google.com/apps-script/reference/docs-list/#setTrashed(Boolean)","!doc":"Sets the trashed status of an item but does not permanently delete it."}}},"FilesResult":{"!url":"http://developers.google.com/apps-script/reference/docs-list/files-result","!doc":"FilesResult Holds an array of files as well as a token used to enable pagination in methods that return a limited number of items such as DocsList.getAllFilesForPaging(number, token). // This example logs the names of all files in the user's drive in batches of 200. var pageSize = 200; var files = null; var token = null; // use a null token for the first lookup do { var result = DocsList.getAllFilesForPaging(pageSize, token); files = result.getFiles(); token = result.getToken(); for (var i = 0; i < files.length; i++) { Logger.log(files[i].getName()); } } while (files.length >= pageSize);","prototype":{"getFiles":{"!type":"fn() -> [+docslist.File]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFiles()","!doc":"Gets the files contained in this result."},"getToken":{"!type":"fn() -> +docslist.Token","!url":"http://developers.google.com/apps-script/reference/docs-list/#getToken()","!doc":"Gets the token for this result."}}},"Folder":{"!url":"http://developers.google.com/apps-script/reference/docs-list/folder","!doc":"Folder A folder contains methods to create, find, and access files inside of itself. // This example gets a folder named 'kittens' and logs the files it contains. var folder = DocsList.getFolder('kittens'); var files = folder.getFiles(); for (var i in files) { Logger.log(files[i].getName()); }","prototype":{"addEditor":{"!type":"fn(user: base.User) -> +docslist.Folder","!url":"http://developers.google.com/apps-script/reference/docs-list/#addEditor(User)","!doc":"Adds the given user to the list of editors for the Folder."},"addEditors":{"!type":"fn(emailAddresses: [string]) -> +docslist.Folder","!url":"http://developers.google.com/apps-script/reference/docs-list/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the Folder."},"addToFolder":{"!type":"fn(parent: docslist.Folder)","!url":"http://developers.google.com/apps-script/reference/docs-list/#addToFolder(Folder)","!doc":"Adds the item to the given folder."},"addViewer":{"!type":"fn(user: base.User) -> +docslist.Folder","!url":"http://developers.google.com/apps-script/reference/docs-list/#addViewer(User)","!doc":"Adds the given user to the list of viewers for the Folder."},"addViewers":{"!type":"fn(emailAddresses: [string]) -> +docslist.Folder","!url":"http://developers.google.com/apps-script/reference/docs-list/#addViewers(String)","!doc":"Adds the given array of users to the list of viewers for the Folder."},"createFile":{"!type":"fn(name: string, contents: string, mimeType: string) -> +docslist.File","!url":"http://developers.google.com/apps-script/reference/docs-list/#createFile(String,String,String)","!doc":"Creates a file with the given name and contents in the current folder with the given MIME type."},"createFolder":{"!type":"fn(name: string) -> +docslist.Folder","!url":"http://developers.google.com/apps-script/reference/docs-list/#createFolder(String)","!doc":"Creates a sub-folder with the given name in the current folder."},"find":{"!type":"fn(query: string) -> [+docslist.File]","!url":"http://developers.google.com/apps-script/reference/docs-list/#find(String)","!doc":"Returns an array of all the files in the container that contain the given string."},"findForPaging":{"!type":"fn(query: string, number: number, token: docslist.Token) -> +docslist.FilesResult","!url":"http://developers.google.com/apps-script/reference/docs-list/#findForPaging(String,Integer,Token)","!doc":"Returns the next number files maching the search query, picking up from where the token from the previous lookup left off."},"getDateCreated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/docs-list/#getDateCreated()","!doc":"Gets the date that this item was created."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getDescription()","!doc":"Returns the description of the item or null if a description doesn't exist."},"getEditors":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getEditors()","!doc":"Gets the list of editors for this Folder."},"getFiles":{"!type":"fn() -> [+docslist.File]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFiles()","!doc":"Returns all the files in the container (up to a maximum of DocsList.DEFAULT_RESULT_SIZE)."},"getFilesByType":{"!type":"fn(type: docslist.FileType) -> [+docslist.File]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFilesByType(FileType)","!doc":"Returns all files of a given type."},"getFilesByTypeForPaging":{"!type":"fn(type: docslist.FileType, number: number, token: docslist.Token) -> +docslist.FilesResult","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFilesByTypeForPaging(FileType,Integer,Token)","!doc":"Returns the next number files of the given type in this container, picking up from where the token from the previous lookup left off."},"getFilesForPaging":{"!type":"fn(number: number, token: docslist.Token) -> +docslist.FilesResult","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFilesForPaging(Integer,Token)","!doc":"Returns the next number files in this container, picking up from where the token from the previous lookup left off."},"getFolders":{"!type":"fn() -> [+docslist.Folder]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFolders()","!doc":"Returns all the folders in this container (up to a maximum of DocsList.DEFAULT_RESULT_SIZE)."},"getFoldersForPaging":{"!type":"fn(number: number, token: docslist.Token) -> +docslist.FoldersResult","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFoldersForPaging(Integer,Token)","!doc":"Returns the next number folders in this container, picking up from where the token from the previous lookup left off."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getId()","!doc":"Returns the document ID associated with the item."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/docs-list/#getLastUpdated()","!doc":"Gets the date that this item was last updated."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getName()","!doc":"Returns the name of the item."},"getOwner":{"!type":"fn() -> +base.User","!url":"http://developers.google.com/apps-script/reference/docs-list/#getOwner()","!doc":"Gets the owner of the item."},"getParents":{"!type":"fn() -> [+docslist.Folder]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getParents()","!doc":"Returns the parent folders."},"getSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/docs-list/#getSize()","!doc":"Returns the amount of disk space used by the item."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/docs-list/#getUrl()","!doc":"Returns a URL to access the particular item."},"getViewers":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getViewers()","!doc":"Gets the list of viewers and commenters for this Folder."},"isStarred":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/docs-list/#isStarred()","!doc":"Gets whether the item is starred."},"isTrashed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/docs-list/#isTrashed()","!doc":"Checks whether the item is trashed."},"removeEditor":{"!type":"fn(user: base.User) -> +docslist.Folder","!url":"http://developers.google.com/apps-script/reference/docs-list/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the Folder."},"removeFromFolder":{"!type":"fn(parent: docslist.Folder)","!url":"http://developers.google.com/apps-script/reference/docs-list/#removeFromFolder(Folder)","!doc":"Removes this object from the given folder."},"removeViewer":{"!type":"fn(user: base.User) -> +docslist.Folder","!url":"http://developers.google.com/apps-script/reference/docs-list/#removeViewer(User)","!doc":"Removes the given user from the list of viewers and commenters for the Folder."},"rename":{"!type":"fn(newName: string)","!url":"http://developers.google.com/apps-script/reference/docs-list/#rename(String)","!doc":"Rename the item."},"setDescription":{"!type":"fn(description: string)","!url":"http://developers.google.com/apps-script/reference/docs-list/#setDescription(String)","!doc":"Update's the item's description."},"setStarred":{"!type":"fn(starred: bool)","!url":"http://developers.google.com/apps-script/reference/docs-list/#setStarred(Boolean)","!doc":"Sets the item's starred status in drive."},"setTrashed":{"!type":"fn(trash: bool)","!url":"http://developers.google.com/apps-script/reference/docs-list/#setTrashed(Boolean)","!doc":"Sets the trashed status of an item but does not permanently delete it."}}},"FoldersResult":{"!url":"http://developers.google.com/apps-script/reference/docs-list/folders-result","!doc":"FoldersResult Holds an array of folders as well as a token used to enable pagination in methods that return a limited number of items such as DocsList.getAllFoldersForPaging(number, token). // This example logs the names of all folders in the users drive in batches of 5 var pageSize = 5; var folders = null; var token = null; // using null token for the first lookup do { var result = DocsList.getAllFoldersForPaging(pageSize, token); folders = result.getFolders(); token = result.getToken(); for (var i = 0; i < folders.length; i++) { Logger.log(folders[i].getName()); } } while (folders.length >= pageSize);","prototype":{"getFolders":{"!type":"fn() -> [+docslist.Folder]","!url":"http://developers.google.com/apps-script/reference/docs-list/#getFolders()","!doc":"Gets the folders contained in this result."},"getToken":{"!type":"fn() -> +docslist.Token","!url":"http://developers.google.com/apps-script/reference/docs-list/#getToken()","!doc":"Gets the token for this result."}}},"Token":{"!url":"http://developers.google.com/apps-script/reference/docs-list/token","!doc":"Token A token object used to enable pagination in methods that return a limited number of items. For example, the token can be passed to sequential DocsList.getAllFilesForPaging(number, token) calls to continue paging through large sets of results. // This example logs the names of all files in the user's drive in batches of 200 var pageSize = 200; var files = null; var token = null; do { var result = DocsList.getAllFilesForPaging(pageSize, token); files = result.getFiles(); token = result.getToken(); for (var i = 0; i < files.length; i++) { Logger.log(files[i].getName()); } } while (files.length >= pageSize);","prototype":{}},"FileType":{"!url":"http://developers.google.com/apps-script/reference/docs-list/file-type","!doc":"FileType An enumeration used to represent various Google and non-Google file types.","prototype":{"DOCUMENT":{"!type":"string","!doc":""},"SPREADSHEET":{"!type":"string","!doc":""},"PRESENTATION":{"!type":"string","!doc":""},"DRAWING":{"!type":"string","!doc":""},"FORM":{"!type":"string","!doc":""},"OTHER":{"!type":"string","!doc":""}}}},"document":{"Body":{"!url":"http://developers.google.com/apps-script/reference/document/body","!doc":"Body An element representing a document body. The Body may contain ListItem, Paragraph, Table, and TableOfContents elements. For more information on document structure, see the guide to extending Google Docs. The Body typically contains the full document contents except for the HeaderSection, FooterSection, and any FootnoteSection elements. var doc = DocumentApp.getActiveDocument(); var body = doc.getBody(); // Append a paragraph and a page break to the document body section directly. body.appendParagraph(\"A paragraph.\"); body.appendPageBreak();","prototype":{"appendHorizontalRule":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#appendHorizontalRule()","!doc":"Creates and appends a new HorizontalRule."},"appendImage":{"!type":"fn(image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#appendImage(InlineImage)","!doc":"Appends the given InlineImage."},"appendListItem":{"!type":"fn(text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#appendListItem(String)","!doc":"Creates and appends a new ListItem containing the specified text contents."},"appendPageBreak":{"!type":"fn(pageBreak: document.PageBreak) -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#appendPageBreak(PageBreak)","!doc":"Appends the given PageBreak."},"appendParagraph":{"!type":"fn(text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#appendParagraph(String)","!doc":"Creates and appends a new Paragraph containing the specified text contents."},"appendTable":{"!type":"fn(table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#appendTable(Table)","!doc":"Appends the given Table."},"clear":{"!type":"fn() -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getImages":{"!type":"fn() -> [+document.InlineImage]","!url":"http://developers.google.com/apps-script/reference/document/#getImages()","!doc":"Retrieves all the InlineImages contained in the section."},"getListItems":{"!type":"fn() -> [+document.ListItem]","!url":"http://developers.google.com/apps-script/reference/document/#getListItems()","!doc":"Retrieves all the ListItems contained in the section."},"getMarginBottom":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getMarginBottom()","!doc":"Retrieves the bottom margin, in points."},"getMarginLeft":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getMarginLeft()","!doc":"Retrieves the left margin, in points."},"getMarginRight":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getMarginRight()","!doc":"Retrieves the right margin."},"getMarginTop":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getMarginTop()","!doc":"Retrieves the top margin."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getPageHeight":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getPageHeight()","!doc":"Retrieves the page height, in points."},"getPageWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getPageWidth()","!doc":"Retrieves the page width, in points."},"getParagraphs":{"!type":"fn() -> [+document.Paragraph]","!url":"http://developers.google.com/apps-script/reference/document/#getParagraphs()","!doc":"Retrieves all the Paragraphs contained in the section."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getTables":{"!type":"fn() -> [+document.Table]","!url":"http://developers.google.com/apps-script/reference/document/#getTables()","!doc":"Retrieves all the Tables contained in the section."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertHorizontalRule":{"!type":"fn(childIndex: number) -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#insertHorizontalRule(Integer)","!doc":"Creates and inserts a new HorizontalRule at the specified index."},"insertImage":{"!type":"fn(childIndex: number, image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#insertImage(Integer,InlineImage)","!doc":"Inserts the given InlineImage at the specified index."},"insertListItem":{"!type":"fn(childIndex: number, text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#insertListItem(Integer,String)","!doc":"Creates and inserts a new ListItem at the specified index, containing the specified text contents."},"insertPageBreak":{"!type":"fn(childIndex: number, pageBreak: document.PageBreak) -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#insertPageBreak(Integer,PageBreak)","!doc":"Inserts the given PageBreak at the specified index."},"insertParagraph":{"!type":"fn(childIndex: number, text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#insertParagraph(Integer,String)","!doc":"Creates and inserts a new Paragraph at the specified index, containing the specified text contents."},"insertTable":{"!type":"fn(childIndex: number, table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#insertTable(Integer,Table)","!doc":"Inserts the given Table at the specified index."},"removeChild":{"!type":"fn(child: document.Element) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setMarginBottom":{"!type":"fn(marginBottom: number) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setMarginBottom(Number)","!doc":"Sets the bottom margin, in points."},"setMarginLeft":{"!type":"fn(marginLeft: number) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setMarginLeft(Number)","!doc":"Sets the left margin, in points."},"setMarginRight":{"!type":"fn(marginRight: number) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setMarginRight(Number)","!doc":"Sets the right margin, in points."},"setMarginTop":{"!type":"fn(marginTop: number) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setMarginTop(Number)","!doc":"Sets the top margin."},"setPageHeight":{"!type":"fn(pageHeight: number) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setPageHeight(Number)","!doc":"Sets the page height, in points."},"setPageWidth":{"!type":"fn(pageWidth: number) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setPageWidth(Number)","!doc":"Sets the page width, in points."},"setText":{"!type":"fn(text: string) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the contents as plain text."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"Bookmark":{"!url":"http://developers.google.com/apps-script/reference/document/bookmark","!doc":"Bookmark An object representing a bookmark. // Insert a bookmark at the cursor position and log its ID. var doc = DocumentApp.getActiveDocument(); var cursor = doc.getCursor(); var bookmark = doc.addBookmark(cursor); Logger.log(bookmark.getId());","prototype":{"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getId()","!doc":"Gets the ID of the Bookmark."},"getPosition":{"!type":"fn() -> +document.Position","!url":"http://developers.google.com/apps-script/reference/document/#getPosition()","!doc":"Gets the Position of the Bookmark within the Document."},"remove":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/document/#remove()","!doc":"Deletes the Bookmark."}}},"ContainerElement":{"!url":"http://developers.google.com/apps-script/reference/document/container-element","!doc":"ContainerElement A generic element that may contain other elements. All elements that may contain child elements, such as Paragraph, inherit from ContainerElement.","prototype":{"asBody":{"!type":"fn() -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#asBody()","!doc":"Returns the current element as a Body."},"asEquation":{"!type":"fn() -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#asEquation()","!doc":"Returns the current element as a Equation."},"asFooterSection":{"!type":"fn() -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#asFooterSection()","!doc":"Returns the current element as a FooterSection."},"asFootnoteSection":{"!type":"fn() -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#asFootnoteSection()","!doc":"Returns the current element as a FootnoteSection."},"asHeaderSection":{"!type":"fn() -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#asHeaderSection()","!doc":"Returns the current element as a HeaderSection."},"asListItem":{"!type":"fn() -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#asListItem()","!doc":"Returns the current element as a ListItem."},"asParagraph":{"!type":"fn() -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#asParagraph()","!doc":"Returns the current element as a Paragraph."},"asTable":{"!type":"fn() -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#asTable()","!doc":"Returns the current element as a Table."},"asTableCell":{"!type":"fn() -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#asTableCell()","!doc":"Returns the current element as a TableCell."},"asTableOfContents":{"!type":"fn() -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#asTableOfContents()","!doc":"Returns the current element as a TableOfContents."},"asTableRow":{"!type":"fn() -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#asTableRow()","!doc":"Returns the current element as a TableRow."},"clear":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setLinkUrl":{"!type":"fn(url: string) -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"Document":{"!url":"http://developers.google.com/apps-script/reference/document/document","!doc":"Document A document, containing rich text and elements such as tables and lists. Documents may be opened or created using DocumentApp. // Open a document by ID. var doc = DocumentApp.openById(\"<my-id>\"); // Create and open a document. doc = DocumentApp.create(\"Document Title\");","prototype":{"addBookmark":{"!type":"fn(position: document.Position) -> +document.Bookmark","!url":"http://developers.google.com/apps-script/reference/document/#addBookmark(Position)","!doc":"Adds a Bookmark at the given Position."},"addEditor":{"!type":"fn(user: base.User) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#addEditor(User)","!doc":"Adds the given user to the list of editors for the Document."},"addEditors":{"!type":"fn(emailAddresses: [string]) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the Document."},"addFooter":{"!type":"fn() -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#addFooter()","!doc":"Adds a document footer section, if none exists."},"addHeader":{"!type":"fn() -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#addHeader()","!doc":"Adds a document header section, if none exists."},"addNamedRange":{"!type":"fn(name: string, range: document.Range) -> +document.NamedRange","!url":"http://developers.google.com/apps-script/reference/document/#addNamedRange(String,Range)","!doc":"Adds a new NamedRange, which is a Range that has a name and ID to allow later retrieval."},"addViewer":{"!type":"fn(user: base.User) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#addViewer(User)","!doc":"Adds the given user to the list of viewers for the Document."},"addViewers":{"!type":"fn(emailAddresses: [string]) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#addViewers(String)","!doc":"Adds the given array of users to the list of viewers for the Document."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/document/#getAs(String)","!doc":"Retrieves the current Document contents as a blob of the specified type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/document/#getBlob()","!doc":"Retrieves the current Document contents as a blob."},"getBody":{"!type":"fn() -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#getBody()","!doc":"Retrieves the active document's Body."},"getBookmark":{"!type":"fn(id: string) -> +document.Bookmark","!url":"http://developers.google.com/apps-script/reference/document/#getBookmark(String)","!doc":"Gets the Bookmark with the given ID."},"getBookmarks":{"!type":"fn() -> [+document.Bookmark]","!url":"http://developers.google.com/apps-script/reference/document/#getBookmarks()","!doc":"Gets all Bookmark objects in the document."},"getCursor":{"!type":"fn() -> +document.Position","!url":"http://developers.google.com/apps-script/reference/document/#getCursor()","!doc":"Gets the user's cursor in the active document."},"getEditors":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/document/#getEditors()","!doc":"Gets the list of editors for this Document."},"getFooter":{"!type":"fn() -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#getFooter()","!doc":"Retrieves the document's footer section, if one exists."},"getFootnotes":{"!type":"fn() -> [+document.Footnote]","!url":"http://developers.google.com/apps-script/reference/document/#getFootnotes()","!doc":"Retrieves all the Footnote elements in the document body."},"getHeader":{"!type":"fn() -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#getHeader()","!doc":"Retrieves the document's header section, if one exists."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getId()","!doc":"Retrieves the document's unique identifier."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getName()","!doc":"Retrieves the title of the document."},"getNamedRangeById":{"!type":"fn(id: string) -> +document.NamedRange","!url":"http://developers.google.com/apps-script/reference/document/#getNamedRangeById(String)","!doc":"Gets the NamedRange with the given ID."},"getNamedRanges":{"!type":"fn(name: string) -> [+document.NamedRange]","!url":"http://developers.google.com/apps-script/reference/document/#getNamedRanges(String)","!doc":"Gets all NamedRange objects in the document with the given name."},"getSelection":{"!type":"fn() -> +document.Range","!url":"http://developers.google.com/apps-script/reference/document/#getSelection()","!doc":"Gets the user's selection in the active document."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getUrl()","!doc":"Retrieves the URL to access the current document."},"getViewers":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/document/#getViewers()","!doc":"Gets the list of viewers and commenters for this Document."},"newPosition":{"!type":"fn(element: document.Element, offset: number) -> +document.Position","!url":"http://developers.google.com/apps-script/reference/document/#newPosition(Element,Integer)","!doc":"Creates a new Position, which is a reference to a location in the document, relative to a specific element."},"newRange":{"!type":"fn() -> +document.RangeBuilder","!url":"http://developers.google.com/apps-script/reference/document/#newRange()","!doc":"Creates a builder used to construct Range objects from document elements."},"removeEditor":{"!type":"fn(user: base.User) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the Document."},"removeViewer":{"!type":"fn(user: base.User) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#removeViewer(User)","!doc":"Removes the given user from the list of viewers and commenters for the Document."},"saveAndClose":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/document/#saveAndClose()","!doc":"Saves the current Document."},"setCursor":{"!type":"fn(position: document.Position) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#setCursor(Position)","!doc":"Sets the user's cursor in the active document, given a Position."},"setName":{"!type":"fn(name: string) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#setName(String)","!doc":"Sets the document title."},"setSelection":{"!type":"fn(range: document.Range) -> +document.Document","!url":"http://developers.google.com/apps-script/reference/document/#setSelection(Range)","!doc":"Sets the user's selection in the active document, given a Range."}}},"Equation":{"!url":"http://developers.google.com/apps-script/reference/document/equation","!doc":"Equation An element representing a mathematical expression. An Equation may contain EquationFunction, EquationSymbol, and Text elements. For more information on document structure, see the guide to extending Google Docs.","prototype":{"clear":{"!type":"fn() -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setLinkUrl":{"!type":"fn(url: string) -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"EquationFunction":{"!url":"http://developers.google.com/apps-script/reference/document/equation-function","!doc":"EquationFunction An element representing a function in a mathematical Equation. An EquationFunction may contain EquationFunction, EquationFunctionArgumentSeparator, EquationSymbol, and Text elements. For more information on document structure, see the guide to extending Google Docs.","prototype":{"clear":{"!type":"fn() -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getCode":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getCode()","!doc":"Retrieves the code corresponding to the equation function."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setLinkUrl":{"!type":"fn(url: string) -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"EquationFunctionArgumentSeparator":{"!url":"http://developers.google.com/apps-script/reference/document/equation-function-argument-separator","!doc":"EquationFunctionArgumentSeparator An element representing a function separator in a mathematical Equation. An EquationFunctionArgumentSeparator cannot contain any other element. For more information on document structure, see the guide to extending Google Docs.","prototype":{"copy":{"!type":"fn() -> +document.EquationFunctionArgumentSeparator","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.EquationFunctionArgumentSeparator","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.EquationFunctionArgumentSeparator","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.EquationFunctionArgumentSeparator","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"EquationSymbol":{"!url":"http://developers.google.com/apps-script/reference/document/equation-symbol","!doc":"EquationSymbol An element representing a symbol in a mathematical Equation. An EquationSymbol cannot contain any other element. For more information on document structure, see the guide to extending Google Docs.","prototype":{"copy":{"!type":"fn() -> +document.EquationSymbol","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getCode":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getCode()","!doc":"Retrieves the code corresponding to the equation symbol."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.EquationSymbol","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.EquationSymbol","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.EquationSymbol","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"FooterSection":{"!url":"http://developers.google.com/apps-script/reference/document/footer-section","!doc":"FooterSection An element representing a footer section. A Document typically contains at most one FooterSection. The FooterSection may contain ListItem, Paragraph, and Table elements. For more information on document structure, see the guide to extending Google Docs.","prototype":{"appendHorizontalRule":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#appendHorizontalRule()","!doc":"Creates and appends a new HorizontalRule."},"appendImage":{"!type":"fn(image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#appendImage(InlineImage)","!doc":"Appends the given InlineImage."},"appendListItem":{"!type":"fn(text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#appendListItem(String)","!doc":"Creates and appends a new ListItem containing the specified text contents."},"appendParagraph":{"!type":"fn(text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#appendParagraph(String)","!doc":"Creates and appends a new Paragraph containing the specified text contents."},"appendTable":{"!type":"fn(table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#appendTable(Table)","!doc":"Appends the given Table."},"clear":{"!type":"fn() -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getImages":{"!type":"fn() -> [+document.InlineImage]","!url":"http://developers.google.com/apps-script/reference/document/#getImages()","!doc":"Retrieves all the InlineImages contained in the section."},"getListItems":{"!type":"fn() -> [+document.ListItem]","!url":"http://developers.google.com/apps-script/reference/document/#getListItems()","!doc":"Retrieves all the ListItems contained in the section."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParagraphs":{"!type":"fn() -> [+document.Paragraph]","!url":"http://developers.google.com/apps-script/reference/document/#getParagraphs()","!doc":"Retrieves all the Paragraphs contained in the section."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getTables":{"!type":"fn() -> [+document.Table]","!url":"http://developers.google.com/apps-script/reference/document/#getTables()","!doc":"Retrieves all the Tables contained in the section."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertHorizontalRule":{"!type":"fn(childIndex: number) -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#insertHorizontalRule(Integer)","!doc":"Creates and inserts a new HorizontalRule at the specified index."},"insertImage":{"!type":"fn(childIndex: number, image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#insertImage(Integer,InlineImage)","!doc":"Inserts the given InlineImage at the specified index."},"insertListItem":{"!type":"fn(childIndex: number, text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#insertListItem(Integer,String)","!doc":"Creates and inserts a new ListItem at the specified index, containing the specified text contents."},"insertParagraph":{"!type":"fn(childIndex: number, text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#insertParagraph(Integer,String)","!doc":"Creates and inserts a new Paragraph at the specified index, containing the specified text contents."},"insertTable":{"!type":"fn(childIndex: number, table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#insertTable(Integer,Table)","!doc":"Inserts the given Table at the specified index."},"removeChild":{"!type":"fn(child: document.Element) -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setText":{"!type":"fn(text: string) -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the contents as plain text."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"Footnote":{"!url":"http://developers.google.com/apps-script/reference/document/footnote","!doc":"Footnote An element representing a footnote. Each Footnote is contained within a ListItem or Paragraph and has a corresponding FootnoteSection element for the footnote's contents. The Footnote itself cannot contain any other element. For more information on document structure, see the guide to extending Google Docs.","prototype":{"copy":{"!type":"fn() -> +document.Footnote","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getFootnoteContents":{"!type":"fn() -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#getFootnoteContents()","!doc":"Retrieves the contents of the footnote element."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"removeFromParent":{"!type":"fn() -> +document.Footnote","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.Footnote","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"FootnoteSection":{"!url":"http://developers.google.com/apps-script/reference/document/footnote-section","!doc":"FootnoteSection An element representing a footnote section. A FootnoteSection contains the text that corresponds to a Footnote. The FootnoteSection may contain ListItem or Paragraph elements. For more information on document structure, see the guide to extending Google Docs.","prototype":{"appendParagraph":{"!type":"fn(text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#appendParagraph(String)","!doc":"Creates and appends a new Paragraph containing the specified text contents."},"clear":{"!type":"fn() -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParagraphs":{"!type":"fn() -> [+document.Paragraph]","!url":"http://developers.google.com/apps-script/reference/document/#getParagraphs()","!doc":"Retrieves all the Paragraphs contained in the section."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertParagraph":{"!type":"fn(childIndex: number, text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#insertParagraph(Integer,String)","!doc":"Creates and inserts a new Paragraph at the specified index, containing the specified text contents."},"removeChild":{"!type":"fn(child: document.Element) -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setText":{"!type":"fn(text: string) -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the contents as plain text."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"HeaderSection":{"!url":"http://developers.google.com/apps-script/reference/document/header-section","!doc":"HeaderSection An element representing a header section. A Document typically contains at most one HeaderSection. The HeaderSection may contain ListItem, Paragraph, and Table elements. For more information on document structure, see the guide to extending Google Docs.","prototype":{"appendHorizontalRule":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#appendHorizontalRule()","!doc":"Creates and appends a new HorizontalRule."},"appendImage":{"!type":"fn(image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#appendImage(InlineImage)","!doc":"Appends the given InlineImage."},"appendListItem":{"!type":"fn(text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#appendListItem(String)","!doc":"Creates and appends a new ListItem containing the specified text contents."},"appendParagraph":{"!type":"fn(text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#appendParagraph(String)","!doc":"Creates and appends a new Paragraph containing the specified text contents."},"appendTable":{"!type":"fn(table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#appendTable(Table)","!doc":"Appends the given Table."},"clear":{"!type":"fn() -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getImages":{"!type":"fn() -> [+document.InlineImage]","!url":"http://developers.google.com/apps-script/reference/document/#getImages()","!doc":"Retrieves all the InlineImages contained in the section."},"getListItems":{"!type":"fn() -> [+document.ListItem]","!url":"http://developers.google.com/apps-script/reference/document/#getListItems()","!doc":"Retrieves all the ListItems contained in the section."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParagraphs":{"!type":"fn() -> [+document.Paragraph]","!url":"http://developers.google.com/apps-script/reference/document/#getParagraphs()","!doc":"Retrieves all the Paragraphs contained in the section."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getTables":{"!type":"fn() -> [+document.Table]","!url":"http://developers.google.com/apps-script/reference/document/#getTables()","!doc":"Retrieves all the Tables contained in the section."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertHorizontalRule":{"!type":"fn(childIndex: number) -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#insertHorizontalRule(Integer)","!doc":"Creates and inserts a new HorizontalRule at the specified index."},"insertImage":{"!type":"fn(childIndex: number, image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#insertImage(Integer,InlineImage)","!doc":"Inserts the given InlineImage at the specified index."},"insertListItem":{"!type":"fn(childIndex: number, text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#insertListItem(Integer,String)","!doc":"Creates and inserts a new ListItem at the specified index, containing the specified text contents."},"insertParagraph":{"!type":"fn(childIndex: number, text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#insertParagraph(Integer,String)","!doc":"Creates and inserts a new Paragraph at the specified index, containing the specified text contents."},"insertTable":{"!type":"fn(childIndex: number, table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#insertTable(Integer,Table)","!doc":"Inserts the given Table at the specified index."},"removeChild":{"!type":"fn(child: document.Element) -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setText":{"!type":"fn(text: string) -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the contents as plain text."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"HorizontalRule":{"!url":"http://developers.google.com/apps-script/reference/document/horizontal-rule","!doc":"HorizontalRule An element representing an horizontal rule. A HorizontalRule can be contained within a ListItem or Paragraph, but cannot itself contain any other element. For more information on document structure, see the guide to extending Google Docs.","prototype":{"copy":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"removeFromParent":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"InlineDrawing":{"!url":"http://developers.google.com/apps-script/reference/document/inline-drawing","!doc":"InlineDrawing An element representing an embedded drawing. An InlineDrawing can be contained within a ListItem or Paragraph, unless the ListItem or Paragraph is within a FootnoteSection. An InlineDrawing cannot itself contain any other element. For more information on document structure, see the guide to extending Google Docs.","prototype":{"copy":{"!type":"fn() -> +document.InlineDrawing","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.InlineDrawing","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.InlineDrawing","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.InlineDrawing","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"InlineImage":{"!url":"http://developers.google.com/apps-script/reference/document/inline-image","!doc":"InlineImage An element representing an embedded image. An InlineImage can be contained within a ListItem or Paragraph, unless the ListItem or Paragraph is within a FootnoteSection. An InlineImage cannot itself contain any other element. For more information on document structure, see the guide to extending Google Docs.","prototype":{"copy":{"!type":"fn() -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/document/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/document/#getBlob()","!doc":"Return the data inside this object as a blob."},"getHeight":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getHeight()","!doc":"Retrieves the image's height, in pixels."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link URL."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"getWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getWidth()","!doc":"Retrieves the image's width, in pixels."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setHeight":{"!type":"fn(height: number) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#setHeight(Integer)","!doc":"Sets the image's height, in pixels."},"setLinkUrl":{"!type":"fn(url: string) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link URL."},"setWidth":{"!type":"fn(width: number) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#setWidth(Integer)","!doc":"Sets the image's width, in pixels."}}},"ListItem":{"!url":"http://developers.google.com/apps-script/reference/document/list-item","!doc":"ListItem An element representing a list item. A ListItem is a Paragraph that is associated with a list ID. A ListItem may contain Equation, Footnote, HorizontalRule, InlineDrawing, InlineImage, PageBreak, and Text elements. For more information on document structure, see the guide to extending Google Docs. ListItems may not contain new-line characters. New-line characters (\"\\n\") are converted to line-break characters (\"\\r\"). ListItems with the same list ID belong to the same list and are numbered accordingly. The ListItems for a given list are not required to be adjacent in the document or even have the same parent element. Two items belonging to the same list may exist anywhere in the document while maintaining consecutive numbering, as the following example illustrates: var body = DocumentApp.getActiveDocument().getBody(); // Append a new list item to the body. var item1 = body.appendListItem('Item 1'); // Log the new list item's list ID. Logger.log(item1.getListId()); // Append a table after the list item. body.appendTable([ ['Cell 1', 'Cell 2'] ]); // Append a second list item with the same list ID. The two items are treated as the same list, // despite not being consecutive. var item2 = body.appendListItem('Item 2'); item2.setListId(item1);","prototype":{"appendHorizontalRule":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#appendHorizontalRule()","!doc":"Creates and appends a new HorizontalRule."},"appendInlineImage":{"!type":"fn(image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#appendInlineImage(InlineImage)","!doc":"Appends the given InlineImage."},"appendPageBreak":{"!type":"fn(pageBreak: document.PageBreak) -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#appendPageBreak(PageBreak)","!doc":"Appends the given PageBreak."},"appendText":{"!type":"fn(text: document.Text) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#appendText(Text)","!doc":"Appends the given Text element."},"clear":{"!type":"fn() -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAlignment":{"!type":"fn() -> +document.HorizontalAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getAlignment()","!doc":"Retrieves the HorizontalAlignment."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getGlyphType":{"!type":"fn() -> +document.GlyphType","!url":"http://developers.google.com/apps-script/reference/document/#getGlyphType()","!doc":"Retrieves the list item's GlyphType."},"getHeading":{"!type":"fn() -> +document.ParagraphHeading","!url":"http://developers.google.com/apps-script/reference/document/#getHeading()","!doc":"Retrieves the ParagraphHeading."},"getIndentEnd":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getIndentEnd()","!doc":"Retrieves the end indentation, in points."},"getIndentFirstLine":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getIndentFirstLine()","!doc":"Retrieves the first line indentation, in points."},"getIndentStart":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getIndentStart()","!doc":"Retrieves the start indentation."},"getLineSpacing":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getLineSpacing()","!doc":"Retrieves the line spacing, in points."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getListId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getListId()","!doc":"Retrieves the list ID."},"getNestingLevel":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNestingLevel()","!doc":"Retrieves the list item's nesting level."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getSpacingAfter":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getSpacingAfter()","!doc":"Retrieves the spacing after the element, in points."},"getSpacingBefore":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getSpacingBefore()","!doc":"Retrieves the spacing before the element, in points."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertHorizontalRule":{"!type":"fn(childIndex: number) -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#insertHorizontalRule(Integer)","!doc":"Creates and inserts a HorizontalRule at the specified index."},"insertInlineImage":{"!type":"fn(childIndex: number, image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#insertInlineImage(Integer,InlineImage)","!doc":"Inserts the given InlineImage at the specified index."},"insertPageBreak":{"!type":"fn(childIndex: number, pageBreak: document.PageBreak) -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#insertPageBreak(Integer,PageBreak)","!doc":"Inserts the given PageBreak at the specified index."},"insertText":{"!type":"fn(childIndex: number, text: document.Text) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#insertText(Integer,Text)","!doc":"Inserts the given Text element at the specified index, with the specified text contents."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"isLeftToRight":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isLeftToRight()","!doc":"Retrieves the left-to-right setting."},"merge":{"!type":"fn() -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeChild":{"!type":"fn(child: document.Element) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAlignment":{"!type":"fn(alignment: document.HorizontalAlignment) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setAlignment(HorizontalAlignment)","!doc":"Sets the HorizontalAlignment."},"setAttributes":{"!type":"fn(attributes: object) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setGlyphType":{"!type":"fn(glyphType: document.GlyphType) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setGlyphType(GlyphType)","!doc":"Sets the list item's GlyphType."},"setHeading":{"!type":"fn(heading: document.ParagraphHeading) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setHeading(ParagraphHeading)","!doc":"Sets the ParagraphHeading."},"setIndentEnd":{"!type":"fn(indentEnd: number) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setIndentEnd(Number)","!doc":"Sets the end indentation, in points."},"setIndentFirstLine":{"!type":"fn(indentFirstLine: number) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setIndentFirstLine(Number)","!doc":"Sets the first line indentation, in points."},"setIndentStart":{"!type":"fn(indentStart: number) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setIndentStart(Number)","!doc":"Sets the start indentation, in points."},"setLeftToRight":{"!type":"fn(leftToRight: bool) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setLeftToRight(Boolean)","!doc":"Sets the left-to-right setting."},"setLineSpacing":{"!type":"fn(multiplier: number) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setLineSpacing(Number)","!doc":"Sets the line spacing, as a quantity indicating the number of lines to use for spacing."},"setLinkUrl":{"!type":"fn(url: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setListId":{"!type":"fn(listItem: document.ListItem) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setListId(ListItem)","!doc":"Sets the list ID."},"setNestingLevel":{"!type":"fn(nestingLevel: number) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setNestingLevel(Integer)","!doc":"Sets the list item's nesting level."},"setSpacingAfter":{"!type":"fn(spacingAfter: number) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setSpacingAfter(Number)","!doc":"Sets the spacing after the element, in points."},"setSpacingBefore":{"!type":"fn(spacingBefore: number) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setSpacingBefore(Number)","!doc":"Sets the spacing before the element, in points."},"setText":{"!type":"fn(text: string)","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the contents of the list item as text."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"NamedRange":{"!url":"http://developers.google.com/apps-script/reference/document/named-range","!doc":"NamedRange A Range that has a name and ID to allow later retrieval. Names are not necessarily unique; several different ranges in the same document may share the same name, much like a class in HTML. By contrast, IDs are unique within the document, like an ID in HTML. Once a NamedRange has been added to a document, it cannot be modified, only removed. A NamedRange can be accessed by any script that accesses the document. To avoid unintended conflicts between scripts, consider prefixing range names with a unique string. // Create a named range that includes every table in the document. var doc = DocumentApp.getActiveDocument(); var rangeBuilder = doc.newRange(); var tables = doc.getBody().getTables(); for (var i = 0; i < tables.length; i++) { rangeBuilder.addElement(tables[i]); } doc.addNamedRange('myUniquePrefix-tables', rangeBuilder.build());","prototype":{"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getId()","!doc":"Gets the ID of this NamedRange."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getName()","!doc":"Gets the name of this NamedRange."},"getRange":{"!type":"fn() -> +document.Range","!url":"http://developers.google.com/apps-script/reference/document/#getRange()","!doc":"Gets the range of elements associated with this NamedRange."},"remove":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/document/#remove()","!doc":"Removes this NamedRange from the document."}}},"PageBreak":{"!url":"http://developers.google.com/apps-script/reference/document/page-break","!doc":"PageBreak An element representing a page break. A PageBreak can be contained within a ListItem or Paragraph, unless the ListItem or Paragraph is within a Table, HeaderSection, FooterSection, or FootnoteSection. A PageBreak cannot itself contain any other element. For more information on document structure, see the guide to extending Google Docs.","prototype":{"copy":{"!type":"fn() -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"removeFromParent":{"!type":"fn() -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"Paragraph":{"!url":"http://developers.google.com/apps-script/reference/document/paragraph","!doc":"Paragraph An element representing a paragraph. A Paragraph may contain Equation, Footnote, HorizontalRule, InlineDrawing, InlineImage, PageBreak, and Text elements. For more information on document structure, see the guide to extending Google Docs. Paragraphs may not contain new-line characters. New-line characters (\"\\n\") are converted to line-break characters (\"\\r\"). var body = DocumentApp.getActiveDocument().getBody(); // Append a document header paragraph. var header = body.appendParagraph(\"A Document\"); header.setHeading(DocumentApp.ParagraphHeading.HEADING1); // Append a section header paragraph. var section = body.appendParagraph(\"Section 1\"); section.setHeading(DocumentApp.ParagraphHeading.HEADING2); // Append a regular paragraph. body.appendParagraph(\"This is a typical paragraph.\");","prototype":{"appendHorizontalRule":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#appendHorizontalRule()","!doc":"Creates and appends a new HorizontalRule."},"appendInlineImage":{"!type":"fn(image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#appendInlineImage(InlineImage)","!doc":"Appends the given InlineImage."},"appendPageBreak":{"!type":"fn(pageBreak: document.PageBreak) -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#appendPageBreak(PageBreak)","!doc":"Appends the given PageBreak."},"appendText":{"!type":"fn(text: document.Text) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#appendText(Text)","!doc":"Appends the given Text element."},"clear":{"!type":"fn() -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAlignment":{"!type":"fn() -> +document.HorizontalAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getAlignment()","!doc":"Retrieves the HorizontalAlignment."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getHeading":{"!type":"fn() -> +document.ParagraphHeading","!url":"http://developers.google.com/apps-script/reference/document/#getHeading()","!doc":"Retrieves the ParagraphHeading."},"getIndentEnd":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getIndentEnd()","!doc":"Retrieves the end indentation, in points."},"getIndentFirstLine":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getIndentFirstLine()","!doc":"Retrieves the first line indentation, in points."},"getIndentStart":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getIndentStart()","!doc":"Retrieves the start indentation."},"getLineSpacing":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getLineSpacing()","!doc":"Retrieves the line spacing, in points."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getSpacingAfter":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getSpacingAfter()","!doc":"Retrieves the spacing after the element, in points."},"getSpacingBefore":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getSpacingBefore()","!doc":"Retrieves the spacing before the element, in points."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertHorizontalRule":{"!type":"fn(childIndex: number) -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#insertHorizontalRule(Integer)","!doc":"Creates and inserts a HorizontalRule at the specified index."},"insertInlineImage":{"!type":"fn(childIndex: number, image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#insertInlineImage(Integer,InlineImage)","!doc":"Inserts the given InlineImage at the specified index."},"insertPageBreak":{"!type":"fn(childIndex: number, pageBreak: document.PageBreak) -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#insertPageBreak(Integer,PageBreak)","!doc":"Inserts the given PageBreak at the specified index."},"insertText":{"!type":"fn(childIndex: number, text: document.Text) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#insertText(Integer,Text)","!doc":"Inserts the given Text element at the specified index, with the specified text contents."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"isLeftToRight":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isLeftToRight()","!doc":"Retrieves the left-to-right setting."},"merge":{"!type":"fn() -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeChild":{"!type":"fn(child: document.Element) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAlignment":{"!type":"fn(alignment: document.HorizontalAlignment) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setAlignment(HorizontalAlignment)","!doc":"Sets the HorizontalAlignment."},"setAttributes":{"!type":"fn(attributes: object) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setHeading":{"!type":"fn(heading: document.ParagraphHeading) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setHeading(ParagraphHeading)","!doc":"Sets the ParagraphHeading."},"setIndentEnd":{"!type":"fn(indentEnd: number) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setIndentEnd(Number)","!doc":"Sets the end indentation, in points."},"setIndentFirstLine":{"!type":"fn(indentFirstLine: number) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setIndentFirstLine(Number)","!doc":"Sets the first line indentation, in points."},"setIndentStart":{"!type":"fn(indentStart: number) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setIndentStart(Number)","!doc":"Sets the start indentation, in points."},"setLeftToRight":{"!type":"fn(leftToRight: bool) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setLeftToRight(Boolean)","!doc":"Sets the left-to-right setting."},"setLineSpacing":{"!type":"fn(multiplier: number) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setLineSpacing(Number)","!doc":"Sets the line spacing, as a quantity indicating the number of lines to use for spacing."},"setLinkUrl":{"!type":"fn(url: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setSpacingAfter":{"!type":"fn(spacingAfter: number) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setSpacingAfter(Number)","!doc":"Sets the spacing after the element, in points."},"setSpacingBefore":{"!type":"fn(spacingBefore: number) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setSpacingBefore(Number)","!doc":"Sets the spacing before the element, in points."},"setText":{"!type":"fn(text: string)","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the contents of the paragraph as text."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"Position":{"!url":"http://developers.google.com/apps-script/reference/document/position","!doc":"Position A reference to a location in the document, relative to a specific element. The user's cursor is represented as a Position, among other uses. Scripts can only access the cursor of the user who is running the script, and only if the script is bound to the document. // Insert some text at the cursor position and make it bold. var cursor = DocumentApp.getActiveDocument().getCursor(); if (cursor) { // Attempt to insert text at the cursor position. If the insertion returns null, the cursor's // containing element doesn't allow insertions, so show the user an error message. var element = cursor.insertText('ಠ‿ಠ'); if (element) { element.setBold(true); } else { DocumentApp.getUi().alert('Cannot insert text here.'); } } else { DocumentApp.getUi().alert('Cannot find a cursor.'); }","prototype":{"getElement":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getElement()","!doc":"Gets the element that contains this Position."},"getOffset":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getOffset()","!doc":"Gets this Position's relative location within the element that contains it."},"getSurroundingText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#getSurroundingText()","!doc":"Creates an artificial Text element that represents the text and formatting of the Paragraph or ListItem that contains the Position, either directly or through a chain of child elements."},"getSurroundingTextOffset":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getSurroundingTextOffset()","!doc":"Gets the offset of this Position within the Text element returned by getSurroundingText()."},"insertBookmark":{"!type":"fn() -> +document.Bookmark","!url":"http://developers.google.com/apps-script/reference/document/#insertBookmark()","!doc":"Creates and inserts a new Bookmark at this Position."},"insertInlineImage":{"!type":"fn(image: base.BlobSource) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#insertInlineImage(BlobSource)","!doc":"Creates and inserts a new InlineImage at this Position from the specified image blob."},"insertText":{"!type":"fn(text: string) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#insertText(String)","!doc":"Inserts the specified text at this Position."}}},"Range":{"!url":"http://developers.google.com/apps-script/reference/document/range","!doc":"Range A range of elements in a document. The user's selection is represented as a Range, among other uses. Scripts can only access the selection of the user who is running the script, and only if the script is bound to the document. // Bold all selected text. var selection = DocumentApp.getActiveDocument().getSelection(); if (selection) { var elements = selection.getRangeElements(); for (var i = 0; i < elements.length; i++) { var element = elements[i]; // Only modify elements that can be edited as text; skip images and other non-text elements. if (element.getElement().editAsText) { var text = element.getElement().editAsText(); // Bold the selected part of the element, or the full element if it's completely selected. if (element.isPartial()) { text.setBold(element.getStartOffset(), element.getEndOffsetInclusive(), true); } else { text.setBold(true); } } } }","prototype":{"getRangeElements":{"!type":"fn() -> [+document.RangeElement]","!url":"http://developers.google.com/apps-script/reference/document/#getRangeElements()","!doc":"Gets all elements in this Range, including any partial Text elements (for example, in the case of a selection that includes only part of a Text element)."}}},"RangeBuilder":{"!url":"http://developers.google.com/apps-script/reference/document/range-builder","!doc":"RangeBuilder A builder used to construct RangeBuilder objects from document elements. // Change the user's selection to a range that includes every table in the document. var doc = DocumentApp.getActiveDocument(); var rangeBuilder = doc.newRange(); var tables = doc.getBody().getTables(); for (var i = 0; i < tables.length; i++) { rangeBuilder.addElement(tables[i]); } doc.setSelection(rangeBuilder.build());","prototype":{"addElement":{"!type":"fn(textElement: document.Text, startOffset: number, endOffsetInclusive: number) -> +document.RangeBuilder","!url":"http://developers.google.com/apps-script/reference/document/#addElement(Text,Integer,Integer)","!doc":"Adds a partial Text element to this RangeBuilder."},"addElementsBetween":{"!type":"fn(startTextElement: document.Text, startOffset: number, endTextElementInclusive: document.Text, endOffsetInclusive: number) -> +document.RangeBuilder","!url":"http://developers.google.com/apps-script/reference/document/#addElementsBetween(Text,Integer,Text,Integer)","!doc":"Adds two partial Text elements, and all elements between them, to the RangeBuilder."},"addRange":{"!type":"fn(range: document.Range) -> +document.RangeBuilder","!url":"http://developers.google.com/apps-script/reference/document/#addRange(Range)","!doc":"Adds the contents of another RangeBuilder to this RangeBuilder."},"build":{"!type":"fn() -> +document.Range","!url":"http://developers.google.com/apps-script/reference/document/#build()","!doc":"Constructs a RangeBuilder from the settings applied to the builder."},"getRangeElements":{"!type":"fn() -> [+document.RangeElement]","!url":"http://developers.google.com/apps-script/reference/document/#getRangeElements()","!doc":"Gets all elements in this Range, including any partial Text elements (for example, in the case of a selection that includes only part of a Text element)."}}},"RangeElement":{"!url":"http://developers.google.com/apps-script/reference/document/range-element","!doc":"RangeElement A wrapper around an Element with a possible start and end offset. These offsets allow a range of characters within a Text element to be represented in search results, document selections, and named ranges.","prototype":{"getElement":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getElement()","!doc":"Gets the Element that corresponds to this RangeElement."},"getEndOffsetInclusive":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getEndOffsetInclusive()","!doc":"Gets the position of the end of a partial range within the range element."},"getStartOffset":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getStartOffset()","!doc":"Gets the position of the start of a partial range within the range element."},"isPartial":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isPartial()","!doc":"Determines whether this range element covers the entire element or a partial selection of the element's characters."}}},"Table":{"!url":"http://developers.google.com/apps-script/reference/document/table","!doc":"Table An element representing a table. A Table may only contain TableRow elements. For more information on document structure, see the guide to extending Google Docs. When creating a Table that contains a large number of rows or cells, consider building it from a string array, as shown in the following example. var body = DocumentApp.getActiveDocument().getBody(); // Create a two-dimensional array containing the cell contents. var cells = [ ['Row 1, Cell 1', 'Row 1, Cell 2'], ['Row 2, Cell 1', 'Row 2, Cell 2'] ]; // Build a table from the array. body.appendTable(cells);","prototype":{"appendTableRow":{"!type":"fn(tableRow: document.TableRow) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#appendTableRow(TableRow)","!doc":"Appends the given TableRow."},"clear":{"!type":"fn() -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getBorderColor":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getBorderColor()","!doc":"Retrieves the border color."},"getBorderWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getBorderWidth()","!doc":"Retrieves the border width, in points."},"getCell":{"!type":"fn(rowIndex: number, cellIndex: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#getCell(Integer,Integer)","!doc":"Retrieves the TableCell at the specified row and cell indices."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getColumnWidth":{"!type":"fn(columnIndex: number) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getColumnWidth(Integer)","!doc":"Retrieves the width of the specified table column, in points."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getNumRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumRows()","!doc":"Retrieves the number of TableRows."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getRow":{"!type":"fn(rowIndex: number) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#getRow(Integer)","!doc":"Retrieves the TableRow at the specified row index."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertTableRow":{"!type":"fn(childIndex: number, tableRow: document.TableRow) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#insertTableRow(Integer,TableRow)","!doc":"Inserts the given TableRow at the specified index."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"removeChild":{"!type":"fn(child: document.Element) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"removeRow":{"!type":"fn(rowIndex: number) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#removeRow(Integer)","!doc":"Removes the TableRow at the specified row index."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setBorderColor":{"!type":"fn(color: string) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#setBorderColor(String)","!doc":"Sets the border color."},"setBorderWidth":{"!type":"fn(width: number) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#setBorderWidth(Number)","!doc":"Sets the border width, in points."},"setColumnWidth":{"!type":"fn(columnIndex: number, width: number) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#setColumnWidth(Integer,Number)","!doc":"Sets the width of the specified column, in points."},"setLinkUrl":{"!type":"fn(url: string) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"TableCell":{"!url":"http://developers.google.com/apps-script/reference/document/table-cell","!doc":"TableCell An element representing a table cell. A TableCell is always contained within a TableRow and may contain ListItem, Paragraph, or Table elements. For more information on document structure, see the guide to extending Google Docs.","prototype":{"appendHorizontalRule":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#appendHorizontalRule()","!doc":"Creates and appends a new HorizontalRule."},"appendImage":{"!type":"fn(image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#appendImage(InlineImage)","!doc":"Appends the given InlineImage."},"appendListItem":{"!type":"fn(text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#appendListItem(String)","!doc":"Creates and appends a new ListItem."},"appendParagraph":{"!type":"fn(text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#appendParagraph(String)","!doc":"Creates and appends a new Paragraph."},"appendTable":{"!type":"fn(table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#appendTable(Table)","!doc":"Appends the given Table."},"clear":{"!type":"fn() -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getBackgroundColor":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getBackgroundColor()","!doc":"Retrieves the background color."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getPaddingBottom":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getPaddingBottom()","!doc":"Retrieves the bottom padding, in points."},"getPaddingLeft":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getPaddingLeft()","!doc":"Retrieves the left padding, in points."},"getPaddingRight":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getPaddingRight()","!doc":"Retrieves the right padding, in points."},"getPaddingTop":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getPaddingTop()","!doc":"Retrieves the top padding, in points."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getParentRow":{"!type":"fn() -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#getParentRow()","!doc":"Retrieves the TableRow containing the current TableCell."},"getParentTable":{"!type":"fn() -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#getParentTable()","!doc":"Retrieves the Table containing the current TableCell."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"getVerticalAlignment":{"!type":"fn() -> +document.VerticalAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getVerticalAlignment()","!doc":"Retrieves the VerticalAlignment."},"getWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getWidth()","!doc":"Retrieves the width of the column containing the cell, in points."},"insertHorizontalRule":{"!type":"fn(childIndex: number) -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#insertHorizontalRule(Integer)","!doc":"Creates and inserts a new HorizontalRule at the specified index."},"insertImage":{"!type":"fn(childIndex: number, image: document.InlineImage) -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#insertImage(Integer,InlineImage)","!doc":"Inserts the given InlineImage at the specified index."},"insertListItem":{"!type":"fn(childIndex: number, text: string) -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#insertListItem(Integer,String)","!doc":"Creates and inserts a new ListItem at the specified index."},"insertParagraph":{"!type":"fn(childIndex: number, text: string) -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#insertParagraph(Integer,String)","!doc":"Creates and inserts a new Paragraph at the specified index."},"insertTable":{"!type":"fn(childIndex: number, table: document.Table) -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#insertTable(Integer,Table)","!doc":"Inserts the given Table at the specified index."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeChild":{"!type":"fn(child: document.Element) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setBackgroundColor":{"!type":"fn(color: string) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setBackgroundColor(String)","!doc":"Sets the background color."},"setLinkUrl":{"!type":"fn(url: string) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setPaddingBottom":{"!type":"fn(paddingBottom: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setPaddingBottom(Number)","!doc":"Sets the bottom padding, in points."},"setPaddingLeft":{"!type":"fn(paddingLeft: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setPaddingLeft(Number)","!doc":"Sets the left padding, in points."},"setPaddingRight":{"!type":"fn(paddingTop: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setPaddingRight(Number)","!doc":"Sets the right padding, in points."},"setPaddingTop":{"!type":"fn(paddingTop: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setPaddingTop(Number)","!doc":"Sets the top padding, in points."},"setText":{"!type":"fn(text: string) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the contents as plain text."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."},"setVerticalAlignment":{"!type":"fn(alignment: document.VerticalAlignment) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setVerticalAlignment(VerticalAlignment)","!doc":"Sets the vertical alignment."},"setWidth":{"!type":"fn(width: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#setWidth(Number)","!doc":"Sets the width of the column containing the current cell, in points."}}},"TableOfContents":{"!url":"http://developers.google.com/apps-script/reference/document/table-of-contents","!doc":"TableOfContents An element containing a table of contents. A TableOfContents may contain ListItem, Paragraph, and Table elements, although the contents of a TableOfContents are usually generated automatically by Google Docs. For more information on document structure, see the guide to extending Google Docs.","prototype":{"clear":{"!type":"fn() -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"removeFromParent":{"!type":"fn() -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setLinkUrl":{"!type":"fn(url: string) -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"TableRow":{"!url":"http://developers.google.com/apps-script/reference/document/table-row","!doc":"TableRow An element representing a table row. A TableRow is always contained within a Table and may only contain TableCell elements. For more information on document structure, see the guide to extending Google Docs.","prototype":{"appendTableCell":{"!type":"fn(tableCell: document.TableCell) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#appendTableCell(TableCell)","!doc":"Appends the given TableCell."},"clear":{"!type":"fn() -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#clear()","!doc":"Clears the contents of the element."},"copy":{"!type":"fn() -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findElement":{"!type":"fn(elementType: document.ElementType, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findElement(ElementType,RangeElement)","!doc":"Searches the contents of the element for a descendant of the specified type, starting from the specified RangeElement."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getCell":{"!type":"fn(cellIndex: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#getCell(Integer)","!doc":"Retrieves the TableCell at the specified cell index."},"getChild":{"!type":"fn(childIndex: number) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getChild(Integer)","!doc":"Retrieves the child element at the specified child index."},"getChildIndex":{"!type":"fn(child: document.Element) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getChildIndex(Element)","!doc":"Retrieves the child index for the specified child element."},"getLinkUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl()","!doc":"Retrieves the link url."},"getMinimumHeight":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getMinimumHeight()","!doc":"Retrieves the minimum height, in points."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getNumCells":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumCells()","!doc":"Retrieves the number of cells in the row."},"getNumChildren":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/document/#getNumChildren()","!doc":"Retrieves the number of children."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getParentTable":{"!type":"fn() -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#getParentTable()","!doc":"Retrieves the Table containing the current row."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn() -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment()","!doc":"Gets the text alignment."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertTableCell":{"!type":"fn(childIndex: number, tableCell: document.TableCell) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#insertTableCell(Integer,TableCell)","!doc":"Inserts the given TableCell at the specified index."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeCell":{"!type":"fn(cellIndex: number) -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#removeCell(Integer)","!doc":"Removes the TableCell at the specified cell index."},"removeChild":{"!type":"fn(child: document.Element) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#removeChild(Element)","!doc":"Removes the specified child element."},"removeFromParent":{"!type":"fn() -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setLinkUrl":{"!type":"fn(url: string) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setMinimumHeight":{"!type":"fn(minHeight: number) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#setMinimumHeight(Integer)","!doc":"Sets the minimum height, in points."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."}}},"Text":{"!url":"http://developers.google.com/apps-script/reference/document/text","!doc":"Text An element representing a rich text region. All text in a Document is contained within Text elements. A Text element can be contained within an Equation, EquationFunction, ListItem, or Paragraph, but cannot itself contain any other element. For more information on document structure, see the guide to extending Google Docs. var body = DocumentApp.getActiveDocument().getBody(); // Use editAsText to obtain a single text element containing // all the characters in the document. var text = body.editAsText(); // Insert text at the beginning of the document. text.insertText(0, 'Inserted text.\\n'); // Insert text at the end of the document. text.appendText('\\nAppended text.'); // Make the first half of the document blue. text.setForegroundColor(0, text.getText().length / 2, '#00FFFF');","prototype":{"appendText":{"!type":"fn(text: string) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#appendText(String)","!doc":"Appends the specified text at the given character offset."},"copy":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"deleteText":{"!type":"fn(startOffset: number, endOffsetInclusive: number) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#deleteText(Integer,Integer)","!doc":"Deletes a range of text."},"editAsText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#editAsText()","!doc":"Obtains a Text version of the current element, for editing."},"findText":{"!type":"fn(searchPattern: string, from: document.RangeElement) -> +document.RangeElement","!url":"http://developers.google.com/apps-script/reference/document/#findText(String,RangeElement)","!doc":"Searches the contents of the element for the specified text pattern, starting from a given search result."},"getAttributes":{"!type":"fn(offset: number) -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes(Integer)","!doc":"Retrieves the attributes at the specified character offset."},"getBackgroundColor":{"!type":"fn(offset: number) -> string","!url":"http://developers.google.com/apps-script/reference/document/#getBackgroundColor(Integer)","!doc":"Retrieves the background color at the specified character offset."},"getFontFamily":{"!type":"fn(offset: number) -> +document.FontFamily","!url":"http://developers.google.com/apps-script/reference/document/#getFontFamily(Integer)","!doc":"Retrieves the font family at the specified character offset."},"getFontSize":{"!type":"fn(offset: number) -> number","!url":"http://developers.google.com/apps-script/reference/document/#getFontSize(Integer)","!doc":"Retrieves the font size at the specified character offset."},"getForegroundColor":{"!type":"fn(offset: number) -> string","!url":"http://developers.google.com/apps-script/reference/document/#getForegroundColor(Integer)","!doc":"Retrieves the foreground color at the specified character offset."},"getLinkUrl":{"!type":"fn(offset: number) -> string","!url":"http://developers.google.com/apps-script/reference/document/#getLinkUrl(Integer)","!doc":"Retrieves the link url at the specified character offset."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/document/#getText()","!doc":"Retrieves the contents of the element as a text string."},"getTextAlignment":{"!type":"fn(offset: number) -> +document.TextAlignment","!url":"http://developers.google.com/apps-script/reference/document/#getTextAlignment(Integer)","!doc":"Gets the text alignment for a single character."},"getTextAttributeIndices":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/document/#getTextAttributeIndices()","!doc":"Retrieves the set of text indices that correspond to the start of distinct text formatting runs."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"insertText":{"!type":"fn(offset: number, text: string) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#insertText(Integer,String)","!doc":"Inserts the specified text at the given character offset."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"isBold":{"!type":"fn(offset: number) -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isBold(Integer)","!doc":"Retrieves the bold setting at the specified character offset."},"isItalic":{"!type":"fn(offset: number) -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isItalic(Integer)","!doc":"Retrieves the italic setting at the specified character offset."},"isStrikethrough":{"!type":"fn(offset: number) -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isStrikethrough(Integer)","!doc":"Retrieves the strikethrough setting at the specified character offset."},"isUnderline":{"!type":"fn(offset: number) -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isUnderline(Integer)","!doc":"Retrieves the underline setting at the specified character offset."},"merge":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"replaceText":{"!type":"fn(searchPattern: string, replacement: string) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#replaceText(String,String)","!doc":"Replaces all occurrences of a given text pattern with a given replacement string, using regular expressions."},"setAttributes":{"!type":"fn(attributes: object) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."},"setBackgroundColor":{"!type":"fn(color: string) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setBackgroundColor(String)","!doc":"Sets the background color."},"setBold":{"!type":"fn(startOffset: number, endOffsetInclusive: number, bold: bool) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setBold(Integer,Integer,Boolean)","!doc":"Sets the bold setting for the specified character range."},"setFontFamily":{"!type":"fn(startOffset: number, endOffsetInclusive: number, family: document.FontFamily) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setFontFamily(Integer,Integer,FontFamily)","!doc":"Sets the font family for the specified character range."},"setFontSize":{"!type":"fn(startOffset: number, endOffsetInclusive: number, size: number) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setFontSize(Integer,Integer,Integer)","!doc":"Sets the font size for the specified character range."},"setForegroundColor":{"!type":"fn(color: string) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setForegroundColor(String)","!doc":"Sets the foreground color."},"setItalic":{"!type":"fn(startOffset: number, endOffsetInclusive: number, italic: bool) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setItalic(Integer,Integer,Boolean)","!doc":"Sets the italic setting for the specified character range."},"setLinkUrl":{"!type":"fn(url: string) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setLinkUrl(String)","!doc":"Sets the link url."},"setStrikethrough":{"!type":"fn(startOffset: number, endOffsetInclusive: number, strikethrough: bool) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setStrikethrough(Integer,Integer,Boolean)","!doc":"Sets the strikethrough setting for the specified character range."},"setText":{"!type":"fn(text: string) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setText(String)","!doc":"Sets the text contents."},"setTextAlignment":{"!type":"fn(textAlignment: document.TextAlignment) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setTextAlignment(TextAlignment)","!doc":"Sets the text alignment."},"setUnderline":{"!type":"fn(startOffset: number, endOffsetInclusive: number, underline: bool) -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#setUnderline(Integer,Integer,Boolean)","!doc":"Sets the underline setting for the specified character range."}}},"UnsupportedElement":{"!url":"http://developers.google.com/apps-script/reference/document/unsupported-element","!doc":"UnsupportedElement An element representing a region that is unknown or cannot be affected by a script, such as a page number.","prototype":{"copy":{"!type":"fn() -> +document.UnsupportedElement","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.UnsupportedElement","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.UnsupportedElement","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.UnsupportedElement","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"Element":{"!url":"http://developers.google.com/apps-script/reference/document/element","!doc":"Element A generic element. Document contents are represented as elements. For example, ListItem, Paragraph, and Table are elements and inherit all of the methods defined by Element, such as getType(). Implementing classes NameBrief description BodyAn element representing a document body. ContainerElementA generic element that may contain other elements. EquationAn element representing a mathematical expression. EquationFunctionAn element representing a function in a mathematical Equation. EquationFunctionArgumentSeparatorAn element representing a function separator in a mathematical Equation. EquationSymbolAn element representing a symbol in a mathematical Equation. FooterSectionAn element representing a footer section. FootnoteAn element representing a footnote. FootnoteSectionAn element representing a footnote section. HeaderSectionAn element representing a header section. HorizontalRuleAn element representing an horizontal rule. InlineDrawingAn element representing an embedded drawing. InlineImageAn element representing an embedded image. ListItemAn element representing a list item. PageBreakAn element representing a page break. ParagraphAn element representing a paragraph. TableAn element representing a table. TableCellAn element representing a table cell. TableOfContentsAn element containing a table of contents. TableRowAn element representing a table row. TextAn element representing a rich text region. UnsupportedElementAn element representing a region that is unknown or cannot be affected by a script, such as a page number.","prototype":{"asBody":{"!type":"fn() -> +document.Body","!url":"http://developers.google.com/apps-script/reference/document/#asBody()","!doc":"Returns the current element as a Body."},"asEquation":{"!type":"fn() -> +document.Equation","!url":"http://developers.google.com/apps-script/reference/document/#asEquation()","!doc":"Returns the current element as a Equation."},"asEquationFunction":{"!type":"fn() -> +document.EquationFunction","!url":"http://developers.google.com/apps-script/reference/document/#asEquationFunction()","!doc":"Returns the current element as a EquationFunction."},"asEquationFunctionArgumentSeparator":{"!type":"fn() -> +document.EquationFunctionArgumentSeparator","!url":"http://developers.google.com/apps-script/reference/document/#asEquationFunctionArgumentSeparator()","!doc":"Returns the current element as a EquationFunctionArgumentSeparator."},"asEquationSymbol":{"!type":"fn() -> +document.EquationSymbol","!url":"http://developers.google.com/apps-script/reference/document/#asEquationSymbol()","!doc":"Returns the current element as a EquationSymbol."},"asFooterSection":{"!type":"fn() -> +document.FooterSection","!url":"http://developers.google.com/apps-script/reference/document/#asFooterSection()","!doc":"Returns the current element as a FooterSection."},"asFootnote":{"!type":"fn() -> +document.Footnote","!url":"http://developers.google.com/apps-script/reference/document/#asFootnote()","!doc":"Returns the current element as a Footnote."},"asFootnoteSection":{"!type":"fn() -> +document.FootnoteSection","!url":"http://developers.google.com/apps-script/reference/document/#asFootnoteSection()","!doc":"Returns the current element as a FootnoteSection."},"asHeaderSection":{"!type":"fn() -> +document.HeaderSection","!url":"http://developers.google.com/apps-script/reference/document/#asHeaderSection()","!doc":"Returns the current element as a HeaderSection."},"asHorizontalRule":{"!type":"fn() -> +document.HorizontalRule","!url":"http://developers.google.com/apps-script/reference/document/#asHorizontalRule()","!doc":"Returns the current element as a HorizontalRule."},"asInlineDrawing":{"!type":"fn() -> +document.InlineDrawing","!url":"http://developers.google.com/apps-script/reference/document/#asInlineDrawing()","!doc":"Returns the current element as a InlineDrawing."},"asInlineImage":{"!type":"fn() -> +document.InlineImage","!url":"http://developers.google.com/apps-script/reference/document/#asInlineImage()","!doc":"Returns the current element as a InlineImage."},"asListItem":{"!type":"fn() -> +document.ListItem","!url":"http://developers.google.com/apps-script/reference/document/#asListItem()","!doc":"Returns the current element as a ListItem."},"asPageBreak":{"!type":"fn() -> +document.PageBreak","!url":"http://developers.google.com/apps-script/reference/document/#asPageBreak()","!doc":"Returns the current element as a PageBreak."},"asParagraph":{"!type":"fn() -> +document.Paragraph","!url":"http://developers.google.com/apps-script/reference/document/#asParagraph()","!doc":"Returns the current element as a Paragraph."},"asTable":{"!type":"fn() -> +document.Table","!url":"http://developers.google.com/apps-script/reference/document/#asTable()","!doc":"Returns the current element as a Table."},"asTableCell":{"!type":"fn() -> +document.TableCell","!url":"http://developers.google.com/apps-script/reference/document/#asTableCell()","!doc":"Returns the current element as a TableCell."},"asTableOfContents":{"!type":"fn() -> +document.TableOfContents","!url":"http://developers.google.com/apps-script/reference/document/#asTableOfContents()","!doc":"Returns the current element as a TableOfContents."},"asTableRow":{"!type":"fn() -> +document.TableRow","!url":"http://developers.google.com/apps-script/reference/document/#asTableRow()","!doc":"Returns the current element as a TableRow."},"asText":{"!type":"fn() -> +document.Text","!url":"http://developers.google.com/apps-script/reference/document/#asText()","!doc":"Returns the current element as a Text."},"copy":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#copy()","!doc":"Returns a detached, deep copy of the current element."},"getAttributes":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/document/#getAttributes()","!doc":"Retrieves the element's attributes."},"getNextSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getNextSibling()","!doc":"Retrieves the element's next sibling element."},"getParent":{"!type":"fn() -> +document.ContainerElement","!url":"http://developers.google.com/apps-script/reference/document/#getParent()","!doc":"Retrieves the element's parent element."},"getPreviousSibling":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#getPreviousSibling()","!doc":"Retrieves the element's previous sibling element."},"getType":{"!type":"fn() -> +document.ElementType","!url":"http://developers.google.com/apps-script/reference/document/#getType()","!doc":"Retrieves the element's ElementType."},"isAtDocumentEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/document/#isAtDocumentEnd()","!doc":"Determines whether the element is at the end of the Document."},"merge":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#merge()","!doc":"Merges the element with the preceding sibling of the same type."},"removeFromParent":{"!type":"fn() -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#removeFromParent()","!doc":"Removes the element from its parent."},"setAttributes":{"!type":"fn(attributes: object) -> +document.Element","!url":"http://developers.google.com/apps-script/reference/document/#setAttributes(Object)","!doc":"Sets the element's attributes."}}},"Attribute":{"!url":"http://developers.google.com/apps-script/reference/document/attribute","!doc":"Attribute An enumeration of the element attributes. Use attributes to compose custom styles. For example: // Define a style with yellow background. var highlightStyle = {}; highlightStyle[DocumentApp.Attribute.BACKGROUND_COLOR] = '#FFFF00'; highlightStyle[DocumentApp.Attribute.BOLD] = true; // Insert \"Hello\", highlighted. DocumentApp.getActiveDocument().editAsText() .insertText(0, 'Hello\\n') .setAttributes(0, 4, highlightStyle);","prototype":{"BACKGROUND_COLOR":{"!type":"string","!doc":"The background color of an element (Paragraph, Table, etc) or document."},"BOLD":{"!type":"string","!doc":"The font weight setting, for rich text."},"BORDER_COLOR":{"!type":"string","!doc":"The border color, for table elements."},"BORDER_WIDTH":{"!type":"string","!doc":"The border width in points, for table elements."},"CODE":{"!type":"string","!doc":"The code contents, for equation elements."},"FONT_FAMILY":{"!type":"string","!doc":"The font family setting, for rich text."},"FONT_SIZE":{"!type":"string","!doc":"The font size setting in points, for rich text."},"FOREGROUND_COLOR":{"!type":"string","!doc":"The foreground color setting, for rich text."},"HEADING":{"!type":"string","!doc":"The heading type, for paragraph elements (for example, DocumentApp.ParagraphHeading.HEADING1)."},"HEIGHT":{"!type":"string","!doc":"The height setting, for image elements."},"HORIZONTAL_ALIGNMENT":{"!type":"string","!doc":"The horizontal alignment, for paragraph elements (for example, DocumentApp.HorizontalAlignment.CENTER)."},"INDENT_END":{"!type":"string","!doc":"The end indentation setting in points, for paragraph elements."},"INDENT_FIRST_LINE":{"!type":"string","!doc":"The first line indentation setting in points, for paragraph elements."},"INDENT_START":{"!type":"string","!doc":"The start indentation setting in points, for paragraph elements."},"ITALIC":{"!type":"string","!doc":"The font style setting, for rich text."},"GLYPH_TYPE":{"!type":"string","!doc":"The glyph type, for list item elements."},"LEFT_TO_RIGHT":{"!type":"string","!doc":"The text direction setting, for rich text."},"LINE_SPACING":{"!type":"string","!doc":"The line spacing setting as a multiplier, for paragraph elements."},"LINK_URL":{"!type":"string","!doc":"The link URL, for rich text. The default link style (foreground color, underline) is automatically applied."},"LIST_ID":{"!type":"string","!doc":"The ID of the encompassing list, for list item elements."},"MARGIN_BOTTOM":{"!type":"string","!doc":"The bottom margin setting in points, for paragraph elements."},"MARGIN_LEFT":{"!type":"string","!doc":"The left margin setting in points, for paragraph elements."},"MARGIN_RIGHT":{"!type":"string","!doc":"The right margin setting in points, for paragraph elements."},"MARGIN_TOP":{"!type":"string","!doc":"The top margin setting in points, for paragraph elements."},"NESTING_LEVEL":{"!type":"string","!doc":"The item nesting level, for list item elements."},"MINIMUM_HEIGHT":{"!type":"string","!doc":"The minimum height setting in points, for table row elements."},"PADDING_BOTTOM":{"!type":"string","!doc":"The bottom padding setting in points, for table cell elements."},"PADDING_LEFT":{"!type":"string","!doc":"The left padding setting in points, for table cell elements."},"PADDING_RIGHT":{"!type":"string","!doc":"The right padding setting in points, for table cell elements."},"PADDING_TOP":{"!type":"string","!doc":"The top padding setting in points, for table cell elements."},"PAGE_HEIGHT":{"!type":"string","!doc":"The page height setting in points, for documents."},"PAGE_WIDTH":{"!type":"string","!doc":"The page width setting in points, for documents."},"SPACING_AFTER":{"!type":"string","!doc":"The bottom spacing setting in points, for paragraph elements."},"SPACING_BEFORE":{"!type":"string","!doc":"The top spacing setting in points, for paragraph elements."},"STRIKETHROUGH":{"!type":"string","!doc":"The strike-through setting, for rich text."},"UNDERLINE":{"!type":"string","!doc":"The underline setting, for rich text."},"VERTICAL_ALIGNMENT":{"!type":"string","!doc":"The vertical alignment setting, for table cell elements."},"WIDTH":{"!type":"string","!doc":"The width setting, for table cell and image elements."}}},"ElementType":{"!url":"http://developers.google.com/apps-script/reference/document/element-type","!doc":"ElementType An enumeration of all the element types. Use the ElementType enumeration to check the type of a given element, for instance: var firstChild = DocumentApp.getActiveDocument().getBody().getChild(0); if (firstChild.getType() == DocumentApp.ElementType.PARAGRAPH) { // It's a paragraph, apply a paragraph heading. firstChild.asParagraph().setHeading(DocumentApp.ParagraphHeading.HEADING1); }","prototype":{"BODY_SECTION":{"!type":"string","!doc":"The type corresponding to the Body element."},"COMMENT_SECTION":{"!type":"string","!doc":"The type corresponding to the CommentSection element."},"DOCUMENT":{"!type":"string","!doc":"The type that corresponds to the root of the document."},"EQUATION":{"!type":"string","!doc":"The type corresponding to the Equation element."},"EQUATION_FUNCTION":{"!type":"string","!doc":"The type corresponding to the EquationFunction element."},"EQUATION_FUNCTION_ARGUMENT_SEPARATOR":{"!type":"string","!doc":"The type corresponding to the EquationFunctionArgumentSeparator element."},"EQUATION_SYMBOL":{"!type":"string","!doc":"The type corresponding to the EquationSymbol element."},"FOOTER_SECTION":{"!type":"string","!doc":"The type corresponding to the FooterSection element."},"FOOTNOTE":{"!type":"string","!doc":"The type corresponding to the Footnote element."},"FOOTNOTE_SECTION":{"!type":"string","!doc":"The type corresponding to the FootnoteSection element."},"HEADER_SECTION":{"!type":"string","!doc":"The type corresponding to the HeaderSection element."},"HORIZONTAL_RULE":{"!type":"string","!doc":"The type corresponding to the HorizontalRule element."},"INLINE_DRAWING":{"!type":"string","!doc":"The type corresponding to the InlineDrawing element."},"INLINE_IMAGE":{"!type":"string","!doc":"The type corresponding to the InlineImage element."},"LIST_ITEM":{"!type":"string","!doc":"The type corresponding to the ListItem element."},"PAGE_BREAK":{"!type":"string","!doc":"The type corresponding to the PageBreak element."},"PARAGRAPH":{"!type":"string","!doc":"The type corresponding to the Paragraph element."},"TABLE":{"!type":"string","!doc":"The type corresponding to the Table element."},"TABLE_CELL":{"!type":"string","!doc":"The type corresponding to the TableCell element."},"TABLE_OF_CONTENTS":{"!type":"string","!doc":"The type corresponding to the TableOfContents element."},"TABLE_ROW":{"!type":"string","!doc":"The type corresponding to the TableRow element."},"TEXT":{"!type":"string","!doc":"The type corresponding to the Text element."},"UNSUPPORTED":{"!type":"string","!doc":"The type corresponding to UnsupportedElement. Unsupported elements represent document portions that do not support scripting."}}},"FontFamily":{"!url":"http://developers.google.com/apps-script/reference/document/font-family","!doc":"FontFamily An enumeration of the supported fonts. Use the FontFamily enumeration to set the font for a range of text, element or document. var body = DocumentApp.getActiveDocument().getBody(); // Insert a paragraph at the start of the document. body.insertParagraph(0, \"Hello, Apps Script!\"); // Set the document font to Calibri. body.editAsText().setFontFamily(DocumentApp.FontFamily.CALIBRI); // Set the first paragraph font to Arial. body.getParagraphs()[0].setFontFamily(DocumentApp.FontFamily.ARIAL); // Set \"Apps Script\" to Comic Sans MS. var text = 'Apps Script'; var a = body.getText().indexOf(text); var b = a + text.length - 1; body.editAsText().setFontFamily(a, b, DocumentApp.FontFamily.COMIC_SANS_MS);","prototype":{"AMARANTH":{"!type":"string","!doc":"The Amaranth font family."},"ARIAL":{"!type":"string","!doc":"The Arial font family."},"ARIAL_BLACK":{"!type":"string","!doc":"The Arial Black font family."},"ARIAL_NARROW":{"!type":"string","!doc":"The Arial Narrow font family."},"ARVO":{"!type":"string","!doc":"The Arvo font family."},"CALIBRI":{"!type":"string","!doc":"The Calibri font family."},"CAMBRIA":{"!type":"string","!doc":"The Cambria font family."},"COMIC_SANS_MS":{"!type":"string","!doc":"The Comic Sans MS font family."},"CONSOLAS":{"!type":"string","!doc":"The Consolas font family."},"CORSIVA":{"!type":"string","!doc":"The Corsiva font family."},"COURIER_NEW":{"!type":"string","!doc":"The Courier New font family."},"DANCING_SCRIPT":{"!type":"string","!doc":"The Dancing Script font family."},"DROID_SANS":{"!type":"string","!doc":"The Droid Sans font family."},"DROID_SERIF":{"!type":"string","!doc":"The Droid Serif font family."},"GARAMOND":{"!type":"string","!doc":"The Garamond font family."},"GEORGIA":{"!type":"string","!doc":"The Georgia font family."},"LOBSTER":{"!type":"string","!doc":"The Lobster font family."},"MERRIWEATHER":{"!type":"string","!doc":"The Merriweather font family."},"PHILOSOPHER":{"!type":"string","!doc":"The Philosopher font family."},"QUATTROCENTO":{"!type":"string","!doc":"The Quattrocento font family."},"SYNCOPATE":{"!type":"string","!doc":"The Syncopate font family."},"TAHOMA":{"!type":"string","!doc":"The Tahoma font family."},"TIMES_NEW_ROMAN":{"!type":"string","!doc":"The Times New Roman font family."},"TREBUCHET_MS":{"!type":"string","!doc":"The Trebuchet MS font family."},"UBUNTU":{"!type":"string","!doc":"The Ubuntu font family."},"VERDANA":{"!type":"string","!doc":"The Verdana font family."}}},"GlyphType":{"!url":"http://developers.google.com/apps-script/reference/document/glyph-type","!doc":"GlyphType An enumeration of the supported glyph types. Use the GlyphType enumeration to set the bullet type for list items. var body = DocumentApp.getActiveDocument().getBody(); // Insert at list item, with the default nesting level of zero. body.appendListItem(\"Item 1\"); // Append a second list item, with a nesting level of one, indented one inch. // The two items will have different bullet glyphs. body.appendListItem(\"Item 2\").setNestingLevel(1).setIndentStart(72);","prototype":{"BULLET":{"!type":"string","!doc":"The default bullet, circular and filled."},"HOLLOW_BULLET":{"!type":"string","!doc":"A hollow bullet."},"SQUARE_BULLET":{"!type":"string","!doc":"A square bullet."},"NUMBER":{"!type":"string","!doc":"A number based bullet."},"LATIN_UPPER":{"!type":"string","!doc":"A latin, uppercase bullet."},"LATIN_LOWER":{"!type":"string","!doc":"A latin, lowercase bullet."},"ROMAN_UPPER":{"!type":"string","!doc":"A roman numeral, uppercase bullet."},"ROMAN_LOWER":{"!type":"string","!doc":"A roman numeral, lowercase bullet."}}},"HorizontalAlignment":{"!url":"http://developers.google.com/apps-script/reference/document/horizontal-alignment","!doc":"HorizontalAlignment An enumeration of the supported horizontal alignment types. Use the HorizontalAlignment enumeration to manipulate the alignment of Paragraph contents. var body = DocumentApp.getActiveDocument().getBody(); // Insert a paragraph and a table at the start of document. var par1 = body.insertParagraph(0, \"Center\"); var table = body.insertTable(1, [['Left', 'Right']]); var par2 = table.getCell(0, 0).getChild(0).asParagraph(); var par3 = table.getCell(0, 0).getChild(0).asParagraph(); // Center align the first paragraph. par1.setAlignment(DocumentApp.HorizontalAlignment.CENTER); // Left align the first cell. par2.setAlignment(DocumentApp.HorizontalAlignment.LEFT); // Right align the second cell. par3.setAlignment(DocumentApp.HorizontalAlignment.RIGHT);","prototype":{"LEFT":{"!type":"string","!doc":"The left-alignment option."},"CENTER":{"!type":"string","!doc":"The center-alignment option."},"RIGHT":{"!type":"string","!doc":"The right-alignment option."},"JUSTIFY":{"!type":"string","!doc":"The justify-alignment option."}}},"ParagraphHeading":{"!url":"http://developers.google.com/apps-script/reference/document/paragraph-heading","!doc":"ParagraphHeading An enumeration of the standard paragraph headings. Use the ParagraphHeading enumeration to configure the heading style for ParagraphElement. var body = DocumentApp.getActiveDocument().getBody(); // Append a paragraph, with heading 1. var par1 = body.appendParagraph(\"Title\"); par1.setHeading(DocumentApp.ParagraphHeading.HEADING1); // Append a paragraph, with heading 2. var par2 = body.appendParagraph(\"SubTitle\"); par2.setHeading(DocumentApp.ParagraphHeading.HEADING2); // Append a paragraph, with normal heading. var par3 = body.appendParagraph(\"Text\"); par3.setHeading(DocumentApp.ParagraphHeading.NORMAL);","prototype":{"NORMAL":{"!type":"string","!doc":"The heading option for normal text."},"HEADING1":{"!type":"string","!doc":"The highest heading option."},"HEADING2":{"!type":"string","!doc":"The second heading option."},"HEADING3":{"!type":"string","!doc":"The third heading option"},"HEADING4":{"!type":"string","!doc":"The fourth heading option."},"HEADING5":{"!type":"string","!doc":"The fifth heading option."},"HEADING6":{"!type":"string","!doc":"The lowest heading option."},"TITLE":{"!type":"string","!doc":"The title heading option."},"SUBTITLE":{"!type":"string","!doc":"The subtitle heading option."}}},"TextAlignment":{"!url":"http://developers.google.com/apps-script/reference/document/text-alignment","!doc":"TextAlignment An enumeration of the type of text alignments. // Make the first character in the first paragraph be superscript. var text = DocumentApp.getActiveDocument().getBody().getParagraphs()[0].editAsText(); text.setTextAlignment(0, 0, DocumentApp.TextAlignment.SUPERSCRIPT);","prototype":{"NORMAL":{"!type":"string","!doc":"The normal text alignment."},"SUPERSCRIPT":{"!type":"string","!doc":"The superscript text alignment."},"SUBSCRIPT":{"!type":"string","!doc":"The subscript text alignment."}}},"VerticalAlignment":{"!url":"http://developers.google.com/apps-script/reference/document/vertical-alignment","!doc":"VerticalAlignment An enumeration of the supported vertical alignment types. Use the VerticalAlignment enumeration to set the vertical alignment of table cells. var body = DocumentApp.getActiveDocument().getBody(); // Append table containing two cells. var table = body.appendTable([['Top', 'Center', 'Bottom']]); // Align the first cell's contents to the top. table.getCell(0, 0).setVerticalAlignment(DocumentApp.VerticalAlignment.TOP); // Align the second cell's contents to the center. table.getCell(0, 1).setVerticalAlignment(DocumentApp.VerticalAlignment.CENTER); // Align the third cell's contents to the bottom. table.getCell(0, 2).setVerticalAlignment(DocumentApp.VerticalAlignment.BOTTOM);","prototype":{"BOTTOM":{"!type":"string","!doc":"The bottom-alignment option."},"CENTER":{"!type":"string","!doc":"The center-alignment option."},"TOP":{"!type":"string","!doc":"The top-alignment option."}}}},"drive":{"File":{"!url":"http://developers.google.com/apps-script/reference/drive/file","!doc":"File A file in Google Drive. Files can be accessed or created from DriveApp. // Trash every untitled spreadsheet that hasn't been updated in a week. var files = DriveApp.getFilesByName('Untitled spreadsheet'); while (files.hasNext()) { var file = files.next(); if (new Date() - file.getLastUpdated() > 7 * 24 * 60 * 60 * 1000) { file.setTrashed(true); } }","prototype":{"addCommenter":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#addCommenter(User)","!doc":"Add the given user to the list of commenters for the File."},"addCommenters":{"!type":"fn(emailAddresses: [string]) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#addCommenters(String)","!doc":"Add the given array of users to the list of commenters for the File."},"addEditor":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#addEditor(User)","!doc":"Adds the given user to the list of editors for the File."},"addEditors":{"!type":"fn(emailAddresses: [string]) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the File."},"addViewer":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#addViewer(User)","!doc":"Adds the given user to the list of viewers for the File."},"addViewers":{"!type":"fn(emailAddresses: [string]) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#addViewers(String)","!doc":"Adds the given array of users to the list of viewers for the File."},"getAccess":{"!type":"fn(user: base.User) -> +drive.Permission","!url":"http://developers.google.com/apps-script/reference/drive/#getAccess(User)","!doc":"Gets the permission granted to the given user."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/drive/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/drive/#getBlob()","!doc":"Return the data inside this object as a blob."},"getDateCreated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/drive/#getDateCreated()","!doc":"Gets the date the File was created."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getDescription()","!doc":"Gets the description for the File."},"getDownloadUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getDownloadUrl()","!doc":"Gets the URL that can be used to download the file."},"getEditors":{"!type":"fn() -> [+drive.User]","!url":"http://developers.google.com/apps-script/reference/drive/#getEditors()","!doc":"Gets the list of editors for this File."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getId()","!doc":"Gets the ID of the File."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/drive/#getLastUpdated()","!doc":"Gets the date the File was last updated."},"getMimeType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getMimeType()","!doc":"Gets the MIME type of the file."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getName()","!doc":"Gets the name of the File."},"getOwner":{"!type":"fn() -> +drive.User","!url":"http://developers.google.com/apps-script/reference/drive/#getOwner()","!doc":"Gets the owner of the File."},"getParents":{"!type":"fn() -> +drive.FolderIterator","!url":"http://developers.google.com/apps-script/reference/drive/#getParents()","!doc":"Gets a collection of folders that are immediate parents of the File."},"getSharingAccess":{"!type":"fn() -> +drive.Access","!url":"http://developers.google.com/apps-script/reference/drive/#getSharingAccess()","!doc":"Gets which class of users can access the File, besides any individual users who have been explicitly given access."},"getSharingPermission":{"!type":"fn() -> +drive.Permission","!url":"http://developers.google.com/apps-script/reference/drive/#getSharingPermission()","!doc":"Gets the permission granted to those users who can access the File, besides any individual users who have been explicitly given access."},"getSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/drive/#getSize()","!doc":"Gets the number of bytes used to store the File in Drive."},"getThumbnail":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/drive/#getThumbnail()","!doc":"Gets a thumbnail image for the file, or null if no thumbnail exists."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getUrl()","!doc":"Gets the URL that can be used to open the File in a Google App like Drive or Docs."},"getViewers":{"!type":"fn() -> [+drive.User]","!url":"http://developers.google.com/apps-script/reference/drive/#getViewers()","!doc":"Gets the list of viewers and commenters for this File."},"isShareableByEditors":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#isShareableByEditors()","!doc":"Determines whether users with edit permissions to the File are allowed to share with other users or change the permissions."},"isStarred":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#isStarred()","!doc":"Determines whether the File has been starred in the user's Drive."},"isTrashed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#isTrashed()","!doc":"Determines whether the File is in the trash of the user's Drive."},"makeCopy":{"!type":"fn(name: string, destination: drive.Folder) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#makeCopy(String,Folder)","!doc":"Creates a copy of the file in the destination directory and names it with the name provided."},"removeCommenter":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#removeCommenter(User)","!doc":"Removes the given user from the list of commenters for the File."},"removeEditor":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the File."},"removeViewer":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#removeViewer(User)","!doc":"Removes the given user from the list of viewers and commenters for the File."},"revokePermissions":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#revokePermissions(User)","!doc":"Revokes the access to the File granted to the given user."},"setContent":{"!type":"fn(content: string) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setContent(String)","!doc":"Overwrites the content of the file with a given replacement."},"setDescription":{"!type":"fn(description: string) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setDescription(String)","!doc":"Sets the description for the File."},"setName":{"!type":"fn(name: string) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setName(String)","!doc":"Sets the name of the File."},"setOwner":{"!type":"fn(user: base.User) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setOwner(User)","!doc":"Changes the owner of the File."},"setShareableByEditors":{"!type":"fn(shareable: bool) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setShareableByEditors(Boolean)","!doc":"Sets whether users with edit permissions to the File are allowed to share with other users or change the permissions."},"setSharing":{"!type":"fn(accessType: drive.Access, permissionType: drive.Permission) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setSharing(Access,Permission)","!doc":"Sets which class of users can access the File and what permissions those users are granted, besides any individual users who have been explicitly given access."},"setStarred":{"!type":"fn(starred: bool) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setStarred(Boolean)","!doc":"Sets whether the File is starred in the user's Drive."},"setTrashed":{"!type":"fn(trashed: bool) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#setTrashed(Boolean)","!doc":"Sets whether the File is in the trash of the user's Drive."}}},"FileIterator":{"!url":"http://developers.google.com/apps-script/reference/drive/file-iterator","!doc":"FileIterator An iterator that allows scripts to iterate over a potentially large collection of files. File iterators can be acccessed from DriveApp or a Folder. // Log the name of every file in the user's Drive. var files = DriveApp.getFiles(); while (files.hasNext()) { var file = files.next(); Logger.log(file.getName()); }","prototype":{"getContinuationToken":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getContinuationToken()","!doc":"Gets a token that can be used to resume this iteration at a later time."},"hasNext":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#hasNext()","!doc":"Determines whether calling next() will return an item."},"next":{"!type":"fn() -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#next()","!doc":"Gets the next item in the collection of files or folders."}}},"Folder":{"!url":"http://developers.google.com/apps-script/reference/drive/folder","!doc":"Folder A folder in Google Drive. Folders can be accessed or created from DriveApp. // Log the name of every folder in the user's Drive. var folders = DriveApp.getFolders(); while (folders.hasNext()) { var folder = folders.next(); Logger.log(folder.getName()); }","prototype":{"addEditor":{"!type":"fn(user: base.User) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#addEditor(User)","!doc":"Adds the given user to the list of editors for the Folder."},"addEditors":{"!type":"fn(emailAddresses: [string]) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the Folder."},"addFile":{"!type":"fn(child: drive.File) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#addFile(File)","!doc":"Adds the given file to the current folder."},"addFolder":{"!type":"fn(child: drive.Folder) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#addFolder(Folder)","!doc":"Adds the given folder to the current folder."},"addViewer":{"!type":"fn(user: base.User) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#addViewer(User)","!doc":"Adds the given user to the list of viewers for the Folder."},"addViewers":{"!type":"fn(emailAddresses: [string]) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#addViewers(String)","!doc":"Adds the given array of users to the list of viewers for the Folder."},"createFile":{"!type":"fn(name: string, content: string, mimeType: string) -> +drive.File","!url":"http://developers.google.com/apps-script/reference/drive/#createFile(String,String,String)","!doc":"Creates a file in the current folder with the given name, contents, and MIME type."},"createFolder":{"!type":"fn(name: string) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#createFolder(String)","!doc":"Creates a folder in the current folder with the given name."},"getAccess":{"!type":"fn(user: base.User) -> +drive.Permission","!url":"http://developers.google.com/apps-script/reference/drive/#getAccess(User)","!doc":"Gets the permission granted to the given user."},"getDateCreated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/drive/#getDateCreated()","!doc":"Gets the date the Folder was created."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getDescription()","!doc":"Gets the description for the Folder."},"getEditors":{"!type":"fn() -> [+drive.User]","!url":"http://developers.google.com/apps-script/reference/drive/#getEditors()","!doc":"Gets the list of editors for this Folder."},"getFiles":{"!type":"fn() -> +drive.FileIterator","!url":"http://developers.google.com/apps-script/reference/drive/#getFiles()","!doc":"Gets a collection of all files that are children of the current folder."},"getFilesByName":{"!type":"fn(name: string) -> +drive.FileIterator","!url":"http://developers.google.com/apps-script/reference/drive/#getFilesByName(String)","!doc":"Gets a collection of all files that are children of the current folder and have the given name."},"getFilesByType":{"!type":"fn(mimeType: string) -> +drive.FileIterator","!url":"http://developers.google.com/apps-script/reference/drive/#getFilesByType(String)","!doc":"Gets a collection of all files that are children of the current folder and have the given MIME type."},"getFolders":{"!type":"fn() -> +drive.FolderIterator","!url":"http://developers.google.com/apps-script/reference/drive/#getFolders()","!doc":"Gets a collection of all folders that are children of the current folder."},"getFoldersByName":{"!type":"fn(name: string) -> +drive.FolderIterator","!url":"http://developers.google.com/apps-script/reference/drive/#getFoldersByName(String)","!doc":"Gets a collection of all folders that are children of the current folder and have the given name."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getId()","!doc":"Gets the ID of the Folder."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/drive/#getLastUpdated()","!doc":"Gets the date the Folder was last updated."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getName()","!doc":"Gets the name of the Folder."},"getOwner":{"!type":"fn() -> +drive.User","!url":"http://developers.google.com/apps-script/reference/drive/#getOwner()","!doc":"Gets the owner of the Folder."},"getParents":{"!type":"fn() -> +drive.FolderIterator","!url":"http://developers.google.com/apps-script/reference/drive/#getParents()","!doc":"Gets a collection of folders that are immediate parents of the Folder."},"getSharingAccess":{"!type":"fn() -> +drive.Access","!url":"http://developers.google.com/apps-script/reference/drive/#getSharingAccess()","!doc":"Gets which class of users can access the Folder, besides any individual users who have been explicitly given access."},"getSharingPermission":{"!type":"fn() -> +drive.Permission","!url":"http://developers.google.com/apps-script/reference/drive/#getSharingPermission()","!doc":"Gets the permission granted to those users who can access the Folder, besides any individual users who have been explicitly given access."},"getSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/drive/#getSize()","!doc":"Gets the number of bytes used to store the Folder in Drive."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getUrl()","!doc":"Gets the URL that can be used to open the Folder in a Google App like Drive or Docs."},"getViewers":{"!type":"fn() -> [+drive.User]","!url":"http://developers.google.com/apps-script/reference/drive/#getViewers()","!doc":"Gets the list of viewers and commenters for this Folder."},"isShareableByEditors":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#isShareableByEditors()","!doc":"Determines whether users with edit permissions to the Folder are allowed to share with other users or change the permissions."},"isStarred":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#isStarred()","!doc":"Determines whether the Folder has been starred in the user's Drive."},"isTrashed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#isTrashed()","!doc":"Determines whether the Folder is in the trash of the user's Drive."},"removeEditor":{"!type":"fn(user: base.User) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the Folder."},"removeFile":{"!type":"fn(child: drive.File) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#removeFile(File)","!doc":"Removes the given file from the current folder."},"removeFolder":{"!type":"fn(child: drive.Folder) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#removeFolder(Folder)","!doc":"Removes the given folder from the current folder."},"removeViewer":{"!type":"fn(user: base.User) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#removeViewer(User)","!doc":"Removes the given user from the list of viewers and commenters for the Folder."},"revokePermissions":{"!type":"fn(user: base.User) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#revokePermissions(User)","!doc":"Revokes the access to the Folder granted to the given user."},"searchFiles":{"!type":"fn(params: string) -> +drive.FileIterator","!url":"http://developers.google.com/apps-script/reference/drive/#searchFiles(String)","!doc":"Gets a collection of all files that are children of the current folder and match the given search criteria."},"searchFolders":{"!type":"fn(params: string) -> +drive.FolderIterator","!url":"http://developers.google.com/apps-script/reference/drive/#searchFolders(String)","!doc":"Gets a collection of all folders that are children of the current folder and match the given search criteria."},"setDescription":{"!type":"fn(description: string) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#setDescription(String)","!doc":"Sets the description for the Folder."},"setName":{"!type":"fn(name: string) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#setName(String)","!doc":"Sets the name of the Folder."},"setOwner":{"!type":"fn(user: base.User) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#setOwner(User)","!doc":"Changes the owner of the Folder."},"setShareableByEditors":{"!type":"fn(shareable: bool) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#setShareableByEditors(Boolean)","!doc":"Sets whether users with edit permissions to the Folder are allowed to share with other users or change the permissions."},"setSharing":{"!type":"fn(accessType: drive.Access, permissionType: drive.Permission) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#setSharing(Access,Permission)","!doc":"Sets which class of users can access the Folder and what permissions those users are granted, besides any individual users who have been explicitly given access."},"setStarred":{"!type":"fn(starred: bool) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#setStarred(Boolean)","!doc":"Sets whether the Folder is starred in the user's Drive."},"setTrashed":{"!type":"fn(trashed: bool) -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#setTrashed(Boolean)","!doc":"Sets whether the Folder is in the trash of the user's Drive."}}},"FolderIterator":{"!url":"http://developers.google.com/apps-script/reference/drive/folder-iterator","!doc":"FolderIterator An object that allows scripts to iterate over a potentially large collection of folders. Folder iterators can be acccessed from DriveApp, a File, or a Folder. // Log the name of every folder in the user's Drive. var folders = DriveApp.getFolders(); while (folders.hasNext()) { var folder = folders.next(); Logger.log(folder.getName()); }","prototype":{"getContinuationToken":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getContinuationToken()","!doc":"Gets a token that can be used to resume this iteration at a later time."},"hasNext":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/drive/#hasNext()","!doc":"Determines whether calling next() will return an item."},"next":{"!type":"fn() -> +drive.Folder","!url":"http://developers.google.com/apps-script/reference/drive/#next()","!doc":"Gets the next item in the collection of files or folders."}}},"User":{"!url":"http://developers.google.com/apps-script/reference/drive/user","!doc":"User A user associated with a file in Google Drive. Users can be accessed from File.getEditors(), Folder.getViewers(), and other methods. // Log the email address of all users who have edit access to a file. var file = DriveApp.getFileById('1234567890abcdefghijklmnopqrstuvwxyz'); var editors = file.getEditors(); for (var i = 0; i < editors.length; i++) { Logger.log(editors[i].getEmail()); }","prototype":{"getDomain":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getDomain()","!doc":"Gets the domain name associated with the user's account."},"getEmail":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getEmail()","!doc":"Gets the user's email address."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getName()","!doc":"Gets the user's name."},"getPhotoUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/drive/#getPhotoUrl()","!doc":"Gets the URL for the user's photo."}}},"Access":{"!url":"http://developers.google.com/apps-script/reference/drive/access","!doc":"Access An enum representing classes of users who can access a file or folder, besides any individual users who have been explicitly given access. These properties can be accessed from DriveApp.Access. // Creates a folder that anyone on the Internet can read from and write to. (Domain // administrators can prohibit this setting for users of Google Apps for Business, Google Apps // for Education, or Google Apps for Your Domain.) var folder = DriveApp.createFolder('Shared Folder'); folder.setSharing(DriveApp.Access.ANYONE, DriveApp.Permission.EDIT);","prototype":{"ANYONE":{"!type":"string","!doc":"Anyone on the Internet can find and access. No sign-in required. Domain administrators can prohibit this setting for users of Google Apps for Business, Google Apps for Education, or Google Apps for Your Domain. If the setting is disabled, passing this value to File.setSharing(accessType, permissionType) throws an exception."},"ANYONE_WITH_LINK":{"!type":"string","!doc":"Anyone who has the link can access. No sign-in required. Domain administrators can prohibit this setting for users of Google Apps for Business, Google Apps for Education, or Google Apps for Your Domain. If the setting is disabled, passing this value to File.setSharing(accessType, permissionType) throws an exception."},"DOMAIN":{"!type":"string","!doc":"People in your domain can find and access. Sign-in required. This setting is available only for users of Google Apps for Business, Google Apps for Education, or Google Apps for Your Domain. For other types of Google accounts, passing this value to File.setSharing(accessType, permissionType) throws an exception."},"DOMAIN_WITH_LINK":{"!type":"string","!doc":"People in your domain who have the link can access. Sign-in required. This setting is available only for users of Google Apps for Business, Google Apps for Education, or Google Apps for Your Domain. For other types of Google accounts, passing this value to File.setSharing(accessType, permissionType) throws an exception."},"PRIVATE":{"!type":"string","!doc":"Only people explicitly granted permission can access. Sign-in required."}}},"Permission":{"!url":"http://developers.google.com/apps-script/reference/drive/permission","!doc":"Permission An enum representing the permissions granted to users who can access a file or folder, besides any individual users who have been explicitly given access. These properties can be accessed from DriveApp.Permission. // Creates a folder that anyone on the Internet can read from and write to. (Domain // administrators can prohibit this setting for users of Google Apps for Business, Google Apps // for Education, or Google Apps for Your Domain.) var folder = DriveApp.createFolder('Shared Folder'); folder.setSharing(DriveApp.Access.ANYONE, DriveApp.Permission.EDIT);","prototype":{"VIEW":{"!type":"string","!doc":"Users who can access the file or folder are able only to view it or copy it. Passing this value to File.setSharing(accessType, permissionType) throws an exception if the type of file does not support it."},"EDIT":{"!type":"string","!doc":"Users who can access the file or folder are able to edit it. Unless File.setShareableByEditors(shareable) is set to false, users can also change the sharing settings. Passing this value to File.setSharing(accessType, permissionType) throws an exception if the type of file does not support it."},"COMMENT":{"!type":"string","!doc":"Users who can access the file or folder are able only to view it, copy it, or comment on it. Passing this value to File.setSharing(accessType, permissionType) throws an exception if the type of file does not support it."},"OWNER":{"!type":"string","!doc":"The user owns the file or folder. This value can be returned, but passing it to File.setSharing(accessType, permissionType) throws an exception."},"NONE":{"!type":"string","!doc":"The user does not have any permissions for the file or folder. This value can be returned, but passing it to File.setSharing(accessType, permissionType) throws an exception unless it is set in combination with Access.ANYONE."}}}},"forms":{"CheckboxItem":{"!url":"http://developers.google.com/apps-script/reference/forms/checkbox-item","!doc":"CheckboxItem A question item that allows the respondent to select one or more checkboxes, as well as an optional \"other\" field. Items can be accessed or created from a Form. // Open a form by ID and add a new checkbox item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addCheckboxItem(); item.setTitle('What condiments would you like on your hot dog?') .setChoices([ item.createChoice('Ketchup'), item.createChoice('Mustard'), item.createChoice('Relish') ]) .showOtherOption(true);","prototype":{"createChoice":{"!type":"fn(value: string) -> +forms.Choice","!url":"http://developers.google.com/apps-script/reference/forms/#createChoice(String)","!doc":"Creates a new choice."},"createResponse":{"!type":"fn(responses: [string]) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(String)","!doc":"Creates a new ItemResponse for this checkbox item."},"duplicate":{"!type":"fn() -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getChoices":{"!type":"fn() -> [+forms.Choice]","!url":"http://developers.google.com/apps-script/reference/forms/#getChoices()","!doc":"Gets all choices for an item."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"hasOtherOption":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#hasOtherOption()","!doc":"Determines whether the item has an \"other\" option."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setChoiceValues":{"!type":"fn(values: [string]) -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#setChoiceValues(String)","!doc":"Sets the choices for an item from an array of strings."},"setChoices":{"!type":"fn(choices: [forms.Choice]) -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#setChoices(Choice)","!doc":"Sets an array of choices for an item."},"setHelpText":{"!type":"fn(text: string) -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"showOtherOption":{"!type":"fn(enabled: bool) -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#showOtherOption(Boolean)","!doc":"Sets whether the item has an \"other\" option."}}},"Choice":{"!url":"http://developers.google.com/apps-script/reference/forms/choice","!doc":"Choice A single choice associated with a type of Item that supports choices, like CheckboxItem, ListItem, or MultipleChoiceItem. // Create a new form and add a multiple-choice item. var form = FormApp.create('Form Name'); var item = form.addMultipleChoiceItem(); item.setTitle('Do you prefer cats or dogs?') .setChoices([ item.createChoice('Cats', FormApp.PageNavigationType.CONTINUE), item.createChoice('Dogs', FormApp.PageNavigationType.RESTART) ]); // Add another page because navigation has no effect on the last page. form.addPageBreakItem().setTitle('You chose well!'); // Log the navigation types that each choice results in. var choices = item.getChoices(); for (var i = 0; i < choices.length; i++) { Logger.log('If the respondent chooses \"%s\", the form will %s.', choices[i].getValue(), choices[i].getPageNavigationType()); }","prototype":{"getGotoPage":{"!type":"fn() -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#getGotoPage()","!doc":"Gets the PageBreakItem set as a GO_TO_PAGE destination if the responder selects this choice and completes the current page."},"getPageNavigationType":{"!type":"fn() -> +forms.PageNavigationType","!url":"http://developers.google.com/apps-script/reference/forms/#getPageNavigationType()","!doc":"Gets the PageNavigationType that occurs if the responder selects this choice and completes the current page."},"getValue":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getValue()","!doc":"Gets the choice's value, which respondents see as a label when viewing the form."}}},"DateItem":{"!url":"http://developers.google.com/apps-script/reference/forms/date-item","!doc":"DateItem A question item that allows the respondent to indicate a date. Items can be accessed or created from a Form. // Open a form by ID and add a new date item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addDateItem(); item.setTitle('When were you born?');","prototype":{"createResponse":{"!type":"fn(response: date) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(Date)","!doc":"Creates a new ItemResponse for this date item."},"duplicate":{"!type":"fn() -> +forms.DateItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"includesYear":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#includesYear()","!doc":"Determines whether the date item includes a year option."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setHelpText":{"!type":"fn(text: string) -> +forms.DateItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setIncludesYear":{"!type":"fn(enableYear: bool) -> +forms.DateItem","!url":"http://developers.google.com/apps-script/reference/forms/#setIncludesYear(Boolean)","!doc":"Sets whether the date item includes a year setting."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.DateItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.DateItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"DateTimeItem":{"!url":"http://developers.google.com/apps-script/reference/forms/date-time-item","!doc":"DateTimeItem A question item that allows the respondent to indicate a date and time. Items can be accessed or created from a Form. // Open a form by ID and add a new date-time item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addDateTimeItem(); item.setTitle('When do you want to meet?');","prototype":{"createResponse":{"!type":"fn(response: date) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(Date)","!doc":"Creates a new ItemResponse for this date-time item."},"duplicate":{"!type":"fn() -> +forms.DateTimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"includesYear":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#includesYear()","!doc":"Determines whether the date item includes a year option."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setHelpText":{"!type":"fn(text: string) -> +forms.DateTimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setIncludesYear":{"!type":"fn(enableYear: bool) -> +forms.DateTimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#setIncludesYear(Boolean)","!doc":"Sets whether the date item includes a year setting."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.DateTimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.DateTimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"DurationItem":{"!url":"http://developers.google.com/apps-script/reference/forms/duration-item","!doc":"DurationItem A question item that allows the respondent to indicate a length of time. Items can be accessed or created from a Form. // Open a form by ID and add a new duration item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addDurationItem(); item.setTitle('How long can you hold your breath?');","prototype":{"createResponse":{"!type":"fn(hours: number, minutes: number, seconds: number) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(Integer,Integer,Integer)","!doc":"Creates a new ItemResponse for this date item."},"duplicate":{"!type":"fn() -> +forms.DurationItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setHelpText":{"!type":"fn(text: string) -> +forms.DurationItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.DurationItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.DurationItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"Form":{"!url":"http://developers.google.com/apps-script/reference/forms/form","!doc":"Form A form that contains overall properties (such as title, settings, and where responses are stored) and items (which includes question items like checkboxes and layout items like page breaks). Forms can be accessed or created from FormApp. // Open a form by ID and create a new spreadsheet. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var ss = SpreadsheetApp.create('Spreadsheet Name'); // Update form properties via chaining. form.setTitle('Form Name') .setDescription('Description of form') .setConfirmationMessage('Thanks for responding!') .setAllowResponseEdits(true) .setAcceptingResponses(false); // Update the form's response destination. form.setDestination(FormApp.DestinationType.SPREADSHEET, ss.getId());","prototype":{"addCheckboxItem":{"!type":"fn() -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#addCheckboxItem()","!doc":"Appends a new question item that allows the respondent to select one or more checkboxes, as well as an optional \"other\" field."},"addDateItem":{"!type":"fn() -> +forms.DateItem","!url":"http://developers.google.com/apps-script/reference/forms/#addDateItem()","!doc":"Appends a new question item that allows the respondent to indicate a date."},"addDateTimeItem":{"!type":"fn() -> +forms.DateTimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#addDateTimeItem()","!doc":"Appends a new question item that allows the respondent to indicate a date and time."},"addDurationItem":{"!type":"fn() -> +forms.DurationItem","!url":"http://developers.google.com/apps-script/reference/forms/#addDurationItem()","!doc":"Appends a new question item that allows the respondent to indicate a length of time."},"addEditor":{"!type":"fn(user: base.User) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#addEditor(User)","!doc":"Adds the given user to the list of editors for the Form."},"addEditors":{"!type":"fn(emailAddresses: [string]) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the Form."},"addGridItem":{"!type":"fn() -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#addGridItem()","!doc":"Appends a new question item, presented as a grid of columns and rows, that allows the respondent to select one choice per row from a sequence of radio buttons."},"addImageItem":{"!type":"fn() -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#addImageItem()","!doc":"Appends a new layout item that displays an image."},"addListItem":{"!type":"fn() -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#addListItem()","!doc":"Appends a new question item that allows the respondent to select one choice from a drop-down list."},"addMultipleChoiceItem":{"!type":"fn() -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#addMultipleChoiceItem()","!doc":"Appends a new question item that allows the respondent to select one choice from a list of radio buttons or an optional \"other\" field."},"addPageBreakItem":{"!type":"fn() -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#addPageBreakItem()","!doc":"Appends a new layout item that marks the start of a page."},"addParagraphTextItem":{"!type":"fn() -> +forms.ParagraphTextItem","!url":"http://developers.google.com/apps-script/reference/forms/#addParagraphTextItem()","!doc":"Appends a new question item that allows the respondent to enter a block of text."},"addScaleItem":{"!type":"fn() -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#addScaleItem()","!doc":"Appends a new question item that allows the respondent to choose one option from a numbered sequence of radio buttons."},"addSectionHeaderItem":{"!type":"fn() -> +forms.SectionHeaderItem","!url":"http://developers.google.com/apps-script/reference/forms/#addSectionHeaderItem()","!doc":"Appends a new layout item that visually indicates the start of a section."},"addTextItem":{"!type":"fn() -> +forms.TextItem","!url":"http://developers.google.com/apps-script/reference/forms/#addTextItem()","!doc":"Appends a new question item that allows the respondent to enter a single line of text."},"addTimeItem":{"!type":"fn() -> +forms.TimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#addTimeItem()","!doc":"Appends a new question item that allows the respondent to indicate a time of day."},"addVideoItem":{"!type":"fn() -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#addVideoItem()","!doc":"Appends a new layout item that displays a video."},"canEditResponse":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#canEditResponse()","!doc":"Determines whether the form displays a link to edit a response after submitting it."},"collectsEmail":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#collectsEmail()","!doc":"Determines whether the form collects respondents' email addresses."},"createResponse":{"!type":"fn() -> +forms.FormResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse()","!doc":"Creates a new response to the form."},"deleteAllResponses":{"!type":"fn() -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#deleteAllResponses()","!doc":"Deletes all submitted responses from the form's response store."},"deleteItem":{"!type":"fn(item: forms.Item)","!url":"http://developers.google.com/apps-script/reference/forms/#deleteItem(Item)","!doc":"Deletes the given item."},"getConfirmationMessage":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getConfirmationMessage()","!doc":"Gets the form's confirmation message."},"getCustomClosedFormMessage":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getCustomClosedFormMessage()","!doc":"Gets the custom message that will be displayed if the form is not accepting responses, or an empty string if no custom message has been set."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getDescription()","!doc":"Gets the form's description."},"getDestinationId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getDestinationId()","!doc":"Gets the ID of the form's response destination."},"getDestinationType":{"!type":"fn() -> +forms.DestinationType","!url":"http://developers.google.com/apps-script/reference/forms/#getDestinationType()","!doc":"Gets the type of the form's response destination."},"getEditUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getEditUrl()","!doc":"Gets the URL that can be used to access the form's edit mode."},"getEditors":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/forms/#getEditors()","!doc":"Gets the list of editors for this Form."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the ID of the form."},"getItemById":{"!type":"fn(id: number) -> +forms.Item","!url":"http://developers.google.com/apps-script/reference/forms/#getItemById(Integer)","!doc":"Gets the item with a given ID."},"getItems":{"!type":"fn(itemType: forms.ItemType) -> [+forms.Item]","!url":"http://developers.google.com/apps-script/reference/forms/#getItems(ItemType)","!doc":"Gets an array of all items of a given type."},"getPublishedUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getPublishedUrl()","!doc":"Gets the URL that can be used to respond to the form."},"getResponse":{"!type":"fn(responseId: string) -> +forms.FormResponse","!url":"http://developers.google.com/apps-script/reference/forms/#getResponse(String)","!doc":"Gets a single form response based on its response ID."},"getResponses":{"!type":"fn(timestamp: date) -> [+forms.FormResponse]","!url":"http://developers.google.com/apps-script/reference/forms/#getResponses(Date)","!doc":"Gets an array of all of the form's responses after a given date and time."},"getSummaryUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getSummaryUrl()","!doc":"Gets the URL that can be used to view a summary of the form's responses."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the form's title."},"hasProgressBar":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#hasProgressBar()","!doc":"Determines whether the form displays a progress bar."},"hasRespondAgainLink":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#hasRespondAgainLink()","!doc":"Determines whether the form displays a link to submit another response after a respondent completes the form."},"isAcceptingResponses":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isAcceptingResponses()","!doc":"Determines whether the form is currently accepting responses."},"isPublishingSummary":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isPublishingSummary()","!doc":"Determines whether the form displays a link to view a summary of responses after a respondent completes the form."},"moveItem":{"!type":"fn(item: forms.Item, toIndex: number) -> +forms.Item","!url":"http://developers.google.com/apps-script/reference/forms/#moveItem(Item,Integer)","!doc":"Moves a given item to an given index among all the items in the form."},"removeDestination":{"!type":"fn() -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#removeDestination()","!doc":"Unlinks the form from its current response destination."},"removeEditor":{"!type":"fn(user: base.User) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the Form."},"requiresLogin":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#requiresLogin()","!doc":"Determines whether the form requires respondents to log in to an account in the same domain or a subdomain before responding."},"setAcceptingResponses":{"!type":"fn(enabled: bool) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setAcceptingResponses(Boolean)","!doc":"Sets whether the form is currently accepting responses."},"setAllowResponseEdits":{"!type":"fn(enabled: bool) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setAllowResponseEdits(Boolean)","!doc":"Sets whether the form displays a link to edit a response after submitting it."},"setCollectEmail":{"!type":"fn(collect: bool) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setCollectEmail(Boolean)","!doc":"Sets whether the form collects respondents' email addresses."},"setConfirmationMessage":{"!type":"fn(message: string) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setConfirmationMessage(String)","!doc":"Sets the form's confirmation message."},"setCustomClosedFormMessage":{"!type":"fn(message: string) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setCustomClosedFormMessage(String)","!doc":"Sets the message to display if the form is not accepting responses."},"setDescription":{"!type":"fn(description: string) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setDescription(String)","!doc":"Sets the form's description."},"setDestination":{"!type":"fn(type: forms.DestinationType, id: string) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setDestination(DestinationType,String)","!doc":"Sets the destination where form responses are saved."},"setProgressBar":{"!type":"fn(enabled: bool) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setProgressBar(Boolean)","!doc":"Sets whether the form has a progress bar."},"setPublishingSummary":{"!type":"fn(enabled: bool) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setPublishingSummary(Boolean)","!doc":"Sets whether the form displays a link to view a summary of responses after a respondent submits the form."},"setRequireLogin":{"!type":"fn(requireLogin: bool) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setRequireLogin(Boolean)","!doc":"Sets whether the form requires respondents to log in to an account in the same domain or a subdomain before responding."},"setShowLinkToRespondAgain":{"!type":"fn(enabled: bool) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setShowLinkToRespondAgain(Boolean)","!doc":"Sets whether the form displays a link to submit another response after a respondent completes the form."},"setTitle":{"!type":"fn(title: string) -> +forms.Form","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the form's title."}}},"FormResponse":{"!url":"http://developers.google.com/apps-script/reference/forms/form-response","!doc":"FormResponse A response to the form as a whole. Form responses have three main uses: they contain the answers submitted by a respondent (see getItemResponses(), they can be used to programmatically respond to the form (see withItemResponse(response) and submit()), and they can be used as a template to create a URL for the form with pre-filled answers. Form responses can be created or accessed from a Form. // Open a form by ID and log the responses to each question. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var formResponses = form.getResponses(); for (var i = 0; i < formResponses.length; i++) { var formResponse = formResponses[i]; var itemResponses = formResponse.getItemResponses(); for (var j = 0; j < itemResponses.length; j++) { var itemResponse = itemResponses[j]; Logger.log('Response #%s to the question \"%s\" was \"%s\"', (i + 1).toString(), itemResponse.getItem().getTitle(), itemResponse.getResponse()); } }","prototype":{"getEditResponseUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getEditResponseUrl()","!doc":"Generates a URL that can be used to edit a response that has already been submitted, even if the Form.setAllowResponseEdits(enabled) setting is disabled."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the ID of the form response."},"getItemResponses":{"!type":"fn() -> [+forms.ItemResponse]","!url":"http://developers.google.com/apps-script/reference/forms/#getItemResponses()","!doc":"Gets all item responses contained in this form response, in the same order as the items appear in the form."},"getRespondentEmail":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getRespondentEmail()","!doc":"Gets the email address of the person who submitted this response, if the Form.setCollectEmail(collect) setting is enabled."},"getResponseForItem":{"!type":"fn(item: forms.Item) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#getResponseForItem(Item)","!doc":"Gets the item response contained in this form response for a given item."},"getTimestamp":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/forms/#getTimestamp()","!doc":"Gets the timestamp at which this response was submitted."},"submit":{"!type":"fn() -> +forms.FormResponse","!url":"http://developers.google.com/apps-script/reference/forms/#submit()","!doc":"Submits the response."},"toPrefilledUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#toPrefilledUrl()","!doc":"Generates a URL for the form in which the answers are pre-filled based on the answers in this form response."},"withItemResponse":{"!type":"fn(response: forms.ItemResponse) -> +forms.FormResponse","!url":"http://developers.google.com/apps-script/reference/forms/#withItemResponse(ItemResponse)","!doc":"Adds an item response to this form response."}}},"GridItem":{"!url":"http://developers.google.com/apps-script/reference/forms/grid-item","!doc":"GridItem A question item, presented as a grid of columns and rows, that allows the respondent to select one choice per row from a sequence of radio buttons. Items can be accessed or created from a Form. // Open a form by ID and add a new grid item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addGridItem(); item.setTitle('Rate your interests') .setRows(['Cars', 'Computers', 'Celebrities']) .setColumns(['Boring', 'So-so', 'Interesting']);","prototype":{"createResponse":{"!type":"fn(responses: [string]) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(String)","!doc":"Creates a new ItemResponse for this grid item."},"duplicate":{"!type":"fn() -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getColumns":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/forms/#getColumns()","!doc":"Gets the values for every column in the grid."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getRows":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/forms/#getRows()","!doc":"Gets the values for every row in the grid."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setColumns":{"!type":"fn(columns: [string]) -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#setColumns(String)","!doc":"Sets the columns of the grid based on an array of values."},"setHelpText":{"!type":"fn(text: string) -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setRows":{"!type":"fn(rows: [string]) -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRows(String)","!doc":"Sets the rows of the grid based on an array of values."},"setTitle":{"!type":"fn(title: string) -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"ImageItem":{"!url":"http://developers.google.com/apps-script/reference/forms/image-item","!doc":"ImageItem A layout item that displays an image. Items can be accessed or created from a Form. // Open a form by ID and add a new image item var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var img = UrlFetchApp.fetch('https://www.google.com/images/srpr/logo4w.png'); form.addImageItem() .setTitle('Google') .setHelpText('Google Logo') // The help text is the image description .setImage(img);","prototype":{"duplicate":{"!type":"fn() -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getAlignment":{"!type":"fn() -> +forms.Alignment","!url":"http://developers.google.com/apps-script/reference/forms/#getAlignment()","!doc":"Gets the image's horizontal alignment."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getImage":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/forms/#getImage()","!doc":"Gets the image that is currently assigned to the item."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"getWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getWidth()","!doc":"Gets the image's width in pixels."},"setAlignment":{"!type":"fn(alignment: forms.Alignment) -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#setAlignment(Alignment)","!doc":"Sets the image's horizontal alignment."},"setHelpText":{"!type":"fn(text: string) -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setImage":{"!type":"fn(image: base.BlobSource) -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#setImage(BlobSource)","!doc":"Sets the image itself."},"setTitle":{"!type":"fn(title: string) -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"setWidth":{"!type":"fn(width: number) -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#setWidth(Integer)","!doc":"Sets the image's width in pixels."}}},"Item":{"!url":"http://developers.google.com/apps-script/reference/forms/item","!doc":"Item A generic form item that contains properties common to all items, such as title and help text. Items can be accessed or created from a Form. To operate on type-specific properties, use getType() to check the item's ItemType, then cast the item to the appropriate class using a method like asCheckboxItem(). // Create a new form and add a text item. var form = FormApp.create('Form Name'); form.addTextItem(); // Access the text item as a generic item. var items = form.getItems(); var item = items[0]; // Cast the generic item to the text-item class. if (item.getType() == 'TEXT') { var textItem = item.asTextItem(); textItem.setRequired(false); }","prototype":{"asCheckboxItem":{"!type":"fn() -> +forms.CheckboxItem","!url":"http://developers.google.com/apps-script/reference/forms/#asCheckboxItem()","!doc":"Returns the item as a checkbox item."},"asDateItem":{"!type":"fn() -> +forms.DateItem","!url":"http://developers.google.com/apps-script/reference/forms/#asDateItem()","!doc":"Returns the item as a date item."},"asDateTimeItem":{"!type":"fn() -> +forms.DateTimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#asDateTimeItem()","!doc":"Returns the item as a date-time item."},"asDurationItem":{"!type":"fn() -> +forms.DurationItem","!url":"http://developers.google.com/apps-script/reference/forms/#asDurationItem()","!doc":"Returns the item as a duration item."},"asGridItem":{"!type":"fn() -> +forms.GridItem","!url":"http://developers.google.com/apps-script/reference/forms/#asGridItem()","!doc":"Returns the item as a grid item."},"asImageItem":{"!type":"fn() -> +forms.ImageItem","!url":"http://developers.google.com/apps-script/reference/forms/#asImageItem()","!doc":"Returns the item as an image item."},"asListItem":{"!type":"fn() -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#asListItem()","!doc":"Returns the item as a list item."},"asMultipleChoiceItem":{"!type":"fn() -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#asMultipleChoiceItem()","!doc":"Returns the item as a multiple-choice item."},"asPageBreakItem":{"!type":"fn() -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#asPageBreakItem()","!doc":"Returns the item as a page-break item."},"asParagraphTextItem":{"!type":"fn() -> +forms.ParagraphTextItem","!url":"http://developers.google.com/apps-script/reference/forms/#asParagraphTextItem()","!doc":"Returns the item as a paragraph-text item."},"asScaleItem":{"!type":"fn() -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#asScaleItem()","!doc":"Returns the item as a scale item."},"asSectionHeaderItem":{"!type":"fn() -> +forms.SectionHeaderItem","!url":"http://developers.google.com/apps-script/reference/forms/#asSectionHeaderItem()","!doc":"Returns the item as a section-header item."},"asTextItem":{"!type":"fn() -> +forms.TextItem","!url":"http://developers.google.com/apps-script/reference/forms/#asTextItem()","!doc":"Returns the item as a text item."},"asTimeItem":{"!type":"fn() -> +forms.TimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#asTimeItem()","!doc":"Returns the item as a time item."},"asVideoItem":{"!type":"fn() -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#asVideoItem()","!doc":"Returns the item as a video item."},"duplicate":{"!type":"fn() -> +forms.Item","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"setHelpText":{"!type":"fn(text: string) -> +forms.Item","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setTitle":{"!type":"fn(title: string) -> +forms.Item","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"ItemResponse":{"!url":"http://developers.google.com/apps-script/reference/forms/item-response","!doc":"ItemResponse A response to one question item within a form. Item responses can be accessed from FormResponse and created from any Item that asks the respondent to answer a question. // Open a form by ID and log the responses to each question. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var formResponses = form.getResponses(); for (var i = 0; i < formResponses.length; i++) { var formResponse = formResponses[i]; var itemResponses = formResponse.getItemResponses(); for (var j = 0; j < itemResponses.length; j++) { var itemResponse = itemResponses[j]; Logger.log('Response #%s to the question \"%s\" was \"%s\"', (i + 1).toString(), itemResponse.getItem().getTitle(), itemResponse.getResponse()); } }","prototype":{"getItem":{"!type":"fn() -> +forms.Item","!url":"http://developers.google.com/apps-script/reference/forms/#getItem()","!doc":"Gets the question item that this response answers."},"getResponse":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/forms/#getResponse()","!doc":"Gets the answer that the respondent submitted."}}},"ListItem":{"!url":"http://developers.google.com/apps-script/reference/forms/list-item","!doc":"ListItem A question item that allows the respondent to select one choice from a drop-down list. Items can be accessed or created from a Form. // Open a form by ID and add a new list item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addListItem(); item.setTitle('Do you prefer cats or dogs?') .setChoices([ item.createChoice('Cats'), item.createChoice('Dogs') ]);","prototype":{"createChoice":{"!type":"fn(value: string, navigationType: forms.PageNavigationType) -> +forms.Choice","!url":"http://developers.google.com/apps-script/reference/forms/#createChoice(String,PageNavigationType)","!doc":"Creates a new choice with a page-navigation option."},"createResponse":{"!type":"fn(response: string) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(String)","!doc":"Creates a new ItemResponse for this list item."},"duplicate":{"!type":"fn() -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getChoices":{"!type":"fn() -> [+forms.Choice]","!url":"http://developers.google.com/apps-script/reference/forms/#getChoices()","!doc":"Gets all choices for an item."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setChoiceValues":{"!type":"fn(values: [string]) -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#setChoiceValues(String)","!doc":"Sets the choices for an item from an array of strings."},"setChoices":{"!type":"fn(choices: [forms.Choice]) -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#setChoices(Choice)","!doc":"Sets an array of choices for an item."},"setHelpText":{"!type":"fn(text: string) -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.ListItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"MultipleChoiceItem":{"!url":"http://developers.google.com/apps-script/reference/forms/multiple-choice-item","!doc":"MultipleChoiceItem A question item that allows the respondent to select one choice from a list of radio buttons or an optional \"other\" field. Items can be accessed or created from a Form. // Open a form by ID and add a new multiple choice item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addMultipleChoiceItem(); item.setTitle('Do you prefer cats or dogs?') .setChoices([ item.createChoice('Cats'), item.createChoice('Dogs') ]) .showOtherOption(true);","prototype":{"createChoice":{"!type":"fn(value: string, navigationType: forms.PageNavigationType) -> +forms.Choice","!url":"http://developers.google.com/apps-script/reference/forms/#createChoice(String,PageNavigationType)","!doc":"Creates a new choice with a page-navigation option."},"createResponse":{"!type":"fn(response: string) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(String)","!doc":"Creates a new ItemResponse for this multiple-choice item."},"duplicate":{"!type":"fn() -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getChoices":{"!type":"fn() -> [+forms.Choice]","!url":"http://developers.google.com/apps-script/reference/forms/#getChoices()","!doc":"Gets all choices for an item."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"hasOtherOption":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#hasOtherOption()","!doc":"Determines whether the item has an \"other\" option."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setChoiceValues":{"!type":"fn(values: [string]) -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#setChoiceValues(String)","!doc":"Sets the choices for an item from an array of strings."},"setChoices":{"!type":"fn(choices: [forms.Choice]) -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#setChoices(Choice)","!doc":"Sets an array of choices for an item."},"setHelpText":{"!type":"fn(text: string) -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"showOtherOption":{"!type":"fn(enabled: bool) -> +forms.MultipleChoiceItem","!url":"http://developers.google.com/apps-script/reference/forms/#showOtherOption(Boolean)","!doc":"Sets whether the item has an \"other\" option."}}},"PageBreakItem":{"!url":"http://developers.google.com/apps-script/reference/forms/page-break-item","!doc":"PageBreakItem A layout item that marks the start of a page. Items can be accessed or created from a Form. // Create a form and add three page-break items. var form = FormApp.create('Form Name'); var pageTwo = form.addPageBreakItem().setTitle('Page Two'); var pageThree = form.addPageBreakItem().setTitle('Page Three'); // Make the first two pages navigate elsewhere upon completion. pageTwo.setGoToPage(pageThree); // At end of page one (start of page two), jump to page three pageThree.setGoToPage(FormApp.PageNavigationType.RESTART); // At end of page two, restart form","prototype":{"duplicate":{"!type":"fn() -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getGoToPage":{"!type":"fn() -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#getGoToPage()","!doc":"Gets the PageBreakItem that the form will jump to after completing the page before this page break (that is, upon reaching this page break by normal linear progression through the form)."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getPageNavigationType":{"!type":"fn() -> +forms.PageNavigationType","!url":"http://developers.google.com/apps-script/reference/forms/#getPageNavigationType()","!doc":"Gets the type of page navigation that occurs after completing the page before this page break (that is, upon reaching this page break by normal linear progression through the form)."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"setGoToPage":{"!type":"fn(navigationType: forms.PageNavigationType) -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#setGoToPage(PageNavigationType)","!doc":"Sets the type of page navigation that occurs after completing the page before this page break (that is, upon reaching this page break by normal linear progression through the form)."},"setHelpText":{"!type":"fn(text: string) -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setTitle":{"!type":"fn(title: string) -> +forms.PageBreakItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"ParagraphTextItem":{"!url":"http://developers.google.com/apps-script/reference/forms/paragraph-text-item","!doc":"ParagraphTextItem A question item that allows the respondent to enter a block of text. Items can be accessed or created from a Form. // Open a form by ID and add a new paragraph text item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addParagraphTextItem(); item.setTitle('What is your address?');","prototype":{"createResponse":{"!type":"fn(response: string) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(String)","!doc":"Creates a new ItemResponse for this paragraph text item."},"duplicate":{"!type":"fn() -> +forms.ParagraphTextItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setHelpText":{"!type":"fn(text: string) -> +forms.ParagraphTextItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.ParagraphTextItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.ParagraphTextItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"ScaleItem":{"!url":"http://developers.google.com/apps-script/reference/forms/scale-item","!doc":"ScaleItem A question item that allows the respondent to choose one option from a numbered sequence of radio buttons. Items can be accessed or created from a Form. // Open a form by ID and add a new scale item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addScaleItem(); item.setTitle('Pick a number between 1 and 10') .setBounds(1, 10);","prototype":{"createResponse":{"!type":"fn(response: number) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(Integer)","!doc":"Creates a new ItemResponse for this scale item."},"duplicate":{"!type":"fn() -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getLeftLabel":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getLeftLabel()","!doc":"Gets the label for the scale's lower bound, if any."},"getLowerBound":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getLowerBound()","!doc":"Gets the scale's lower bound."},"getRightLabel":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getRightLabel()","!doc":"Gets the label for the scale's upper bound, if any."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"getUpperBound":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getUpperBound()","!doc":"Gets the scale's upper bound."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setBounds":{"!type":"fn(lower: number, upper: number) -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#setBounds(Integer,Integer)","!doc":"Sets the scale's lower and upper bounds."},"setHelpText":{"!type":"fn(text: string) -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setLabels":{"!type":"fn(lower: string, upper: string) -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#setLabels(String,String)","!doc":"Sets labels for the scale's lower and upper bounds."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.ScaleItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"SectionHeaderItem":{"!url":"http://developers.google.com/apps-script/reference/forms/section-header-item","!doc":"SectionHeaderItem A layout item that visually indicates the start of a section. Items can be accessed or created from a Form. // Open a form by ID and add a new section header. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addSectionHeaderItem(); item.setTitle('Title of new section');","prototype":{"duplicate":{"!type":"fn() -> +forms.SectionHeaderItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"setHelpText":{"!type":"fn(text: string) -> +forms.SectionHeaderItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setTitle":{"!type":"fn(title: string) -> +forms.SectionHeaderItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"TextItem":{"!url":"http://developers.google.com/apps-script/reference/forms/text-item","!doc":"TextItem A question item that allows the respondent to enter a single line of text. Items can be accessed or created from a Form. // Open a form by ID and add a new text item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addTextItem(); item.setTitle('What is your name?');","prototype":{"createResponse":{"!type":"fn(response: string) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(String)","!doc":"Creates a new ItemResponse for this text item."},"duplicate":{"!type":"fn() -> +forms.TextItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setHelpText":{"!type":"fn(text: string) -> +forms.TextItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.TextItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.TextItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"TimeItem":{"!url":"http://developers.google.com/apps-script/reference/forms/time-item","!doc":"TimeItem A question item that allows the respondent to indicate a time of day. Items can be accessed or created from a Form. // Open a form by ID and add a new time item. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var item = form.addTimeItem(); item.setTitle('What time do you usually wake up in the morning?');","prototype":{"createResponse":{"!type":"fn(hour: number, minute: number) -> +forms.ItemResponse","!url":"http://developers.google.com/apps-script/reference/forms/#createResponse(Integer,Integer)","!doc":"Creates a new ItemResponse for this time item."},"duplicate":{"!type":"fn() -> +forms.TimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"isRequired":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/forms/#isRequired()","!doc":"Determines whether the respondent must answer the question."},"setHelpText":{"!type":"fn(text: string) -> +forms.TimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setRequired":{"!type":"fn(enabled: bool) -> +forms.TimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#setRequired(Boolean)","!doc":"Sets whether the respondent must answer the question."},"setTitle":{"!type":"fn(title: string) -> +forms.TimeItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."}}},"VideoItem":{"!url":"http://developers.google.com/apps-script/reference/forms/video-item","!doc":"VideoItem A layout item that displays a video. Items can be accessed or created from a Form. // Open a form by ID and add three new video items, using a long URL, // a short URL, and a video ID. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); form.addVideoItem() .setTitle('Video Title') .setHelpText('Video Caption') .setVideoUrl('www.youtube.com/watch?v=1234abcdxyz'); form.addVideoItem() .setTitle('Video Title') .setHelpText('Video Caption') .setVideoUrl('youtu.be/1234abcdxyz'); form.addVideoItem() .setTitle('Video Title') .setHelpText('Video Caption') .setVideoUrl('1234abcdxyz');","prototype":{"duplicate":{"!type":"fn() -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#duplicate()","!doc":"Creates a copy of this item and appends it to the end of the form."},"getAlignment":{"!type":"fn() -> +forms.Alignment","!url":"http://developers.google.com/apps-script/reference/forms/#getAlignment()","!doc":"Gets the video's horizontal alignment."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getHelpText()","!doc":"Gets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"getId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getId()","!doc":"Gets the item's unique identifier."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getIndex()","!doc":"Gets the index of the item among all the items in the form."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/forms/#getTitle()","!doc":"Gets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"getType":{"!type":"fn() -> +forms.ItemType","!url":"http://developers.google.com/apps-script/reference/forms/#getType()","!doc":"Gets the item's type, represented as an ItemType."},"getWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/forms/#getWidth()","!doc":"Gets the video's width in pixels."},"setAlignment":{"!type":"fn(alignment: forms.Alignment) -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#setAlignment(Alignment)","!doc":"Sets the video's horizontal alignment."},"setHelpText":{"!type":"fn(text: string) -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#setHelpText(String)","!doc":"Sets the item's help text (sometimes called description text for layout items like ImageItems, PageBreakItems, and SectionHeaderItems)."},"setTitle":{"!type":"fn(title: string) -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#setTitle(String)","!doc":"Sets the item's title (sometimes called header text, in the case of a SectionHeaderItem)."},"setVideoUrl":{"!type":"fn(youtubeUrl: string) -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#setVideoUrl(String)","!doc":"Sets the video itself from a given YouTube URL or YouTube video ID."},"setWidth":{"!type":"fn(width: number) -> +forms.VideoItem","!url":"http://developers.google.com/apps-script/reference/forms/#setWidth(Integer)","!doc":"Sets the video's width in pixels."}}},"Alignment":{"!url":"http://developers.google.com/apps-script/reference/forms/alignment","!doc":"Alignment An enum representing the supported types of image alignment. Alignment types can be accessed from FormApp.Alignment. // Open a form by ID and add a new image item with alignment var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var img = UrlFetchApp.fetch('https://www.google.com/images/srpr/logo4w.png'); form.addImageItem() .setImage(img) .setAlignment(FormApp.Alignment.CENTER);","prototype":{"LEFT":{"!type":"string","!doc":"Align the image to the left side of the form."},"CENTER":{"!type":"string","!doc":"Align the image to the center of the form."},"RIGHT":{"!type":"string","!doc":"Align the image to the right side of the form."}}},"DestinationType":{"!url":"http://developers.google.com/apps-script/reference/forms/destination-type","!doc":"DestinationType An enum representing the supported types of form-response destinations. All forms, including those that do not have a destination set explicitly, save a copy of responses in the form's response store. Destination types can be accessed from FormApp.DestinationType. // Open a form by ID and create a new spreadsheet. var form = FormApp.openById('1234567890abcdefghijklmnopqrstuvwxyz'); var ss = SpreadsheetApp.create('Spreadsheet Name'); // Update the form's response destination. form.setDestination(FormApp.DestinationType.SPREADSHEET, ss.getId());","prototype":{"SPREADSHEET":{"!type":"string","!doc":"A Google Sheets spreadsheet as a destination for form responses."}}},"ItemType":{"!url":"http://developers.google.com/apps-script/reference/forms/item-type","!doc":"ItemType An enum representing the supported types of form items. Item types can be accessed from FormApp.ItemType. // Open a form by ID and add a new section header. var form = FormApp.create('Form Name'); var item = form.addSectionHeaderItem(); item.setTitle('Title of new section'); // Check the item type. if (item.getType() == FormApp.ItemType.SECTION_HEADER) { item.setHelpText('Description of new section.'); }","prototype":{"CHECKBOX":{"!type":"string","!doc":"A question item that allows the respondent to select one or more checkboxes, as well as an optional \"other\" field."},"DATE":{"!type":"string","!doc":"A question item that allows the respondent to indicate a date."},"DATETIME":{"!type":"string","!doc":"A question item that allows the respondent to indicate a date and time."},"DURATION":{"!type":"string","!doc":"A question item that allows the respondent to indicate a length of time."},"GRID":{"!type":"string","!doc":"A question item, presented as a grid of columns and rows, that allows the respondent to select one choice per row from a sequence of radio buttons."},"IMAGE":{"!type":"string","!doc":"A layout item that displays an image."},"LIST":{"!type":"string","!doc":"A question item that allows the respondent to select one choice from a drop-down list."},"MULTIPLE_CHOICE":{"!type":"string","!doc":"A question item that allows the respondent to select one choice from a list of radio buttons or an optional \"other\" field."},"PAGE_BREAK":{"!type":"string","!doc":"A layout item that marks the start of a page."},"PARAGRAPH_TEXT":{"!type":"string","!doc":"A question item that allows the respondent to enter a block of text."},"SCALE":{"!type":"string","!doc":"A question item that allows the respondent to choose one option from a numbered sequence of radio buttons."},"SECTION_HEADER":{"!type":"string","!doc":"A layout item that visually indicates the start of a section."},"TEXT":{"!type":"string","!doc":"A question item that allows the respondent to enter a single line of text."},"TIME":{"!type":"string","!doc":"A question item that allows the respondent to indicate a time of day."}}},"PageNavigationType":{"!url":"http://developers.google.com/apps-script/reference/forms/page-navigation-type","!doc":"PageNavigationType An enum representing the supported types of page navigation. Page navigation types can be accessed from FormApp.PageNavigationType. The page navigation occurs after the respondent completes a page that contains the option, and only if the respondent chose that option. If the respondent chose multiple options with page-navigation instructions on the same page, only the last navigation option has any effect. Page navigation also has no effect on the last page of a form. Choices that use page navigation cannot be combined in the same item with choices that do not use page navigation. // Create a form and add a new multiple-choice item and a page-break item. var form = FormApp.create('Form Name'); var item = form.addMultipleChoiceItem(); var pageBreak = form.addPageBreakItem(); // Set some choices with go-to-page logic. var rightChoice = item.createChoice('Vanilla', FormApp.PageNavigationType.SUBMIT); var wrongChoice = item.createChoice('Chocolate', FormApp.PageNavigationType.RESTART); // For GO_TO_PAGE, just pass in the page break item. For CONTINUE (normally the default), pass in // CONTINUE explicitly because page navigation cannot be mixed with non-navigation choices. var iffyChoice = item.createChoice('Peanut', pageBreak); var otherChoice = item.createChoice('Strawberry', FormApp.PageNavigationType.CONTINUE); item.setChoices([rightChoice, wrongChoice, iffyChoice, otherChoice]);","prototype":{"CONTINUE":{"!type":"string","!doc":"Continue to the next page of the form after completing the current page."},"GO_TO_PAGE":{"!type":"string","!doc":"Jump to a specified page of the form after completing the current page."},"RESTART":{"!type":"string","!doc":"Restart the form from the beginning, without clearing answers entered so far, after completing the current page."},"SUBMIT":{"!type":"string","!doc":"Submit the form response after completing the current page."}}}},"gmail":{"GmailAttachment":{"!url":"http://developers.google.com/apps-script/reference/gmail/gmail-attachment","!doc":"GmailAttachment An attachment from Gmail. This is a regular Blob except that it has an extra getSize() method that is faster than calling getBytes().length and does not count against the Gmail read quota. // Logs information about any attachments in the first 100 inbox threads. var threads = GmailApp.getInboxThreads(0, 100); var msgs = GmailApp.getMessagesForThreads(threads); for (var i = 0 ; i < msgs.length; i++) { for (var j = 0; j < msgs[i].length; j++) { var attachments = msgs[i][j].getAttachments(); for (var k = 0; k < attachments.length; k++) { Logger.log('Message \"%s\" contains the attachment \"%s\" (%s bytes)', msgs[i][j].getSubject(), attachments[k].getName(), attachments[k].getSize()); } } }","prototype":{"copyBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/gmail/#copyBlob()","!doc":"Returns a copy of this blob."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/gmail/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBytes":{"!type":"fn() -> [byte]","!url":"http://developers.google.com/apps-script/reference/gmail/#getBytes()","!doc":"Gets the data stored in this blob."},"getContentType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getContentType()","!doc":"Gets the content type of the bytes in this blob."},"getDataAsString":{"!type":"fn(charset: string) -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getDataAsString(String)","!doc":"Gets the data of this blob as a string with the specified encoding."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getName()","!doc":"Gets the name of this blob."},"getSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/gmail/#getSize()","!doc":"Gets the size of this attachment."},"isGoogleType":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isGoogleType()","!doc":"Returns whether this blob is a Google Apps file (Sheets, Docs, etc.)."},"setBytes":{"!type":"fn(data: [byte]) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/gmail/#setBytes(Byte)","!doc":"Sets the data stored in this blob."},"setContentType":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/gmail/#setContentType(String)","!doc":"Sets the content type of the bytes in this blob."},"setContentTypeFromExtension":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/gmail/#setContentTypeFromExtension()","!doc":"Sets the content type of the bytes in this blob based on the file extension."},"setDataFromString":{"!type":"fn(string: string, charset: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/gmail/#setDataFromString(String,String)","!doc":"Sets the data of this blob from a string with the specified encoding."},"setName":{"!type":"fn(name: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/gmail/#setName(String)","!doc":"Sets the name of this blob."}}},"GmailLabel":{"!url":"http://developers.google.com/apps-script/reference/gmail/gmail-label","!doc":"GmailLabel A user-created label in a user's Gmail account.","prototype":{"addToThread":{"!type":"fn(thread: gmail.GmailThread) -> +gmail.GmailLabel","!url":"http://developers.google.com/apps-script/reference/gmail/#addToThread(GmailThread)","!doc":"Adds this label to the given thread and forces the thread to refresh (GmailThread.refresh())."},"addToThreads":{"!type":"fn(threads: [gmail.GmailThread]) -> +gmail.GmailLabel","!url":"http://developers.google.com/apps-script/reference/gmail/#addToThreads(GmailThread)","!doc":"Adds this label to the given threads and forces the threads to refresh."},"deleteLabel":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/gmail/#deleteLabel()","!doc":"Deletes this label."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getName()","!doc":"Gets the name of this label."},"getThreads":{"!type":"fn(start: number, max: number) -> [+gmail.GmailThread]","!url":"http://developers.google.com/apps-script/reference/gmail/#getThreads(Integer,Integer)","!doc":"Gets a range of threads marked with this label."},"getUnreadCount":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/gmail/#getUnreadCount()","!doc":"Gets the number of unread threads tagged with this label."},"removeFromThread":{"!type":"fn(thread: gmail.GmailThread) -> +gmail.GmailLabel","!url":"http://developers.google.com/apps-script/reference/gmail/#removeFromThread(GmailThread)","!doc":"Removes this label from the given thread and forces the thread to refresh."},"removeFromThreads":{"!type":"fn(threads: [gmail.GmailThread]) -> +gmail.GmailLabel","!url":"http://developers.google.com/apps-script/reference/gmail/#removeFromThreads(GmailThread)","!doc":"Removes this label from the given threads and forces the threads to refresh."}}},"GmailMessage":{"!url":"http://developers.google.com/apps-script/reference/gmail/gmail-message","!doc":"GmailMessage A message in a user's Gmail account.","prototype":{"forward":{"!type":"fn(recipient: string, options: object) -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#forward(String,Object)","!doc":"Forwards this message to new recipients, with optional arguments."},"getAttachments":{"!type":"fn() -> [+gmail.GmailAttachment]","!url":"http://developers.google.com/apps-script/reference/gmail/#getAttachments()","!doc":"Gets all the attachments for this message."},"getBcc":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getBcc()","!doc":"Gets the comma-separated recipients bcc'd on this message."},"getBody":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getBody()","!doc":"Gets the HTML content of the body of this message."},"getCc":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getCc()","!doc":"Gets the comma-separated recipients cc'd on this message."},"getDate":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/gmail/#getDate()","!doc":"Gets the date and time of this message."},"getFrom":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getFrom()","!doc":"Gets the sender of this message."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getId()","!doc":"Gets the id of this message."},"getPlainBody":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getPlainBody()","!doc":"Gets the content of the body of this message without HTML formatting."},"getRawContent":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getRawContent()","!doc":"Gets the raw content of this message."},"getReplyTo":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getReplyTo()","!doc":"Gets the reply-to address of this message (usually the sender)."},"getSubject":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getSubject()","!doc":"Gets the subject of this message."},"getThread":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#getThread()","!doc":"Gets the thread that contains this message."},"getTo":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getTo()","!doc":"Gets the comma-separated recipient(s) of this message."},"isDraft":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isDraft()","!doc":"Gets whether this message is a draft."},"isInChats":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isInChats()","!doc":"Gets whether this message is a chat."},"isInInbox":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isInInbox()","!doc":"Gets whether this message is in the inbox."},"isInTrash":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isInTrash()","!doc":"Gets whether this message is in the trash."},"isStarred":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isStarred()","!doc":"Gets whether this message is starred."},"isUnread":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isUnread()","!doc":"Gets whether this message is unread."},"markRead":{"!type":"fn() -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#markRead()","!doc":"Marks the message as read."},"markUnread":{"!type":"fn() -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#markUnread()","!doc":"Marks the message as unread."},"moveToTrash":{"!type":"fn() -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#moveToTrash()","!doc":"Moves the message to the trash."},"refresh":{"!type":"fn() -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#refresh()","!doc":"Reloads this message and associated state from Gmail (useful in case the labels, read state, etc., have changed)."},"reply":{"!type":"fn(body: string, options: object) -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#reply(String,Object)","!doc":"Replies to the sender of this message using the reply-to address, with optional arguments."},"replyAll":{"!type":"fn(body: string, options: object) -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#replyAll(String,Object)","!doc":"Replies to the sender of this message using the reply-to address and all recipients, with optional arguments."},"star":{"!type":"fn() -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#star()","!doc":"Stars the message."},"unstar":{"!type":"fn() -> +gmail.GmailMessage","!url":"http://developers.google.com/apps-script/reference/gmail/#unstar()","!doc":"Unstars the message."}}},"GmailThread":{"!url":"http://developers.google.com/apps-script/reference/gmail/gmail-thread","!doc":"GmailThread A thread in a user's Gmail account.","prototype":{"addLabel":{"!type":"fn(label: gmail.GmailLabel) -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#addLabel(GmailLabel)","!doc":"Adds this label to the thread."},"getFirstMessageSubject":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getFirstMessageSubject()","!doc":"Gets the subject of the first message in the thread."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getId()","!doc":"Gets the ID of this thread."},"getLabels":{"!type":"fn() -> [+gmail.GmailLabel]","!url":"http://developers.google.com/apps-script/reference/gmail/#getLabels()","!doc":"Returns the user-created labels on this thread."},"getLastMessageDate":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/gmail/#getLastMessageDate()","!doc":"Gets the date of this thread's most recent message."},"getMessageCount":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/gmail/#getMessageCount()","!doc":"Returns the number of messages in the thread."},"getMessages":{"!type":"fn() -> [+gmail.GmailMessage]","!url":"http://developers.google.com/apps-script/reference/gmail/#getMessages()","!doc":"Gets the messages in this thread."},"getPermalink":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/gmail/#getPermalink()","!doc":"Gets a permalink for this thread."},"hasStarredMessages":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#hasStarredMessages()","!doc":"Returns whether the thread has any starred messages."},"isImportant":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isImportant()","!doc":"Returns whether the thread is marked important."},"isInChats":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isInChats()","!doc":"Returns whether the thread is labeled a chat."},"isInInbox":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isInInbox()","!doc":"Returns whether the thread is in the inbox."},"isInSpam":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isInSpam()","!doc":"Returns whether the thread is marked as spam."},"isInTrash":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isInTrash()","!doc":"Returns whether the thread is in the trash."},"isUnread":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/gmail/#isUnread()","!doc":"Returns whether the thread has any unread messages."},"markImportant":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#markImportant()","!doc":"Marks this thread as important."},"markRead":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#markRead()","!doc":"Marks this thread as read."},"markUnimportant":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#markUnimportant()","!doc":"Marks this thread as unimportant."},"markUnread":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#markUnread()","!doc":"Marks this thread as unread."},"moveToArchive":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#moveToArchive()","!doc":"Moves this thread to the archive."},"moveToInbox":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#moveToInbox()","!doc":"Moves this thread to the inbox."},"moveToSpam":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#moveToSpam()","!doc":"Moves this thread to spam."},"moveToTrash":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#moveToTrash()","!doc":"Moves this thread to the trash."},"refresh":{"!type":"fn() -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#refresh()","!doc":"Reloads this thread, and associated state from Gmail (useful in case the labels, read state, etc., have changed)."},"removeLabel":{"!type":"fn(label: gmail.GmailLabel) -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#removeLabel(GmailLabel)","!doc":"Removes this label from the thread."},"reply":{"!type":"fn(body: string, options: object) -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#reply(String,Object)","!doc":"Reply to the sender of the last message on this thread using the replyTo address, with optional arguments."},"replyAll":{"!type":"fn(body: string, options: object) -> +gmail.GmailThread","!url":"http://developers.google.com/apps-script/reference/gmail/#replyAll(String,Object)","!doc":"Reply to the sender (using the replyTo address), and all recipients of the last message on this thread, with optional arguments."}}}},"groups":{"Group":{"!url":"http://developers.google.com/apps-script/reference/groups/group","!doc":"Group A group object whose members and those members' roles within the group can be queried. Here's an example which shows the members of a group. Before running it, replace the email address of the group with that of one on your domain. function listGroupMembers() { var group = GroupsApp.getGroupByEmail(\"example@googlegroups.com\"); var s = group.getEmail() + ': '; var users = group.getUsers(); for (var i = 0; i < users.length; i++) { var user = users[i]; s = s + user.getEmail() + \", \"; } Logger.log(s); }","prototype":{"getEmail":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/groups/#getEmail()","!doc":"Gets this group's email address."},"getRole":{"!type":"fn(user: base.User) -> +groups.Role","!url":"http://developers.google.com/apps-script/reference/groups/#getRole(User)","!doc":"Retrieves a user's role in the context of the group."},"getUsers":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/groups/#getUsers()","!doc":"Retrieves all the direct members of the group."},"hasUser":{"!type":"fn(user: base.User) -> bool","!url":"http://developers.google.com/apps-script/reference/groups/#hasUser(User)","!doc":"Tests if a user is a direct member of the group."}}},"Role":{"!url":"http://developers.google.com/apps-script/reference/groups/role","!doc":"Role Possible roles of a user within a group, such as owner or ordinary member. Users subscribed to a group have exactly one role within the context of that group. See also Group.getRole(email)","prototype":{"OWNER":{"!type":"string","!doc":"The owner of a group."},"MANAGER":{"!type":"string","!doc":"The manager of a group."},"MEMBER":{"!type":"string","!doc":"A user who is a member of this group but is neither an owner nor a manager."},"INVITED":{"!type":"string","!doc":"A user who has been invited to join a group by an owner or manager of the group but who has not yet accepted the invitation."},"PENDING":{"!type":"string","!doc":"A user who has requested to join a group but who has not yet been approved by an owner or manager."}}}},"html":{"HtmlOutput":{"!url":"http://developers.google.com/apps-script/reference/html/html-output","!doc":"HtmlOutput An HtmlOutput object that can be served from a script. Due to security considerations, scripts cannot directly return HTML to a browser. Instead, they must sanitize it so that it cannot perform malicious actions. You can return sanitized HTML like this: function doGet() { return HtmlService.createHtmlOutput('<b>Hello, world!</b>'); } The code in the HtmlOutput can include embedded JavaScript and CSS. (This is standard client-side JavaScript that manipulates the DOM, not Apps Script). All of this content is sanitized using Google Caja, which applies some limitations to your client-side code. For more information, see the guide to restrictions in HTML service.","prototype":{"append":{"!type":"fn(addedContent: string) -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#append(String)","!doc":"Appends new content to the content of this HtmlOutput."},"appendUntrusted":{"!type":"fn(addedContent: string) -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#appendUntrusted(String)","!doc":"Appends new content to the content of this HtmlOutput, using contextual escaping."},"asTemplate":{"!type":"fn() -> +html.HtmlTemplate","!url":"http://developers.google.com/apps-script/reference/html/#asTemplate()","!doc":"Returns an HtmlTemplate backed by this HtmlOutput."},"clear":{"!type":"fn() -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#clear()","!doc":"Clears the current content."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/html/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/html/#getBlob()","!doc":"Return the data inside this object as a blob."},"getContent":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/html/#getContent()","!doc":"Gets the content of this HtmlOutput."},"getHeight":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/html/#getHeight()","!doc":"Gets the initial height of the custom dialog in Google Docs, Sheets, or Forms."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/html/#getTitle()","!doc":"Gets the title of the output page."},"getWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/html/#getWidth()","!doc":"Gets the initial width of the custom dialog or sidebar in Google Docs, Sheets, or Forms."},"setContent":{"!type":"fn(content: string) -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#setContent(String)","!doc":"Sets the content of this HtmlOutput."},"setHeight":{"!type":"fn(height: number) -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#setHeight(Integer)","!doc":"Sets the initial height of the custom dialog in Google Docs, Sheets, or Forms."},"setSandboxMode":{"!type":"fn(mode: html.SandboxMode) -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#setSandboxMode(SandboxMode)","!doc":"Sets the the ECMAScript sandbox mode used for client-side scripts."},"setTitle":{"!type":"fn(title: string) -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#setTitle(String)","!doc":"Sets the title of the output page."},"setWidth":{"!type":"fn(width: number) -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#setWidth(Integer)","!doc":"Sets the initial width of a custom dialog or sidebar in Google Docs, Sheets, or Forms."}}},"HtmlTemplate":{"!url":"http://developers.google.com/apps-script/reference/html/html-template","!doc":"HtmlTemplate A template object for dynamically constructing HTML. For more information, see the guide to templates.","prototype":{"evaluate":{"!type":"fn() -> +html.HtmlOutput","!url":"http://developers.google.com/apps-script/reference/html/#evaluate()","!doc":"Evaluates this template and returns an HtmlOutput object."},"getCode":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/html/#getCode()","!doc":"Generates a string of JavaScript code, based on the template file, that can be evaluated."},"getCodeWithComments":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/html/#getCodeWithComments()","!doc":"Generates a string of JavaScript code that can be evaluated, with each line of the code containing the original line from the template as a comment."},"getRawContent":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/html/#getRawContent()","!doc":"Returns the unprocessed content of this template."}}},"SandboxMode":{"!url":"http://developers.google.com/apps-script/reference/html/sandbox-mode","!doc":"SandboxMode An enum representing the ECMAScript sandbox modes that can be used for client-side HtmlService scripts. These values can be accessed from HtmlService.SandboxMode. To protect users from being served malicious HTML or JavaScript, client-side code served from HTML service executes in a security sandbox that imposes restrictions on the code. The method HtmlOutput.setSandboxMode(mode) allows script authors to choose between different versions of the sandbox. For more information, see the guide to restrictions in HTML service. If a script does not set a sandbox mode, Apps Script uses NATIVE mode as the default. Prior to February 2014, the default was EMULATED. The default is subject to change. NATIVE imposes fewer restrictions than EMULATED and generally runs faster. By contrast, EMULATED mode is more likely to work in older browsers that do not support ECMAScript 5 strict mode, most notably Internet Explorer 9. If NATIVE mode is set but not supported in the user's browser, the sandbox mode falls back to EMULATED mode for that user. // Serve HTML with a defined sandbox mode (in Apps Script server-side code). var output = HtmlService.createHtmlOutput('<b>Hello, world!</b>'); output.setSandboxMode(HtmlService.SandboxMode.EMULATED); The sandbox mode can also be read in a client-side script by inspecting google.script.sandbox.mode. Note that this property returns the actual mode on the client, which may differ from the mode requested on the server if the requested mode is not supported in the user's browser. <!-- Read the sandbox mode (in a client-side script). --> <script> alert(google.script.sandbox.mode); </script>","prototype":{"EMULATED":{"!type":"string","!doc":"A legacy sandbox mode that emulates ECMAScript 5 strict mode using only the features available in ECMAScript 3. This mode was the default prior to February 2014. This mode is more likely than NATIVE mode to work in older browsers that do not support ECMAScript 5 strict mode, most notably Internet Explorer 9. (Very old browsers, including Internet Explorer 8 and below, are usually incompatible with HTML service.) This mode imposes extra restrictions on what a script can do and generally runs more slowly than NATIVE mode."},"NATIVE":{"!type":"string","!doc":"A newer sandbox mode that is built on top of ECMAScript 5 strict mode. This mode has been the default since February 2014. This mode imposes fewer restrictions than EMULATED mode and generally runs faster. If this mode is set, certain older browsers — most notably Internet Explorer 9 — fall back to EMULATED mode on an individual basis. (Very old browsers, including Internet Explorer 8 and below, are usually incompatible with HTML service.)"}}}},"jdbc":{"JdbcArray":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-array","!doc":"JdbcArray A JDBC Array. For documentation of this class, see java.sql.Array.","prototype":{"free":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#free()","!doc":"For documentation of this method, see java.sql.Array#free()."},"getArray":{"!type":"fn(index: number, count: number) -> object","!url":"http://developers.google.com/apps-script/reference/jdbc/#getArray(Integer,Integer)","!doc":"For documentation of this method, see java.sql.Array#getArray(long, int)."},"getBaseType":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBaseType()","!doc":"For documentation of this method, see java.sql.Array#getBaseType()."},"getBaseTypeName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBaseTypeName()","!doc":"For documentation of this method, see java.sql.Array#getBaseTypeName()."},"getResultSet":{"!type":"fn(index: number, count: number) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSet(Integer,Integer)","!doc":"For documentation of this method, see java.sql.Array#getResultSet(long, int)."}}},"JdbcBlob":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-blob","!doc":"JdbcBlob A JDBC Blob. For documentation of this class, see java.sql.Blob.","prototype":{"free":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#free()","!doc":"For documentation of this method, see java.sql.Blob#free()."},"getAppsScriptBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getAppsScriptBlob()","!doc":"Gets the content of this JdbcBlob as an Apps Script blob."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBytes":{"!type":"fn(position: number, length: number) -> [byte]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBytes(Integer,Integer)","!doc":"For documentation of this method, see java.sql.Blob#getBytes(long, int)."},"length":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#length()","!doc":"For documentation of this method, see java.sql.Blob#length()."},"position":{"!type":"fn(pattern: jdbc.JdbcBlob, start: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#position(JdbcBlob,Integer)","!doc":"For documentation of this method, see java.sql.Blob#position(java.sql.Blob, long)."},"setBytes":{"!type":"fn(position: number, bytes: [byte], offset: number, length: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBytes(Integer,Byte,Integer,Integer)","!doc":"For documentation of this method, see java.sql.Blob#setBytes(long, byte[], int, int)."},"truncate":{"!type":"fn(length: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#truncate(Integer)","!doc":"For documentation of this method, see java.sql.Blob#truncate(long)."}}},"JdbcCallableStatement":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-callable-statement","!doc":"JdbcCallableStatement A JDBC CallableStatement. For documentation of this class, see java.sql.CallableStatement. See also CallableStatement","prototype":{"addBatch":{"!type":"fn(sql: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#addBatch(String)","!doc":"For documentation of this method, see java.sql.Statement#addBatch(String)."},"cancel":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#cancel()","!doc":"For documentation of this method, see java.sql.Statement#cancel()."},"clearBatch":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearBatch()","!doc":"For documentation of this method, see java.sql.Statement#clearBatch()."},"clearParameters":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearParameters()","!doc":"For documentation of this method, see java.sql.PreparedStatement#clearParameters()."},"clearWarnings":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearWarnings()","!doc":"For documentation of this method, see java.sql.Statement#clearWarnings()."},"close":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#close()","!doc":"For documentation of this method, see java.sql.Statement#close()."},"execute":{"!type":"fn(sql: string, columnNames: [string]) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#execute(String,String)","!doc":"For documentation of this method, see java.sql.Statement#execute(String, String[])."},"executeBatch":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeBatch()","!doc":"For documentation of this method, see java.sql.Statement#executeBatch()."},"executeQuery":{"!type":"fn(sql: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeQuery(String)","!doc":"For documentation of this method, see java.sql.Statement#executeQuery(String)."},"executeUpdate":{"!type":"fn(sql: string, columnNames: [string]) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeUpdate(String,String)","!doc":"For documentation of this method, see java.sql.Statement#executeUpdate(String, String[])."},"getArray":{"!type":"fn(parameterName: string) -> +jdbc.JdbcArray","!url":"http://developers.google.com/apps-script/reference/jdbc/#getArray(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getArray(String)."},"getBigDecimal":{"!type":"fn(parameterName: string) -> bignumber","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBigDecimal(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getBigDecimal(String)."},"getBlob":{"!type":"fn(parameterName: string) -> +jdbc.JdbcBlob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBlob(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getBlob(String)."},"getBoolean":{"!type":"fn(parameterName: string) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBoolean(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getBoolean(String)."},"getByte":{"!type":"fn(parameterName: string) -> byte","!url":"http://developers.google.com/apps-script/reference/jdbc/#getByte(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getByte(String)."},"getBytes":{"!type":"fn(parameterName: string) -> [byte]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBytes(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getBytes(String)."},"getClob":{"!type":"fn(parameterName: string) -> +jdbc.JdbcClob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getClob(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getClob(String)."},"getConnection":{"!type":"fn() -> +jdbc.JdbcConnection","!url":"http://developers.google.com/apps-script/reference/jdbc/#getConnection()","!doc":"For documentation of this method, see java.sql.Statement#getConnection()."},"getDate":{"!type":"fn(parameterName: string, timeZone: string) -> +jdbc.JdbcDate","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDate(String,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getDate(String, java.util.Calendar)."},"getDouble":{"!type":"fn(parameterName: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDouble(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getDouble(String)."},"getFetchDirection":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchDirection()","!doc":"For documentation of this method, see java.sql.Statement#getFetchDirection()."},"getFetchSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchSize()","!doc":"For documentation of this method, see java.sql.Statement#getFetchSize()."},"getFloat":{"!type":"fn(parameterName: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFloat(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getFloat(String)."},"getGeneratedKeys":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getGeneratedKeys()","!doc":"For documentation of this method, see java.sql.Statement#getGeneratedKeys()."},"getInt":{"!type":"fn(parameterName: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getInt(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getInt(String)."},"getLong":{"!type":"fn(parameterName: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getLong(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getLong(String)."},"getMaxFieldSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxFieldSize()","!doc":"For documentation of this method, see java.sql.Statement#getMaxFieldSize()."},"getMaxRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxRows()","!doc":"For documentation of this method, see java.sql.Statement#getMaxRows()."},"getMetaData":{"!type":"fn() -> +jdbc.JdbcResultSetMetaData","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMetaData()","!doc":"For documentation of this method, see java.sql.PreparedStatement#getMetaData()."},"getMoreResults":{"!type":"fn(current: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMoreResults(Integer)","!doc":"For documentation of this method, see java.sql.Statement#getMoreResults(int)."},"getNClob":{"!type":"fn(parameterName: string) -> +jdbc.JdbcClob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getNClob(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getNClob(String)."},"getNString":{"!type":"fn(parameterName: string) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getNString(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getNString(String)."},"getObject":{"!type":"fn(parameterName: string) -> object","!url":"http://developers.google.com/apps-script/reference/jdbc/#getObject(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getObject(String)."},"getParameterMetaData":{"!type":"fn() -> +jdbc.JdbcParameterMetaData","!url":"http://developers.google.com/apps-script/reference/jdbc/#getParameterMetaData()","!doc":"For documentation of this method, see java.sql.PreparedStatement#getParameterMetaData()."},"getQueryTimeout":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getQueryTimeout()","!doc":"For documentation of this method, see java.sql.Statement#getQueryTimeout()."},"getRef":{"!type":"fn(parameterName: string) -> +jdbc.JdbcRef","!url":"http://developers.google.com/apps-script/reference/jdbc/#getRef(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getRef(String)."},"getResultSet":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSet()","!doc":"For documentation of this method, see java.sql.Statement#getResultSet()."},"getResultSetConcurrency":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetConcurrency()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetConcurrency()."},"getResultSetHoldability":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetHoldability()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetHoldability()."},"getResultSetType":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetType()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetType()."},"getRowId":{"!type":"fn(parameterName: string) -> +jdbc.JdbcRowId","!url":"http://developers.google.com/apps-script/reference/jdbc/#getRowId(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getRowId(String)."},"getSQLXML":{"!type":"fn(parameterName: string) -> +jdbc.JdbcSQLXML","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSQLXML(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getSQLXML(String)."},"getShort":{"!type":"fn(parameterName: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getShort(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getShort(String)."},"getString":{"!type":"fn(parameterName: string) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getString(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getString(String)."},"getTime":{"!type":"fn(parameterName: string, timeZone: string) -> +jdbc.JdbcTime","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTime(String,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getTime(String, java.util.Calendar)."},"getTimestamp":{"!type":"fn(parameterName: string, timeZone: string) -> +jdbc.JdbcTimestamp","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTimestamp(String,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getTimestamp(String, java.util.Calendar)."},"getURL":{"!type":"fn(parameterName: string) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getURL(String)","!doc":"For documentation of this method, see java.sql.CallableStatement#getURL(String)."},"getUpdateCount":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getUpdateCount()","!doc":"For documentation of this method, see java.sql.Statement#getUpdateCount()."},"getWarnings":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getWarnings()","!doc":"Returns the current set of warnings reported by the driver."},"isClosed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isClosed()","!doc":"For documentation of this method, see java.sql.Statement#isClosed()."},"isPoolable":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isPoolable()","!doc":"For documentation of this method, see java.sql.Statement#isPoolable()."},"registerOutParameter":{"!type":"fn(parameterName: string, sqlType: number, typeName: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#registerOutParameter(String,Integer,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#registerOutParameter(String, int, String)."},"setArray":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcArray)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setArray(Integer,JdbcArray)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setArray(int, java.sql.Array)."},"setBigDecimal":{"!type":"fn(parameterName: string, x: bignumber)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBigDecimal(String,BigNumber)","!doc":"For documentation of this method, see java.sql.CallableStatement#setBigDecimal(String, java.math.BigDecimal)."},"setBlob":{"!type":"fn(parameterName: string, x: jdbc.JdbcBlob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBlob(String,JdbcBlob)","!doc":"For documentation of this method, see java.sql.CallableStatement#setBlob(String, java.sql.Blob)."},"setBoolean":{"!type":"fn(parameterName: string, x: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBoolean(String,Boolean)","!doc":"For documentation of this method, see java.sql.CallableStatement#setBoolean(String, boolean)."},"setByte":{"!type":"fn(parameterName: string, x: byte)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setByte(String,Byte)","!doc":"For documentation of this method, see java.sql.CallableStatement#setByte(String, byte)."},"setBytes":{"!type":"fn(parameterName: string, x: [byte])","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBytes(String,Byte)","!doc":"For documentation of this method, see java.sql.CallableStatement#setBytes(String, byte[])."},"setClob":{"!type":"fn(parameterName: string, x: jdbc.JdbcClob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setClob(String,JdbcClob)","!doc":"For documentation of this method, see java.sql.CallableStatement#setClob(String, java.sql.Clob)."},"setCursorName":{"!type":"fn(name: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setCursorName(String)","!doc":"For documentation of this method, see java.sql.Statement#setCursorName(String)."},"setDate":{"!type":"fn(parameterName: string, x: jdbc.JdbcDate, timeZone: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setDate(String,JdbcDate,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#setDate(String, java.sql.Date, java.util.Calendar)."},"setDouble":{"!type":"fn(parameterName: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setDouble(String,Number)","!doc":"For documentation of this method, see java.sql.CallableStatement#setDouble(String, double)."},"setEscapeProcessing":{"!type":"fn(enable: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setEscapeProcessing(Boolean)","!doc":"For documentation of this method, see java.sql.Statement#setEscapeProcessing(boolean)."},"setFetchDirection":{"!type":"fn(direction: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchDirection(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setFetchDirection(int)."},"setFetchSize":{"!type":"fn(rows: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchSize(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setFetchSize(int)."},"setFloat":{"!type":"fn(parameterName: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFloat(String,Number)","!doc":"For documentation of this method, see java.sql.CallableStatement#setFloat(String, float)."},"setInt":{"!type":"fn(parameterName: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setInt(String,Integer)","!doc":"For documentation of this method, see java.sql.CallableStatement#setInt(String, int)."},"setLong":{"!type":"fn(parameterName: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setLong(String,Integer)","!doc":"For documentation of this method, see java.sql.CallableStatement#setLong(String, long)."},"setMaxFieldSize":{"!type":"fn(max: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMaxFieldSize(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setMaxFieldSize(int)."},"setMaxRows":{"!type":"fn(max: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMaxRows(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setMaxRows(int)."},"setNClob":{"!type":"fn(parameterName: string, value: jdbc.JdbcClob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setNClob(String,JdbcClob)","!doc":"For documentation of this method, see java.sql.CallableStatement#setNClob(String, java.sql.NClob)."},"setNString":{"!type":"fn(parameterName: string, value: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setNString(String,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#setNString(String, String)."},"setNull":{"!type":"fn(parameterName: string, sqlType: number, typeName: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setNull(String,Integer,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#setNull(String, int, String)."},"setObject":{"!type":"fn(parameterName: string, x: object, targetSqlType: number, scale: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setObject(String,Object,Integer,Integer)","!doc":"For documentation of this method, see java.sql.CallableStatement#setObject(String, Object, int, int)."},"setPoolable":{"!type":"fn(poolable: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setPoolable(Boolean)","!doc":"For documentation of this method, see java.sql.Statement#setPoolable(boolean)."},"setQueryTimeout":{"!type":"fn(seconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setQueryTimeout(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setQueryTimeout(int)."},"setRef":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcRef)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setRef(Integer,JdbcRef)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setRef(int, java.sql.Ref)."},"setRowId":{"!type":"fn(parameterName: string, x: jdbc.JdbcRowId)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setRowId(String,JdbcRowId)","!doc":"For documentation of this method, see java.sql.CallableStatement#setRowId(String, java.sql.RowId)."},"setSQLXML":{"!type":"fn(parameterName: string, xmlObject: jdbc.JdbcSQLXML)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setSQLXML(String,JdbcSQLXML)","!doc":"For documentation of this method, see java.sql.CallableStatement#setSQLXML(String, java.sql.SQLXML)."},"setShort":{"!type":"fn(parameterName: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setShort(String,Integer)","!doc":"For documentation of this method, see java.sql.CallableStatement#setShort(String, short)."},"setString":{"!type":"fn(parameterName: string, x: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setString(String,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#setString(String, String)."},"setTime":{"!type":"fn(parameterName: string, x: jdbc.JdbcTime, timeZone: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTime(String,JdbcTime,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#setTime(String, java.sql.Time, java.util.Calendar)."},"setTimestamp":{"!type":"fn(parameterName: string, x: jdbc.JdbcTimestamp, timeZone: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTimestamp(String,JdbcTimestamp,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#setTimestamp(String, java.sql.Timestamp, java.util.Calendar)."},"setURL":{"!type":"fn(parameterName: string, val: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setURL(String,String)","!doc":"For documentation of this method, see java.sql.CallableStatement#setURL(String, java.net.URL)."},"wasNull":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#wasNull()","!doc":"For documentation of this method, see java.sql.CallableStatement#wasNull()."}}},"JdbcClob":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-clob","!doc":"JdbcClob A JDBC Clob. For documentation of this class, see java.sql.Clob.","prototype":{"free":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#free()","!doc":"For documentation of this method, see java.sql.Clob#free()."},"getAppsScriptBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getAppsScriptBlob()","!doc":"Gets the content of this JdbcClob as an Apps Script blob."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getSubString":{"!type":"fn(position: number, length: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSubString(Integer,Integer)","!doc":"For documentation of this method, see java.sql.Clob#getSubString(long, int)."},"length":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#length()","!doc":"For documentation of this method, see java.sql.Clob#length()."},"position":{"!type":"fn(search: string, start: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#position(String,Integer)","!doc":"For documentation of this method, see java.sql.Clob#position(String, long)."},"setString":{"!type":"fn(position: number, value: string, offset: number, len: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#setString(Integer,String,Integer,Integer)","!doc":"For documentation of this method, see java.sql.Clob#setString(long, String, int, int)."},"truncate":{"!type":"fn(length: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#truncate(Integer)","!doc":"For documentation of this method, see java.sql.Clob#truncate(long)."}}},"JdbcConnection":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-connection","!doc":"JdbcConnection A JDBC Connection. For documentation of this class, see java.sql.Connection.","prototype":{"clearWarnings":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearWarnings()","!doc":"For documentation of this method, see java.sql.Connection#clearWarnings()."},"close":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#close()","!doc":"Release the JdbcConnection's database and all associated resources."},"commit":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#commit()","!doc":"Makes all pending changes permanent, releases database locks held by this JdbcConnection."},"createArrayOf":{"!type":"fn(typeName: string, elements: [object]) -> +jdbc.JdbcArray","!url":"http://developers.google.com/apps-script/reference/jdbc/#createArrayOf(String,Object)","!doc":"For documentation of this method, see java.sql.Connection#createArrayOf(String, Object[])."},"createBlob":{"!type":"fn() -> +jdbc.JdbcBlob","!url":"http://developers.google.com/apps-script/reference/jdbc/#createBlob()","!doc":"Constructs a JdbcBlob instance The object returned initially contains no data."},"createClob":{"!type":"fn() -> +jdbc.JdbcClob","!url":"http://developers.google.com/apps-script/reference/jdbc/#createClob()","!doc":"For documentation of this method, see java.sql.Connection#createClob()."},"createNClob":{"!type":"fn() -> +jdbc.JdbcClob","!url":"http://developers.google.com/apps-script/reference/jdbc/#createNClob()","!doc":"For documentation of this method, see java.sql.Connection#createNClob()."},"createSQLXML":{"!type":"fn() -> +jdbc.JdbcSQLXML","!url":"http://developers.google.com/apps-script/reference/jdbc/#createSQLXML()","!doc":"For documentation of this method, see java.sql.Connection#createSQLXML()."},"createStatement":{"!type":"fn(resultSetType: number, resultSetConcurrency: number, resultSetHoldability: number) -> +jdbc.JdbcStatement","!url":"http://developers.google.com/apps-script/reference/jdbc/#createStatement(Integer,Integer,Integer)","!doc":"Creates a JdbcStatement object for sending SQL statements to the database."},"createStruct":{"!type":"fn(typeName: string, attributes: [object]) -> +jdbc.JdbcStruct","!url":"http://developers.google.com/apps-script/reference/jdbc/#createStruct(String,Object)","!doc":"For documentation of this method, see java.sql.Connection#createStruct(String, Object[])."},"getAutoCommit":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#getAutoCommit()","!doc":"For documentation of this method, see java.sql.Connection#getAutoCommit()."},"getCatalog":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getCatalog()","!doc":"For documentation of this method, see java.sql.Connection#getCatalog()."},"getHoldability":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getHoldability()","!doc":"For documentation of this method, see java.sql.Connection#getHoldability()."},"getMetaData":{"!type":"fn() -> +jdbc.JdbcDatabaseMetaData","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMetaData()","!doc":"For documentation of this method, see java.sql.Connection#getMetaData()."},"getTransactionIsolation":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTransactionIsolation()","!doc":"For documentation of this method, see java.sql.Connection#getTransactionIsolation()."},"getWarnings":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getWarnings()","!doc":"For documentation of this method, see java.sql.Connection#getWarnings()."},"isClosed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isClosed()","!doc":"For documentation of this method, see java.sql.Connection#isClosed()."},"isReadOnly":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isReadOnly()","!doc":"For documentation of this method, see java.sql.Connection#isReadOnly()."},"isValid":{"!type":"fn(timeout: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isValid(Integer)","!doc":"For documentation of this method, see java.sql.Connection#isValid(int)."},"nativeSQL":{"!type":"fn(sql: string) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#nativeSQL(String)","!doc":"For documentation of this method, see java.sql.Connection#nativeSQL(String)."},"prepareCall":{"!type":"fn(sql: string, resultSetType: number, resultSetConcurrency: number, resultSetHoldability: number) -> +jdbc.JdbcCallableStatement","!url":"http://developers.google.com/apps-script/reference/jdbc/#prepareCall(String,Integer,Integer,Integer)","!doc":"For documentation of this method, see java.sql.Connection#prepareCall(String, int, int, int)."},"prepareStatement":{"!type":"fn(sql: string, resultSetType: number, resultSetConcurrency: number, resultSetHoldability: number) -> +jdbc.JdbcPreparedStatement","!url":"http://developers.google.com/apps-script/reference/jdbc/#prepareStatement(String,Integer,Integer,Integer)","!doc":"For documentation of this method, see java.sql.Connection#prepareStatement(String, int, int, int)."},"prepareStatementByIndex":{"!type":"fn(sql: string, indices: [number]) -> +jdbc.JdbcPreparedStatement","!url":"http://developers.google.com/apps-script/reference/jdbc/#prepareStatementByIndex(String,Integer)","!doc":"For documentation of this method, see java.sql.Connection#prepareStatement(String, int[])."},"prepareStatementByName":{"!type":"fn(sql: string, columnNames: [string]) -> +jdbc.JdbcPreparedStatement","!url":"http://developers.google.com/apps-script/reference/jdbc/#prepareStatementByName(String,String)","!doc":"For documentation of this method, see java.sql.Connection#prepareStatement(String, String[])."},"releaseSavepoint":{"!type":"fn(savepoint: jdbc.JdbcSavepoint)","!url":"http://developers.google.com/apps-script/reference/jdbc/#releaseSavepoint(JdbcSavepoint)","!doc":"For documentation of this method, see java.sql.Connection#releaseSavepoint(java.sql.Savepoint)."},"rollback":{"!type":"fn(savepoint: jdbc.JdbcSavepoint)","!url":"http://developers.google.com/apps-script/reference/jdbc/#rollback(JdbcSavepoint)","!doc":"For documentation of this method, see java.sql.Connection#rollback(java.sql.Savepoint)."},"setAutoCommit":{"!type":"fn(autoCommit: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setAutoCommit(Boolean)","!doc":"For documentation of this method, see java.sql.Connection#setAutoCommit(boolean)."},"setCatalog":{"!type":"fn(catalog: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setCatalog(String)","!doc":"For documentation of this method, see java.sql.Connection#setCatalog(String)."},"setHoldability":{"!type":"fn(holdability: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setHoldability(Integer)","!doc":"For documentation of this method, see java.sql.Connection#setHoldability(int)."},"setReadOnly":{"!type":"fn(readOnly: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setReadOnly(Boolean)","!doc":"For documentation of this method, see java.sql.Connection#setReadOnly(boolean)."},"setSavepoint":{"!type":"fn(name: string) -> +jdbc.JdbcSavepoint","!url":"http://developers.google.com/apps-script/reference/jdbc/#setSavepoint(String)","!doc":"For documentation of this method, see java.sql.Connection#setSavepoint(String)."},"setTransactionIsolation":{"!type":"fn(level: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTransactionIsolation(Integer)","!doc":"For documentation of this method, see java.sql.Connection#setTransactionIsolation(int)."}}},"JdbcDatabaseMetaData":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-database-meta-data","!doc":"JdbcDatabaseMetaData A JDBC DatabaseMetaData. For documentation of this class, see java.sql.DatabaseMetaData.","prototype":{"allProceduresAreCallable":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#allProceduresAreCallable()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#allProceduresAreCallable()."},"allTablesAreSelectable":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#allTablesAreSelectable()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#allTablesAreSelectable()."},"autoCommitFailureClosesAllResultSets":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#autoCommitFailureClosesAllResultSets()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#autoCommitFailureClosesAllResultSets()."},"dataDefinitionCausesTransactionCommit":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#dataDefinitionCausesTransactionCommit()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#dataDefinitionCausesTransactionCommit()."},"dataDefinitionIgnoredInTransactions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#dataDefinitionIgnoredInTransactions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#dataDefinitionIgnoredInTransactions()."},"deletesAreDetected":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#deletesAreDetected(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#deletesAreDetected(int)."},"doesMaxRowSizeIncludeBlobs":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#doesMaxRowSizeIncludeBlobs()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#doesMaxRowSizeIncludeBlobs()."},"getAttributes":{"!type":"fn(catalog: string, schemaPattern: string, typeNamePattern: string, attributeNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getAttributes(String,String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getAttributes(String, String, String, String)."},"getBestRowIdentifier":{"!type":"fn(catalog: string, schema: string, table: string, scope: number, nullable: bool) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBestRowIdentifier(String,String,String,Integer,Boolean)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getBestRowIdentifier(String, String, String, int, boolean)."},"getCatalogSeparator":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getCatalogSeparator()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getCatalogSeparator()."},"getCatalogTerm":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getCatalogTerm()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getCatalogTerm()."},"getCatalogs":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getCatalogs()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getCatalogs()."},"getClientInfoProperties":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getClientInfoProperties()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getClientInfoProperties()."},"getColumnPrivileges":{"!type":"fn(catalog: string, schema: string, table: string, columnNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnPrivileges(String,String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getColumnPrivileges(String, String, String, String)."},"getColumns":{"!type":"fn(catalog: string, schemaPattern: string, tableNamePattern: string, columnNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumns(String,String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getColumns(String, String, String, String)."},"getConnection":{"!type":"fn() -> +jdbc.JdbcConnection","!url":"http://developers.google.com/apps-script/reference/jdbc/#getConnection()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getConnection()."},"getCrossReference":{"!type":"fn(parentCatalog: string, parentSchema: string, parentTable: string, foreignCatalog: string, foreignSchema: string, foreignTable: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getCrossReference(String,String,String,String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getCrossReference(String, String, String, String, String, String)."},"getDatabaseMajorVersion":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDatabaseMajorVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDatabaseMajorVersion()."},"getDatabaseMinorVersion":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDatabaseMinorVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDatabaseMinorVersion()."},"getDatabaseProductName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDatabaseProductName()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDatabaseProductName()."},"getDatabaseProductVersion":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDatabaseProductVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDatabaseProductVersion()."},"getDefaultTransactionIsolation":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDefaultTransactionIsolation()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDefaultTransactionIsolation()."},"getDriverMajorVersion":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDriverMajorVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDriverMajorVersion()."},"getDriverMinorVersion":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDriverMinorVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDriverMinorVersion()."},"getDriverName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDriverName()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDriverName()."},"getDriverVersion":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDriverVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getDriverVersion()."},"getExportedKeys":{"!type":"fn(catalog: string, schema: string, table: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getExportedKeys(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getExportedKeys(String, String, String)."},"getExtraNameCharacters":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getExtraNameCharacters()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getExtraNameCharacters()."},"getFunctionColumns":{"!type":"fn(catalog: string, schemaPattern: string, functionNamePattern: string, columnNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFunctionColumns(String,String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getFunctionColumns(String, String, String, String)."},"getFunctions":{"!type":"fn(catalog: string, schemaPattern: string, functionNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFunctions(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getFunctions(String, String, String)."},"getIdentifierQuoteString":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getIdentifierQuoteString()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getIdentifierQuoteString()."},"getImportedKeys":{"!type":"fn(catalog: string, schema: string, table: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getImportedKeys(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getImportedKeys(String, String, String)."},"getIndexInfo":{"!type":"fn(catalog: string, schema: string, table: string, unique: bool, approximate: bool) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getIndexInfo(String,String,String,Boolean,Boolean)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getIndexInfo(String, String, String, boolean, boolean)."},"getJDBCMajorVersion":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getJDBCMajorVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getJDBCMajorVersion()."},"getJDBCMinorVersion":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getJDBCMinorVersion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getJDBCMinorVersion()."},"getMaxBinaryLiteralLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxBinaryLiteralLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxBinaryLiteralLength()."},"getMaxCatalogNameLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxCatalogNameLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxCatalogNameLength()."},"getMaxCharLiteralLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxCharLiteralLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxCharLiteralLength()."},"getMaxColumnNameLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxColumnNameLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxColumnNameLength()."},"getMaxColumnsInGroupBy":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxColumnsInGroupBy()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxColumnsInGroupBy()."},"getMaxColumnsInIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxColumnsInIndex()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxColumnsInIndex()."},"getMaxColumnsInOrderBy":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxColumnsInOrderBy()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxColumnsInOrderBy()."},"getMaxColumnsInSelect":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxColumnsInSelect()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxColumnsInSelect()."},"getMaxColumnsInTable":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxColumnsInTable()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxColumnsInTable()."},"getMaxConnections":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxConnections()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxConnections()."},"getMaxCursorNameLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxCursorNameLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxCursorNameLength()."},"getMaxIndexLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxIndexLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxIndexLength()."},"getMaxProcedureNameLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxProcedureNameLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxProcedureNameLength()."},"getMaxRowSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxRowSize()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxRowSize()."},"getMaxSchemaNameLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxSchemaNameLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxSchemaNameLength()."},"getMaxStatementLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxStatementLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxStatementLength()."},"getMaxStatements":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxStatements()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxStatements()."},"getMaxTableNameLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxTableNameLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxTableNameLength()."},"getMaxTablesInSelect":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxTablesInSelect()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxTablesInSelect()."},"getMaxUserNameLength":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxUserNameLength()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getMaxUserNameLength()."},"getNumericFunctions":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getNumericFunctions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getNumericFunctions()."},"getPrimaryKeys":{"!type":"fn(catalog: string, schema: string, table: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getPrimaryKeys(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getPrimaryKeys(String, String, String)."},"getProcedureColumns":{"!type":"fn(catalog: string, schemaPattern: string, procedureNamePattern: string, columnNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getProcedureColumns(String,String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getProcedureColumns(String, String, String, String)."},"getProcedureTerm":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getProcedureTerm()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getProcedureTerm()."},"getProcedures":{"!type":"fn(catalog: string, schemaPattern: string, procedureNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getProcedures(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getProcedures(String, String, String)."},"getResultSetHoldability":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetHoldability()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getResultSetHoldability()."},"getRowIdLifetime":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getRowIdLifetime()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getRowIdLifetime()."},"getSQLKeywords":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSQLKeywords()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSQLKeywords()."},"getSQLStateType":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSQLStateType()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSQLStateType()."},"getSchemaTerm":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSchemaTerm()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSchemaTerm()."},"getSchemas":{"!type":"fn(catalog: string, schemaPattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSchemas(String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSchemas(String, String)."},"getSearchStringEscape":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSearchStringEscape()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSearchStringEscape()."},"getStringFunctions":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getStringFunctions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getStringFunctions()."},"getSuperTables":{"!type":"fn(catalog: string, schemaPattern: string, tableNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSuperTables(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSuperTables(String, String, String)."},"getSuperTypes":{"!type":"fn(catalog: string, schemaPattern: string, typeNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSuperTypes(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSuperTypes(String, String, String)."},"getSystemFunctions":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSystemFunctions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getSystemFunctions()."},"getTablePrivileges":{"!type":"fn(catalog: string, schemaPattern: string, tableNamePattern: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTablePrivileges(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getTablePrivileges(String, String, String)."},"getTableTypes":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTableTypes()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getTableTypes()."},"getTables":{"!type":"fn(catalog: string, schemaPattern: string, tableNamePattern: string, types: [string]) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTables(String,String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getTables(String, String, String, String[])."},"getTimeDateFunctions":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTimeDateFunctions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getTimeDateFunctions()."},"getTypeInfo":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTypeInfo()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getTypeInfo()."},"getUDTs":{"!type":"fn(catalog: string, schemaPattern: string, typeNamePattern: string, types: [number]) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getUDTs(String,String,String,Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getUDTs(String, String, String, int[])."},"getURL":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getURL()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getURL()."},"getUserName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getUserName()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getUserName()."},"getVersionColumns":{"!type":"fn(catalog: string, schema: string, table: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getVersionColumns(String,String,String)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#getVersionColumns(String, String, String)."},"insertsAreDetected":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#insertsAreDetected(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#insertsAreDetected(int)."},"isCatalogAtStart":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isCatalogAtStart()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#isCatalogAtStart()."},"isReadOnly":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isReadOnly()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#isReadOnly()."},"locatorsUpdateCopy":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#locatorsUpdateCopy()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#locatorsUpdateCopy()."},"nullPlusNonNullIsNull":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#nullPlusNonNullIsNull()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#nullPlusNonNullIsNull()."},"nullsAreSortedAtEnd":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#nullsAreSortedAtEnd()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#nullsAreSortedAtEnd()."},"nullsAreSortedAtStart":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#nullsAreSortedAtStart()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#nullsAreSortedAtStart()."},"nullsAreSortedHigh":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#nullsAreSortedHigh()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#nullsAreSortedHigh()."},"nullsAreSortedLow":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#nullsAreSortedLow()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#nullsAreSortedLow()."},"othersDeletesAreVisible":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#othersDeletesAreVisible(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#othersDeletesAreVisible(int)."},"othersInsertsAreVisible":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#othersInsertsAreVisible(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#othersInsertsAreVisible(int)."},"othersUpdatesAreVisible":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#othersUpdatesAreVisible(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#othersUpdatesAreVisible(int)."},"ownDeletesAreVisible":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#ownDeletesAreVisible(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#ownDeletesAreVisible(int)."},"ownInsertsAreVisible":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#ownInsertsAreVisible(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#ownInsertsAreVisible(int)."},"ownUpdatesAreVisible":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#ownUpdatesAreVisible(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#ownUpdatesAreVisible(int)."},"storesLowerCaseIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#storesLowerCaseIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#storesLowerCaseIdentifiers()."},"storesLowerCaseQuotedIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#storesLowerCaseQuotedIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#storesLowerCaseQuotedIdentifiers()."},"storesMixedCaseIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#storesMixedCaseIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#storesMixedCaseIdentifiers()."},"storesMixedCaseQuotedIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#storesMixedCaseQuotedIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#storesMixedCaseQuotedIdentifiers()."},"storesUpperCaseIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#storesUpperCaseIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#storesUpperCaseIdentifiers()."},"storesUpperCaseQuotedIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#storesUpperCaseQuotedIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#storesUpperCaseQuotedIdentifiers()."},"supportsANSI92EntryLevelSQL":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsANSI92EntryLevelSQL()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsANSI92EntryLevelSQL()."},"supportsANSI92FullSQL":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsANSI92FullSQL()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsANSI92FullSQL()."},"supportsANSI92IntermediateSQL":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsANSI92IntermediateSQL()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsANSI92IntermediateSQL()."},"supportsAlterTableWithAddColumn":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsAlterTableWithAddColumn()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsAlterTableWithAddColumn()."},"supportsAlterTableWithDropColumn":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsAlterTableWithDropColumn()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsAlterTableWithDropColumn()."},"supportsBatchUpdates":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsBatchUpdates()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsBatchUpdates()."},"supportsCatalogsInDataManipulation":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsCatalogsInDataManipulation()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsCatalogsInDataManipulation()."},"supportsCatalogsInIndexDefinitions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsCatalogsInIndexDefinitions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsCatalogsInIndexDefinitions()."},"supportsCatalogsInPrivilegeDefinitions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsCatalogsInPrivilegeDefinitions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsCatalogsInPrivilegeDefinitions()."},"supportsCatalogsInProcedureCalls":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsCatalogsInProcedureCalls()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsCatalogsInProcedureCalls()."},"supportsCatalogsInTableDefinitions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsCatalogsInTableDefinitions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsCatalogsInTableDefinitions()."},"supportsColumnAliasing":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsColumnAliasing()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsColumnAliasing()."},"supportsConvert":{"!type":"fn(fromType: number, toType: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsConvert(Integer,Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsConvert(int, int)."},"supportsCoreSQLGrammar":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsCoreSQLGrammar()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsCoreSQLGrammar()."},"supportsCorrelatedSubqueries":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsCorrelatedSubqueries()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsCorrelatedSubqueries()."},"supportsDataDefinitionAndDataManipulationTransactions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsDataDefinitionAndDataManipulationTransactions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsDataDefinitionAndDataManipulationTransactions()."},"supportsDataManipulationTransactionsOnly":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsDataManipulationTransactionsOnly()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsDataManipulationTransactionsOnly()."},"supportsDifferentTableCorrelationNames":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsDifferentTableCorrelationNames()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsDifferentTableCorrelationNames()."},"supportsExpressionsInOrderBy":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsExpressionsInOrderBy()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsExpressionsInOrderBy()."},"supportsExtendedSQLGrammar":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsExtendedSQLGrammar()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsExtendedSQLGrammar()."},"supportsFullOuterJoins":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsFullOuterJoins()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsFullOuterJoins()."},"supportsGetGeneratedKeys":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsGetGeneratedKeys()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsGetGeneratedKeys()."},"supportsGroupBy":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsGroupBy()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsGroupBy()."},"supportsGroupByBeyondSelect":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsGroupByBeyondSelect()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsGroupByBeyondSelect()."},"supportsGroupByUnrelated":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsGroupByUnrelated()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsGroupByUnrelated()."},"supportsIntegrityEnhancementFacility":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsIntegrityEnhancementFacility()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsIntegrityEnhancementFacility()."},"supportsLikeEscapeClause":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsLikeEscapeClause()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsLikeEscapeClause()."},"supportsLimitedOuterJoins":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsLimitedOuterJoins()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsLimitedOuterJoins()."},"supportsMinimumSQLGrammar":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsMinimumSQLGrammar()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsMinimumSQLGrammar()."},"supportsMixedCaseIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsMixedCaseIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsMixedCaseIdentifiers()."},"supportsMixedCaseQuotedIdentifiers":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsMixedCaseQuotedIdentifiers()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsMixedCaseQuotedIdentifiers()."},"supportsMultipleOpenResults":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsMultipleOpenResults()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsMultipleOpenResults()."},"supportsMultipleResultSets":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsMultipleResultSets()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsMultipleResultSets()."},"supportsMultipleTransactions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsMultipleTransactions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsMultipleTransactions()."},"supportsNamedParameters":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsNamedParameters()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsNamedParameters()."},"supportsNonNullableColumns":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsNonNullableColumns()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsNonNullableColumns()."},"supportsOpenCursorsAcrossCommit":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsOpenCursorsAcrossCommit()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsOpenCursorsAcrossCommit()."},"supportsOpenCursorsAcrossRollback":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsOpenCursorsAcrossRollback()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsOpenCursorsAcrossRollback()."},"supportsOpenStatementsAcrossCommit":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsOpenStatementsAcrossCommit()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsOpenStatementsAcrossCommit()."},"supportsOpenStatementsAcrossRollback":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsOpenStatementsAcrossRollback()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsOpenStatementsAcrossRollback()."},"supportsOrderByUnrelated":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsOrderByUnrelated()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsOrderByUnrelated()."},"supportsOuterJoins":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsOuterJoins()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsOuterJoins()."},"supportsPositionedDelete":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsPositionedDelete()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsPositionedDelete()."},"supportsPositionedUpdate":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsPositionedUpdate()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsPositionedUpdate()."},"supportsResultSetConcurrency":{"!type":"fn(type: number, concurrency: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsResultSetConcurrency(Integer,Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsResultSetConcurrency(int, int)."},"supportsResultSetHoldability":{"!type":"fn(holdability: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsResultSetHoldability(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsResultSetHoldability(int)."},"supportsResultSetType":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsResultSetType(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsResultSetType(int)."},"supportsSavepoints":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSavepoints()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSavepoints()."},"supportsSchemasInDataManipulation":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSchemasInDataManipulation()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSchemasInDataManipulation()."},"supportsSchemasInIndexDefinitions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSchemasInIndexDefinitions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSchemasInIndexDefinitions()."},"supportsSchemasInPrivilegeDefinitions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSchemasInPrivilegeDefinitions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSchemasInPrivilegeDefinitions()."},"supportsSchemasInProcedureCalls":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSchemasInProcedureCalls()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSchemasInProcedureCalls()."},"supportsSchemasInTableDefinitions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSchemasInTableDefinitions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSchemasInTableDefinitions()."},"supportsSelectForUpdate":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSelectForUpdate()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSelectForUpdate()."},"supportsStatementPooling":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsStatementPooling()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsStatementPooling()."},"supportsStoredFunctionsUsingCallSyntax":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsStoredFunctionsUsingCallSyntax()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsStoredFunctionsUsingCallSyntax()."},"supportsStoredProcedures":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsStoredProcedures()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsStoredProcedures()."},"supportsSubqueriesInComparisons":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSubqueriesInComparisons()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSubqueriesInComparisons()."},"supportsSubqueriesInExists":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSubqueriesInExists()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSubqueriesInExists()."},"supportsSubqueriesInIns":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSubqueriesInIns()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSubqueriesInIns()."},"supportsSubqueriesInQuantifieds":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsSubqueriesInQuantifieds()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsSubqueriesInQuantifieds()."},"supportsTableCorrelationNames":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsTableCorrelationNames()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsTableCorrelationNames()."},"supportsTransactionIsolationLevel":{"!type":"fn(level: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsTransactionIsolationLevel(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsTransactionIsolationLevel(int)."},"supportsTransactions":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsTransactions()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsTransactions()."},"supportsUnion":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsUnion()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsUnion()."},"supportsUnionAll":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#supportsUnionAll()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#supportsUnionAll()."},"updatesAreDetected":{"!type":"fn(type: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#updatesAreDetected(Integer)","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#updatesAreDetected(int)."},"usesLocalFilePerTable":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#usesLocalFilePerTable()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#usesLocalFilePerTable()."},"usesLocalFiles":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#usesLocalFiles()","!doc":"For documentation of this method, see java.sql.DatabaseMetaData#usesLocalFiles()."}}},"JdbcDate":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-date","!doc":"JdbcDate A JDBC Date. For documentation of this class, see java.sql.Date.","prototype":{"after":{"!type":"fn(when: jdbc.JdbcDate) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#after(JdbcDate)","!doc":"For documentation of this method, see java.sql.Date#after(java.util.Date)."},"before":{"!type":"fn(when: jdbc.JdbcDate) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#before(JdbcDate)","!doc":"For documentation of this method, see java.sql.Date#before(java.util.Date)."},"getDate":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDate()","!doc":"For documentation of this method, see java.sql.Date#getDate()."},"getMonth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMonth()","!doc":"For documentation of this method, see java.sql.Date#getMonth()."},"getTime":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTime()","!doc":"For documentation of this method, see java.sql.Date#getTime()."},"getYear":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getYear()","!doc":"For documentation of this method, see java.sql.Date#getYear()."},"setDate":{"!type":"fn(date: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setDate(Integer)","!doc":"For documentation of this method, see java.sql.Date#setDate(int)."},"setMonth":{"!type":"fn(month: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMonth(Integer)","!doc":"For documentation of this method, see java.sql.Date#setMonth(int)."},"setTime":{"!type":"fn(milliseconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTime(Integer)","!doc":"For documentation of this method, see java.sql.Date#setTime(long)."},"setYear":{"!type":"fn(year: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setYear(Integer)","!doc":"For documentation of this method, see java.sql.Date#setYear(int)."}}},"JdbcParameterMetaData":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-parameter-meta-data","!doc":"JdbcParameterMetaData A JDBC ParameterMetaData. For documentation of this class, see java.sql.ParameterMetaData.","prototype":{"getParameterClassName":{"!type":"fn(param: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getParameterClassName(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#getParameterClassName(int)."},"getParameterCount":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getParameterCount()","!doc":"For documentation of this method, see java.sql.ParameterMetaData#getParameterCount()."},"getParameterMode":{"!type":"fn(param: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getParameterMode(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#getParameterMode(int)."},"getParameterType":{"!type":"fn(param: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getParameterType(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#getParameterType(int)."},"getParameterTypeName":{"!type":"fn(param: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getParameterTypeName(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#getParameterTypeName(int)."},"getPrecision":{"!type":"fn(param: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getPrecision(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#getPrecision(int)."},"getScale":{"!type":"fn(param: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getScale(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#getScale(int)."},"isNullable":{"!type":"fn(param: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#isNullable(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#isNullable(int)."},"isSigned":{"!type":"fn(param: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isSigned(Integer)","!doc":"For documentation of this method, see java.sql.ParameterMetaData#isSigned(int)."}}},"JdbcPreparedStatement":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-prepared-statement","!doc":"JdbcPreparedStatement A JDBC PreparedStatement. For documentation of this class, see java.sql.PreparedStatement.","prototype":{"addBatch":{"!type":"fn(sql: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#addBatch(String)","!doc":"For documentation of this method, see java.sql.Statement#addBatch(String)."},"cancel":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#cancel()","!doc":"For documentation of this method, see java.sql.Statement#cancel()."},"clearBatch":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearBatch()","!doc":"For documentation of this method, see java.sql.Statement#clearBatch()."},"clearParameters":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearParameters()","!doc":"For documentation of this method, see java.sql.PreparedStatement#clearParameters()."},"clearWarnings":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearWarnings()","!doc":"For documentation of this method, see java.sql.Statement#clearWarnings()."},"close":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#close()","!doc":"For documentation of this method, see java.sql.Statement#close()."},"execute":{"!type":"fn(sql: string, columnNames: [string]) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#execute(String,String)","!doc":"For documentation of this method, see java.sql.Statement#execute(String, String[])."},"executeBatch":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeBatch()","!doc":"For documentation of this method, see java.sql.Statement#executeBatch()."},"executeQuery":{"!type":"fn(sql: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeQuery(String)","!doc":"For documentation of this method, see java.sql.Statement#executeQuery(String)."},"executeUpdate":{"!type":"fn(sql: string, columnNames: [string]) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeUpdate(String,String)","!doc":"For documentation of this method, see java.sql.Statement#executeUpdate(String, String[])."},"getConnection":{"!type":"fn() -> +jdbc.JdbcConnection","!url":"http://developers.google.com/apps-script/reference/jdbc/#getConnection()","!doc":"For documentation of this method, see java.sql.Statement#getConnection()."},"getFetchDirection":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchDirection()","!doc":"For documentation of this method, see java.sql.Statement#getFetchDirection()."},"getFetchSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchSize()","!doc":"For documentation of this method, see java.sql.Statement#getFetchSize()."},"getGeneratedKeys":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getGeneratedKeys()","!doc":"For documentation of this method, see java.sql.Statement#getGeneratedKeys()."},"getMaxFieldSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxFieldSize()","!doc":"For documentation of this method, see java.sql.Statement#getMaxFieldSize()."},"getMaxRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxRows()","!doc":"For documentation of this method, see java.sql.Statement#getMaxRows()."},"getMetaData":{"!type":"fn() -> +jdbc.JdbcResultSetMetaData","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMetaData()","!doc":"For documentation of this method, see java.sql.PreparedStatement#getMetaData()."},"getMoreResults":{"!type":"fn(current: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMoreResults(Integer)","!doc":"For documentation of this method, see java.sql.Statement#getMoreResults(int)."},"getParameterMetaData":{"!type":"fn() -> +jdbc.JdbcParameterMetaData","!url":"http://developers.google.com/apps-script/reference/jdbc/#getParameterMetaData()","!doc":"For documentation of this method, see java.sql.PreparedStatement#getParameterMetaData()."},"getQueryTimeout":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getQueryTimeout()","!doc":"For documentation of this method, see java.sql.Statement#getQueryTimeout()."},"getResultSet":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSet()","!doc":"For documentation of this method, see java.sql.Statement#getResultSet()."},"getResultSetConcurrency":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetConcurrency()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetConcurrency()."},"getResultSetHoldability":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetHoldability()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetHoldability()."},"getResultSetType":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetType()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetType()."},"getUpdateCount":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getUpdateCount()","!doc":"For documentation of this method, see java.sql.Statement#getUpdateCount()."},"getWarnings":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getWarnings()","!doc":"Returns the current set of warnings reported by the driver."},"isClosed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isClosed()","!doc":"For documentation of this method, see java.sql.Statement#isClosed()."},"isPoolable":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isPoolable()","!doc":"For documentation of this method, see java.sql.Statement#isPoolable()."},"setArray":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcArray)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setArray(Integer,JdbcArray)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setArray(int, java.sql.Array)."},"setBigDecimal":{"!type":"fn(parameterIndex: number, x: bignumber)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBigDecimal(Integer,BigNumber)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setBigDecimal(int, java.math.BigDecimal)."},"setBlob":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcBlob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBlob(Integer,JdbcBlob)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setBlob(int, java.sql.Blob)."},"setBoolean":{"!type":"fn(parameterIndex: number, x: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBoolean(Integer,Boolean)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setBoolean(int, boolean)."},"setByte":{"!type":"fn(parameterIndex: number, x: byte)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setByte(Integer,Byte)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setByte(int, byte)."},"setBytes":{"!type":"fn(parameterIndex: number, x: [byte])","!url":"http://developers.google.com/apps-script/reference/jdbc/#setBytes(Integer,Byte)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setBytes(int, byte[])."},"setClob":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcClob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setClob(Integer,JdbcClob)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setClob(int, java.sql.Clob)."},"setCursorName":{"!type":"fn(name: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setCursorName(String)","!doc":"For documentation of this method, see java.sql.Statement#setCursorName(String)."},"setDate":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcDate, timeZone: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setDate(Integer,JdbcDate,String)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setDate(int, java.sql.Date, java.util.Calendar)."},"setDouble":{"!type":"fn(parameterIndex: number, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setDouble(Integer,Number)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setDouble(int, double)."},"setEscapeProcessing":{"!type":"fn(enable: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setEscapeProcessing(Boolean)","!doc":"For documentation of this method, see java.sql.Statement#setEscapeProcessing(boolean)."},"setFetchDirection":{"!type":"fn(direction: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchDirection(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setFetchDirection(int)."},"setFetchSize":{"!type":"fn(rows: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchSize(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setFetchSize(int)."},"setFloat":{"!type":"fn(parameterIndex: number, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFloat(Integer,Number)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setFloat(int, float)."},"setInt":{"!type":"fn(parameterIndex: number, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setInt(Integer,Integer)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setInt(int, int)."},"setLong":{"!type":"fn(parameterIndex: number, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setLong(Integer,Integer)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setLong(int, long)."},"setMaxFieldSize":{"!type":"fn(max: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMaxFieldSize(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setMaxFieldSize(int)."},"setMaxRows":{"!type":"fn(max: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMaxRows(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setMaxRows(int)."},"setNClob":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcClob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setNClob(Integer,JdbcClob)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setNClob(int, java.sql.NClob)."},"setNString":{"!type":"fn(parameterIndex: number, x: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setNString(Integer,String)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setNString(int, String)."},"setNull":{"!type":"fn(parameterIndex: number, sqlType: number, typeName: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setNull(Integer,Integer,String)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setNull(int, int, String)."},"setObject":{"!type":"fn(parameterIndex: number, x: object, targetSqlType: number, scaleOrLength: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setObject(Integer,Object,Integer,Integer)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setObject(int, Object, int, int)."},"setPoolable":{"!type":"fn(poolable: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setPoolable(Boolean)","!doc":"For documentation of this method, see java.sql.Statement#setPoolable(boolean)."},"setQueryTimeout":{"!type":"fn(seconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setQueryTimeout(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setQueryTimeout(int)."},"setRef":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcRef)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setRef(Integer,JdbcRef)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setRef(int, java.sql.Ref)."},"setRowId":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcRowId)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setRowId(Integer,JdbcRowId)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setRowId(int, java.sql.RowId)."},"setSQLXML":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcSQLXML)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setSQLXML(Integer,JdbcSQLXML)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setSQLXML(int, java.sql.SQLXML)."},"setShort":{"!type":"fn(parameterIndex: number, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setShort(Integer,Integer)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setShort(int, short)."},"setString":{"!type":"fn(parameterIndex: number, x: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setString(Integer,String)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setString(int, String)."},"setTime":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcTime, timeZone: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTime(Integer,JdbcTime,String)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setTime(int, java.sql.Time, java.util.Calendar)."},"setTimestamp":{"!type":"fn(parameterIndex: number, x: jdbc.JdbcTimestamp, timeZone: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTimestamp(Integer,JdbcTimestamp,String)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setTimestamp(int, java.sql.Timestamp, java.util.Calendar)."},"setURL":{"!type":"fn(parameterIndex: number, x: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setURL(Integer,String)","!doc":"For documentation of this method, see java.sql.PreparedStatement#setURL(int, java.net.URL)."}}},"JdbcRef":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-ref","!doc":"JdbcRef A JDBC Ref. For documentation of this class, see java.sql.Ref.","prototype":{"getBaseTypeName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBaseTypeName()","!doc":"For documentation of this method, see java.sql.Ref#getBaseTypeName()."},"getObject":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/jdbc/#getObject()","!doc":"For documentation of this method, see java.sql.Ref#getObject()."},"setObject":{"!type":"fn(object: object)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setObject(Object)","!doc":"For documentation of this method, see java.sql.Ref#setObject(Object)."}}},"JdbcResultSet":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-result-set","!doc":"JdbcResultSet A JDBC ResultSet. For documentation of this class, see java.sql.ResultSet.","prototype":{"absolute":{"!type":"fn(row: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#absolute(Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#absolute(int)."},"afterLast":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#afterLast()","!doc":"For documentation of this method, see java.sql.ResultSet#afterLast()."},"beforeFirst":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#beforeFirst()","!doc":"For documentation of this method, see java.sql.ResultSet#beforeFirst()."},"cancelRowUpdates":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#cancelRowUpdates()","!doc":"For documentation of this method, see java.sql.ResultSet#cancelRowUpdates()."},"clearWarnings":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearWarnings()","!doc":"For documentation of this method, see java.sql.ResultSet#clearWarnings()."},"close":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#close()","!doc":"For documentation of this method, see java.sql.ResultSet#close()."},"deleteRow":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#deleteRow()","!doc":"For documentation of this method, see java.sql.ResultSet#deleteRow()."},"findColumn":{"!type":"fn(columnLabel: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#findColumn(String)","!doc":"For documentation of this method, see java.sql.ResultSet#findColumn(String)."},"first":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#first()","!doc":"For documentation of this method, see java.sql.ResultSet#first()."},"getArray":{"!type":"fn(columnLabel: string) -> +jdbc.JdbcArray","!url":"http://developers.google.com/apps-script/reference/jdbc/#getArray(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getArray(String)."},"getBigDecimal":{"!type":"fn(columnLabel: string) -> bignumber","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBigDecimal(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getBigDecimal(String)."},"getBlob":{"!type":"fn(columnLabel: string) -> +jdbc.JdbcBlob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBlob(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getBlob(String)."},"getBoolean":{"!type":"fn(columnLabel: string) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBoolean(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getBoolean(String)."},"getByte":{"!type":"fn(columnLabel: string) -> byte","!url":"http://developers.google.com/apps-script/reference/jdbc/#getByte(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getByte(String)."},"getBytes":{"!type":"fn(columnLabel: string) -> [byte]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBytes(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getBytes(String)."},"getClob":{"!type":"fn(columnLabel: string) -> +jdbc.JdbcClob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getClob(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getClob(String)."},"getConcurrency":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getConcurrency()","!doc":"For documentation of this method, see java.sql.ResultSet#getConcurrency()."},"getCursorName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getCursorName()","!doc":"For documentation of this method, see java.sql.ResultSet#getCursorName()."},"getDate":{"!type":"fn(columnLabel: string, timeZone: string) -> +jdbc.JdbcDate","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDate(String,String)","!doc":"For documentation of this method, see java.sql.ResultSet#getDate(String, java.util.Calendar)."},"getDouble":{"!type":"fn(columnLabel: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDouble(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getDouble(String)."},"getFetchDirection":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchDirection()","!doc":"For documentation of this method, see java.sql.ResultSet#getFetchDirection()."},"getFetchSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchSize()","!doc":"For documentation of this method, see java.sql.ResultSet#getFetchSize()."},"getFloat":{"!type":"fn(columnLabel: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFloat(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getFloat(String)."},"getHoldability":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getHoldability()","!doc":"For documentation of this method, see java.sql.ResultSet#getHoldability()."},"getInt":{"!type":"fn(columnLabel: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getInt(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getInt(String)."},"getLong":{"!type":"fn(columnLabel: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getLong(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getLong(String)."},"getMetaData":{"!type":"fn() -> +jdbc.JdbcResultSetMetaData","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMetaData()","!doc":"For documentation of this method, see java.sql.ResultSet#getMetaData()."},"getNClob":{"!type":"fn(columnLabel: string) -> +jdbc.JdbcClob","!url":"http://developers.google.com/apps-script/reference/jdbc/#getNClob(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getNClob(String)."},"getNString":{"!type":"fn(columnLabel: string) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getNString(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getNString(String)."},"getObject":{"!type":"fn(columnLabel: string) -> object","!url":"http://developers.google.com/apps-script/reference/jdbc/#getObject(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getObject(String)."},"getRef":{"!type":"fn(columnLabel: string) -> +jdbc.JdbcRef","!url":"http://developers.google.com/apps-script/reference/jdbc/#getRef(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getRef(String)."},"getRow":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getRow()","!doc":"For documentation of this method, see java.sql.ResultSet#getRow()."},"getRowId":{"!type":"fn(columnLabel: string) -> +jdbc.JdbcRowId","!url":"http://developers.google.com/apps-script/reference/jdbc/#getRowId(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getRowId(String)."},"getSQLXML":{"!type":"fn(columnLabel: string) -> +jdbc.JdbcSQLXML","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSQLXML(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getSQLXML(String)."},"getShort":{"!type":"fn(columnLabel: string) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getShort(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getShort(String)."},"getStatement":{"!type":"fn() -> +jdbc.JdbcStatement","!url":"http://developers.google.com/apps-script/reference/jdbc/#getStatement()","!doc":"For documentation of this method, see java.sql.ResultSet#getStatement()."},"getString":{"!type":"fn(columnLabel: string) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getString(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getString(String)."},"getTime":{"!type":"fn(columnLabel: string, timeZone: string) -> +jdbc.JdbcTime","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTime(String,String)","!doc":"For documentation of this method, see java.sql.ResultSet#getTime(String, java.util.Calendar)."},"getTimestamp":{"!type":"fn(columnLabel: string, timeZone: string) -> +jdbc.JdbcTimestamp","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTimestamp(String,String)","!doc":"For documentation of this method, see java.sql.ResultSet#getTimestamp(String, java.util.Calendar)."},"getType":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getType()","!doc":"For documentation of this method, see java.sql.ResultSet#getType()."},"getURL":{"!type":"fn(columnLabel: string) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getURL(String)","!doc":"For documentation of this method, see java.sql.ResultSet#getURL(String)."},"getWarnings":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getWarnings()","!doc":"Returns the current set of warnings reported by the driver."},"insertRow":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#insertRow()","!doc":"For documentation of this method, see java.sql.ResultSet#insertRow()."},"isAfterLast":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isAfterLast()","!doc":"For documentation of this method, see java.sql.ResultSet#isAfterLast()."},"isBeforeFirst":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isBeforeFirst()","!doc":"For documentation of this method, see java.sql.ResultSet#isBeforeFirst()."},"isClosed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isClosed()","!doc":"For documentation of this method, see java.sql.ResultSet#isClosed()."},"isFirst":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isFirst()","!doc":"For documentation of this method, see java.sql.ResultSet#isFirst()."},"isLast":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isLast()","!doc":"For documentation of this method, see java.sql.ResultSet#isLast()."},"last":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#last()","!doc":"For documentation of this method, see java.sql.ResultSet#last()."},"moveToCurrentRow":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#moveToCurrentRow()","!doc":"For documentation of this method, see java.sql.ResultSet#moveToCurrentRow()."},"moveToInsertRow":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#moveToInsertRow()","!doc":"For documentation of this method, see java.sql.ResultSet#moveToInsertRow()."},"next":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#next()","!doc":"For documentation of this method, see java.sql.ResultSet#next()."},"previous":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#previous()","!doc":"For documentation of this method, see java.sql.ResultSet#previous()."},"refreshRow":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#refreshRow()","!doc":"For documentation of this method, see java.sql.ResultSet#refreshRow()."},"relative":{"!type":"fn(rows: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#relative(Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#relative(int)."},"rowDeleted":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#rowDeleted()","!doc":"For documentation of this method, see java.sql.ResultSet#rowDeleted()."},"rowInserted":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#rowInserted()","!doc":"For documentation of this method, see java.sql.ResultSet#rowInserted()."},"rowUpdated":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#rowUpdated()","!doc":"For documentation of this method, see java.sql.ResultSet#rowUpdated()."},"setFetchDirection":{"!type":"fn(direction: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchDirection(Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#setFetchDirection(int)."},"setFetchSize":{"!type":"fn(rows: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchSize(Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#setFetchSize(int)."},"updateArray":{"!type":"fn(columnLabel: string, x: jdbc.JdbcArray)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateArray(String,JdbcArray)","!doc":"For documentation of this method, see java.sql.ResultSet#updateArray(String, java.sql.Array)."},"updateBigDecimal":{"!type":"fn(columnLabel: string, x: bignumber)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateBigDecimal(String,BigNumber)","!doc":"For documentation of this method, see java.sql.ResultSet#updateBigDecimal(String, java.math.BigDecimal)."},"updateBlob":{"!type":"fn(columnLabel: string, x: jdbc.JdbcBlob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateBlob(String,JdbcBlob)","!doc":"For documentation of this method, see java.sql.ResultSet#updateBlob(String, java.sql.Blob)."},"updateBoolean":{"!type":"fn(columnLabel: string, x: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateBoolean(String,Boolean)","!doc":"For documentation of this method, see java.sql.ResultSet#updateBoolean(String, boolean)."},"updateByte":{"!type":"fn(columnLabel: string, x: byte)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateByte(String,Byte)","!doc":"For documentation of this method, see java.sql.ResultSet#updateByte(String, byte)."},"updateBytes":{"!type":"fn(columnLabel: string, x: [byte])","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateBytes(String,Byte)","!doc":"For documentation of this method, see java.sql.ResultSet#updateBytes(String, byte[])."},"updateClob":{"!type":"fn(columnLabel: string, x: jdbc.JdbcClob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateClob(String,JdbcClob)","!doc":"For documentation of this method, see java.sql.ResultSet#updateClob(String, java.sql.Clob)."},"updateDate":{"!type":"fn(columnLabel: string, x: jdbc.JdbcDate)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateDate(String,JdbcDate)","!doc":"For documentation of this method, see java.sql.ResultSet#updateDate(String, java.sql.Date)."},"updateDouble":{"!type":"fn(columnLabel: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateDouble(String,Number)","!doc":"For documentation of this method, see java.sql.ResultSet#updateDouble(String, double)."},"updateFloat":{"!type":"fn(columnLabel: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateFloat(String,Number)","!doc":"For documentation of this method, see java.sql.ResultSet#updateFloat(String, float)."},"updateInt":{"!type":"fn(columnLabel: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateInt(String,Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#updateInt(String, int)."},"updateLong":{"!type":"fn(columnLabel: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateLong(String,Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#updateLong(String, long)."},"updateNClob":{"!type":"fn(columnLabel: string, x: jdbc.JdbcClob)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateNClob(String,JdbcClob)","!doc":"For documentation of this method, see java.sql.ResultSet#updateNClob(String, java.sql.NClob)."},"updateNString":{"!type":"fn(columnLabel: string, x: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateNString(String,String)","!doc":"For documentation of this method, see java.sql.ResultSet#updateNString(String, String)."},"updateNull":{"!type":"fn(columnLabel: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateNull(String)","!doc":"For documentation of this method, see java.sql.ResultSet#updateNull(String)."},"updateObject":{"!type":"fn(columnLabel: string, x: object, scaleOrLength: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateObject(String,Object,Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#updateObject(String, Object, int)."},"updateRef":{"!type":"fn(columnLabel: string, x: jdbc.JdbcRef)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateRef(String,JdbcRef)","!doc":"For documentation of this method, see java.sql.ResultSet#updateRef(String, java.sql.Ref)."},"updateRow":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateRow()","!doc":"For documentation of this method, see java.sql.ResultSet#updateRow()."},"updateRowId":{"!type":"fn(columnLabel: string, x: jdbc.JdbcRowId)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateRowId(String,JdbcRowId)","!doc":"For documentation of this method, see java.sql.ResultSet#updateRowId(String, java.sql.RowId)."},"updateSQLXML":{"!type":"fn(columnLabel: string, x: jdbc.JdbcSQLXML)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateSQLXML(String,JdbcSQLXML)","!doc":"For documentation of this method, see java.sql.ResultSet#updateSQLXML(String, java.sql.SQLXML)."},"updateShort":{"!type":"fn(columnLabel: string, x: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateShort(String,Integer)","!doc":"For documentation of this method, see java.sql.ResultSet#updateShort(String, short)."},"updateString":{"!type":"fn(columnLabel: string, x: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateString(String,String)","!doc":"For documentation of this method, see java.sql.ResultSet#updateString(String, String)."},"updateTime":{"!type":"fn(columnLabel: string, x: jdbc.JdbcTime)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateTime(String,JdbcTime)","!doc":"For documentation of this method, see java.sql.ResultSet#updateTime(String, java.sql.Time)."},"updateTimestamp":{"!type":"fn(columnLabel: string, x: jdbc.JdbcTimestamp)","!url":"http://developers.google.com/apps-script/reference/jdbc/#updateTimestamp(String,JdbcTimestamp)","!doc":"For documentation of this method, see java.sql.ResultSet#updateTimestamp(String, java.sql.Timestamp)."},"wasNull":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#wasNull()","!doc":"For documentation of this method, see java.sql.ResultSet#wasNull()."}}},"JdbcResultSetMetaData":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-result-set-meta-data","!doc":"JdbcResultSetMetaData A JDBC ResultSetMetaData. For documentation of this class, see java.sql.ResultSetMetaData.","prototype":{"getCatalogName":{"!type":"fn(column: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getCatalogName(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getCatalogName(int)."},"getColumnClassName":{"!type":"fn(column: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnClassName(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getColumnClassName(int)."},"getColumnCount":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnCount()","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getColumnCount()."},"getColumnDisplaySize":{"!type":"fn(column: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnDisplaySize(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getColumnDisplaySize(int)."},"getColumnLabel":{"!type":"fn(column: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnLabel(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getColumnLabel(int)."},"getColumnName":{"!type":"fn(column: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnName(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getColumnName(int)."},"getColumnType":{"!type":"fn(column: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnType(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getColumnType(int)."},"getColumnTypeName":{"!type":"fn(column: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getColumnTypeName(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getColumnTypeName(int)."},"getPrecision":{"!type":"fn(column: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getPrecision(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getPrecision(int)."},"getScale":{"!type":"fn(column: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getScale(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getScale(int)."},"getSchemaName":{"!type":"fn(column: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSchemaName(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getSchemaName(int)."},"getTableName":{"!type":"fn(column: number) -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTableName(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#getTableName(int)."},"isAutoIncrement":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isAutoIncrement(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isAutoIncrement(int)."},"isCaseSensitive":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isCaseSensitive(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isCaseSensitive(int)."},"isCurrency":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isCurrency(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isCurrency(int)."},"isDefinitelyWritable":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isDefinitelyWritable(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isDefinitelyWritable(int)."},"isNullable":{"!type":"fn(column: number) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#isNullable(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isNullable(int)."},"isReadOnly":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isReadOnly(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isReadOnly(int)."},"isSearchable":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isSearchable(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isSearchable(int)."},"isSigned":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isSigned(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isSigned(int)."},"isWritable":{"!type":"fn(column: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isWritable(Integer)","!doc":"For documentation of this method, see java.sql.ResultSetMetaData#isWritable(int)."}}},"JdbcRowId":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-row-id","!doc":"JdbcRowId A JDBC RowId. For documentation of this class, see java.sql.RowId.","prototype":{"getBytes":{"!type":"fn() -> [byte]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getBytes()","!doc":"For documentation of this method, see java.sql.RowId#getBytes()."}}},"JdbcSQLXML":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-sqlxml","!doc":"JdbcSQLXML A JDBC SQLXML. For documentation of this class, see java.sql.SQLXML.","prototype":{"free":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#free()","!doc":"For documentation of this method, see java.sql.SQLXML#free()."},"getString":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getString()","!doc":"For documentation of this method, see java.sql.SQLXML#getString()."},"setString":{"!type":"fn(value: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setString(String)","!doc":"For documentation of this method, see java.sql.SQLXML#setString(String)."}}},"JdbcSavepoint":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-savepoint","!doc":"JdbcSavepoint A JDBC Savepoint. For documentation of this class, see java.sql.Savepoint. See also Savepoint","prototype":{"getSavepointId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSavepointId()","!doc":"For documentation of this method, see java.sql.Savepoint#getSavepointId()."},"getSavepointName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSavepointName()","!doc":"For documentation of this method, see java.sql.Savepoint#getSavepointName()."}}},"JdbcStatement":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-statement","!doc":"JdbcStatement A JDBC Statement. For documentation of this class, see java.sql.Statement.","prototype":{"addBatch":{"!type":"fn(sql: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#addBatch(String)","!doc":"For documentation of this method, see java.sql.Statement#addBatch(String)."},"cancel":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#cancel()","!doc":"For documentation of this method, see java.sql.Statement#cancel()."},"clearBatch":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearBatch()","!doc":"For documentation of this method, see java.sql.Statement#clearBatch()."},"clearWarnings":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#clearWarnings()","!doc":"For documentation of this method, see java.sql.Statement#clearWarnings()."},"close":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/jdbc/#close()","!doc":"For documentation of this method, see java.sql.Statement#close()."},"execute":{"!type":"fn(sql: string, columnNames: [string]) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#execute(String,String)","!doc":"For documentation of this method, see java.sql.Statement#execute(String, String[])."},"executeBatch":{"!type":"fn() -> [number]","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeBatch()","!doc":"For documentation of this method, see java.sql.Statement#executeBatch()."},"executeQuery":{"!type":"fn(sql: string) -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeQuery(String)","!doc":"For documentation of this method, see java.sql.Statement#executeQuery(String)."},"executeUpdate":{"!type":"fn(sql: string, columnNames: [string]) -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#executeUpdate(String,String)","!doc":"For documentation of this method, see java.sql.Statement#executeUpdate(String, String[])."},"getConnection":{"!type":"fn() -> +jdbc.JdbcConnection","!url":"http://developers.google.com/apps-script/reference/jdbc/#getConnection()","!doc":"For documentation of this method, see java.sql.Statement#getConnection()."},"getFetchDirection":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchDirection()","!doc":"For documentation of this method, see java.sql.Statement#getFetchDirection()."},"getFetchSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getFetchSize()","!doc":"For documentation of this method, see java.sql.Statement#getFetchSize()."},"getGeneratedKeys":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getGeneratedKeys()","!doc":"For documentation of this method, see java.sql.Statement#getGeneratedKeys()."},"getMaxFieldSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxFieldSize()","!doc":"For documentation of this method, see java.sql.Statement#getMaxFieldSize()."},"getMaxRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMaxRows()","!doc":"For documentation of this method, see java.sql.Statement#getMaxRows()."},"getMoreResults":{"!type":"fn(current: number) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMoreResults(Integer)","!doc":"For documentation of this method, see java.sql.Statement#getMoreResults(int)."},"getQueryTimeout":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getQueryTimeout()","!doc":"For documentation of this method, see java.sql.Statement#getQueryTimeout()."},"getResultSet":{"!type":"fn() -> +jdbc.JdbcResultSet","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSet()","!doc":"For documentation of this method, see java.sql.Statement#getResultSet()."},"getResultSetConcurrency":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetConcurrency()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetConcurrency()."},"getResultSetHoldability":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetHoldability()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetHoldability()."},"getResultSetType":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getResultSetType()","!doc":"For documentation of this method, see java.sql.Statement#getResultSetType()."},"getUpdateCount":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getUpdateCount()","!doc":"For documentation of this method, see java.sql.Statement#getUpdateCount()."},"getWarnings":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getWarnings()","!doc":"Returns the current set of warnings reported by the driver."},"isClosed":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isClosed()","!doc":"For documentation of this method, see java.sql.Statement#isClosed()."},"isPoolable":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#isPoolable()","!doc":"For documentation of this method, see java.sql.Statement#isPoolable()."},"setCursorName":{"!type":"fn(name: string)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setCursorName(String)","!doc":"For documentation of this method, see java.sql.Statement#setCursorName(String)."},"setEscapeProcessing":{"!type":"fn(enable: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setEscapeProcessing(Boolean)","!doc":"For documentation of this method, see java.sql.Statement#setEscapeProcessing(boolean)."},"setFetchDirection":{"!type":"fn(direction: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchDirection(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setFetchDirection(int)."},"setFetchSize":{"!type":"fn(rows: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setFetchSize(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setFetchSize(int)."},"setMaxFieldSize":{"!type":"fn(max: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMaxFieldSize(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setMaxFieldSize(int)."},"setMaxRows":{"!type":"fn(max: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMaxRows(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setMaxRows(int)."},"setPoolable":{"!type":"fn(poolable: bool)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setPoolable(Boolean)","!doc":"For documentation of this method, see java.sql.Statement#setPoolable(boolean)."},"setQueryTimeout":{"!type":"fn(seconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setQueryTimeout(Integer)","!doc":"For documentation of this method, see java.sql.Statement#setQueryTimeout(int)."}}},"JdbcStruct":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-struct","!doc":"JdbcStruct A JDBC Struct. For documentation of this class, see java.sql.Struct.","prototype":{"getAttributes":{"!type":"fn() -> [object]","!url":"http://developers.google.com/apps-script/reference/jdbc/#getAttributes()","!doc":"For documentation of this method, see java.sql.Struct#getAttributes()."},"getSQLTypeName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSQLTypeName()","!doc":"For documentation of this method, see java.sql.Struct#getSQLTypeName()."}}},"JdbcTime":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-time","!doc":"JdbcTime A JDBC Time. For documentation of this class, see java.sql.Time.","prototype":{"after":{"!type":"fn(when: jdbc.JdbcTime) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#after(JdbcTime)","!doc":"For documentation of this method, see java.sql.Time#after(java.util.Date)."},"before":{"!type":"fn(when: jdbc.JdbcTime) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#before(JdbcTime)","!doc":"For documentation of this method, see java.sql.Time#before(java.util.Date)."},"getHours":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getHours()","!doc":"For documentation of this method, see java.sql.Time#getHours()."},"getMinutes":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMinutes()","!doc":"For documentation of this method, see java.sql.Time#getMinutes()."},"getSeconds":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSeconds()","!doc":"For documentation of this method, see java.sql.Time#getSeconds()."},"getTime":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTime()","!doc":"For documentation of this method, see java.sql.Time#getTime()."},"setHours":{"!type":"fn(hours: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setHours(Integer)","!doc":"For documentation of this method, see java.sql.Time#setHours(int)."},"setMinutes":{"!type":"fn(minutes: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMinutes(Integer)","!doc":"For documentation of this method, see java.sql.Time#setMinutes(int)."},"setSeconds":{"!type":"fn(seconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setSeconds(Integer)","!doc":"For documentation of this method, see java.sql.Time#setSeconds(int)."},"setTime":{"!type":"fn(milliseconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTime(Integer)","!doc":"For documentation of this method, see java.sql.Time#setTime(long)."}}},"JdbcTimestamp":{"!url":"http://developers.google.com/apps-script/reference/jdbc/jdbc-timestamp","!doc":"JdbcTimestamp A JDBC Timestamp. For documentation of this class, see java.sql.Timestamp.","prototype":{"after":{"!type":"fn(when: jdbc.JdbcTimestamp) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#after(JdbcTimestamp)","!doc":"For documentation of this method, see java.sql.Timestamp#after(java.sql.Timestamp)."},"before":{"!type":"fn(when: jdbc.JdbcTimestamp) -> bool","!url":"http://developers.google.com/apps-script/reference/jdbc/#before(JdbcTimestamp)","!doc":"For documentation of this method, see java.sql.Timestamp#before(java.sql.Timestamp)."},"getDate":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getDate()","!doc":"For documentation of this method, see java.sql.Timestamp#getDate()."},"getHours":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getHours()","!doc":"For documentation of this method, see java.sql.Timestamp#getHours()."},"getMinutes":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMinutes()","!doc":"For documentation of this method, see java.sql.Timestamp#getMinutes()."},"getMonth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getMonth()","!doc":"For documentation of this method, see java.sql.Timestamp#getMonth()."},"getNanos":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getNanos()","!doc":"For documentation of this method, see java.sql.Timestamp#getNanos()."},"getSeconds":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getSeconds()","!doc":"For documentation of this method, see java.sql.Timestamp#getSeconds()."},"getTime":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getTime()","!doc":"For documentation of this method, see java.sql.Timestamp#getTime()."},"getYear":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/jdbc/#getYear()","!doc":"For documentation of this method, see java.sql.Timestamp#getYear()."},"setDate":{"!type":"fn(date: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setDate(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setDate(int)."},"setHours":{"!type":"fn(hours: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setHours(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setHours(int)."},"setMinutes":{"!type":"fn(minutes: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMinutes(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setMinutes(int)."},"setMonth":{"!type":"fn(month: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setMonth(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setMonth(int)."},"setNanos":{"!type":"fn(nanoseconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setNanos(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setNanos(int)."},"setSeconds":{"!type":"fn(seconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setSeconds(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setSeconds(int)."},"setTime":{"!type":"fn(milliseconds: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setTime(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setTime(long)."},"setYear":{"!type":"fn(year: number)","!url":"http://developers.google.com/apps-script/reference/jdbc/#setYear(Integer)","!doc":"For documentation of this method, see java.sql.Timestamp#setYear(int)."}}}},"lock":{"Lock":{"!url":"http://developers.google.com/apps-script/reference/lock/lock","!doc":"A representation of a mutual-exclusion lock. This class allows scripts to make sure that only one instance of the script is executing a given section of code at a time. This is particularly useful for callbacks and triggers, where a user action may cause changes to a shared resource and you want to ensure that aren't collisions. The following examples shows how to use a lock in a form submit handler. // Generates a unique ticket number for every form submission. function onFormSubmit(e) { var targetCell = e.range.offset(0, e.range.getNumColumns(), 1, 1); // Get a public lock on this script, because we're about to modify a shared resource. var lock = LockService.getPublicLock(); // Wait for up to 30 seconds for other processes to finish. lock.waitLock(30000); var ticketNumber = Number(ScriptProperties.getProperty('lastTicketNumber')) + 1; ScriptProperties.setProperty('lastTicketNumber', ticketNumber); // Release the lock so that other processes can continue. lock.releaseLock(); targetCell.setValue(ticketNumber); } Without the LockService, if two users submit the form at approximately the same time the ticket numbers could end up the same, since the lastTicketNumber property could change after it was read from the ScriptProperties but before the new value was written back.","prototype":{"hasLock":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/lock/#hasLock()","!doc":"Returns true if the lock was aquired."},"releaseLock":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/lock/#releaseLock()","!doc":"Releases the lock, allowing other processes waiting on the lock to continue."},"tryLock":{"!type":"fn(timeoutInMillis: number) -> bool","!url":"http://developers.google.com/apps-script/reference/lock/#tryLock(Integer)","!doc":"Attempts to aquire the lock, timing out after the provided number of milliseconds."},"waitLock":{"!type":"fn(timeoutInMillis: number)","!url":"http://developers.google.com/apps-script/reference/lock/#waitLock(Integer)","!doc":"Attempts to aquire the lock, timing out with an exception after the provided number of milliseconds."}}}},"maps":{"DirectionFinder":{"!url":"http://developers.google.com/apps-script/reference/maps/direction-finder","!doc":"DirectionFinder Allows for the retrieval of directions between locations. The example below shows how you can use this class to get the directions from Times Square to Central Park, stopping first at Lincoln Center, plot the locations and path on a map, and send the map in an email. // Get the directions. var directions = Maps.newDirectionFinder() .setOrigin('Times Square, New York, NY') .addWaypoint('Lincoln Center, New York, NY') .setDestination('Central Park, New York, NY') .setMode(Maps.DirectionFinder.Mode.DRIVING) .getDirections(); var route = directions.routes[0]; // Set up marker styles. var markerSize = Maps.StaticMap.MarkerSize.MID; var markerColor = Maps.StaticMap.Color.GREEN var markerLetterCode = 'A'.charCodeAt(); // Add markers to the map. var map = Maps.newStaticMap(); for (var i = 0; i < route.legs.length; i++) { var leg = route.legs[i]; if (i == 0) { // Add a marker for the start location of the first leg only. map.setMarkerStyle(markerSize, markerColor, String.fromCharCode(markerLetterCode)); map.addMarker(leg.start_location.lat, leg.start_location.lng); markerLetterCode++; } map.setMarkerStyle(markerSize, markerColor, String.fromCharCode(markerLetterCode)); map.addMarker(leg.end_location.lat, leg.end_location.lng); markerLetterCode++; } // Add a path for the entire route. map.addPath(route.overview_polyline.points); // Send the map in an email. var toAddress = Session.getActiveUser().getEmail(); MailApp.sendEmail(toAddress, 'Directions', 'Please open: ' + map.getMapUrl(), { htmlBody: 'See below.<br/><img src=\"cid:mapImage\">', inlineImages: { mapImage: Utilities.newBlob(map.getMapImage(), 'image/png') } }); See also Google Directions API","prototype":{"addWaypoint":{"!type":"fn(address: string) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#addWaypoint(String)","!doc":"Adds a waypoint that the route must pass through, using an address."},"clearWaypoints":{"!type":"fn() -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#clearWaypoints()","!doc":"Clears the current set of waypoints."},"getDirections":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/maps/#getDirections()","!doc":"Gets the directions using the origin, destination, and other options that were set."},"setAlternatives":{"!type":"fn(useAlternatives: bool) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setAlternatives(Boolean)","!doc":"Sets whether or not alternative routes should be returned, instead of just the highest ranked route (defaults to false)."},"setArrive":{"!type":"fn(time: date) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setArrive(Date)","!doc":"Sets the desired time of arrival (when applicable)."},"setAvoid":{"!type":"fn(avoid: string) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setAvoid(String)","!doc":"Sets whether to avoid certain types of restrictions."},"setDepart":{"!type":"fn(time: date) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setDepart(Date)","!doc":"Sets the desired time of departure (when applicable)."},"setDestination":{"!type":"fn(address: string) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setDestination(String)","!doc":"Sets the ending location for which to calculate directions to, using an address."},"setLanguage":{"!type":"fn(language: string) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setLanguage(String)","!doc":"Sets the language to be used for the directions."},"setMode":{"!type":"fn(mode: string) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setMode(String)","!doc":"Sets the mode of travel (defaults to driving)."},"setOptimizeWaypoints":{"!type":"fn(optimizeOrder: bool) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setOptimizeWaypoints(Boolean)","!doc":"Sets whether or not to optimize the provided route by rearranging the waypoints in a more efficient order (defaults to false)."},"setOrigin":{"!type":"fn(address: string) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setOrigin(String)","!doc":"Sets the starting location from which to calculate directions, using an address."},"setRegion":{"!type":"fn(region: string) -> +maps.DirectionFinder","!url":"http://developers.google.com/apps-script/reference/maps/#setRegion(String)","!doc":"Sets a region to use when interpreting location names."}}},"DirectionFinderEnums":{"!url":"http://developers.google.com/apps-script/reference/maps/direction-finder-enums","!doc":"DirectionFinderEnums A collection of enums used by DirectionFinder.","prototype":{"Avoid":{"!type":"+maps.Avoid","!doc":""},"Mode":{"!type":"+maps.Mode","!doc":""}}},"ElevationSampler":{"!url":"http://developers.google.com/apps-script/reference/maps/elevation-sampler","!doc":"ElevationSampler Allows for the sampling of elevations at particular locations. The example below shows how you can use this class to determine the highest point along the route from Denver to Grand Junction in Colorado, plot it on a map, and save the map to Google Drive. // Get directions from Denver to Grand Junction. var directions = Maps.newDirectionFinder() .setOrigin('Denver, CO') .setDestination('Grand Junction, CO') .setMode(Maps.DirectionFinder.Mode.DRIVING) .getDirections(); var route = directions.routes[0]; // Get elevation samples along the route. var numberOfSamples = 30; var response = Maps.newElevationSampler() .samplePath(route.overview_polyline.points, numberOfSamples) // Determine highest point. var maxElevation = Number.MIN_VALUE; var highestPoint = null; for (var i = 0; i < response.results.length; i++) { var sample = response.results[i]; if (sample.elevation > maxElevation) { maxElevation = sample.elevation; highestPoint = sample.location; } } // Add the path and marker to a map. var map = Maps.newStaticMap() .addPath(route.overview_polyline.points) .addMarker(highestPoint.lat, highestPoint.lng); // Save the map to your drive DocsList.createFile(Utilities.newBlob(map.getMapImage(), 'image/png', 'map.png')); See also Google Elevation API","prototype":{"sampleLocation":{"!type":"fn(latitude: number, longitude: number) -> object","!url":"http://developers.google.com/apps-script/reference/maps/#sampleLocation(Number,Number)","!doc":"Returns elevation data for a single point (lat/lng)."},"sampleLocations":{"!type":"fn(encodedPolyline: string) -> object","!url":"http://developers.google.com/apps-script/reference/maps/#sampleLocations(String)","!doc":"Returns elevation data for the points in an encoded polyline."},"samplePath":{"!type":"fn(encodedPolyline: string, numSamples: number) -> object","!url":"http://developers.google.com/apps-script/reference/maps/#samplePath(String,Integer)","!doc":"Returns elevation data for a number of samples along a line, defined using an encoded polyline."}}},"Geocoder":{"!url":"http://developers.google.com/apps-script/reference/maps/geocoder","!doc":"Geocoder Allows for the conversion between an address and geographical coordinates. The example below shows how you can use this class find the top nine matches for the location \"Main St\" in Colorado, add them to a map, and then embed it in a new Google Doc. // Find the best matches for \"Main St\" in Colorado. var response = Maps.newGeocoder() // The latitudes and longitudes of southwest and northeast corners of Colorado, respectively. .setBounds(36.998166, -109.045486, 41.001666,-102.052002) .geocode('Main St'); // Create a Google Doc and map. var doc = DocumentApp.create('My Map'); var map = Maps.newStaticMap(); // Add each result to the map and doc. for (var i = 0; i < response.results.length && i < 9; i++) { var result = response.results[i]; map.setMarkerStyle(null, null, i + 1); map.addMarker(result.geometry.location.lat, result.geometry.location.lng); doc.appendListItem(result.formatted_address); } // Add the finished map to the doc. doc.appendImage(Utilities.newBlob(map.getMapImage(), 'image/png')); See also Google Geocoding API","prototype":{"geocode":{"!type":"fn(address: string) -> object","!url":"http://developers.google.com/apps-script/reference/maps/#geocode(String)","!doc":"Gets the approximate geographic points for a given address."},"reverseGeocode":{"!type":"fn(swLatitude: number, swLongitude: number, neLatitude: number, neLongitude: number) -> object","!url":"http://developers.google.com/apps-script/reference/maps/#reverseGeocode(Number,Number,Number,Number)","!doc":"Gets the approximate addresses for a given area."},"setBounds":{"!type":"fn(swLatitude: number, swLongitude: number, neLatitude: number, neLongitude: number) -> +maps.Geocoder","!url":"http://developers.google.com/apps-script/reference/maps/#setBounds(Number,Number,Number,Number)","!doc":"Sets the bounds of an area that should be given extra preference in the results."},"setLanguage":{"!type":"fn(language: string) -> +maps.Geocoder","!url":"http://developers.google.com/apps-script/reference/maps/#setLanguage(String)","!doc":"Sets the language to be used in the results."},"setRegion":{"!type":"fn(region: string) -> +maps.Geocoder","!url":"http://developers.google.com/apps-script/reference/maps/#setRegion(String)","!doc":"Sets a region to use when interpreting location names."}}},"StaticMap":{"!url":"http://developers.google.com/apps-script/reference/maps/static-map","!doc":"StaticMap Allows for the creation and decoration of static map images. The example below shows how you can use this class to create a map of New York City's Theatre District, including nearby train stations, and display it in a simple web app. function doGet(event) { // Create a map centered on Times Square. var map = Maps.newStaticMap() .setSize(600, 600) .setCenter('Times Square, New York, NY'); // Add markers for the nearbye train stations. map.setMarkerStyle(Maps.StaticMap.MarkerSize.MID, Maps.StaticMap.Color.RED, 'T'); map.addMarker('Grand Central Station, New York, NY'); map.addMarker('Penn Station, New York, NY'); // Show the boundaries of the Theatre District. var corners = [ '8th Ave & 53rd St, New York, NY', '6th Ave & 53rd St, New York, NY', '6th Ave & 40th St, New York, NY', '8th Ave & 40th St, New York, NY' ]; map.setPathStyle(4, Maps.StaticMap.Color.BLACK, Maps.StaticMap.Color.BLUE); map.beginPath(); for (var i = 0; i < corners.length; i++) { map.addAddress(corners[i]); } // Create the user interface and add the map image. var app = UiApp.createApplication().setTitle('NYC Theatre District'); app.add(app.createImage(map.getMapUrl())); return app; } See also Google Static Maps API","prototype":{"addAddress":{"!type":"fn(address: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#addAddress(String)","!doc":"Adds a new address to the current path definition."},"addMarker":{"!type":"fn(address: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#addMarker(String)","!doc":"Adds a marker to the map using an address."},"addPath":{"!type":"fn(polyline: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#addPath(String)","!doc":"Adds a path to the map using an encoded polyline."},"addPoint":{"!type":"fn(latitude: number, longitude: number) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#addPoint(Number,Number)","!doc":"Adds a new point (lat/lng) to the current path definition."},"addVisible":{"!type":"fn(address: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#addVisible(String)","!doc":"Adds an address location that must be visible in the map."},"beginPath":{"!type":"fn() -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#beginPath()","!doc":"Starts a new path definition."},"clearMarkers":{"!type":"fn() -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#clearMarkers()","!doc":"Clears the current set of markers."},"clearPaths":{"!type":"fn() -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#clearPaths()","!doc":"Clear the current set of paths."},"clearVisibles":{"!type":"fn() -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#clearVisibles()","!doc":"Clears the current set of visible locations."},"endPath":{"!type":"fn() -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#endPath()","!doc":"Completes a path definition started with beginPath()."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/maps/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/maps/#getBlob()","!doc":"Gets the image data as a Blob."},"getMapImage":{"!type":"fn() -> [byte]","!url":"http://developers.google.com/apps-script/reference/maps/#getMapImage()","!doc":"Gets the raw image data as a byte array."},"getMapUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/maps/#getMapUrl()","!doc":"Gets the URL of the map image."},"setCenter":{"!type":"fn(address: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setCenter(String)","!doc":"Sets the center of the map using an address."},"setCustomMarkerStyle":{"!type":"fn(imageUrl: string, useShadow: bool) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setCustomMarkerStyle(String,Boolean)","!doc":"Sets the custom marker image to use when creating new markers."},"setFormat":{"!type":"fn(format: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setFormat(String)","!doc":"Sets the format of the map image."},"setLanguage":{"!type":"fn(language: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setLanguage(String)","!doc":"Sets the language to be used for text on the map (where avaialbe)."},"setMapType":{"!type":"fn(mapType: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setMapType(String)","!doc":"Sets the type of map to be shown."},"setMarkerStyle":{"!type":"fn(size: string, color: string, label: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setMarkerStyle(String,String,String)","!doc":"Sets the marker style to use when creating new markers."},"setMobile":{"!type":"fn(useMobileTiles: bool) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setMobile(Boolean)","!doc":"Sets whether or not to use specialized tile sets for mobile devices."},"setPathStyle":{"!type":"fn(weight: number, color: string, fillColor: string) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setPathStyle(Integer,String,String)","!doc":"Sets the path style to use when creating new paths."},"setSize":{"!type":"fn(width: number, height: number) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setSize(Integer,Integer)","!doc":"Sets the width and height of the map image in pixels."},"setZoom":{"!type":"fn(zoom: number) -> +maps.StaticMap","!url":"http://developers.google.com/apps-script/reference/maps/#setZoom(Integer)","!doc":"Sets the zoom factor, or magnification level, used for the map."}}},"StaticMapEnums":{"!url":"http://developers.google.com/apps-script/reference/maps/static-map-enums","!doc":"StaticMapEnums A collection of enums used by StaticMap.","prototype":{"Color":{"!type":"+maps.Color","!doc":""},"Format":{"!type":"+maps.Format","!doc":""},"MarkerSize":{"!type":"+maps.MarkerSize","!doc":""},"Type":{"!type":"+maps.Type","!doc":""}}},"Avoid":{"!url":"http://developers.google.com/apps-script/reference/maps/avoid","!doc":"Avoid An enum representing the types of restrictions to avoid when finding directions.","prototype":{"TOLLS":{"!type":"string","!doc":"Avoid tolls."},"HIGHWAYS":{"!type":"string","!doc":"Avoid highways."}}},"Color":{"!url":"http://developers.google.com/apps-script/reference/maps/color","!doc":"Color An enum representing the named colors available to use in map images.","prototype":{"BLACK":{"!type":"string","!doc":""},"BROWN":{"!type":"string","!doc":""},"GREEN":{"!type":"string","!doc":""},"PURPLE":{"!type":"string","!doc":""},"YELLOW":{"!type":"string","!doc":""},"BLUE":{"!type":"string","!doc":""},"GRAY":{"!type":"string","!doc":""},"ORANGE":{"!type":"string","!doc":""},"RED":{"!type":"string","!doc":""},"WHITE":{"!type":"string","!doc":""}}},"Format":{"!url":"http://developers.google.com/apps-script/reference/maps/format","!doc":"Format An enum representing the format of the map image. See also Google Static Maps API","prototype":{"PNG":{"!type":"string","!doc":"8-bit PNG format."},"PNG8":{"!type":"string","!doc":"8-bit PNG format."},"PNG32":{"!type":"string","!doc":"32-bit PNG format."},"GIF":{"!type":"string","!doc":"GIF format."},"JPG":{"!type":"string","!doc":"JPEG format."},"JPG_BASELINE":{"!type":"string","!doc":"Non-progressive JPEG format."}}},"MarkerSize":{"!url":"http://developers.google.com/apps-script/reference/maps/marker-size","!doc":"MarkerSize An enum representing the size of a marker added to a map. See also Google Static Maps API","prototype":{"TINY":{"!type":"string","!doc":"Tiny sized markets (smallest available). Labels will not be visible on markers of this size."},"MID":{"!type":"string","!doc":"Medium sized markers (largest available)."},"SMALL":{"!type":"string","!doc":"Small sized markers. Labels will not be visible on markers of this size."}}},"Mode":{"!url":"http://developers.google.com/apps-script/reference/maps/mode","!doc":"Mode An enum representing the mode of travel to use when finding directions.","prototype":{"DRIVING":{"!type":"string","!doc":"Driving directions via roads."},"WALKING":{"!type":"string","!doc":"Walking directions via pedestrian paths and sidewalks (where available)."},"BICYCLING":{"!type":"string","!doc":"Bicycling directions via bicycle paths and preferred streets (where available)."},"TRANSIT":{"!type":"string","!doc":"Transit directions via public transit routes (where available). This mode requires that you set either the departure or arrival time. // Log all available data for a public-transit trip. var directions = Maps.newDirectionFinder() .setOrigin('The Cloisters, New York, NY') .setDestination('JFK airport, New York, NY') .setMode(Maps.DirectionFinder.Mode.TRANSIT) .setDepart(new Date()) .getDirections(); var route = directions.routes[0]; Logger.log(route);"}}},"Type":{"!url":"http://developers.google.com/apps-script/reference/maps/type","!doc":"Type An enum representing the type of map to render. See also Google Static Maps API","prototype":{"ROADMAP":{"!type":"string","!doc":"A standard roadmap, as is normally shown on the Google Maps website."},"SATELLITE":{"!type":"string","!doc":"A satellite map."},"TERRAIN":{"!type":"string","!doc":"A physical relief map, showing terrain and vegetation."},"HYBRID":{"!type":"string","!doc":"A hybrid of the satellite and roadmap maps, showing a transparent layer of major streets and place names on the satellite map."}}}},"properties":{"Properties":{"!url":"http://developers.google.com/apps-script/reference/properties/properties","!doc":"Properties The properties object acts as the interface to access user, document, or script properties. The specific property type depends on which of the three methods of PropertiesService the script called: PropertiesService.getDocumentProperties(), PropertiesService.getUserProperties(), or PropertiesService.getScriptProperties(). Properties cannot be shared between scripts. For more information about property types, see the guide to the Properties service.","prototype":{"deleteAllProperties":{"!type":"fn() -> +properties.Properties","!url":"http://developers.google.com/apps-script/reference/properties/#deleteAllProperties()","!doc":"Deletes all properties in the current Properties store."},"deleteProperty":{"!type":"fn(key: string) -> +properties.Properties","!url":"http://developers.google.com/apps-script/reference/properties/#deleteProperty(String)","!doc":"Deletes the property with the given key in the current Properties store."},"getKeys":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/properties/#getKeys()","!doc":"Gets all keys in the current Properties store."},"getProperties":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/properties/#getProperties()","!doc":"Gets a copy of all key-value pairs in the current Properties store."},"getProperty":{"!type":"fn(key: string) -> string","!url":"http://developers.google.com/apps-script/reference/properties/#getProperty(String)","!doc":"Gets the value associated with the given key in the current Properties store, or null if no such key exists."},"setProperties":{"!type":"fn(properties: object, deleteAllOthers: bool) -> +properties.Properties","!url":"http://developers.google.com/apps-script/reference/properties/#setProperties(Object,Boolean)","!doc":"Sets all key-value pairs from the given object in the current Properties store, optionally deleting all other properties in the store."},"setProperty":{"!type":"fn(key: string, value: string) -> +properties.Properties","!url":"http://developers.google.com/apps-script/reference/properties/#setProperty(String,String)","!doc":"Sets the given key-value pair in the current Properties store."}}}},"script":{"ClockTriggerBuilder":{"!url":"http://developers.google.com/apps-script/reference/script/clock-trigger-builder","!doc":"ClockTriggerBuilder A builder for clock triggers","prototype":{"after":{"!type":"fn(durationMilliseconds: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#after(Integer)","!doc":"Specifies the duration (in milliseconds) after the current time that the trigger will run."},"at":{"!type":"fn(date: date) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#at(Date)","!doc":"Specifies when the trigger will run (plus or minus 15 minutes)."},"atDate":{"!type":"fn(year: number, month: number, day: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#atDate(Integer,Integer,Integer)","!doc":"Specifies trigger will fire on the given date, by default near midnight (+/- 15 minutes)."},"atHour":{"!type":"fn(hour: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#atHour(Integer)","!doc":"Specifies the hour the trigger will run (plus or minus 15 minutes)."},"create":{"!type":"fn() -> +script.Trigger","!url":"http://developers.google.com/apps-script/reference/script/#create()","!doc":"Creates the trigger."},"everyDays":{"!type":"fn(n: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#everyDays(Integer)","!doc":"Specifies to run the trigger every n days."},"everyHours":{"!type":"fn(n: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#everyHours(Integer)","!doc":"Specifies to run the trigger every n hours."},"everyMinutes":{"!type":"fn(n: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#everyMinutes(Integer)","!doc":"Specifies to run the trigger every n minutes."},"everyWeeks":{"!type":"fn(n: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#everyWeeks(Integer)","!doc":"Specifies to run the trigger every n weeks."},"inTimezone":{"!type":"fn(timezone: string) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#inTimezone(String)","!doc":"Specifies the timezone that the specified dates/time that the trigger will run in."},"nearMinute":{"!type":"fn(minute: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#nearMinute(Integer)","!doc":"Specifies the minute the trigger will run (plus or minus 15 minutes)."},"onMonthDay":{"!type":"fn(day: number) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onMonthDay(Integer)","!doc":"Specifies on what date in the month that the trigger will run."},"onWeekDay":{"!type":"fn(day: base.Weekday) -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onWeekDay(Weekday)","!doc":"Specifies on what day of the week that the trigger will run."}}},"FormTriggerBuilder":{"!url":"http://developers.google.com/apps-script/reference/script/form-trigger-builder","!doc":"FormTriggerBuilder A builder for form triggers.","prototype":{"create":{"!type":"fn() -> +script.Trigger","!url":"http://developers.google.com/apps-script/reference/script/#create()","!doc":"Creates and returns the new trigger."},"onFormSubmit":{"!type":"fn() -> +script.FormTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onFormSubmit()","!doc":"Specifies a trigger that will fire when a response is submitted to the form."},"onOpen":{"!type":"fn() -> +script.FormTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onOpen()","!doc":"Specifies a trigger that will fire when the form's edit view is opened."}}},"Service":{"!url":"http://developers.google.com/apps-script/reference/script/service","!doc":"Service Access and manipulate script publishing.","prototype":{"Restriction":{"!type":"+script.Service.Restriction","!doc":"Enum representing the access restrictions on a script exported as a service."},"disable":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/script/#disable()","!doc":"Disables the script from being accessed as a web app."},"enable":{"!type":"fn(restriction: script.Service.Restriction)","!url":"http://developers.google.com/apps-script/reference/script/#enable(Service.Restriction)","!doc":"Allows the script to be accessed as a web app with the specified permissions."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/script/#getUrl()","!doc":"Returns the URL of the web app, if it has been deployed; otherwise returns null."},"isEnabled":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/script/#isEnabled()","!doc":"Returns true if the script is accessible as a web app."}}},"SpreadsheetTriggerBuilder":{"!url":"http://developers.google.com/apps-script/reference/script/spreadsheet-trigger-builder","!doc":"SpreadsheetTriggerBuilder Builder for spreadsheet triggers.","prototype":{"create":{"!type":"fn() -> +script.Trigger","!url":"http://developers.google.com/apps-script/reference/script/#create()","!doc":"Creates the trigger and returns it."},"onChange":{"!type":"fn() -> +script.SpreadsheetTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onChange()","!doc":"Specifies a trigger that will fire when the spreadsheet's content or structure is changed."},"onEdit":{"!type":"fn() -> +script.SpreadsheetTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onEdit()","!doc":"Specifies a trigger that will fire when the spreadsheet is edited."},"onFormSubmit":{"!type":"fn() -> +script.SpreadsheetTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onFormSubmit()","!doc":"Specifies a trigger that will fire when the spreadsheet has a form submitted to it."},"onOpen":{"!type":"fn() -> +script.SpreadsheetTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#onOpen()","!doc":"Specifies a trigger that will fire when the spreadsheet is opened."}}},"StateTokenBuilder":{"!url":"http://developers.google.com/apps-script/reference/script/state-token-builder","!doc":"StateTokenBuilder Allows scripts to create state tokens that can be used in callback APIs (like OAuth flows). // Reusable function to generate a callback URL, assuming the script has been published as a // web app (necessary to obtain the URL programmatically). If the script has not been published // as a web app, set `var url` in the first line to the URL of your script project (which // cannot be obtained programmatically). function getCallbackURL(callbackFunction){ var url = ScriptApp.getService().getUrl(); // Ends in /exec (for a web app) url = url.slice(0, -4) + 'usercallback?state='; // Change /exec to /usercallback var stateToken = ScriptApp.newStateToken() .withMethod(callbackFunction) .withTimeout(120) .createToken(); return url + stateToken; }","prototype":{"createToken":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/script/#createToken()","!doc":"Constructs an encrypted string representation of the state token."},"withArgument":{"!type":"fn(name: string, value: string) -> +script.StateTokenBuilder","!url":"http://developers.google.com/apps-script/reference/script/#withArgument(String,String)","!doc":"Adds an argument to the token."},"withMethod":{"!type":"fn(method: string) -> +script.StateTokenBuilder","!url":"http://developers.google.com/apps-script/reference/script/#withMethod(String)","!doc":"Sets a callback function."},"withTimeout":{"!type":"fn(seconds: number) -> +script.StateTokenBuilder","!url":"http://developers.google.com/apps-script/reference/script/#withTimeout(Integer)","!doc":"Sets the duration (in seconds) for which the token is valid."}}},"Trigger":{"!url":"http://developers.google.com/apps-script/reference/script/trigger","!doc":"Trigger A script trigger","prototype":{"getEventType":{"!type":"fn() -> +script.EventType","!url":"http://developers.google.com/apps-script/reference/script/#getEventType()","!doc":"Returns the event type that the trigger fires on."},"getHandlerFunction":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/script/#getHandlerFunction()","!doc":"Returns the function that will be called when the trigger fires."},"getTriggerSource":{"!type":"fn() -> +script.TriggerSource","!url":"http://developers.google.com/apps-script/reference/script/#getTriggerSource()","!doc":"Returns the source of events that will cause the trigger to fire."},"getTriggerSourceId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/script/#getTriggerSourceId()","!doc":"Returns the id specific to the source."},"getUniqueId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/script/#getUniqueId()","!doc":"Returns a unique identifier that can be used to distinguish triggers from each other."}}},"TriggerBuilder":{"!url":"http://developers.google.com/apps-script/reference/script/trigger-builder","!doc":"TriggerBuilder A generic builder for script triggers.","prototype":{"forForm":{"!type":"fn(key: string) -> +script.FormTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#forForm(String)","!doc":"Creates and returns a FormTriggerBuilder tied to the form with the given ID."},"forSpreadsheet":{"!type":"fn(key: string) -> +script.SpreadsheetTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#forSpreadsheet(String)","!doc":"Creates and returns a SpreadsheetTriggerBuilder tied to the spreadsheet with the given ID."},"timeBased":{"!type":"fn() -> +script.ClockTriggerBuilder","!url":"http://developers.google.com/apps-script/reference/script/#timeBased()","!doc":"Creates and returns a ClockTriggerBuilder for building time-based triggers."}}},"AuthMode":{"!url":"http://developers.google.com/apps-script/reference/script/auth-mode","!doc":"AuthMode An enumeration that identifies which categories of authorized services Apps Script is able to execute through a triggered function. These values are exposed in triggered functions as the authMode property of the event parameter, e. For more information, see the guide to the authorization lifecycle for add-ons. function onOpen(e) { var menu = SpreadsheetApp.getUi().createAddonMenu(); if (e && e.authMode == ScriptApp.AuthMode.NONE) { // Add a normal menu item (works in all authorization modes). menu.addItem('Start workflow', 'startWorkflow'); } else { // Add a menu item based on properties (doesn't work in AuthMode.NONE). var properties = PropertiesService.getDocumentProperties(); var workflowStarted = properties.getProperty('workflowStarted'); if (workflowStarted) { menu.addItem('Check workflow status', 'checkWorkflow'); } else { menu.addItem('Start workflow', 'startWorkflow'); } // Record analytics. UrlFetchApp.fetch('http://www.example.com/analytics?event=open'); } menu.addToUi(); }","prototype":{"NONE":{"!type":"string","!doc":"A mode that does not allow access to any services that require authorization. This mode occurs when an add-on executes an onOpen(e) simple trigger, and the user has installed an add-on in a different document but the add-on has not been used in the current document."},"CUSTOM_FUNCTION":{"!type":"string","!doc":"A mode that allows access to a limited subset of services for use in custom spreadsheet functions. Some of these services — including read-only access to Spreadsheet service — normally require authorization, but are permitted without authorization when used in a custom function. Because custom functions do not include an event parameter, this value is never returned; it is documented only to demonstrate that custom functions run in their own authorization mode."},"LIMITED":{"!type":"string","!doc":"A mode that allows access to a limited subset of services. This mode occurs when an add-on or a script bound to a document executes an onOpen(e) or onEdit(e) simple trigger, except in the case described for NONE."},"FULL":{"!type":"string","!doc":"A mode that allows access to all services that require authorization. This mode occurs when an add-on or a script executes as the result of any trigger other than the cases described for LIMITED or NONE."}}},"EventType":{"!url":"http://developers.google.com/apps-script/reference/script/event-type","!doc":"EventType An enum denoting the type of the event.","prototype":{"CLOCK":{"!type":"string","!doc":""},"ON_OPEN":{"!type":"string","!doc":""},"ON_EDIT":{"!type":"string","!doc":""},"ON_FORM_SUBMIT":{"!type":"string","!doc":""},"ON_CHANGE":{"!type":"string","!doc":""}}},"Service.Restriction":{"!url":"http://developers.google.com/apps-script/reference/script/service.-restriction","!doc":"Service.Restriction","prototype":{"MYSELF":{"!type":"string","!doc":""},"DOMAIN":{"!type":"string","!doc":""},"ALL":{"!type":"string","!doc":""}}},"TriggerSource":{"!url":"http://developers.google.com/apps-script/reference/script/trigger-source","!doc":"TriggerSource Enum denoting what the source of the event that the trigger fires on is.","prototype":{"SPREADSHEETS":{"!type":"string","!doc":""},"CLOCK":{"!type":"string","!doc":""},"FORMS":{"!type":"string","!doc":""},"DOCUMENTS":{"!type":"string","!doc":""}}}},"sites":{"Attachment":{"!url":"http://developers.google.com/apps-script/reference/sites/attachment","!doc":"Attachment A Sites Attachment such as a file attached to a page. Note that an Attachment is a Blob and can be used anywhere Blob input is expected. var filesPage = SitesApp.getSite('example.com', 'mysite').getChildByName(\"files\"); var attachments = filesPage.getAttachments(); // DocsList.createFile accepts a blob input. Since an Attachment is just a blob, we can // just pass it directly to that method var file = DocsList.createFile(attachments[0]);","prototype":{"deleteAttachment":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/sites/#deleteAttachment()","!doc":"Deletes this attachment."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/sites/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getAttachmentType":{"!type":"fn() -> +sites.AttachmentType","!url":"http://developers.google.com/apps-script/reference/sites/#getAttachmentType()","!doc":"Return the type of this attachment (HOSTED or WEB)."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/sites/#getBlob()","!doc":"Return the data inside this object as a blob."},"getContentType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getContentType()","!doc":"Return the mime type of this attachment."},"getDatePublished":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getDatePublished()","!doc":"Return the date this attachment was first published."},"getDescription":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getDescription()","!doc":"Return the description of this attachment."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getLastUpdated()","!doc":"Return the date this attachment was last updated."},"getParent":{"!type":"fn() -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#getParent()","!doc":"Get the parent page of this attachment."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getTitle()","!doc":"Return the title of this attachment."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getUrl()","!doc":"Return the download url for this attachment."},"setContentType":{"!type":"fn(contentType: string) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#setContentType(String)","!doc":"Set the mime type of this attachment."},"setDescription":{"!type":"fn(description: string) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#setDescription(String)","!doc":"Set the descripton of this attachment."},"setFrom":{"!type":"fn(blob: base.BlobSource) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#setFrom(BlobSource)","!doc":"Set the actual data of this attachment."},"setParent":{"!type":"fn(parent: sites.Page) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#setParent(Page)","!doc":"Set the parent page of this attachment."},"setTitle":{"!type":"fn(title: string) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#setTitle(String)","!doc":"Set the title of this attachment."},"setUrl":{"!type":"fn(url: string) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#setUrl(String)","!doc":"Sets the download url for this attachment."}}},"Column":{"!url":"http://developers.google.com/apps-script/reference/sites/column","!doc":"Column A Sites Column - a column from a Sites List page.","prototype":{"deleteColumn":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/sites/#deleteColumn()","!doc":"Deletes this column."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getName()","!doc":"Gets the name of this column."},"getParent":{"!type":"fn() -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#getParent()","!doc":"Returns the List Page this column belongs to."},"setName":{"!type":"fn(name: string) -> +sites.Column","!url":"http://developers.google.com/apps-script/reference/sites/#setName(String)","!doc":"Sets the name of this column."}}},"Comment":{"!url":"http://developers.google.com/apps-script/reference/sites/comment","!doc":"Comment A Comment attached to any Sites page.","prototype":{"deleteComment":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/sites/#deleteComment()","!doc":"Deletes this comment."},"getAuthorEmail":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getAuthorEmail()","!doc":"Gets the email address of the author of this comment."},"getAuthorName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getAuthorName()","!doc":"Gets the name of the author of this comment."},"getContent":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getContent()","!doc":"Return the content of this comment as a String."},"getDatePublished":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getDatePublished()","!doc":"Return the date this comment was originally published."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getLastUpdated()","!doc":"Return the date this comment was last updated."},"getParent":{"!type":"fn() -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#getParent()","!doc":"Get the parent page of this comment."},"setContent":{"!type":"fn(content: string) -> +sites.Comment","!url":"http://developers.google.com/apps-script/reference/sites/#setContent(String)","!doc":"Set the content of this comment."},"setParent":{"!type":"fn(parent: sites.Page) -> +sites.Comment","!url":"http://developers.google.com/apps-script/reference/sites/#setParent(Page)","!doc":"Set the parent page of this comment."}}},"ListItem":{"!url":"http://developers.google.com/apps-script/reference/sites/list-item","!doc":"ListItem A Sites ListItem - a list element from a Sites List page.","prototype":{"deleteListItem":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/sites/#deleteListItem()","!doc":"Deletes this list item."},"getDatePublished":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getDatePublished()","!doc":"Return the date this list item was first published."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getLastUpdated()","!doc":"Return the date this comment was last updated."},"getParent":{"!type":"fn() -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#getParent()","!doc":"Get the parent page of this list item."},"getValueByIndex":{"!type":"fn(index: number) -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getValueByIndex(Integer)","!doc":"Get the value of this ListItem for a numbered column."},"getValueByName":{"!type":"fn(name: string) -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getValueByName(String)","!doc":"Get the value of this ListItem for a named column."},"setParent":{"!type":"fn(parent: sites.Page) -> +sites.ListItem","!url":"http://developers.google.com/apps-script/reference/sites/#setParent(Page)","!doc":"Set the parent page of this list item."},"setValueByIndex":{"!type":"fn(index: number, value: string) -> +sites.ListItem","!url":"http://developers.google.com/apps-script/reference/sites/#setValueByIndex(Integer,String)","!doc":"Set the value of this ListItem for a numbered column."},"setValueByName":{"!type":"fn(name: string, value: string) -> +sites.ListItem","!url":"http://developers.google.com/apps-script/reference/sites/#setValueByName(String,String)","!doc":"Set the value of this ListItem for a numbered column."}}},"Page":{"!url":"http://developers.google.com/apps-script/reference/sites/page","!doc":"Page A Page on a Google Site.","prototype":{"addColumn":{"!type":"fn(name: string) -> +sites.Column","!url":"http://developers.google.com/apps-script/reference/sites/#addColumn(String)","!doc":"Add a new column to the list."},"addComment":{"!type":"fn(content: string) -> +sites.Comment","!url":"http://developers.google.com/apps-script/reference/sites/#addComment(String)","!doc":"Add a comment to the page."},"addHostedAttachment":{"!type":"fn(blob: base.BlobSource, description: string) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#addHostedAttachment(BlobSource,String)","!doc":"Add an attachment to the page."},"addListItem":{"!type":"fn(values: [string]) -> +sites.ListItem","!url":"http://developers.google.com/apps-script/reference/sites/#addListItem(String)","!doc":"Add a list item to the list."},"addWebAttachment":{"!type":"fn(title: string, description: string, url: string) -> +sites.Attachment","!url":"http://developers.google.com/apps-script/reference/sites/#addWebAttachment(String,String,String)","!doc":"Add a web attachment to the page."},"createAnnouncement":{"!type":"fn(title: string, html: string, asDraft: bool) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createAnnouncement(String,String,Boolean)","!doc":"Create an announcements for this page."},"createAnnouncementsPage":{"!type":"fn(title: string, name: string, html: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createAnnouncementsPage(String,String,String)","!doc":"Create a new announcements page."},"createFileCabinetPage":{"!type":"fn(title: string, name: string, html: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createFileCabinetPage(String,String,String)","!doc":"Create a new file-cabinet page."},"createListPage":{"!type":"fn(title: string, name: string, html: string, columnNames: [string]) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createListPage(String,String,String,String)","!doc":"Create a new list page."},"createPageFromTemplate":{"!type":"fn(title: string, name: string, template: sites.Page) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createPageFromTemplate(String,String,Page)","!doc":"Create a new page from a template."},"createWebPage":{"!type":"fn(title: string, name: string, html: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createWebPage(String,String,String)","!doc":"Create a new web page."},"deletePage":{"!type":"fn()","!url":"http://developers.google.com/apps-script/reference/sites/#deletePage()","!doc":"Deletes this page."},"getAllDescendants":{"!type":"fn(options: object) -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#getAllDescendants(Object)","!doc":"Gets an array of descendant pages, with optional advanced arguments."},"getAnnouncements":{"!type":"fn(optOptions: object) -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#getAnnouncements(Object)","!doc":"Get the announcements for this page."},"getAttachments":{"!type":"fn(optOptions: object) -> [+sites.Attachment]","!url":"http://developers.google.com/apps-script/reference/sites/#getAttachments(Object)","!doc":"Get the attachments for this page."},"getAuthors":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/sites/#getAuthors()","!doc":"Get the emails of the authors of the page"},"getChildByName":{"!type":"fn(name: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#getChildByName(String)","!doc":"Gets a particular child page."},"getChildren":{"!type":"fn(options: object) -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#getChildren(Object)","!doc":"Gets an array of child pages, with optional advanced arguments."},"getColumns":{"!type":"fn() -> [+sites.Column]","!url":"http://developers.google.com/apps-script/reference/sites/#getColumns()","!doc":"Get the columns for the list."},"getComments":{"!type":"fn(optOptions: object) -> [+sites.Comment]","!url":"http://developers.google.com/apps-script/reference/sites/#getComments(Object)","!doc":"Get the comments for this page."},"getDatePublished":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getDatePublished()","!doc":"Return the date this page was first published."},"getHtmlContent":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getHtmlContent()","!doc":"Get the HTML content of the page."},"getIsDraft":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/sites/#getIsDraft()","!doc":"Returns whether the page is in draft mode."},"getLastEdited":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getLastEdited()","!doc":"Return the last edit date, which includes only content edits."},"getLastUpdated":{"!type":"fn() -> date","!url":"http://developers.google.com/apps-script/reference/sites/#getLastUpdated()","!doc":"Return the last updated date, which includes non-content changes like moving."},"getListItems":{"!type":"fn(optOptions: object) -> [+sites.ListItem]","!url":"http://developers.google.com/apps-script/reference/sites/#getListItems(Object)","!doc":"Get the list items for the list."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getName()","!doc":"Return the page's name."},"getPageType":{"!type":"fn() -> +sites.PageType","!url":"http://developers.google.com/apps-script/reference/sites/#getPageType()","!doc":"Return the type of this page as a SitesApp.PageType enum."},"getParent":{"!type":"fn() -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#getParent()","!doc":"Return the parent of this page."},"getTextContent":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getTextContent()","!doc":"Returns the plain-text page content."},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getTitle()","!doc":"Return the page's title."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getUrl()","!doc":"Get the url of the page."},"isDeleted":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/sites/#isDeleted()","!doc":"Returns whether a page has been deleted."},"isTemplate":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/sites/#isTemplate()","!doc":"Returns whether this page is a copyable template."},"publishAsTemplate":{"!type":"fn(name: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#publishAsTemplate(String)","!doc":"Publish this page as a copyable template."},"search":{"!type":"fn(query: string, options: object) -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#search(String,Object)","!doc":"Gets an array of descendant pages that match a search query, with optional advanced arguments."},"setHtmlContent":{"!type":"fn(html: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#setHtmlContent(String)","!doc":"Set the HTML content of the page."},"setIsDraft":{"!type":"fn(draft: bool) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#setIsDraft(Boolean)","!doc":"Sets whether the page is in draft mode."},"setName":{"!type":"fn(name: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#setName(String)","!doc":"Set this page's name."},"setParent":{"!type":"fn(parent: sites.Page) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#setParent(Page)","!doc":"Set the parent of this page."},"setTitle":{"!type":"fn(title: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#setTitle(String)","!doc":"Set the page's title."}}},"Site":{"!url":"http://developers.google.com/apps-script/reference/sites/site","!doc":"Site An object representing a Google Site.","prototype":{"addEditor":{"!type":"fn(user: base.User) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#addEditor(User)","!doc":"Adds the given user to the list of editors for the Site."},"addEditors":{"!type":"fn(emailAddresses: [string]) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the Site."},"addOwner":{"!type":"fn(user: base.User) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#addOwner(User)","!doc":"Add a new owner to the website"},"addViewer":{"!type":"fn(user: base.User) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#addViewer(User)","!doc":"Adds the given user to the list of viewers for the Site."},"addViewers":{"!type":"fn(emailAddresses: [string]) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#addViewers(String)","!doc":"Adds the given array of users to the list of viewers for the Site."},"createAnnouncementsPage":{"!type":"fn(title: string, name: string, html: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createAnnouncementsPage(String,String,String)","!doc":"Create a new announcements page."},"createFileCabinetPage":{"!type":"fn(title: string, name: string, html: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createFileCabinetPage(String,String,String)","!doc":"Create a new file-cabinet page."},"createListPage":{"!type":"fn(title: string, name: string, html: string, columnNames: [string]) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createListPage(String,String,String,String)","!doc":"Create a new list page."},"createPageFromTemplate":{"!type":"fn(title: string, name: string, template: sites.Page) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createPageFromTemplate(String,String,Page)","!doc":"Create a new page from a template."},"createWebPage":{"!type":"fn(title: string, name: string, html: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#createWebPage(String,String,String)","!doc":"Create a new web page."},"getAllDescendants":{"!type":"fn(options: object) -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#getAllDescendants(Object)","!doc":"Gets an array of descendant pages, with optional advanced arguments."},"getChildByName":{"!type":"fn(name: string) -> +sites.Page","!url":"http://developers.google.com/apps-script/reference/sites/#getChildByName(String)","!doc":"Gets a particular child page."},"getChildren":{"!type":"fn(options: object) -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#getChildren(Object)","!doc":"Gets an array of child pages, with optional advanced arguments."},"getEditors":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/sites/#getEditors()","!doc":"Gets the list of editors for this Site."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getName()","!doc":"Return the name of the site"},"getOwners":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/sites/#getOwners()","!doc":"Retrieves list of owners for the site"},"getSummary":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getSummary()","!doc":"Return the summary of the web site"},"getTemplates":{"!type":"fn() -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#getTemplates()","!doc":"Returns all template pages."},"getTheme":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getTheme()","!doc":"Gets the theme of the site"},"getTitle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getTitle()","!doc":"Return the title of the site"},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/sites/#getUrl()","!doc":"Retrieves the url of this Site."},"getViewers":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/sites/#getViewers()","!doc":"Gets the list of viewers and commenters for this Site."},"removeEditor":{"!type":"fn(user: base.User) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the Site."},"removeOwner":{"!type":"fn(user: base.User) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#removeOwner(User)","!doc":"Removes owner from the site"},"removeViewer":{"!type":"fn(user: base.User) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#removeViewer(User)","!doc":"Removes the given user from the list of viewers and commenters for the Site."},"search":{"!type":"fn(query: string, options: object) -> [+sites.Page]","!url":"http://developers.google.com/apps-script/reference/sites/#search(String,Object)","!doc":"Gets an array of descendant pages that match a search query, with optional advanced arguments."},"setSummary":{"!type":"fn(summary: string) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#setSummary(String)","!doc":"Set the summary of the web site"},"setTheme":{"!type":"fn(theme: string) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#setTheme(String)","!doc":"Sets the theme of the site Theme must be a valid theme string."},"setTitle":{"!type":"fn(title: string) -> +sites.Site","!url":"http://developers.google.com/apps-script/reference/sites/#setTitle(String)","!doc":"Set the title of the site"}}},"AttachmentType":{"!url":"http://developers.google.com/apps-script/reference/sites/attachment-type","!doc":"AttachmentType A typesafe enum for sites attachment type.","prototype":{"WEB":{"!type":"string","!doc":""},"HOSTED":{"!type":"string","!doc":""}}},"PageType":{"!url":"http://developers.google.com/apps-script/reference/sites/page-type","!doc":"PageType A typesafe enum for sites page type.","prototype":{"WEB_PAGE":{"!type":"string","!doc":""},"LIST_PAGE":{"!type":"string","!doc":""},"ANNOUNCEMENT":{"!type":"string","!doc":""},"ANNOUNCEMENTS_PAGE":{"!type":"string","!doc":""},"FILE_CABINET_PAGE":{"!type":"string","!doc":""}}}},"spreadsheet":{"ContainerInfo":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/container-info","!doc":"ContainerInfo The chart's position within a sheet. Can be updated using the EmbeddedChart.modify() function. chart = chart.modify().setPosition(5, 5, 0, 0).build(); sheet.updateChart(chart);","prototype":{"getAnchorColumn":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getAnchorColumn()","!doc":"The chart's left side will be anchored in this column."},"getAnchorRow":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getAnchorRow()","!doc":"The chart's top side will be anchored in this row."},"getOffsetX":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getOffsetX()","!doc":"The chart's upper left hand corner will be offset from the anchor column by this many pixels."},"getOffsetY":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getOffsetY()","!doc":"Chart's upper left hand corner will be offset from the anchor row by this many pixels."}}},"DataValidation":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/data-validation","!doc":"DataValidation This class allows users to access existing data-validation rules. To create a new rule, see SpreadsheetApp.newDataValidation(), DataValidationBuilder, and Range.setDataValidation(rule). // Log information about the data-validation rule for cell A1. var cell = SpreadsheetApp.getActive().getRange('A1'); var rule = cell.getDataValidation(); if (rule != null) { var criteria = rule.getCriteriaType(); var args = rule.getCriteriaValues(); Logger.log('The data-validation rule is %s %s', criteria, args); } else { Logger.log('The cell does not have a data-validation rule.') }","prototype":{"copy":{"!type":"fn() -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#copy()","!doc":"Creates a builder for a data-validation rule based on this rule's settings."},"getAllowInvalid":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getAllowInvalid()","!doc":"Returns true if the rule shows a warning when input fails data validation, or false if it rejects the input entirely."},"getCriteriaType":{"!type":"fn() -> +spreadsheet.DataValidationCriteria","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getCriteriaType()","!doc":"Gets the rule's criteria type as defined in the DataValidationCriteria enum."},"getCriteriaValues":{"!type":"fn() -> [object]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getCriteriaValues()","!doc":"Gets an array of arguments for the rule's criteria."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getHelpText()","!doc":"Gets the rule's help text, or null if no help text is set."}}},"DataValidationBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/data-validation-builder","!doc":"DataValidationBuilder Builder for data-validation rules. // Set the data validation for cell A1 to require a value from B1:B10. var cell = SpreadsheetApp.getActive().getRange('A1'); var range = SpreadsheetApp.getActive().getRange('B1:B10'); var rule = SpreadsheetApp.newDataValidation().requireValueInRange(range).build(); cell.setDataValidation(rule);","prototype":{"build":{"!type":"fn() -> +spreadsheet.DataValidation","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Constructs a data-validation rule from the settings applied to the builder."},"copy":{"!type":"fn() -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#copy()","!doc":"Creates a builder for a data-validation rule based on this rule's settings."},"getAllowInvalid":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getAllowInvalid()","!doc":"Returns true if the rule shows a warning when input fails data validation, or false if it rejects the input entirely."},"getCriteriaType":{"!type":"fn() -> +spreadsheet.DataValidationCriteria","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getCriteriaType()","!doc":"Gets the rule's criteria type as defined in the DataValidationCriteria enum."},"getCriteriaValues":{"!type":"fn() -> [object]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getCriteriaValues()","!doc":"Gets an array of arguments for the rule's criteria."},"getHelpText":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getHelpText()","!doc":"Gets the rule's help text, or null if no help text is set."},"requireDate":{"!type":"fn() -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDate()","!doc":"Sets the data-validation rule to require a date."},"requireDateAfter":{"!type":"fn(date: date) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDateAfter(Date)","!doc":"Sets the data-validation rule to require a date after the given value."},"requireDateBefore":{"!type":"fn(date: date) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDateBefore(Date)","!doc":"Sets the data-validation rule to require a date before the given value."},"requireDateBetween":{"!type":"fn(start: date, end: date) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDateBetween(Date,Date)","!doc":"Sets the data-validation rule to require a date between the given values, inclusive of the values themselves."},"requireDateEqualTo":{"!type":"fn(date: date) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDateEqualTo(Date)","!doc":"Sets the data-validation rule to require a date equal to the given value."},"requireDateNotBetween":{"!type":"fn(start: date, end: date) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDateNotBetween(Date,Date)","!doc":"Sets the data-validation rule to require a date not between the given values, inclusive of the values themselves."},"requireDateOnOrAfter":{"!type":"fn(date: date) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDateOnOrAfter(Date)","!doc":"Sets the data-validation rule to require a date on or after the given value."},"requireDateOnOrBefore":{"!type":"fn(date: date) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireDateOnOrBefore(Date)","!doc":"Sets the data-validation rule to require a date on or before the given value."},"requireFormulaSatisfied":{"!type":"fn(formula: string) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireFormulaSatisfied(String)","!doc":"Sets the data-validation rule to require that the given formula evaluates to true."},"requireNumberBetween":{"!type":"fn(start: number, end: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberBetween(Number,Number)","!doc":"Sets the data-validation rule to require a number between the given values, inclusive of the values themselves."},"requireNumberEqualTo":{"!type":"fn(number: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberEqualTo(Number)","!doc":"Sets the data-validation rule to require a number equal to the given value."},"requireNumberGreaterThan":{"!type":"fn(number: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberGreaterThan(Number)","!doc":"Sets the data-validation rule to require a number greater than the given value."},"requireNumberGreaterThanOrEqualTo":{"!type":"fn(number: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberGreaterThanOrEqualTo(Number)","!doc":"Sets the data-validation rule to require a number greater than or equal to the given value."},"requireNumberLessThan":{"!type":"fn(number: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberLessThan(Number)","!doc":"Sets the data-validation rule to require a number less than the given value."},"requireNumberLessThanOrEqualTo":{"!type":"fn(number: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberLessThanOrEqualTo(Number)","!doc":"Sets the data-validation rule to require a number less than or equal to the given value."},"requireNumberNotBetween":{"!type":"fn(start: number, end: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberNotBetween(Number,Number)","!doc":"Sets the data-validation rule to require a number not between the given values, inclusive of the values themselves."},"requireNumberNotEqualTo":{"!type":"fn(number: number) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireNumberNotEqualTo(Number)","!doc":"Sets the data-validation rule to require a number not equal to the given value."},"requireTextContains":{"!type":"fn(text: string) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireTextContains(String)","!doc":"Sets the data-validation rule to require that the input contains the given value."},"requireTextDoesNotContain":{"!type":"fn(text: string) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireTextDoesNotContain(String)","!doc":"Sets the data-validation rule to require that the input does not contain the given value."},"requireTextEqualTo":{"!type":"fn(text: string) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireTextEqualTo(String)","!doc":"Sets the data-validation rule to require that the input is equal to the given value."},"requireTextIsEmail":{"!type":"fn() -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireTextIsEmail()","!doc":"Sets the data-validation rule to require that the input is in the form of an email address."},"requireTextIsUrl":{"!type":"fn() -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireTextIsUrl()","!doc":"Sets the data-validation rule to require that the input is in the form of a URL."},"requireValueInList":{"!type":"fn(values: [string], showDropdown: bool) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireValueInList(String,Boolean)","!doc":"Sets the data-validation rule to require that the input is equal to one of the given values, with an option to hide the dropdown menu."},"requireValueInRange":{"!type":"fn(range: spreadsheet.Range, showDropdown: bool) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#requireValueInRange(Range,Boolean)","!doc":"Sets the data-validation rule to require that the input is equal to a value in the given range, with an option to hide the dropdown menu."},"setAllowInvalid":{"!type":"fn(allowInvalidData: bool) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setAllowInvalid(Boolean)","!doc":"Sets whether to show a warning when input fails data validation or whether to reject the input entirely."},"setHelpText":{"!type":"fn(helpText: string) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setHelpText(String)","!doc":"Sets the help text shown when the user hovers over the cell on which data-validation is set."},"withCriteria":{"!type":"fn(criteria: spreadsheet.DataValidationCriteria, args: [object]) -> +spreadsheet.DataValidationBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#withCriteria(DataValidationCriteria,Object)","!doc":"Sets the data-validation rule to require criteria defined in the DataValidationCriteria enum."}}},"EmbeddedAreaChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-area-chart-builder","!doc":"EmbeddedAreaChartBuilder Builder for area charts. For more details, see the Gviz documentation.","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"reverseCategories":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPointStyle":{"!type":"fn(style: charts.PointStyle) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPointStyle(PointStyle)","!doc":"Sets the style for points in the line."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."},"setRange":{"!type":"fn(start: number, end: number) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setStacked":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setStacked()","!doc":"Uses stacked lines, meaning that line and bar values are stacked (accumulated)."},"setTitle":{"!type":"fn(chartTitle: string) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"EmbeddedBarChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-bar-chart-builder","!doc":"EmbeddedBarChartBuilder Builder for bar charts. For more details, see the Gviz documentation.","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"reverseCategories":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"reverseDirection":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#reverseDirection()","!doc":"Reverses the direction in which the bars grow along the horizontal axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."},"setRange":{"!type":"fn(start: number, end: number) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setStacked":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setStacked()","!doc":"Uses stacked lines, meaning that line and bar values are stacked (accumulated)."},"setTitle":{"!type":"fn(chartTitle: string) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"EmbeddedChart":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-chart","!doc":"EmbeddedChart Represents a chart that has been embedded into a Spreadsheet. This example shows how to modify an existing chart: var sheet = SpreadsheetApp.getActiveSheet(); var range = sheet.getRange(\"A2:B8\") var chart = sheet.getCharts()[0]; chart = chart.modify() .addRange(range) .setOption('title', 'Updated!') .setOption('animation.duration', 500) .setPosition(2,2,0,0) .build(); sheet.updateChart(chart); This example shows how to create a new chart: function newChart(range, sheet) { var sheet = SpreadsheetApp.getActiveSheet(); var chartBuilder = sheet.newChart(); chartBuilder.addRange(range) .setChartType(Charts.ChartType.LINE) .setOption('title', 'My Line Chart!'); sheet.insertChart(chartBuilder.build()); }","prototype":{"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getBlob()","!doc":"Return the data inside this object as a blob."},"getContainerInfo":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainerInfo()","!doc":"Returns information about where the chart is positioned within a sheet."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getId()","!doc":"Returns the id that has been assigned to this object."},"getOptions":{"!type":"fn() -> +charts.ChartOptions","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getOptions()","!doc":"Returns the options for this chart, such as height, colors, axes, etc."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns the Ranges that this chart uses as a data source."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getType()","!doc":"Gets the type of this object."},"modify":{"!type":"fn() -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#modify()","!doc":"Returns an EmbeddedChartBuilder that can be used to modify this chart."},"setId":{"!type":"fn(id: string) -> +charts.Chart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setId(String)","!doc":"Sets the id of this EmbeddedChart to be used with UiApp."}}},"EmbeddedChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-chart-builder","!doc":"EmbeddedChartBuilder This builder allows you to edit an EmbeddedChart. Make sure to call sheet.updateChart(builder.build()) to save your changes. var sheet = SpreadsheetApp.getActiveSheet(); var range = sheet.getRange(\"A1:B8\"); var chart = sheet.getCharts()[0]; chart = chart.modify() .addRange(range) .setOption('title', 'Updated!') .setOption('animation.duration', 500) .setPosition(2,2,0,0) .build(); sheet.updateChart(chart);","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."}}},"EmbeddedColumnChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-column-chart-builder","!doc":"EmbeddedColumnChartBuilder Builder for column charts. For more details, see the Gviz documentation.","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"reverseCategories":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."},"setRange":{"!type":"fn(start: number, end: number) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setStacked":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setStacked()","!doc":"Uses stacked lines, meaning that line and bar values are stacked (accumulated)."},"setTitle":{"!type":"fn(chartTitle: string) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"EmbeddedLineChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-line-chart-builder","!doc":"EmbeddedLineChartBuilder Builder for line charts. For more details, see the Gviz documentation.","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"reverseCategories":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setCurveStyle":{"!type":"fn(style: charts.CurveStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setCurveStyle(CurveStyle)","!doc":"Sets the style to use for curves in the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPointStyle":{"!type":"fn(style: charts.PointStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPointStyle(PointStyle)","!doc":"Sets the style for points in the line."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."},"setRange":{"!type":"fn(start: number, end: number) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setRange(Number,Number)","!doc":"Sets the range for the chart."},"setTitle":{"!type":"fn(chartTitle: string) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."},"useLogScale":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#useLogScale()","!doc":"Makes the range axis into a logarithmic scale (requires all values to be positive)."}}},"EmbeddedPieChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-pie-chart-builder","!doc":"EmbeddedPieChartBuilder Builder for pie charts. For more details, see the Gviz documentation.","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"reverseCategories":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#reverseCategories()","!doc":"Reverses the drawing of series in the domain axis."},"set3D":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#set3D()","!doc":"Sets the chart to be three-dimensional."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."},"setTitle":{"!type":"fn(chartTitle: string) -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."}}},"EmbeddedScatterChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-scatter-chart-builder","!doc":"EmbeddedScatterChartBuilder Builder for scatter charts. For more details, see the Gviz documentation.","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"setBackgroundColor":{"!type":"fn(cssValue: string) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgroundColor(String)","!doc":"Sets the background color for the chart."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setColors":{"!type":"fn(cssValues: [string]) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColors(String)","!doc":"Sets the colors for the lines in the chart."},"setLegendPosition":{"!type":"fn(position: charts.Position) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendPosition(Position)","!doc":"Sets the position of the legend with respect to the chart."},"setLegendTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setLegendTextStyle(TextStyle)","!doc":"Sets the text style of the chart legend."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPointStyle":{"!type":"fn(style: charts.PointStyle) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPointStyle(PointStyle)","!doc":"Sets the style for points in the line."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."},"setTitle":{"!type":"fn(chartTitle: string) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitle(String)","!doc":"Sets the title of the chart."},"setTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setTitleTextStyle(TextStyle)","!doc":"Sets the text style of the chart title."},"setXAxisLogScale":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisLogScale()","!doc":"Makes the horizontal axis into a logarithmic scale (requires all values to be positive)."},"setXAxisRange":{"!type":"fn(start: number, end: number) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisRange(Number,Number)","!doc":"Sets the range for the horizontal axis of the chart."},"setXAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTextStyle(TextStyle)","!doc":"Sets the horizontal axis text style."},"setXAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitle(String)","!doc":"Adds a title to the horizontal axis."},"setXAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setXAxisTitleTextStyle(TextStyle)","!doc":"Sets the horizontal axis title text style."},"setYAxisLogScale":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisLogScale()","!doc":"Makes the vertical axis into a logarithmic scale (requires all values to be positive)."},"setYAxisRange":{"!type":"fn(start: number, end: number) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisRange(Number,Number)","!doc":"Sets the range for the vertical axis of the chart."},"setYAxisTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTextStyle(TextStyle)","!doc":"Sets the vertical axis text style."},"setYAxisTitle":{"!type":"fn(title: string) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitle(String)","!doc":"Adds a title to the vertical axis."},"setYAxisTitleTextStyle":{"!type":"fn(textStyle: charts.TextStyle) -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setYAxisTitleTextStyle(TextStyle)","!doc":"Sets the vertical axis title text style."}}},"EmbeddedTableChartBuilder":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/embedded-table-chart-builder","!doc":"EmbeddedTableChartBuilder Builder for table charts. For more details, see the Gviz documentation.","prototype":{"addRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addRange(Range)","!doc":"Adds a Range to the chart represented by this builder."},"asAreaChart":{"!type":"fn() -> +spreadsheet.EmbeddedAreaChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asAreaChart()","!doc":"Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder."},"asBarChart":{"!type":"fn() -> +spreadsheet.EmbeddedBarChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asBarChart()","!doc":"Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder."},"asColumnChart":{"!type":"fn() -> +spreadsheet.EmbeddedColumnChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asColumnChart()","!doc":"Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder."},"asLineChart":{"!type":"fn() -> +spreadsheet.EmbeddedLineChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asLineChart()","!doc":"Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder."},"asPieChart":{"!type":"fn() -> +spreadsheet.EmbeddedPieChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asPieChart()","!doc":"Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder."},"asScatterChart":{"!type":"fn() -> +spreadsheet.EmbeddedScatterChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asScatterChart()","!doc":"Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder."},"asTableChart":{"!type":"fn() -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#asTableChart()","!doc":"Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder."},"build":{"!type":"fn() -> +spreadsheet.EmbeddedChart","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#build()","!doc":"Builds the chart to reflect all changes made to it."},"enablePaging":{"!type":"fn(pageSize: number, startPage: number) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#enablePaging(Integer,Integer)","!doc":"Enables paging, sets the number of rows in each page and the first table page to display (page numbers are zero based)."},"enableRtlTable":{"!type":"fn(rtlEnabled: bool) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#enableRtlTable(Boolean)","!doc":"Adds basic support for right-to-left languages (such as Arabic or Hebrew) by reversing the column order of the table, so that column zero is the right-most column, and the last column is the left-most column."},"enableSorting":{"!type":"fn(enableSorting: bool) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#enableSorting(Boolean)","!doc":"Sets whether to sort columns when the user clicks a column heading."},"getChartType":{"!type":"fn() -> +charts.ChartType","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getChartType()","!doc":"Returns the current chart type."},"getContainer":{"!type":"fn() -> +spreadsheet.ContainerInfo","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getContainer()","!doc":"Return the ContainerInfo, which encapsulates where the chart appears on the sheet."},"getRanges":{"!type":"fn() -> [+spreadsheet.Range]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRanges()","!doc":"Returns a copy of the list of ranges currently providing data for this chart."},"removeRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeRange(Range)","!doc":"Removes the specified Range from the chart represented by this builder."},"setChartType":{"!type":"fn(type: charts.ChartType) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setChartType(ChartType)","!doc":"Changes the type of chart."},"setFirstRowNumber":{"!type":"fn(number: number) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFirstRowNumber(Integer)","!doc":"Sets the row number for the first row in the data table."},"setInitialSortingAscending":{"!type":"fn(column: number) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setInitialSortingAscending(Integer)","!doc":"Sets the index of the column according to which the table should be initially sorted (ascending)."},"setInitialSortingDescending":{"!type":"fn(column: number) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setInitialSortingDescending(Integer)","!doc":"Sets the index of the column according to which the table should be initially sorted (descending)."},"setOption":{"!type":"fn(option: string, value: object) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setOption(String,Object)","!doc":"Sets advanced options for this chart."},"setPosition":{"!type":"fn(anchorRowPos: number, anchorColPos: number, offsetX: number, offsetY: number) -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setPosition(Integer,Integer,Integer,Integer)","!doc":"Sets the position, changing where the chart appears on the sheet."},"showRowNumberColumn":{"!type":"fn(showRowNumber: bool) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#showRowNumberColumn(Boolean)","!doc":"Sets whether to show the row number as the first column of the table."},"useAlternatingRowStyle":{"!type":"fn(alternate: bool) -> +spreadsheet.EmbeddedTableChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#useAlternatingRowStyle(Boolean)","!doc":"Sets whether alternating color style will be assigned to odd and even rows of a table chart."}}},"PageProtection":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/page-protection","!doc":"PageProtection Access and modify the state of protection permissions on a sheet. This class allows users to access and modify sheet protection permissions on a sheet.","prototype":{"addUser":{"!type":"fn(email: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addUser(String)","!doc":"Adds a user to the list of users who can edit the sheet, if it is protected."},"getUsers":{"!type":"fn() -> [string]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getUsers()","!doc":"Returns a list of the email addresses of the users who can edit this sheet."},"isProtected":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#isProtected()","!doc":"Indicates whether the sheet has sheet protection enabled or not."},"removeUser":{"!type":"fn(user: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeUser(String)","!doc":"Removes a user from the list of users who can edit the sheet."},"setProtected":{"!type":"fn(protection: bool)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setProtected(Boolean)","!doc":"Sets the protection status for the sheet."}}},"Range":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/range","!doc":"Range Access and modify spreadsheet ranges. This class allows users to access and modify ranges in Google Sheets. A range can be a single cell in a sheet or a range of cells in a sheet.","prototype":{"activate":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#activate()","!doc":"Make this range the active range."},"breakApart":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#breakApart()","!doc":"Break any multi-column cells in the range into individual cells again."},"clear":{"!type":"fn(options: object) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clear(Object)","!doc":"Clears the range of contents, format, data-validation rules, and/or comments, as specified with the given advanced options."},"clearContent":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clearContent()","!doc":"Clears the content of the range, leaving the formatting intact."},"clearDataValidations":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clearDataValidations()","!doc":"Clears the data-validation rules for the range."},"clearFormat":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clearFormat()","!doc":"Clears formatting for this range."},"clearNote":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clearNote()","!doc":"Clears the note in the given cell or cells."},"copyFormatToRange":{"!type":"fn(sheet: spreadsheet.Sheet, column: number, columnEnd: number, row: number, rowEnd: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#copyFormatToRange(Sheet,Integer,Integer,Integer,Integer)","!doc":"Copy the formatting of the range to the given location."},"copyTo":{"!type":"fn(destination: spreadsheet.Range, options: object)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#copyTo(Range,Object)","!doc":"Copies the data from a range of cells to another range of cells."},"copyValuesToRange":{"!type":"fn(sheet: spreadsheet.Sheet, column: number, columnEnd: number, row: number, rowEnd: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#copyValuesToRange(Sheet,Integer,Integer,Integer,Integer)","!doc":"Copy the content of the range to the given location."},"getA1Notation":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getA1Notation()","!doc":"Returns a string description of the range, in A1 notation."},"getBackground":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getBackground()","!doc":"Returns the background color of the top-left cell in the range (i.e., '#ffffff')."},"getBackgrounds":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getBackgrounds()","!doc":"Returns the background colors of the cells in the range (i.e., '#ffffff')."},"getCell":{"!type":"fn(row: number, column: number) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getCell(Integer,Integer)","!doc":"Returns a given cell within a range."},"getColumn":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getColumn()","!doc":"Returns the starting column position for this range."},"getDataSourceUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getDataSourceUrl()","!doc":"Returns a URL for the data in this range, which can be used to create charts and queries."},"getDataTable":{"!type":"fn(firstRowIsHeader: bool) -> +charts.DataTable","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getDataTable(Boolean)","!doc":"Return the data inside this Range as a DataTable."},"getDataValidation":{"!type":"fn() -> +spreadsheet.DataValidation","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getDataValidation()","!doc":"Returns the data-validation rule for the top-left cell in the range."},"getDataValidations":{"!type":"fn() -> [[+spreadsheet.DataValidation]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getDataValidations()","!doc":"Returns the data-validation rules for all cells in the range."},"getFontColor":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontColor()","!doc":"Returns the font color of the cell in the top-left corner of the range, in CSS notation (like '#ffffff' or 'white')."},"getFontColors":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontColors()","!doc":"Returns the font colors of the cells in the range in CSS notation (like '#ffffff' or 'white')."},"getFontFamilies":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontFamilies()","!doc":"Returns the font families of the cells in the range."},"getFontFamily":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontFamily()","!doc":"Returns the font family of the cell in the top-left corner of the range."},"getFontLine":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontLine()","!doc":"Gets the line style of the cell in the top-left corner of the range ('underline', 'line-through', or 'none')."},"getFontLines":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontLines()","!doc":"Gets the line style of the cells in the range ('underline', 'line-through', or 'none')."},"getFontSize":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontSize()","!doc":"Returns the font size in point size of the cell in the top-left corner of the range."},"getFontSizes":{"!type":"fn() -> [[number]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontSizes()","!doc":"Returns the font sizes of the cells in the range."},"getFontStyle":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontStyle()","!doc":"Returns the font style ('italic' or 'normal' of the cell in the top-left corner of the range."},"getFontStyles":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontStyles()","!doc":"Returns the font styles of the cells in the range."},"getFontWeight":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontWeight()","!doc":"Returns the font weight (normal/bold) of the cell in the top-left corner of the range."},"getFontWeights":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFontWeights()","!doc":"Returns the font weights of the cells in the range."},"getFormula":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFormula()","!doc":"Returns the formula (A1 notation) for the top-left cell of the range, or an empty string if the cell is empty or doesn't contain a formula."},"getFormulaR1C1":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFormulaR1C1()","!doc":"Returns the formula (R1C1 notation) for a given cell, or null if none."},"getFormulas":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFormulas()","!doc":"Returns the formulas (A1 notation) for the cells in the range."},"getFormulasR1C1":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFormulasR1C1()","!doc":"Returns the formulas (R1C1 notation) for the cells in the range."},"getGridId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getGridId()","!doc":"Returns the grid ID of the range's parent sheet."},"getHeight":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getHeight()","!doc":"Returns the height of the range."},"getHorizontalAlignment":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getHorizontalAlignment()","!doc":"Returns the horizontal alignment of the text (left/center/right) of the cell in the top-left corner of the range."},"getHorizontalAlignments":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getHorizontalAlignments()","!doc":"Returns the horizontal alignments of the cells in the range."},"getLastColumn":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getLastColumn()","!doc":"Returns the end column position."},"getLastRow":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getLastRow()","!doc":"Returns the end row position."},"getNote":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getNote()","!doc":"Returns the note associated with the given range."},"getNotes":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getNotes()","!doc":"Returns the notes associated with the cells in the range."},"getNumColumns":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getNumColumns()","!doc":"Returns the number of columns in this range."},"getNumRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getNumRows()","!doc":"Returns the number of rows in this range."},"getNumberFormat":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getNumberFormat()","!doc":"Get the number formatting of the top-left cell of the given range."},"getNumberFormats":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getNumberFormats()","!doc":"Returns the number formats for the cells in the range."},"getRow":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRow()","!doc":"Returns the row position for this range."},"getRowIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRowIndex()","!doc":"Returns the row position for this range."},"getSheet":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheet()","!doc":"Returns the sheet this range belongs to."},"getValue":{"!type":"fn() -> object","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getValue()","!doc":"Returns the value of the top-left cell in the range."},"getValues":{"!type":"fn() -> [[object]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getValues()","!doc":"Returns the rectangular grid of values for this range."},"getVerticalAlignment":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getVerticalAlignment()","!doc":"Returns the vertical alignment (top/middle/bottom) of the cell in the top-left corner of the range."},"getVerticalAlignments":{"!type":"fn() -> [[string]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getVerticalAlignments()","!doc":"Returns the vertical alignments of the cells in the range."},"getWidth":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getWidth()","!doc":"Returns the width of the range in columns."},"getWrap":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getWrap()","!doc":"Returns the wrapping policy of the cell in the top-left corner of the range."},"getWraps":{"!type":"fn() -> [[bool]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getWraps()","!doc":"Returns the wrapping policy of the cells in the range."},"isBlank":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#isBlank()","!doc":"Returns true if the range is totally blank."},"merge":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#merge()","!doc":"Merges the cells in the range together into a single block."},"mergeAcross":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#mergeAcross()","!doc":"Merge the cells in the range across the columns of the range."},"mergeVertically":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#mergeVertically()","!doc":"Merges the cells in the range together."},"moveTo":{"!type":"fn(target: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#moveTo(Range)","!doc":"Cut and paste (both format and values) from this range to the target range."},"offset":{"!type":"fn(rowOffset: number, columnOffset: number, numRows: number, numColumns: number) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#offset(Integer,Integer,Integer,Integer)","!doc":"Returns a new range that is relative to the current range, whose upper left point is offset from the current range by the given rows and columns, and with the given height and width in cells."},"setBackground":{"!type":"fn(color: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackground(String)","!doc":"Sets the background color of all cells in the range in CSS notation (like '#ffffff' or 'white')."},"setBackgroundRGB":{"!type":"fn(red: number, green: number, blue: number) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgroundRGB(Integer,Integer,Integer)","!doc":"Sets the background to the given RGB color."},"setBackgrounds":{"!type":"fn(color: [[string]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBackgrounds(String)","!doc":"Sets a rectangular grid of background colors (must match dimensions of this range)."},"setBorder":{"!type":"fn(top: bool, left: bool, bottom: bool, right: bool, vertical: bool, horizontal: bool) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setBorder(Boolean,Boolean,Boolean,Boolean,Boolean,Boolean)","!doc":"Sets the border property."},"setDataValidation":{"!type":"fn(rule: spreadsheet.DataValidation) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setDataValidation(DataValidation)","!doc":"Sets one data-validation rule for all cells in the range."},"setDataValidations":{"!type":"fn(rules: [[spreadsheet.DataValidation]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setDataValidations(DataValidation)","!doc":"Sets the data-validation rules for all cells in the range."},"setFontColor":{"!type":"fn(color: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontColor(String)","!doc":"Sets the font color in CSS notation (like '#ffffff' or 'white')."},"setFontColors":{"!type":"fn(colors: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontColors(Object)","!doc":"Sets a rectangular grid of font colors (must match dimensions of this range)."},"setFontFamilies":{"!type":"fn(fontFamilies: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontFamilies(Object)","!doc":"Sets a rectangular grid of font families (must match dimensions of this range)."},"setFontFamily":{"!type":"fn(fontFamily: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontFamily(String)","!doc":"Sets the font family, such as \"Arial\" or \"Helvetica\"."},"setFontLine":{"!type":"fn(fontLine: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontLine(String)","!doc":"Sets the line style of the given range ('underline', 'line-through', or 'none')."},"setFontLines":{"!type":"fn(fontLines: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontLines(Object)","!doc":"Sets a rectangular grid of line styles (must match dimensions of this range)."},"setFontSize":{"!type":"fn(size: number) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontSize(Integer)","!doc":"Sets the font size, with the size being the point size to use."},"setFontSizes":{"!type":"fn(sizes: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontSizes(Object)","!doc":"Sets a rectangular grid of font sizes (must match dimensions of this range)."},"setFontStyle":{"!type":"fn(fontStyle: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontStyle(String)","!doc":"Set the font style for the given range ('italic' or 'normal')."},"setFontStyles":{"!type":"fn(fontStyles: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontStyles(Object)","!doc":"Sets a rectangular grid of font styles (must match dimensions of this range)."},"setFontWeight":{"!type":"fn(fontWeight: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontWeight(String)","!doc":"Set the font weight for the given range (normal/bold)."},"setFontWeights":{"!type":"fn(fontWeights: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFontWeights(Object)","!doc":"Sets a rectangular grid of font weights (must match dimensions of this range)."},"setFormula":{"!type":"fn(formula: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFormula(String)","!doc":"Updates the formula for this range."},"setFormulaR1C1":{"!type":"fn(formula: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFormulaR1C1(String)","!doc":"Updates the formula for this range."},"setFormulas":{"!type":"fn(formulas: [[string]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFormulas(String)","!doc":"Sets a rectangular grid of formulas (must match dimensions of this range)."},"setFormulasR1C1":{"!type":"fn(formulas: [[string]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFormulasR1C1(String)","!doc":"Sets a rectangular grid of formulas (must match dimensions of this range)."},"setHorizontalAlignment":{"!type":"fn(alignment: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setHorizontalAlignment(String)","!doc":"Set the horizontal (left to right) alignment for the given range (left/center/right)."},"setHorizontalAlignments":{"!type":"fn(alignments: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setHorizontalAlignments(Object)","!doc":"Sets a rectangular grid of horizontal alignments."},"setNote":{"!type":"fn(note: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setNote(String)","!doc":"Sets the note to the given value."},"setNotes":{"!type":"fn(notes: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setNotes(Object)","!doc":"Sets a rectangular grid of notes (must match dimensions of this range)."},"setNumberFormat":{"!type":"fn(numberFormat: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setNumberFormat(String)","!doc":"Sets the number or date format to the given formatting string."},"setNumberFormats":{"!type":"fn(numberFormats: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setNumberFormats(Object)","!doc":"Sets a rectangular grid of number or date formats (must match dimensions of this range)."},"setValue":{"!type":"fn(value: object) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setValue(Object)","!doc":"Sets the value of the range."},"setValues":{"!type":"fn(values: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setValues(Object)","!doc":"Sets a rectangular grid of values (must match dimensions of this range)."},"setVerticalAlignment":{"!type":"fn(alignment: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setVerticalAlignment(String)","!doc":"Set the vertical (top to bottom) alignment for the given range (top/middle/bottom)."},"setVerticalAlignments":{"!type":"fn(alignments: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setVerticalAlignments(Object)","!doc":"Sets a rectangular grid of vertical alignments (must match dimensions of this range)."},"setWrap":{"!type":"fn(isWrapEnabled: bool) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setWrap(Boolean)","!doc":"Set the cell wrap of the given range."},"setWraps":{"!type":"fn(isWrapEnabled: [[object]]) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setWraps(Object)","!doc":"Sets a rectangular grid of word wrap policies (must match dimensions of this range)."},"sort":{"!type":"fn(sortSpecObj: object) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#sort(Object)","!doc":"Sorts the cells in the given range."}}},"Sheet":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/sheet","!doc":"Sheet Access and modify spreadsheet sheets. Common operations are renaming a sheet and accessing range objects from the sheet.","prototype":{"activate":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#activate()","!doc":"Activates this sheet."},"appendRow":{"!type":"fn(rowContents: [object]) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#appendRow(Object)","!doc":"Appends a row to the spreadsheet."},"autoResizeColumn":{"!type":"fn(columnPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#autoResizeColumn(Integer)","!doc":"Sets the width of the given column to fit its contents"},"clear":{"!type":"fn(options: object) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clear(Object)","!doc":"Clears the sheet of contents and/or format, as specified with the given advanced options."},"clearContents":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clearContents()","!doc":"Clears the sheet of contents, while preserving formatting information."},"clearFormats":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clearFormats()","!doc":"Clears the sheet of formatting, while preserving contents."},"clearNotes":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#clearNotes()","!doc":"Clears the sheet of all notes."},"copyTo":{"!type":"fn(spreadsheet: spreadsheet.Spreadsheet) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#copyTo(Spreadsheet)","!doc":"Copies the sheet to another spreadsheet."},"deleteColumn":{"!type":"fn(columnPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteColumn(Integer)","!doc":"Deletes the column at the given column position."},"deleteColumns":{"!type":"fn(columnPosition: number, howMany: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteColumns(Integer,Integer)","!doc":"Deletes a number of columns starting at the given column position."},"deleteRow":{"!type":"fn(rowPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteRow(Integer)","!doc":"Deletes the row at the given row position."},"deleteRows":{"!type":"fn(rowPosition: number, howMany: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteRows(Integer,Integer)","!doc":"Deletes a number of rows starting at the given row position."},"getActiveCell":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getActiveCell()","!doc":"Returns the active cell in this sheet."},"getActiveRange":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getActiveRange()","!doc":"Returns the active range for the active sheet."},"getCharts":{"!type":"fn() -> [+spreadsheet.EmbeddedChart]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getCharts()","!doc":"Returns an array of charts on this sheet."},"getColumnWidth":{"!type":"fn(columnPosition: number) -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getColumnWidth(Integer)","!doc":"Gets the width in pixels of the given column."},"getDataRange":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getDataRange()","!doc":"Returns a Range corresponding to the dimensions in which data is present."},"getFrozenColumns":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFrozenColumns()","!doc":"Returns the number of frozen columns."},"getFrozenRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFrozenRows()","!doc":"Returns the number of frozen rows."},"getIndex":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getIndex()","!doc":"Gets the position of the sheet in its parent spreadsheet."},"getLastColumn":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getLastColumn()","!doc":"Returns the position of the last column that has content."},"getLastRow":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getLastRow()","!doc":"Returns the position of the last row that has content."},"getMaxColumns":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getMaxColumns()","!doc":"The maximum width of the sheet, regardless of content."},"getMaxRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getMaxRows()","!doc":"The maximum height of the sheet, regardless of content."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getName()","!doc":"Returns the name of the sheet."},"getParent":{"!type":"fn() -> +spreadsheet.Spreadsheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getParent()","!doc":"Returns the Spreadsheet that contains this sheet."},"getRange":{"!type":"fn(a1Notation: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRange(String)","!doc":"Returns the range as specified in A1 notation or R1C1 notation."},"getRowHeight":{"!type":"fn(rowPosition: number) -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRowHeight(Integer)","!doc":"Gets the height in pixels of the given row."},"getSheetId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetId()","!doc":"Returns the ID of the sheet represented by this object."},"getSheetName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetName()","!doc":"Returns the sheet name."},"getSheetProtection":{"!type":"fn() -> +spreadsheet.PageProtection","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetProtection()","!doc":"Returns a PageProtection instance describing the permissions for the current sheet."},"getSheetValues":{"!type":"fn(startRow: number, startColumn: number, numRows: number, numColumns: number) -> [[object]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetValues(Integer,Integer,Integer,Integer)","!doc":"Returns the rectangular grid of values for this range starting at the given coordinates."},"hideColumn":{"!type":"fn(column: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#hideColumn(Range)","!doc":"Hides the columns in the given range."},"hideColumns":{"!type":"fn(columnIndex: number, numColumns: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#hideColumns(Integer,Integer)","!doc":"Hides one or more consecutive columns starting at the given index."},"hideRow":{"!type":"fn(row: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#hideRow(Range)","!doc":"Hides the rows in the given range."},"hideRows":{"!type":"fn(rowIndex: number, numRows: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#hideRows(Integer,Integer)","!doc":"Hides one or more consecutive rows starting at the given index."},"hideSheet":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#hideSheet()","!doc":"Hides this sheet."},"insertChart":{"!type":"fn(chart: spreadsheet.EmbeddedChart)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertChart(EmbeddedChart)","!doc":"Adds a new chart to this sheet."},"insertColumnAfter":{"!type":"fn(afterPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnAfter(Integer)","!doc":"Inserts a column after the given column position."},"insertColumnBefore":{"!type":"fn(beforePosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnBefore(Integer)","!doc":"Inserts a column before the given column position."},"insertColumns":{"!type":"fn(columnIndex: number, numColumns: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumns(Integer,Integer)","!doc":"Inserts one or more consecutive blank columns in a sheet starting at the specified location."},"insertColumnsAfter":{"!type":"fn(afterPosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnsAfter(Integer,Integer)","!doc":"Inserts a number of columns after the given column position."},"insertColumnsBefore":{"!type":"fn(beforePosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnsBefore(Integer,Integer)","!doc":"Inserts a number of columns before the given column position."},"insertImage":{"!type":"fn(url: string, column: number, row: number, offsetX: number, offsetY: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertImage(String,Integer,Integer,Integer,Integer)","!doc":"Inserts an image in the document at a given row and column with a pixel offset."},"insertRowAfter":{"!type":"fn(afterPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowAfter(Integer)","!doc":"Inserts a row after the given row position."},"insertRowBefore":{"!type":"fn(beforePosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowBefore(Integer)","!doc":"Inserts a row before the given row position."},"insertRows":{"!type":"fn(rowIndex: number, numRows: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRows(Integer,Integer)","!doc":"Inserts one or more consecutive blank rows in a sheet starting at the specified location."},"insertRowsAfter":{"!type":"fn(afterPosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowsAfter(Integer,Integer)","!doc":"Inserts a number of rows after the given row position."},"insertRowsBefore":{"!type":"fn(beforePosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowsBefore(Integer,Integer)","!doc":"Inserts a number of rows before the given row position."},"isSheetHidden":{"!type":"fn() -> bool","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#isSheetHidden()","!doc":"Returns true if the sheet is currently hidden."},"newChart":{"!type":"fn() -> +spreadsheet.EmbeddedChartBuilder","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#newChart()","!doc":"Returns a builder to create a new chart for this sheet."},"removeChart":{"!type":"fn(chart: spreadsheet.EmbeddedChart)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeChart(EmbeddedChart)","!doc":"Removes a chart from the parent sheet."},"setActiveRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setActiveRange(Range)","!doc":"Sets the active range for the active sheet."},"setActiveSelection":{"!type":"fn(a1Notation: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setActiveSelection(String)","!doc":"Sets the active selection, as specified in A1 notation or R1C1 notation."},"setColumnWidth":{"!type":"fn(columnPosition: number, width: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColumnWidth(Integer,Integer)","!doc":"Sets the width of the given column in pixels."},"setFrozenColumns":{"!type":"fn(columns: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFrozenColumns(Integer)","!doc":"Freezes the given number of columns."},"setFrozenRows":{"!type":"fn(rows: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFrozenRows(Integer)","!doc":"Freezes the given number of rows."},"setName":{"!type":"fn(name: string) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setName(String)","!doc":"Sets the sheet name."},"setRowHeight":{"!type":"fn(rowPosition: number, height: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setRowHeight(Integer,Integer)","!doc":"Sets the row height of the given row in pixels."},"setSheetProtection":{"!type":"fn(permissions: spreadsheet.PageProtection)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setSheetProtection(PageProtection)","!doc":"Sets the permissions for the current sheet."},"showColumns":{"!type":"fn(columnIndex: number, numColumns: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#showColumns(Integer,Integer)","!doc":"Unhides one or more consecutive columns starting at the given index."},"showRows":{"!type":"fn(rowIndex: number, numRows: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#showRows(Integer,Integer)","!doc":"Unhides one or more consecutive rows starting at the given index."},"showSheet":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#showSheet()","!doc":"Makes the sheet visible."},"sort":{"!type":"fn(columnPosition: number, ascending: bool) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#sort(Integer,Boolean)","!doc":"Sorts a sheet by column."},"unhideColumn":{"!type":"fn(column: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#unhideColumn(Range)","!doc":"Unhides the column in the given range."},"unhideRow":{"!type":"fn(row: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#unhideRow(Range)","!doc":"Unhides the row in the given range."},"updateChart":{"!type":"fn(chart: spreadsheet.EmbeddedChart)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#updateChart(EmbeddedChart)","!doc":"Updates the chart on this sheet."}}},"Spreadsheet":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/spreadsheet","!doc":"Spreadsheet This class allows users to access and modify Google Sheets files. Common operations are adding new sheets and adding collaborators.","prototype":{"addEditor":{"!type":"fn(user: base.User)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addEditor(User)","!doc":"Adds the given user to the list of editors for the Spreadsheet."},"addEditors":{"!type":"fn(emailAddresses: [string])","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addEditors(String)","!doc":"Adds the given array of users to the list of editors for the Spreadsheet."},"addMenu":{"!type":"fn(name: string, subMenus: [object])","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addMenu(String,Object)","!doc":"Creates a new menu in the Spreadsheet UI."},"addViewer":{"!type":"fn(user: base.User)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addViewer(User)","!doc":"Adds the given user to the list of viewers for the Spreadsheet."},"addViewers":{"!type":"fn(emailAddresses: [string])","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#addViewers(String)","!doc":"Adds the given array of users to the list of viewers for the Spreadsheet."},"appendRow":{"!type":"fn(rowContents: [object]) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#appendRow(Object)","!doc":"Appends a row to the spreadsheet."},"autoResizeColumn":{"!type":"fn(columnPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#autoResizeColumn(Integer)","!doc":"Sets the width of the given column to fit its contents"},"copy":{"!type":"fn(name: string) -> +spreadsheet.Spreadsheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#copy(String)","!doc":"Copies the spreadsheet and returns the new one."},"deleteActiveSheet":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteActiveSheet()","!doc":"Deletes the currently active sheet."},"deleteColumn":{"!type":"fn(columnPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteColumn(Integer)","!doc":"Deletes the column at the given column position."},"deleteColumns":{"!type":"fn(columnPosition: number, howMany: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteColumns(Integer,Integer)","!doc":"Deletes a number of columns starting at the given column position."},"deleteRow":{"!type":"fn(rowPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteRow(Integer)","!doc":"Deletes the row at the given row position."},"deleteRows":{"!type":"fn(rowPosition: number, howMany: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteRows(Integer,Integer)","!doc":"Deletes a number of rows starting at the given row position."},"deleteSheet":{"!type":"fn(sheet: spreadsheet.Sheet)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#deleteSheet(Sheet)","!doc":"Deletes the specified sheet."},"duplicateActiveSheet":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#duplicateActiveSheet()","!doc":"Duplicates the active sheet and makes it the active sheet."},"getActiveCell":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getActiveCell()","!doc":"Returns the active cell in this sheet."},"getActiveRange":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getActiveRange()","!doc":"Returns the active range for the active sheet."},"getActiveSheet":{"!type":"fn() -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getActiveSheet()","!doc":"Gets the active sheet in a spreadsheet."},"getAs":{"!type":"fn(contentType: string) -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getAs(String)","!doc":"Return the data inside this object as a blob converted to the specified content type."},"getBlob":{"!type":"fn() -> +base.Blob","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getBlob()","!doc":"Return the data inside this object as a blob."},"getColumnWidth":{"!type":"fn(columnPosition: number) -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getColumnWidth(Integer)","!doc":"Gets the width in pixels of the given column."},"getDataRange":{"!type":"fn() -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getDataRange()","!doc":"Returns a Range corresponding to the dimensions in which data is present."},"getEditors":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getEditors()","!doc":"Gets the list of editors for this Spreadsheet."},"getFormUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFormUrl()","!doc":"Returns the url for the form attached to the spreadsheet, null if there is no form."},"getFrozenColumns":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFrozenColumns()","!doc":"Returns the number of frozen columns."},"getFrozenRows":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getFrozenRows()","!doc":"Returns the number of frozen rows."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getId()","!doc":"Gets a unique identifier for this spreadsheet."},"getLastColumn":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getLastColumn()","!doc":"Returns the position of the last column that has content."},"getLastRow":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getLastRow()","!doc":"Returns the position of the last row that has content."},"getName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getName()","!doc":"Gets the name of the document."},"getNumSheets":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getNumSheets()","!doc":"Returns the number of sheets in this spreadsheet."},"getOwner":{"!type":"fn() -> +base.User","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getOwner()","!doc":"Returns the owner of the document."},"getRange":{"!type":"fn(a1Notation: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRange(String)","!doc":"Returns the range as specified in A1 notation or R1C1 notation."},"getRangeByName":{"!type":"fn(name: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRangeByName(String)","!doc":"Returns a named range, or null if no range with the given name is found."},"getRowHeight":{"!type":"fn(rowPosition: number) -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getRowHeight(Integer)","!doc":"Gets the height in pixels of the given row."},"getSheetByName":{"!type":"fn(name: string) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetByName(String)","!doc":"Returns a sheet with the given name."},"getSheetId":{"!type":"fn() -> number","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetId()","!doc":"Returns the ID of the sheet represented by this object."},"getSheetName":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetName()","!doc":"Returns the sheet name."},"getSheetProtection":{"!type":"fn() -> +spreadsheet.PageProtection","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetProtection()","!doc":"Returns a PageProtection instance describing the permissions for the current sheet."},"getSheetValues":{"!type":"fn(startRow: number, startColumn: number, numRows: number, numColumns: number) -> [[object]]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheetValues(Integer,Integer,Integer,Integer)","!doc":"Returns the rectangular grid of values for this range starting at the given coordinates."},"getSheets":{"!type":"fn() -> [+spreadsheet.Sheet]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSheets()","!doc":"Gets all the sheets in this spreadsheet."},"getSpreadsheetLocale":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSpreadsheetLocale()","!doc":"Gets the spreadsheet locale."},"getSpreadsheetTimeZone":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getSpreadsheetTimeZone()","!doc":"Gets the time zone for the spreadsheet."},"getUrl":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getUrl()","!doc":"Returns the url for the given spreadsheet."},"getViewers":{"!type":"fn() -> [+base.User]","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#getViewers()","!doc":"Gets the list of viewers and commenters for this Spreadsheet."},"hideColumn":{"!type":"fn(column: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#hideColumn(Range)","!doc":"Hides the columns in the given range."},"hideRow":{"!type":"fn(row: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#hideRow(Range)","!doc":"Hides the rows in the given range."},"insertColumnAfter":{"!type":"fn(afterPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnAfter(Integer)","!doc":"Inserts a column after the given column position."},"insertColumnBefore":{"!type":"fn(beforePosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnBefore(Integer)","!doc":"Inserts a column before the given column position."},"insertColumnsAfter":{"!type":"fn(afterPosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnsAfter(Integer,Integer)","!doc":"Inserts a number of columns after the given column position."},"insertColumnsBefore":{"!type":"fn(beforePosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertColumnsBefore(Integer,Integer)","!doc":"Inserts a number of columns before the given column position."},"insertImage":{"!type":"fn(url: string, column: number, row: number, offsetX: number, offsetY: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertImage(String,Integer,Integer,Integer,Integer)","!doc":"Inserts an image in the document at a given row and column with a pixel offset."},"insertRowAfter":{"!type":"fn(afterPosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowAfter(Integer)","!doc":"Inserts a row after the given row position."},"insertRowBefore":{"!type":"fn(beforePosition: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowBefore(Integer)","!doc":"Inserts a row before the given row position."},"insertRowsAfter":{"!type":"fn(afterPosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowsAfter(Integer,Integer)","!doc":"Inserts a number of rows after the given row position."},"insertRowsBefore":{"!type":"fn(beforePosition: number, howMany: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertRowsBefore(Integer,Integer)","!doc":"Inserts a number of rows before the given row position."},"insertSheet":{"!type":"fn(sheetName: string, options: object) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#insertSheet(String,Object)","!doc":"Inserts a new sheet in the spreadsheet with the given name and uses optional advanced arguments."},"moveActiveSheet":{"!type":"fn(pos: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#moveActiveSheet(Integer)","!doc":"Moves the active sheet to the given position in the list of sheets."},"removeEditor":{"!type":"fn(user: base.User)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeEditor(User)","!doc":"Removes the given user from the list of editors for the Spreadsheet."},"removeMenu":{"!type":"fn(name: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeMenu(String)","!doc":"Removes a menu that was added by addMenu(name, subMenus)."},"removeNamedRange":{"!type":"fn(name: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeNamedRange(String)","!doc":"Deletes a named range with the given name."},"removeViewer":{"!type":"fn(user: base.User)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#removeViewer(User)","!doc":"Removes the given user from the list of viewers and commenters for the Spreadsheet."},"rename":{"!type":"fn(newName: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#rename(String)","!doc":"Renames the document."},"renameActiveSheet":{"!type":"fn(newName: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#renameActiveSheet(String)","!doc":"Renames the current active sheet to the given new name."},"setActiveRange":{"!type":"fn(range: spreadsheet.Range) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setActiveRange(Range)","!doc":"Sets the active range for the active sheet."},"setActiveSelection":{"!type":"fn(a1Notation: string) -> +spreadsheet.Range","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setActiveSelection(String)","!doc":"Sets the active selection, as specified in A1 notation or R1C1 notation."},"setActiveSheet":{"!type":"fn(sheet: spreadsheet.Sheet) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setActiveSheet(Sheet)","!doc":"Sets the given sheet to be the active sheet in the spreadsheet."},"setColumnWidth":{"!type":"fn(columnPosition: number, width: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setColumnWidth(Integer,Integer)","!doc":"Sets the width of the given column in pixels."},"setFrozenColumns":{"!type":"fn(columns: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFrozenColumns(Integer)","!doc":"Freezes the given number of columns."},"setFrozenRows":{"!type":"fn(rows: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setFrozenRows(Integer)","!doc":"Freezes the given number of rows."},"setNamedRange":{"!type":"fn(name: string, range: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setNamedRange(String,Range)","!doc":"Names a range."},"setRowHeight":{"!type":"fn(rowPosition: number, height: number) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setRowHeight(Integer,Integer)","!doc":"Sets the row height of the given row in pixels."},"setSheetProtection":{"!type":"fn(permissions: spreadsheet.PageProtection)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setSheetProtection(PageProtection)","!doc":"Sets the permissions for the current sheet."},"setSpreadsheetLocale":{"!type":"fn(locale: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setSpreadsheetLocale(String)","!doc":"Sets the spreadsheet locale."},"setSpreadsheetTimeZone":{"!type":"fn(timezone: string)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#setSpreadsheetTimeZone(String)","!doc":"Sets the time zone for the spreadsheet."},"show":{"!type":"fn(userInterface: object)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#show(Object)","!doc":"Displays a custom user interface component in a dialog centered in the user's browser's viewport."},"sort":{"!type":"fn(columnPosition: number, ascending: bool) -> +spreadsheet.Sheet","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#sort(Integer,Boolean)","!doc":"Sorts a sheet by column."},"toast":{"!type":"fn(msg: string, title: string, timeoutSeconds: number)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#toast(String,String,Number)","!doc":"Shows a popup window in the lower right corner of the spreadsheet with the given title and message, that stays visible for a certain length of time."},"unhideColumn":{"!type":"fn(column: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#unhideColumn(Range)","!doc":"Unhides the column in the given range."},"unhideRow":{"!type":"fn(row: spreadsheet.Range)","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#unhideRow(Range)","!doc":"Unhides the row in the given range."},"updateMenu":{"!type":"fn(name: string, subMenus: [object])","!url":"http://developers.google.com/apps-script/reference/spreadsheet/#updateMenu(String,Object)","!doc":"Updates a menu that was added by addMenu(name, subMenus)."}}},"DataValidationCriteria":{"!url":"http://developers.google.com/apps-script/reference/spreadsheet/data-validation-criteria","!doc":"DataValidationCriteria An enumeration representing the data-validation criteria that can be set on a range. // Change existing data-validation rules that require a date in 2013 to require a date in 2014. var oldDates = [new Date('1/1/2013'), new Date('12/31/2013')]; var newDates = [new Date('1/1/2014'), new Date('12/31/2014')]; var sheet = SpreadsheetApp.getActiveSheet(); var range = sheet.getRange(1, 1, sheet.getMaxRows(), sheet.getMaxColumns()); var rules = range.getDataValidations(); for (var i = 0; i < rules.length; i++) { for (var j = 0; j < rules[i].length; j++) { var rule = rules[i][j]; if (rule != null) { var criteria = rule.getCriteriaType(); var args = rule.getCriteriaValues(); if (criteria == SpreadsheetApp.DataValidationCriteria.DATE_BETWEEN && args[0].getTime() == oldDates[0].getTime() && args[1].getTime() == oldDates[1].getTime()) { // Create a builder from the existing rule, then change the dates. rules[i][j] = rule.copy().withCriteria(criteria, newDates).build(); } } } } range.setDataValidations(rules);","prototype":{"DATE_AFTER":{"!type":"string","!doc":"Requires a date that is after the given value."},"DATE_BEFORE":{"!type":"string","!doc":"Requires a date that is before the given value."},"DATE_BETWEEN":{"!type":"string","!doc":"Requires a date that is between the given values."},"DATE_EQUAL_TO":{"!type":"string","!doc":"Requires a date that is equal to the given value."},"DATE_IS_VALID_DATE":{"!type":"string","!doc":"Requires a date."},"DATE_NOT_BETWEEN":{"!type":"string","!doc":"Requires a date that is not between the given values."},"DATE_ON_OR_AFTER":{"!type":"string","!doc":"Require a date that is on or after the given value."},"DATE_ON_OR_BEFORE":{"!type":"string","!doc":"Requires a date that is on or before the given value."},"NUMBER_BETWEEN":{"!type":"string","!doc":"Requires a number that is between the given values."},"NUMBER_EQUAL_TO":{"!type":"string","!doc":"Requires a number that is equal to the given value."},"NUMBER_GREATER_THAN":{"!type":"string","!doc":"Require a number that is greater than the given value."},"NUMBER_GREATER_THAN_OR_EQUAL_TO":{"!type":"string","!doc":"Requires a number that is greater than or equal to the given value."},"NUMBER_LESS_THAN":{"!type":"string","!doc":"Requires a number that is less than the given value."},"NUMBER_LESS_THAN_OR_EQUAL_TO":{"!type":"string","!doc":"Requires a number that is less than or equal to the given value."},"NUMBER_NOT_BETWEEN":{"!type":"string","!doc":"Requires a number that is not between the given values."},"NUMBER_NOT_EQUAL_TO":{"!type":"string","!doc":"Requires a number that is not equal to the given value."},"TEXT_CONTAINS":{"!type":"string","!doc":"Requires that the input contains the given value."},"TEXT_DOES_NOT_CONTAIN":{"!type":"string","!doc":"Requires that the input does not contain the given value."},"TEXT_EQUAL_TO":{"!type":"string","!doc":"Requires that the input is equal to the given value."},"TEXT_IS_VALID_EMAIL":{"!type":"string","!doc":"Requires that the input is in the form of an email address."},"TEXT_IS_VALID_URL":{"!type":"string","!doc":"Requires that the input is in the form of a URL."},"VALUE_IN_LIST":{"!type":"string","!doc":"Requires that the input is equal to one of the given values."},"VALUE_IN_RANGE":{"!type":"string","!doc":"Requires that the input is equal to a value in the given range."},"CUSTOM_FORMULA":{"!type":"string","!doc":"Requires that the input makes the given formula evaluate to true."}}}},"ui":{"AbsolutePanel":{"!url":"http://developers.google.com/apps-script/reference/ui/absolute-panel","!doc":"AbsolutePanel An absolute panel positions all of its children absolutely, allowing them to overlap. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var button = app.createButton(\"a button\"); var panel = app.createAbsolutePanel(); // add a widget at position (10, 20) panel.add(button, 10, 20); app.add(panel); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the AbsolutePanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget, left: number, top: number) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget,Integer,Integer)","!doc":"Add a widget to the AbsolutePanel."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this AbsolutePanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this AbsolutePanel."},"clear":{"!type":"fn() -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the AbsolutePanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this AbsolutePanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"remove":{"!type":"fn(widget: ui.Widget) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#remove(Widget)","!doc":"Remove the given widget from the AbsolutePanel."},"setHeight":{"!type":"fn(height: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this AbsolutePanel."},"setId":{"!type":"fn(id: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this AbsolutePanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this AbsolutePanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this AbsolutePanel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this AbsolutePanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this AbsolutePanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this AbsolutePanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this AbsolutePanel."},"setTag":{"!type":"fn(tag: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this AbsolutePanel."},"setTitle":{"!type":"fn(title: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this AbsolutePanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this AbsolutePanel is visible."},"setWidgetPosition":{"!type":"fn(widget: ui.Widget, left: number, top: number) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidgetPosition(Widget,Integer,Integer)","!doc":"Set the position of a widget that is already a child of the AbsolutePanel."},"setWidth":{"!type":"fn(width: string) -> +ui.AbsolutePanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this AbsolutePanel."}}},"Anchor":{"!url":"http://developers.google.com/apps-script/reference/ui/anchor","!doc":"Anchor A widget that represents a simple <a> element. That is, a hyperlink to a different page. By design, these hyperlinks always open in a new page. Links that reload the current page are not allowed. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); // Creates a link to your favorite search engine. var anchor = app.createAnchor(\"a link\", \"http://www.google.com\"); app.add(anchor); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the Anchor documentation here.","prototype":{"addBlurHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addBlurHandler(Handler)","!doc":"Add a handler for blur events (losing keyboard focus)."},"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addFocusHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addFocusHandler(Handler)","!doc":"Add a handler for focus events (gaining keyboard focus)."},"addKeyDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyDownHandler(Handler)","!doc":"Add a handler for key down events."},"addKeyPressHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyPressHandler(Handler)","!doc":"Add a handler for key press events."},"addKeyUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyUpHandler(Handler)","!doc":"Add a handler for key up events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this Anchor."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this Anchor."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this Anchor."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setFocus":{"!type":"fn(focus: bool) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setFocus(Boolean)","!doc":"Explicitly focus/unfocus this Anchor."},"setHTML":{"!type":"fn(html: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setHTML(String)","!doc":"Sets the HTML content of this Anchor."},"setHeight":{"!type":"fn(height: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this Anchor."},"setHorizontalAlignment":{"!type":"fn(horizontalAlignment: ui.HorizontalAlignment) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setHorizontalAlignment(HorizontalAlignment)","!doc":"Set the horizontal text alignment of the display text of this Anchor."},"setHref":{"!type":"fn(href: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setHref(String)","!doc":"Set the URL that this Anchor links to."},"setId":{"!type":"fn(id: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this Anchor."},"setName":{"!type":"fn(name: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setName(String)","!doc":"Set the name of this link, rather than the target."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this Anchor in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this Anchor."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this Anchor's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this Anchor's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this Anchor."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this Anchor."},"setTabIndex":{"!type":"fn(index: number) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setTabIndex(Integer)","!doc":"Sets the Anchor's position in the tab index."},"setTag":{"!type":"fn(tag: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this Anchor."},"setTarget":{"!type":"fn(target: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setTarget(String)","!doc":"Set the target of this link."},"setText":{"!type":"fn(text: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Set the display text of this Anchor."},"setTitle":{"!type":"fn(title: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this Anchor."},"setVisible":{"!type":"fn(visible: bool) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this Anchor is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this Anchor."},"setWordWrap":{"!type":"fn(wordWrap: bool) -> +ui.Anchor","!url":"http://developers.google.com/apps-script/reference/ui/#setWordWrap(Boolean)","!doc":"Set whether this Anchor wraps its text."}}},"Button":{"!url":"http://developers.google.com/apps-script/reference/ui/button","!doc":"Button A standard push-button widget. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); // create a button and give it a click handler var button = app.createButton(\"click me!\").setId(\"button\"); button.addClickHandler(app.createServerHandler(\"handlerFunction\")); app.add(button); return app; } function handlerFunction(eventInfo) { var app = UiApp.getActiveApplication(); app.getElementById(\"button\").setText(\"I was clicked!\"); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the Button documentation here.","prototype":{"addBlurHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addBlurHandler(Handler)","!doc":"Add a handler for blur events (losing keyboard focus)."},"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addFocusHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addFocusHandler(Handler)","!doc":"Add a handler for focus events (gaining keyboard focus)."},"addKeyDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyDownHandler(Handler)","!doc":"Add a handler for key down events."},"addKeyPressHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyPressHandler(Handler)","!doc":"Add a handler for key press events."},"addKeyUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyUpHandler(Handler)","!doc":"Add a handler for key up events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this Button."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this Button."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this Button."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setEnabled":{"!type":"fn(enabled: bool) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setEnabled(Boolean)","!doc":"Sets whether the Button is enabled."},"setFocus":{"!type":"fn(focus: bool) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setFocus(Boolean)","!doc":"Explicitly focus/unfocus this Button."},"setHTML":{"!type":"fn(html: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setHTML(String)","!doc":"Sets the HTML content of this Button."},"setHeight":{"!type":"fn(height: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this Button."},"setId":{"!type":"fn(id: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this Button."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this Button in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this Button."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this Button's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this Button's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this Button."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this Button."},"setTabIndex":{"!type":"fn(index: number) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setTabIndex(Integer)","!doc":"Sets the Button's position in the tab index."},"setTag":{"!type":"fn(tag: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this Button."},"setText":{"!type":"fn(text: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Set the display text of this Button."},"setTitle":{"!type":"fn(title: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this Button."},"setVisible":{"!type":"fn(visible: bool) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this Button is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.Button","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this Button."}}},"CaptionPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/caption-panel","!doc":"CaptionPanel A panel that wraps its contents in a border with a caption that appears in the upper left corner of the border. This is an implementation of the fieldset HTML element. Note that this panel can contain at most one direct child widget. To add more children, make the child of this panel a different panel that can contain more than one child. Note also that the placement of the caption in a caption panel will vary slightly from browser to browser, so this widget is not a good choice when precise cross-browser layout is needed. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var panel = app.createCaptionPanel(\"my caption!\"); panel.add(app.createButton(\"a button inside...\")); app.add(panel); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the CaptionPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget)","!doc":"Add a widget to the CaptionPanel."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this CaptionPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this CaptionPanel."},"clear":{"!type":"fn() -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the CaptionPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this CaptionPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setHeight":{"!type":"fn(height: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this CaptionPanel."},"setId":{"!type":"fn(id: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this CaptionPanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this CaptionPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this CaptionPanel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this CaptionPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this CaptionPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this CaptionPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this CaptionPanel."},"setTag":{"!type":"fn(tag: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this CaptionPanel."},"setText":{"!type":"fn(text: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Set the display text of this CaptionPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this CaptionPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this CaptionPanel is visible."},"setWidget":{"!type":"fn(widget: ui.Widget) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidget(Widget)","!doc":"Sets the widget inside this CaptionPanel, removing anything previously there."},"setWidth":{"!type":"fn(width: string) -> +ui.CaptionPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this CaptionPanel."}}},"CheckBox":{"!url":"http://developers.google.com/apps-script/reference/ui/check-box","!doc":"CheckBox A standard check box widget. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var handler = app.createServerHandler(\"change\"); var check = app.createCheckBox(\"click me\").addValueChangeHandler(handler); app.add(check); return app; } function change() { var app = UiApp.getActiveApplication(); app.add(app.createLabel(\"The value changed!\")); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the CheckBox documentation here.","prototype":{"addBlurHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addBlurHandler(Handler)","!doc":"Add a handler for blur events (losing keyboard focus)."},"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addFocusHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addFocusHandler(Handler)","!doc":"Add a handler for focus events (gaining keyboard focus)."},"addKeyDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyDownHandler(Handler)","!doc":"Add a handler for key down events."},"addKeyPressHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyPressHandler(Handler)","!doc":"Add a handler for key press events."},"addKeyUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyUpHandler(Handler)","!doc":"Add a handler for key up events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this CheckBox."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this CheckBox."},"addValueChangeHandler":{"!type":"fn(handler: ui.Handler) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#addValueChangeHandler(Handler)","!doc":"Add a handler for value change events."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this CheckBox."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setEnabled":{"!type":"fn(enabled: bool) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setEnabled(Boolean)","!doc":"Sets whether the CheckBox is enabled."},"setFocus":{"!type":"fn(focus: bool) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setFocus(Boolean)","!doc":"Explicitly focus/unfocus this CheckBox."},"setFormValue":{"!type":"fn(formValue: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setFormValue(String)","!doc":"Set the value property on the input element that backs this CheckBox."},"setHTML":{"!type":"fn(html: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setHTML(String)","!doc":"Sets the HTML content of this CheckBox."},"setHeight":{"!type":"fn(height: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this CheckBox."},"setId":{"!type":"fn(id: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this CheckBox."},"setName":{"!type":"fn(name: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setName(String)","!doc":"Sets the name of the CheckBox, which is how it will be referred to when used in a FormPanel or as a callback element on an event handler."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this CheckBox in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this CheckBox."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this CheckBox's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this CheckBox's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this CheckBox."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this CheckBox."},"setTabIndex":{"!type":"fn(index: number) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTabIndex(Integer)","!doc":"Sets the CheckBox's position in the tab index."},"setTag":{"!type":"fn(tag: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this CheckBox."},"setText":{"!type":"fn(text: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Set the display text of this CheckBox."},"setTitle":{"!type":"fn(title: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this CheckBox."},"setValue":{"!type":"fn(value: bool, fireEvents: bool) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setValue(Boolean,Boolean)","!doc":"Sets whether the CheckBox should be checked and optionally fires an event if the value changes as a result of this call."},"setVisible":{"!type":"fn(visible: bool) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this CheckBox is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.CheckBox","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this CheckBox."}}},"ClientHandler":{"!url":"http://developers.google.com/apps-script/reference/ui/client-handler","!doc":"ClientHandler An event handler that runs in the user's browser without needing a call back to the server. These will, in general, run much faster than ServerHandlers but they are also more limited in what they can do. Any method that accepts a \"Handler\" parameter can accept a ClientHandler. If you set validators on a ClientHandler, they will be checked before the handler performs its actions. The actions will only be performed if the validators succeed. If you have multiple ClientHandlers for the same event on the same widget, they will perform their actions in the order that they were added. An example of using client handlers: function doGet() { var app = UiApp.createApplication(); var button = app.createButton(\"Say Hello\"); // Create a label with the \"Hello World!\" text and hide it for now var label = app.createLabel(\"Hello World!\").setVisible(false); // Create a new handler that does not require the server. // We give the handler two actions to perform on different targets. // The first action disables the widget that invokes the handler // and the second displays the label. var handler = app.createClientHandler() .forEventSource().setEnabled(false) .forTargets(label).setVisible(true); // Add our new handler to be invoked when the button is clicked button.addClickHandler(handler); app.add(button); app.add(label); return app; }","prototype":{"forEventSource":{"!type":"fn() -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#forEventSource()","!doc":"Sets the target of this handler for subsequent directives to be whatever widget triggered the event that this handler was called for."},"forTargets":{"!type":"fn(widgets: Object...) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#forTargets(Object...)","!doc":"Sets the target of this handler for subsequent directives to be the given widgets."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this ClientHandler."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setEnabled":{"!type":"fn(enabled: bool) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setEnabled(Boolean)","!doc":"A directive to set the enabled/disabled state of the widgets this handler is targeted to."},"setHTML":{"!type":"fn(html: string) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setHTML(String)","!doc":"A directive to set the html text of the widgets this handler is targeted to."},"setId":{"!type":"fn(id: string) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this ClientHandler."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"A directive to set a style attribute on the widgets the handler is targeted to."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"A directive to set multiple style attributes on the widgets the handler is targeted to."},"setTag":{"!type":"fn(tag: string) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this ClientHandler."},"setText":{"!type":"fn(text: string) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"A directive to set the text of the widgets this handler is targeted to."},"setValue":{"!type":"fn(value: bool) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setValue(Boolean)","!doc":"A directive to set the boolean value of the widgets this handler is targeted to."},"setVisible":{"!type":"fn(visible: bool) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"A directive to set the visibility of the widgets this handler is targeted to."},"validateEmail":{"!type":"fn(widget: ui.Widget) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateEmail(Widget)","!doc":"Sets this handler to fire only if the given widget's value is a valid email address."},"validateInteger":{"!type":"fn(widget: ui.Widget) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateInteger(Widget)","!doc":"Sets this handler to fire only if the given widget's value can be interpreted as an integer."},"validateLength":{"!type":"fn(widget: ui.Widget, min: number, max: number) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateLength(Widget,Integer,Integer)","!doc":"Sets this handler to fire only if the given widget's value is a string whose length is between min and max."},"validateMatches":{"!type":"fn(widget: ui.Widget, pattern: string, flags: string) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateMatches(Widget,String,String)","!doc":"Sets this handler to fire only if the given widget's value matches this regular expression."},"validateNotEmail":{"!type":"fn(widget: ui.Widget) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotEmail(Widget)","!doc":"Sets this handler to fire only if the given widget's value is not a valid email address."},"validateNotInteger":{"!type":"fn(widget: ui.Widget) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotInteger(Widget)","!doc":"Sets this handler to fire only if the given widget's value cannot be interpreted as an integer."},"validateNotLength":{"!type":"fn(widget: ui.Widget, min: number, max: number) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotLength(Widget,Integer,Integer)","!doc":"Sets this handler to fire only if the given widget's value is a string whose length is less than min or greater than max."},"validateNotMatches":{"!type":"fn(widget: ui.Widget, pattern: string, flags: string) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotMatches(Widget,String,String)","!doc":"Sets this handler to fire only if the given widget's value does not match this regular expression."},"validateNotNumber":{"!type":"fn(widget: ui.Widget) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotNumber(Widget)","!doc":"Sets this handler to fire only if the given widget's value cannot be interpreted as an number."},"validateNotOptions":{"!type":"fn(widget: ui.Widget, options: [string]) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotOptions(Widget,String)","!doc":"Sets this handler to fire only if the given widget's value is not one of the strings given in the options parameter."},"validateNotRange":{"!type":"fn(widget: ui.Widget, min: number, max: number) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotRange(Widget,Number,Number)","!doc":"Sets this handler to fire only if the given widget's value cannot be interpreted as a number that is between min and max."},"validateNotSum":{"!type":"fn(widgets: [ui.Widget], sum: number) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNotSum(Widget,Integer)","!doc":"Sets this handler to fire only if the given widgets have values that are not numbers, or that do not sum up to the given value."},"validateNumber":{"!type":"fn(widget: ui.Widget) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateNumber(Widget)","!doc":"Sets this handler to fire only if the given widget's value can be interpreted as a number."},"validateOptions":{"!type":"fn(widget: ui.Widget, options: [string]) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateOptions(Widget,String)","!doc":"Sets this handler to fire only if the given widget's value is one of the strings given in the options parameter."},"validateRange":{"!type":"fn(widget: ui.Widget, min: number, max: number) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateRange(Widget,Number,Number)","!doc":"Sets this handler to fire only if the given widget's value can be interpreted as a number and is between min and max."},"validateSum":{"!type":"fn(widgets: [ui.Widget], sum: number) -> +ui.ClientHandler","!url":"http://developers.google.com/apps-script/reference/ui/#validateSum(Widget,Integer)","!doc":"Sets this handler to fire only if the given widgets have values that are numbers and sum up to the given value."}}},"DateBox":{"!url":"http://developers.google.com/apps-script/reference/ui/date-box","!doc":"DateBox A text box that shows a DatePicker when the user focuses on it. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var handler = app.createServerHandler(\"change\"); var dateBox = app.createDateBox().addValueChangeHandler(handler).setId(\"datebox\"); app.add(dateBox); return app; } function change(eventInfo) { var app = UiApp.getActiveApplication(); app.add(app.createLabel(\"The value of the date box changed to \" + eventInfo.parameter.datebox)); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the DateBox documentation here.","prototype":{"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this DateBox."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this DateBox."},"addValueChangeHandler":{"!type":"fn(handler: ui.Handler) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#addValueChangeHandler(Handler)","!doc":"Add a handler for value change events."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this DateBox."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"hideDatePicker":{"!type":"fn() -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#hideDatePicker()","!doc":"Hide the date picker."},"setEnabled":{"!type":"fn(enabled: bool) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setEnabled(Boolean)","!doc":"Sets whether the DateBox is enabled."},"setFireEventsForInvalid":{"!type":"fn(fireEvents: bool) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setFireEventsForInvalid(Boolean)","!doc":"Sets whether value changed events are fired for invalid or empty input in the box."},"setFocus":{"!type":"fn(focus: bool) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setFocus(Boolean)","!doc":"Explicitly focus/unfocus this DateBox."},"setFormat":{"!type":"fn(dateTimeFormat: ui.DateTimeFormat) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setFormat(DateTimeFormat)","!doc":"Sets the format used to control formatting and parsing of dates in this DateBox."},"setHeight":{"!type":"fn(height: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this DateBox."},"setId":{"!type":"fn(id: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this DateBox."},"setName":{"!type":"fn(name: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setName(String)","!doc":"Sets the name of the DateBox, which is how it will be referred to when used in a FormPanel or as a callback element on an event handler."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this DateBox in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this DateBox."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this DateBox's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this DateBox's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this DateBox."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this DateBox."},"setTabIndex":{"!type":"fn(index: number) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTabIndex(Integer)","!doc":"Sets the DateBox's position in the tab index."},"setTag":{"!type":"fn(tag: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this DateBox."},"setTitle":{"!type":"fn(title: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this DateBox."},"setValue":{"!type":"fn(date: date) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setValue(Date)","!doc":"Sets the date shown by this DateBox."},"setVisible":{"!type":"fn(visible: bool) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this DateBox is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this DateBox."},"showDatePicker":{"!type":"fn() -> +ui.DateBox","!url":"http://developers.google.com/apps-script/reference/ui/#showDatePicker()","!doc":"Parses the current DateBox's value and shows that date."}}},"DatePicker":{"!url":"http://developers.google.com/apps-script/reference/ui/date-picker","!doc":"DatePicker A date picker widget. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var handler = app.createServerHandler(\"change\"); var picker = app.createDatePicker().addValueChangeHandler(handler).setId(\"picker\"); app.add(picker); return app; } function change(eventInfo) { var app = UiApp.getActiveApplication(); app.add(app.createLabel(\"The value of the date picker changed to \" + eventInfo.parameter.picker)); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the DatePicker documentation here.","prototype":{"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this DatePicker."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this DatePicker."},"addValueChangeHandler":{"!type":"fn(handler: ui.Handler) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#addValueChangeHandler(Handler)","!doc":"Add a handler for value change events."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this DatePicker."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setCurrentMonth":{"!type":"fn(date: date) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setCurrentMonth(Date)","!doc":"Sets the DatePicker to show the given month without selecting a particular date."},"setHeight":{"!type":"fn(height: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this DatePicker."},"setId":{"!type":"fn(id: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this DatePicker."},"setName":{"!type":"fn(name: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setName(String)","!doc":"Sets the name of the DatePicker, which is how it will be referred to when used in a FormPanel or as a callback element on an event handler."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this DatePicker in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this DatePicker."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this DatePicker's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this DatePicker's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this DatePicker."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this DatePicker."},"setTag":{"!type":"fn(tag: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this DatePicker."},"setTitle":{"!type":"fn(title: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this DatePicker."},"setValue":{"!type":"fn(date: date) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setValue(Date)","!doc":"Sets the date shown by this DatePicker."},"setVisible":{"!type":"fn(visible: bool) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this DatePicker is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.DatePicker","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this DatePicker."}}},"DecoratedStackPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/decorated-stack-panel","!doc":"DecoratedStackPanel A StackPanel that wraps each item in a 2x3 grid (six box), which allows users to add rounded corners. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the DecoratedStackPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget, text: string, asHtml: bool) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget,String,Boolean)","!doc":"Adds a widget to the stack with the given header text."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this DecoratedStackPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this DecoratedStackPanel."},"clear":{"!type":"fn() -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the DecoratedStackPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this DecoratedStackPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"remove":{"!type":"fn(widget: ui.Widget) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#remove(Widget)","!doc":"Remove the given widget from the DecoratedStackPanel."},"setHeight":{"!type":"fn(height: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this DecoratedStackPanel."},"setId":{"!type":"fn(id: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this DecoratedStackPanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this DecoratedStackPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this DecoratedStackPanel."},"setStackText":{"!type":"fn(index: number, text: string, asHtml: bool) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStackText(Integer,String,Boolean)","!doc":"Sets the text associated with a child by its index."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this DecoratedStackPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this DecoratedStackPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this DecoratedStackPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this DecoratedStackPanel."},"setTag":{"!type":"fn(tag: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this DecoratedStackPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this DecoratedStackPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this DecoratedStackPanel is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.DecoratedStackPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this DecoratedStackPanel."}}},"DecoratedTabBar":{"!url":"http://developers.google.com/apps-script/reference/ui/decorated-tab-bar","!doc":"DecoratedTabBar A TabBar that wraps each tab in a 2x3 grid (six box), which allows users to add rounded corners. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the DecoratedTabBar documentation here.","prototype":{"addSelectionHandler":{"!type":"fn(handler: ui.Handler) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#addSelectionHandler(Handler)","!doc":"Add a handler for selection events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this DecoratedTabBar."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this DecoratedTabBar."},"addTab":{"!type":"fn(widget: ui.Widget) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#addTab(Widget)","!doc":"Add a tab with the given widget as its title."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this DecoratedTabBar."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"selectTab":{"!type":"fn(index: number) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#selectTab(Integer)","!doc":"Select a tab by index."},"setHeight":{"!type":"fn(height: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this DecoratedTabBar."},"setId":{"!type":"fn(id: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this DecoratedTabBar."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this DecoratedTabBar in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this DecoratedTabBar."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this DecoratedTabBar's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this DecoratedTabBar's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this DecoratedTabBar."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this DecoratedTabBar."},"setTabEnabled":{"!type":"fn(index: number, enabled: bool) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setTabEnabled(Integer,Boolean)","!doc":"Set whether the given tab is enabled."},"setTabText":{"!type":"fn(index: number, text: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setTabText(Integer,String)","!doc":"Set the header text of a given tab."},"setTag":{"!type":"fn(tag: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this DecoratedTabBar."},"setTitle":{"!type":"fn(title: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this DecoratedTabBar."},"setVisible":{"!type":"fn(visible: bool) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this DecoratedTabBar is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.DecoratedTabBar","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this DecoratedTabBar."}}},"DecoratedTabPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/decorated-tab-panel","!doc":"DecoratedTabPanel A TabPanel that uses a DecoratedTabBar with rounded corners. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the DecoratedTabPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget, tabWidget: ui.Widget) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget,Widget)","!doc":"Add a widget to this DecoratedTabPanel with the given widget as its tab header."},"addSelectionHandler":{"!type":"fn(handler: ui.Handler) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addSelectionHandler(Handler)","!doc":"Add a handler for selection events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this DecoratedTabPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this DecoratedTabPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this DecoratedTabPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"selectTab":{"!type":"fn(index: number) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#selectTab(Integer)","!doc":"Select a tab by index."},"setAnimationEnabled":{"!type":"fn(animationEnabled: bool) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setAnimationEnabled(Boolean)","!doc":"Sets whether changing tabs DecoratedTabPanel is animated."},"setHeight":{"!type":"fn(height: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this DecoratedTabPanel."},"setId":{"!type":"fn(id: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this DecoratedTabPanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this DecoratedTabPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this DecoratedTabPanel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this DecoratedTabPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this DecoratedTabPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this DecoratedTabPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this DecoratedTabPanel."},"setTag":{"!type":"fn(tag: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this DecoratedTabPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this DecoratedTabPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this DecoratedTabPanel is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.DecoratedTabPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this DecoratedTabPanel."}}},"DecoratorPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/decorator-panel","!doc":"DecoratorPanel A SimplePanel that wraps its contents in stylized boxes, which can be used to add rounded corners to a Widget. Note that this panel can contain at most one direct child widget. To add more children, make the child of this panel a different panel that can contain more than one child. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the DecoratorPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget)","!doc":"Add a widget to the DecoratorPanel."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this DecoratorPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this DecoratorPanel."},"clear":{"!type":"fn() -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the DecoratorPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this DecoratorPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setHeight":{"!type":"fn(height: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this DecoratorPanel."},"setId":{"!type":"fn(id: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this DecoratorPanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this DecoratorPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this DecoratorPanel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this DecoratorPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this DecoratorPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this DecoratorPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this DecoratorPanel."},"setTag":{"!type":"fn(tag: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this DecoratorPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this DecoratorPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this DecoratorPanel is visible."},"setWidget":{"!type":"fn(widget: ui.Widget) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidget(Widget)","!doc":"Sets the widget inside this DecoratorPanel, removing anything previously there."},"setWidth":{"!type":"fn(width: string) -> +ui.DecoratorPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this DecoratorPanel."}}},"DialogBox":{"!url":"http://developers.google.com/apps-script/reference/ui/dialog-box","!doc":"DialogBox A form of popup that has a caption area at the top and can be dragged by the user. Unlike a PopupPanel, calls to setWidth(width) and setHeight(height) will set the width and height of the dialog box itself, even if a widget has not been added as yet. In general it's not recommended to add this panel as a child of another widget or of the app as that will make it behave like any other inline panel and not act as a popup. Instead, create the popup and then use its show() and hide() methods to show and hide it. See the example below. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the DialogBox documentation here. Here is an example showing how to use the dialog box widget: function doGet() { var app = UiApp.createApplication(); // Create a dialog box. var dialog = app.createDialogBox(); // Set the position and dimensions. dialog.setPopupPosition(100, 100).setSize(500, 500); // Show the dialog. Note that it does not have to be \"added\" to the UiInstance. dialog.show(); return app; }","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget)","!doc":"Add a widget to the DialogBox."},"addCloseHandler":{"!type":"fn(handler: ui.Handler) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#addCloseHandler(Handler)","!doc":"Add a handler for close events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this DialogBox."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this DialogBox."},"clear":{"!type":"fn() -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the DialogBox."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this DialogBox."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"hide":{"!type":"fn() -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#hide()","!doc":"Hides the popup."},"setAnimationEnabled":{"!type":"fn(animationEnabled: bool) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setAnimationEnabled(Boolean)","!doc":"Sets whether opening and closing the DialogBox is animated."},"setAutoHideEnabled":{"!type":"fn(enabled: bool) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setAutoHideEnabled(Boolean)","!doc":"Enable or disable the autoHide feature."},"setGlassEnabled":{"!type":"fn(enabled: bool) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setGlassEnabled(Boolean)","!doc":"Enable or disable a \"glass\" pane."},"setHTML":{"!type":"fn(html: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setHTML(String)","!doc":"Sets the HTML content of this DialogBox."},"setHeight":{"!type":"fn(height: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this DialogBox."},"setId":{"!type":"fn(id: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this DialogBox."},"setModal":{"!type":"fn(modal: bool) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setModal(Boolean)","!doc":"Sets whether this DialogBox is in \"modal\" mode."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this DialogBox in pixels."},"setPopupPosition":{"!type":"fn(left: number, top: number) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setPopupPosition(Integer,Integer)","!doc":"Sets the popup's position relative to the browser's client area."},"setPreviewingAllNativeEvents":{"!type":"fn(previewing: bool) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setPreviewingAllNativeEvents(Boolean)","!doc":"When enabled, the DialogBox will preview all native events, even if another popup was opened after this one."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this DialogBox."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this DialogBox's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this DialogBox's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this DialogBox."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this DialogBox."},"setTag":{"!type":"fn(tag: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this DialogBox."},"setText":{"!type":"fn(text: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Sets the text inside the caption."},"setTitle":{"!type":"fn(title: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this DialogBox."},"setVisible":{"!type":"fn(visible: bool) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this DialogBox is visible."},"setWidget":{"!type":"fn(widget: ui.Widget) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setWidget(Widget)","!doc":"Sets the widget inside this DialogBox, removing anything previously there."},"setWidth":{"!type":"fn(width: string) -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this DialogBox."},"show":{"!type":"fn() -> +ui.DialogBox","!url":"http://developers.google.com/apps-script/reference/ui/#show()","!doc":"Shows the popup."}}},"DocsListDialog":{"!url":"http://developers.google.com/apps-script/reference/ui/docs-list-dialog","!doc":"DocsListDialog A \"file-open\" dialog for Google Drive. Unlike most UiApp objects, DocsListDialog should not be added to the UiInstance. The example below shows how to display a DocsListDialog in the new version of Google Sheets. Note that HTML service offers a similar but superior feature, Google Picker. In almost all cases, using Google Picker is preferable. function onOpen() { SpreadsheetApp.getUi() // Or DocumentApp or FormApp. .createMenu('Custom Menu') .addItem('Select file', 'showDialog') .addToUi(); } function showDialog() { var app = UiApp.createApplication() .setWidth(570) .setHeight(352); var serverHandler = app.createServerHandler('pickerHandler'); app.createDocsListDialog() .addCloseHandler(serverHandler) .addSelectionHandler(serverHandler) .showDocsPicker(); SpreadsheetApp.getUi() // Or DocumentApp or FormApp. .showModalDialog(app,' '); } function pickerHandler(e) { var action = e.parameter.eventType; var app = UiApp.getActiveApplication(); if (action == 'selection') { var doc = e.parameter.items[0]; var id = doc.id; var name = doc.name; var url = doc.url; app.add(app.createLabel('You picked ')); app.add(app.createAnchor(name, url)); app.add(app.createLabel('(ID: ' + id + ').')); } else if (action == 'close') { app.add(app.createLabel('You clicked \"Cancel\".')); } return app; }","prototype":{"addCloseHandler":{"!type":"fn(handler: ui.Handler) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#addCloseHandler(Handler)","!doc":"Add a handler for close events."},"addSelectionHandler":{"!type":"fn(handler: ui.Handler) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#addSelectionHandler(Handler)","!doc":"Add a handler for selection events."},"addView":{"!type":"fn(fileType: ui.FileType) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#addView(FileType)","!doc":"Add a type of file that this DocsListDialog will show."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setDialogTitle":{"!type":"fn(title: string) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#setDialogTitle(String)","!doc":"Set the title of this DocsListDialog."},"setHeight":{"!type":"fn(height: number) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(Integer)","!doc":"Set the height of this DocsListDialog."},"setInitialView":{"!type":"fn(fileType: ui.FileType) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#setInitialView(FileType)","!doc":"Set the initial type of file that this DocsListDialog will show."},"setMultiSelectEnabled":{"!type":"fn(multiSelectEnabled: bool) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#setMultiSelectEnabled(Boolean)","!doc":"Set whether multiple items can be selected."},"setWidth":{"!type":"fn(width: number) -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(Integer)","!doc":"Set the width of this DocsListDialog."},"showDocsPicker":{"!type":"fn() -> +ui.DocsListDialog","!url":"http://developers.google.com/apps-script/reference/ui/#showDocsPicker()","!doc":"Show this DocsListDialog."}}},"FileUpload":{"!url":"http://developers.google.com/apps-script/reference/ui/file-upload","!doc":"FileUpload A widget that wraps the HTML <input type='file'> element. This widget must be used within a FormPanel. The result of a FileUpload is a \"Blob\" which can we used in various other functions. Below is an example of how to use FileUpload. function doGet(e) { var app = UiApp.createApplication().setTitle(\"Upload CSV to Sheet\"); var formContent = app.createVerticalPanel(); formContent.add(app.createFileUpload().setName('thefile')); formContent.add(app.createSubmitButton()); var form = app.createFormPanel(); form.add(formContent); app.add(form); return app; } function doPost(e) { // data returned is a blob for FileUpload widget var fileBlob = e.parameter.thefile; var doc = DocsList.createFile(fileBlob); } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the FileUpload documentation here.","prototype":{"addChangeHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#addChangeHandler(Handler)","!doc":"Add a handler for change events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this FileUpload."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this FileUpload."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this FileUpload."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setEnabled":{"!type":"fn(enabled: bool) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setEnabled(Boolean)","!doc":"Sets whether the FileUpload is enabled."},"setHeight":{"!type":"fn(height: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this FileUpload."},"setId":{"!type":"fn(id: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this FileUpload."},"setName":{"!type":"fn(name: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setName(String)","!doc":"Sets the name of the FileUpload, which is how it will be referred to when used in a FormPanel or as a callback element on an event handler."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this FileUpload in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this FileUpload."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this FileUpload's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this FileUpload's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this FileUpload."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this FileUpload."},"setTag":{"!type":"fn(tag: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this FileUpload."},"setTitle":{"!type":"fn(title: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this FileUpload."},"setVisible":{"!type":"fn(visible: bool) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this FileUpload is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.FileUpload","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this FileUpload."}}},"FlexTable":{"!url":"http://developers.google.com/apps-script/reference/ui/flex-table","!doc":"FlexTable A flexible table that creates cells on demand. It can be jagged (that is, each row can contain a different number of cells) and individual cells can be set to span multiple rows or columns. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); app.add(app.createFlexTable() .insertRow(0).insertRow(0).insertRow(0) .insertCell(0, 0) .insertCell(0, 1) .insertCell(0, 2) .insertCell(1, 0) .insertCell(1, 1) .insertCell(2, 0) .setBorderWidth(5).setCellPadding(10).setCellSpacing(10)); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the FlexTable documentation here.","prototype":{"addCell":{"!type":"fn(row: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#addCell(Integer)","!doc":"Appends a cell to the specified row."},"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this FlexTable."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this FlexTable."},"clear":{"!type":"fn() -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the FlexTable."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this FlexTable."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"insertCell":{"!type":"fn(beforeRow: number, beforeColumn: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#insertCell(Integer,Integer)","!doc":"Inserts a cell into the FlexTable."},"insertRow":{"!type":"fn(beforeRow: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#insertRow(Integer)","!doc":"Inserts a row into the FlexTable before the given row."},"removeCell":{"!type":"fn(row: number, column: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#removeCell(Integer,Integer)","!doc":"Removes the specified cell from the FlexTable."},"removeCells":{"!type":"fn(row: number, column: number, num: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#removeCells(Integer,Integer,Integer)","!doc":"Removes a number of cells from one row in the FlexTable."},"removeRow":{"!type":"fn(row: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#removeRow(Integer)","!doc":"Removes the specified row from the FlexTable."},"setBorderWidth":{"!type":"fn(width: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setBorderWidth(Integer)","!doc":"Sets the border width."},"setCellPadding":{"!type":"fn(padding: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setCellPadding(Integer)","!doc":"Sets the padding within cells."},"setCellSpacing":{"!type":"fn(spacing: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setCellSpacing(Integer)","!doc":"Sets the spacing between cells."},"setColumnStyleAttribute":{"!type":"fn(column: number, attribute: string, value: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setColumnStyleAttribute(Integer,String,String)","!doc":"Sets a CSS style on a column of this FlexTable."},"setColumnStyleAttributes":{"!type":"fn(column: number, attributes: object) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setColumnStyleAttributes(Integer,Object)","!doc":"Sets a CSS style on a column of this FlexTable."},"setHeight":{"!type":"fn(height: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this FlexTable."},"setId":{"!type":"fn(id: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this FlexTable."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this FlexTable in pixels."},"setRowStyleAttribute":{"!type":"fn(row: number, attribute: string, value: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setRowStyleAttribute(Integer,String,String)","!doc":"Sets a CSS style on a row of this FlexTable."},"setRowStyleAttributes":{"!type":"fn(row: number, attributes: object) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setRowStyleAttributes(Integer,Object)","!doc":"Sets a CSS style on a row of this FlexTable."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this FlexTable."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this FlexTable's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this FlexTable's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this FlexTable."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this FlexTable."},"setTag":{"!type":"fn(tag: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this FlexTable."},"setText":{"!type":"fn(row: number, column: number, text: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setText(Integer,Integer,String)","!doc":"Sets the contents of a given cell to the given text."},"setTitle":{"!type":"fn(title: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this FlexTable."},"setVisible":{"!type":"fn(visible: bool) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this FlexTable is visible."},"setWidget":{"!type":"fn(row: number, column: number, widget: ui.Widget) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setWidget(Integer,Integer,Widget)","!doc":"Sets the widget in a given cell."},"setWidth":{"!type":"fn(width: string) -> +ui.FlexTable","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this FlexTable."}}},"FlowPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/flow-panel","!doc":"FlowPanel A panel that formats its child widgets using the default HTML layout behavior. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var panel = app.createFlowPanel(); panel.add(app.createButton(\"button 1\")); panel.add(app.createButton(\"button 2\")); app.add(panel); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the FlowPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget)","!doc":"Add a widget to the FlowPanel."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this FlowPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this FlowPanel."},"clear":{"!type":"fn() -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the FlowPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this FlowPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"insert":{"!type":"fn(widget: ui.Widget, beforeIndex: number) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#insert(Widget,Integer)","!doc":"Add a widget to the FlowPanel at a specific index."},"remove":{"!type":"fn(widget: ui.Widget) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#remove(Widget)","!doc":"Remove the given widget from the FlowPanel."},"setHeight":{"!type":"fn(height: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this FlowPanel."},"setId":{"!type":"fn(id: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this FlowPanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this FlowPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this FlowPanel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this FlowPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this FlowPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this FlowPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this FlowPanel."},"setTag":{"!type":"fn(tag: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this FlowPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this FlowPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this FlowPanel is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.FlowPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this FlowPanel."}}},"FocusPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/focus-panel","!doc":"FocusPanel A simple panel that makes its contents focusable, and adds the ability to catch mouse and keyboard events. Note that this panel can contain at most one direct child widget. To add more children, make the child of this panel a different panel that can contain more than one child. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var focus = app.createFocusPanel(); var flow = app.createFlowPanel(); flow.add(app.createButton(\"button 1\")); flow.add(app.createButton(\"button 2\")); focus.add(flow); app.add(focus); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the FocusPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget)","!doc":"Add a widget to the FocusPanel."},"addBlurHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addBlurHandler(Handler)","!doc":"Add a handler for blur events (losing keyboard focus)."},"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addFocusHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addFocusHandler(Handler)","!doc":"Add a handler for focus events (gaining keyboard focus)."},"addKeyDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyDownHandler(Handler)","!doc":"Add a handler for key down events."},"addKeyPressHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyPressHandler(Handler)","!doc":"Add a handler for key press events."},"addKeyUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyUpHandler(Handler)","!doc":"Add a handler for key up events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this FocusPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this FocusPanel."},"clear":{"!type":"fn() -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the FocusPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this FocusPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setFocus":{"!type":"fn(focus: bool) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setFocus(Boolean)","!doc":"Explicitly focus/unfocus this FocusPanel."},"setHeight":{"!type":"fn(height: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this FocusPanel."},"setId":{"!type":"fn(id: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this FocusPanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this FocusPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this FocusPanel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this FocusPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this FocusPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this FocusPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this FocusPanel."},"setTabIndex":{"!type":"fn(index: number) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTabIndex(Integer)","!doc":"Sets the FocusPanel's position in the tab index."},"setTag":{"!type":"fn(tag: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this FocusPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this FocusPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this FocusPanel is visible."},"setWidget":{"!type":"fn(widget: ui.Widget) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidget(Widget)","!doc":"Sets the widget inside this FocusPanel, removing anything previously there."},"setWidth":{"!type":"fn(width: string) -> +ui.FocusPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this FocusPanel."}}},"FormPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/form-panel","!doc":"FormPanel A panel that wraps its contents in an HTML <FORM> element. This panel can be used with a SubmitButton to post form values to the server. All children of this panel (direct, or even children of sub-panels) that have a setName function and have been given a name will have their values sent to the server when the form is submitted. The submit can be handled in the special \"doPost\" function, as shown in the example. Note that this panel can contain at most one direct child widget. To add more children, make the child of this panel a different panel that can contain more than one child. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var form = app.createFormPanel(); var flow = app.createFlowPanel(); flow.add(app.createTextBox().setName(\"textBox\")); flow.add(app.createListBox().setName(\"listBox\").addItem(\"option 1\").addItem(\"option 2\")); flow.add(app.createSubmitButton(\"Submit\")); form.add(flow); app.add(form); return app; } function doPost(eventInfo) { var app = UiApp.getActiveApplication(); app.add(app.createLabel(\"Form submitted. The text box's value was '\" + eventInfo.parameter.textBox + \"' and the list box's value was '\" + eventInfo.parameter.listBox + \"'\")); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the FormPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget)","!doc":"Add a widget to the FormPanel."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this FormPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this FormPanel."},"addSubmitCompleteHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addSubmitCompleteHandler(Handler)","!doc":"Add a handler for when the form is submitted and the server has finished processing the results."},"addSubmitHandler":{"!type":"fn(handler: ui.Handler) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addSubmitHandler(Handler)","!doc":"Add a handler for when the form is submitted."},"clear":{"!type":"fn() -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the FormPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this FormPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setAction":{"!type":"fn(action: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setAction(String)","!doc":"Sets the URL to submit this form to."},"setEncoding":{"!type":"fn(encoding: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setEncoding(String)","!doc":"Sets the encoding used for submitting this form."},"setHeight":{"!type":"fn(height: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this FormPanel."},"setId":{"!type":"fn(id: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this FormPanel."},"setMethod":{"!type":"fn(method: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setMethod(String)","!doc":"Sets the HTTP method used for submitting this form."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this FormPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this FormPanel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this FormPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this FormPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this FormPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this FormPanel."},"setTag":{"!type":"fn(tag: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this FormPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this FormPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this FormPanel is visible."},"setWidget":{"!type":"fn(widget: ui.Widget) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidget(Widget)","!doc":"Sets the widget inside this FormPanel, removing anything previously there."},"setWidth":{"!type":"fn(width: string) -> +ui.FormPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this FormPanel."}}},"Grid":{"!url":"http://developers.google.com/apps-script/reference/ui/grid","!doc":"Grid A rectangular grid that can contain text, html, or a child widget within its cells. It must be resized explicitly to the desired number of rows and columns. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); app.add(app.createGrid(3, 3) .setBorderWidth(1) .setCellSpacing(10) .setCellPadding(10) .setText(0, 0, \"X\") .setText(1, 1, \"X\") .setText(2, 2, \"X\") .setText(0, 1, \"O\") .setText(0, 2, \"O\") .setStyleAttribute(0, 0, \"color\", \"red\") .setStyleAttribute(1, 1, \"color\", \"red\") .setStyleAttribute(2, 2, \"color\", \"red\") .setStyleAttribute(0, 1, \"color\", \"blue\") .setStyleAttribute(0, 2, \"color\", \"blue\")); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the Grid documentation here.","prototype":{"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this Grid."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this Grid."},"clear":{"!type":"fn() -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the Grid."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this Grid."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"resize":{"!type":"fn(rows: number, columns: number) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#resize(Integer,Integer)","!doc":"Resizes the Grid."},"setBorderWidth":{"!type":"fn(width: number) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setBorderWidth(Integer)","!doc":"Sets the border width."},"setCellPadding":{"!type":"fn(padding: number) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setCellPadding(Integer)","!doc":"Sets the padding within cells."},"setCellSpacing":{"!type":"fn(spacing: number) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setCellSpacing(Integer)","!doc":"Sets the spacing between cells."},"setColumnStyleAttribute":{"!type":"fn(column: number, attribute: string, value: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setColumnStyleAttribute(Integer,String,String)","!doc":"Sets a CSS style on a column of this Grid."},"setColumnStyleAttributes":{"!type":"fn(column: number, attributes: object) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setColumnStyleAttributes(Integer,Object)","!doc":"Sets a CSS style on a column of this Grid."},"setHeight":{"!type":"fn(height: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this Grid."},"setId":{"!type":"fn(id: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this Grid."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this Grid in pixels."},"setRowStyleAttribute":{"!type":"fn(row: number, attribute: string, value: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setRowStyleAttribute(Integer,String,String)","!doc":"Sets a CSS style on a row of this Grid."},"setRowStyleAttributes":{"!type":"fn(row: number, attributes: object) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setRowStyleAttributes(Integer,Object)","!doc":"Sets a CSS style on a row of this Grid."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this Grid."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this Grid's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this Grid's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this Grid."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this Grid."},"setTag":{"!type":"fn(tag: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this Grid."},"setText":{"!type":"fn(row: number, column: number, text: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setText(Integer,Integer,String)","!doc":"Sets the contents of a given cell to the given text."},"setTitle":{"!type":"fn(title: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this Grid."},"setVisible":{"!type":"fn(visible: bool) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this Grid is visible."},"setWidget":{"!type":"fn(row: number, column: number, widget: ui.Widget) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setWidget(Integer,Integer,Widget)","!doc":"Sets the widget in a given cell."},"setWidth":{"!type":"fn(width: string) -> +ui.Grid","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this Grid."}}},"HTML":{"!url":"http://developers.google.com/apps-script/reference/ui/html","!doc":"HTML A widget that contains arbitrary text, which is interpreted as HTML. Only basic HTML markup such as bold, italic, etc. are allowed; in particular, scripts will be stripped out completely. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); app.add(app.createHTML(\"<b>Hello World!</b>\")); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the HTML documentation here.","prototype":{"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this HTML."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this HTML."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this HTML."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setHTML":{"!type":"fn(html: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setHTML(String)","!doc":"Sets the HTML content of this HTML."},"setHeight":{"!type":"fn(height: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this HTML."},"setHorizontalAlignment":{"!type":"fn(horizontalAlignment: ui.HorizontalAlignment) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setHorizontalAlignment(HorizontalAlignment)","!doc":"Set the horizontal text alignment of the display text of this HTML."},"setId":{"!type":"fn(id: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this HTML."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this HTML in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this HTML."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this HTML's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this HTML's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this HTML."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this HTML."},"setTag":{"!type":"fn(tag: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this HTML."},"setText":{"!type":"fn(text: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Set the display text of this HTML."},"setTitle":{"!type":"fn(title: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this HTML."},"setVisible":{"!type":"fn(visible: bool) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this HTML is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this HTML."},"setWordWrap":{"!type":"fn(wordWrap: bool) -> +ui.HTML","!url":"http://developers.google.com/apps-script/reference/ui/#setWordWrap(Boolean)","!doc":"Set whether this HTML wraps its text."}}},"Hidden":{"!url":"http://developers.google.com/apps-script/reference/ui/hidden","!doc":"Hidden Represents a hidden field for storing data in the user's browser that can be passed back to a handler as a \"callback element\". Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); // Note that the name \"appState\" for callbacks, and the id \"hidden\" for // getting a reference to the widget, are not required to be the same. var hidden = app.createHidden(\"appState\", \"0\").setId(\"hidden\"); app.add(hidden); var handler = app.createServerHandler(\"click\").addCallbackElement(hidden); app.add(app.createButton(\"click me!\", handler)); app.add(app.createLabel(\"clicked 0 times\").setId(\"label\")); return app; } function click(eventInfo) { var app = UiApp.createApplication(); // We have the value of the hidden field because it was a callback element. var numClicks = Number(eventInfo.parameter.appState); numClicks++; // Just store the number as a string. We could actually store arbitrarily complex data // here using JSON.stringify() to turn a JavaScript object into a string to store, and // JSON.parse() to turn the string back into an object. app.getElementById(\"hidden\").setValue(String(numClicks)); app.getElementById(\"label\").setText(\"clicked \" + numClicks + \" times\"); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the Hidden documentation here.","prototype":{"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this Hidden."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setId":{"!type":"fn(id: string) -> +ui.Hidden","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this Hidden."},"setName":{"!type":"fn(name: string) -> +ui.Hidden","!url":"http://developers.google.com/apps-script/reference/ui/#setName(String)","!doc":"Sets the name of the Hidden, which is how it will be referred to when used in a FormPanel or as a callback element on an event handler."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.Hidden","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this Hidden's style attributes."},"setTag":{"!type":"fn(tag: string) -> +ui.Hidden","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this Hidden."},"setValue":{"!type":"fn(value: string) -> +ui.Hidden","!url":"http://developers.google.com/apps-script/reference/ui/#setValue(String)","!doc":"Sets the value of this Hidden."}}},"HorizontalPanel":{"!url":"http://developers.google.com/apps-script/reference/ui/horizontal-panel","!doc":"HorizontalPanel A panel that lays all of its widgets out in a single horizontal column. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); var panel = app.createHorizontalPanel(); panel.add(app.createButton(\"button 1\")); panel.add(app.createButton(\"button 2\")); app.add(panel); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the HorizontalPanel documentation here.","prototype":{"add":{"!type":"fn(widget: ui.Widget) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#add(Widget)","!doc":"Add a widget to the HorizontalPanel."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this HorizontalPanel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this HorizontalPanel."},"clear":{"!type":"fn() -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Remove all widgets from the HorizontalPanel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this HorizontalPanel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"remove":{"!type":"fn(widget: ui.Widget) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#remove(Widget)","!doc":"Remove the given widget from the HorizontalPanel."},"setBorderWidth":{"!type":"fn(width: number) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setBorderWidth(Integer)","!doc":"Sets the width of the border to be applied to all cells in this panel."},"setCellHeight":{"!type":"fn(widget: ui.Widget, height: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setCellHeight(Widget,String)","!doc":"Sets the height of the cell associated with the given widget, related to the panel as a whole."},"setCellHorizontalAlignment":{"!type":"fn(widget: ui.Widget, horizontalAlignment: ui.HorizontalAlignment) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setCellHorizontalAlignment(Widget,HorizontalAlignment)","!doc":"Sets the horizontal alignment of the given widget within its cell."},"setCellVerticalAlignment":{"!type":"fn(widget: ui.Widget, verticalAlignment: ui.VerticalAlignment) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setCellVerticalAlignment(Widget,VerticalAlignment)","!doc":"Sets the vertical alignment of the given widget within its cell."},"setCellWidth":{"!type":"fn(widget: ui.Widget, width: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setCellWidth(Widget,String)","!doc":"Sets the width of the cell associated with the given widget, related to the panel as a whole."},"setHeight":{"!type":"fn(height: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this HorizontalPanel."},"setHorizontalAlignment":{"!type":"fn(horizontalAlignment: ui.HorizontalAlignment) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setHorizontalAlignment(HorizontalAlignment)","!doc":"Set the horizontal alignment of widgets added to this HorizontalPanel."},"setId":{"!type":"fn(id: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this HorizontalPanel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this HorizontalPanel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this HorizontalPanel."},"setSpacing":{"!type":"fn(spacing: number) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setSpacing(Integer)","!doc":"Sets the amount of spacing between this panel's cells."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this HorizontalPanel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this HorizontalPanel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this HorizontalPanel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this HorizontalPanel."},"setTag":{"!type":"fn(tag: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this HorizontalPanel."},"setTitle":{"!type":"fn(title: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this HorizontalPanel."},"setVerticalAlignment":{"!type":"fn(verticalAlignment: ui.VerticalAlignment) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVerticalAlignment(VerticalAlignment)","!doc":"Set the vertical alignment of widgets added to this HorizontalPanel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this HorizontalPanel is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.HorizontalPanel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this HorizontalPanel."}}},"Image":{"!url":"http://developers.google.com/apps-script/reference/ui/image","!doc":"Image A widget that displays the image at a given URL. The image can be in 'unclipped' mode (the default) or 'clipped' mode. In clipped mode, a viewport is overlaid on top of the image so that a subset of the image will be displayed. In unclipped mode, there is no viewport - the entire image will be visible. Whether an image is in clipped or unclipped mode depends on how the image is constructed, and how it is transformed after construction. Methods will operate differently depending on the mode that the image is in. These differences are detailed in the documentation for each method. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); // The very first Google Doodle! app.add(app.createImage(\"http://www.google.com/logos/googleburn.jpg\")); // Just the man in the middle app.add(app.createImage(\"http://www.google.com/logos/googleburn.jpg\", 118, 0, 50, 106)); return app; } Due to browser-specific HTML constructions needed to achieve the clipping effect, certain CSS attributes, such as padding and background, may not work as expected when an image is in clipped mode. These limitations can usually be easily worked around by encapsulating the image in a container widget that can itself be styled. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the Image documentation here.","prototype":{"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addErrorHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addErrorHandler(Handler)","!doc":"Add a handler for error events (failed loads)."},"addLoadHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addLoadHandler(Handler)","!doc":"Add a handler for load events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this Image."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this Image."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this Image."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setHeight":{"!type":"fn(height: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this Image."},"setId":{"!type":"fn(id: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this Image."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this Image in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this Image."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this Image's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this Image's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this Image."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this Image."},"setTag":{"!type":"fn(tag: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this Image."},"setTitle":{"!type":"fn(title: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this Image."},"setUrl":{"!type":"fn(url: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setUrl(String)","!doc":"Sets the URL of the image to be displayed."},"setUrlAndVisibleRect":{"!type":"fn(url: string, left: number, top: number, width: number, height: number) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setUrlAndVisibleRect(String,Integer,Integer,Integer,Integer)","!doc":"Sets the url and the visibility rectangle for the image at the same time."},"setVisible":{"!type":"fn(visible: bool) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this Image is visible."},"setVisibleRect":{"!type":"fn(left: number, top: number, width: number, height: number) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setVisibleRect(Integer,Integer,Integer,Integer)","!doc":"Sets the visibility rectangle of an image."},"setWidth":{"!type":"fn(width: string) -> +ui.Image","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this Image."}}},"InlineLabel":{"!url":"http://developers.google.com/apps-script/reference/ui/inline-label","!doc":"InlineLabel A widget that contains arbitrary text, not interpreted as HTML. This widget uses a <span> element, causing it to be displayed with inline layout. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the InlineLabel documentation here.","prototype":{"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this InlineLabel."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this InlineLabel."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this InlineLabel."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setHeight":{"!type":"fn(height: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this InlineLabel."},"setHorizontalAlignment":{"!type":"fn(horizontalAlignment: ui.HorizontalAlignment) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setHorizontalAlignment(HorizontalAlignment)","!doc":"Set the horizontal text alignment of the display text of this InlineLabel."},"setId":{"!type":"fn(id: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this InlineLabel."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this InlineLabel in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this InlineLabel."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this InlineLabel's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this InlineLabel's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this InlineLabel."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this InlineLabel."},"setTag":{"!type":"fn(tag: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this InlineLabel."},"setText":{"!type":"fn(text: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Set the display text of this InlineLabel."},"setTitle":{"!type":"fn(title: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this InlineLabel."},"setVisible":{"!type":"fn(visible: bool) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this InlineLabel is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this InlineLabel."},"setWordWrap":{"!type":"fn(wordWrap: bool) -> +ui.InlineLabel","!url":"http://developers.google.com/apps-script/reference/ui/#setWordWrap(Boolean)","!doc":"Set whether this InlineLabel wraps its text."}}},"Label":{"!url":"http://developers.google.com/apps-script/reference/ui/label","!doc":"Label A widget that contains arbitrary text, not interpreted as HTML. Here is an example of how to use this widget: function doGet() { var app = UiApp.createApplication(); app.add(app.createLabel(\"Hello World!\")); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the Label documentation here.","prototype":{"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this Label."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this Label."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this Label."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setHeight":{"!type":"fn(height: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this Label."},"setHorizontalAlignment":{"!type":"fn(horizontalAlignment: ui.HorizontalAlignment) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setHorizontalAlignment(HorizontalAlignment)","!doc":"Set the horizontal text alignment of the display text of this Label."},"setId":{"!type":"fn(id: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this Label."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this Label in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this Label."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this Label's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this Label's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this Label."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this Label."},"setTag":{"!type":"fn(tag: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this Label."},"setText":{"!type":"fn(text: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setText(String)","!doc":"Set the display text of this Label."},"setTitle":{"!type":"fn(title: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this Label."},"setVisible":{"!type":"fn(visible: bool) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this Label is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this Label."},"setWordWrap":{"!type":"fn(wordWrap: bool) -> +ui.Label","!url":"http://developers.google.com/apps-script/reference/ui/#setWordWrap(Boolean)","!doc":"Set whether this Label wraps its text."}}},"ListBox":{"!url":"http://developers.google.com/apps-script/reference/ui/list-box","!doc":"ListBox A widget that presents a list of choices to the user, either as a list box or as a drop-down list. Here is an example usage, which should be executed from within a spreadsheet bound script. // execute this in a spreadsheet function show() { var doc = SpreadsheetApp.getActiveSpreadsheet(); var app = UiApp.createApplication().setTitle('My Application'); var panel = app.createVerticalPanel(); var lb = app.createListBox(true).setId('myId').setName('myLbName'); // add items to ListBox lb.setVisibleItemCount(3); lb.addItem('first'); lb.addItem('second'); lb.addItem('third'); lb.addItem('fourth'); lb.addItem('fifth'); lb.addItem('sixth'); panel.add(lb); var button = app.createButton('press me'); var handler = app.createServerClickHandler('click').addCallbackElement(panel); button.addClickHandler(handler); panel.add(button); app.add(panel); doc.show(app); } function click(eventInfo) { var app = UiApp.getActiveApplication(); // get values of ListBox var value = eventInfo.parameter.myLbName; // multi select box returns a comma separated string var n = value.split(','); var doc = SpreadsheetApp.getActiveSpreadsheet(); doc.getRange('a1').setValue(value); doc.getRange('b1').setValue('there are ' + n.length + ' items selected'); return app; } Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the ListBox documentation here.","prototype":{"addBlurHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addBlurHandler(Handler)","!doc":"Add a handler for blur events (losing keyboard focus)."},"addChangeHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addChangeHandler(Handler)","!doc":"Add a handler for change events."},"addClickHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addClickHandler(Handler)","!doc":"Add a handler for click events."},"addFocusHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addFocusHandler(Handler)","!doc":"Add a handler for focus events (gaining keyboard focus)."},"addItem":{"!type":"fn(text: string, value: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addItem(String,String)","!doc":"Adds an item to the list box, specifying its value."},"addKeyDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyDownHandler(Handler)","!doc":"Add a handler for key down events."},"addKeyPressHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyPressHandler(Handler)","!doc":"Add a handler for key press events."},"addKeyUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addKeyUpHandler(Handler)","!doc":"Add a handler for key up events."},"addMouseDownHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseDownHandler(Handler)","!doc":"Add a handler for mouse down events."},"addMouseMoveHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseMoveHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseOutHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOutHandler(Handler)","!doc":"Add a handler for mouse out events."},"addMouseOverHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseOverHandler(Handler)","!doc":"Add a handler for mouse move events."},"addMouseUpHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseUpHandler(Handler)","!doc":"Add a handler for mouse up events."},"addMouseWheelHandler":{"!type":"fn(handler: ui.Handler) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addMouseWheelHandler(Handler)","!doc":"Add a handler for mouse wheel events."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this ListBox."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this ListBox."},"clear":{"!type":"fn() -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#clear()","!doc":"Removes all items from the list box."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this ListBox."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"removeItem":{"!type":"fn(index: number) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#removeItem(Integer)","!doc":"Removes the item at the specified index."},"setEnabled":{"!type":"fn(enabled: bool) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setEnabled(Boolean)","!doc":"Sets whether the ListBox is enabled."},"setFocus":{"!type":"fn(focus: bool) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setFocus(Boolean)","!doc":"Explicitly focus/unfocus this ListBox."},"setHeight":{"!type":"fn(height: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this ListBox."},"setId":{"!type":"fn(id: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this ListBox."},"setItemSelected":{"!type":"fn(index: number, selected: bool) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setItemSelected(Integer,Boolean)","!doc":"Selects the item at the specified index."},"setItemText":{"!type":"fn(index: number, text: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setItemText(Integer,String)","!doc":"Sets the text associated with the item at a given index."},"setName":{"!type":"fn(name: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setName(String)","!doc":"Sets the name of the ListBox, which is how it will be referred to when used in a FormPanel or as a callback element on an event handler."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this ListBox in pixels."},"setSelectedIndex":{"!type":"fn(index: number) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setSelectedIndex(Integer)","!doc":"Selects the item at the specified index."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this ListBox."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this ListBox's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this ListBox's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this ListBox."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this ListBox."},"setTabIndex":{"!type":"fn(index: number) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTabIndex(Integer)","!doc":"Sets the ListBox's position in the tab index."},"setTag":{"!type":"fn(tag: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this ListBox."},"setTitle":{"!type":"fn(title: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this ListBox."},"setValue":{"!type":"fn(index: number, value: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setValue(Integer,String)","!doc":"Sets the value associated with the item at a given index."},"setVisible":{"!type":"fn(visible: bool) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this ListBox is visible."},"setVisibleItemCount":{"!type":"fn(count: number) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setVisibleItemCount(Integer)","!doc":"Sets the number of items that are visible."},"setWidth":{"!type":"fn(width: string) -> +ui.ListBox","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this ListBox."}}},"MenuBar":{"!url":"http://developers.google.com/apps-script/reference/ui/menu-bar","!doc":"MenuBar A standard menu bar widget. A menu bar can contain any number of menu items, each of which can either fire an event handler or open a cascaded menu bar. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the MenuBar documentation here.","prototype":{"addCloseHandler":{"!type":"fn(handler: ui.Handler) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#addCloseHandler(Handler)","!doc":"Add a handler for close events."},"addItem":{"!type":"fn(text: string, subMenu: menubar) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#addItem(String,MenuBar)","!doc":"Creates a new menu item with the given text and submenu and adds it to this MenuBar."},"addSeparator":{"!type":"fn(separator: menuitemseparator) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#addSeparator(MenuItemSeparator)","!doc":"Add a separator to the MenuBar."},"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this MenuBar."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this MenuBar."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this MenuBar."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setAnimationEnabled":{"!type":"fn(animationEnabled: bool) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setAnimationEnabled(Boolean)","!doc":"Sets whether opening and closing the MenuBar is animated."},"setAutoOpen":{"!type":"fn(autoOpen: bool) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setAutoOpen(Boolean)","!doc":"Sets whether this menu bar's child menus will open when the mouse is moved over it."},"setHeight":{"!type":"fn(height: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this MenuBar."},"setId":{"!type":"fn(id: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this MenuBar."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this MenuBar in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this MenuBar."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one of this MenuBar's style attributes to a new value."},"setStyleAttributes":{"!type":"fn(attributes: object) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttributes(Object)","!doc":"Sets this MenuBar's style attributes."},"setStyleName":{"!type":"fn(styleName: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleName(String)","!doc":"Sets the style name of this MenuBar."},"setStylePrimaryName":{"!type":"fn(styleName: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setStylePrimaryName(String)","!doc":"Sets the primary style name of this MenuBar."},"setTag":{"!type":"fn(tag: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setTag(String)","!doc":"Sets the text tag of this MenuBar."},"setTitle":{"!type":"fn(title: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setTitle(String)","!doc":"Sets the hover title of this MenuBar."},"setVisible":{"!type":"fn(visible: bool) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setVisible(Boolean)","!doc":"Sets whether this MenuBar is visible."},"setWidth":{"!type":"fn(width: string) -> +ui.MenuBar","!url":"http://developers.google.com/apps-script/reference/ui/#setWidth(String)","!doc":"Sets the width of this MenuBar."}}},"MenuItem":{"!url":"http://developers.google.com/apps-script/reference/ui/menu-item","!doc":"MenuItem An entry in a MenuBar. Menu items can either fire an event handler when they are clicked, or open a cascading sub-menu. Internally, UiApp widgets are built on top of the Google Web Toolkit, and it can sometimes be helpful to look at the GWT documentation directly. You can find the MenuItem documentation here.","prototype":{"addStyleDependentName":{"!type":"fn(styleName: string) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleDependentName(String)","!doc":"Sets the dependent style name of this MenuItem."},"addStyleName":{"!type":"fn(styleName: string) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#addStyleName(String)","!doc":"Adds a style name to this MenuItem."},"getId":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getId()","!doc":"Returns the id that has been assigned to this object."},"getTag":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getTag()","!doc":"Gets the text tag of this MenuItem."},"getType":{"!type":"fn() -> string","!url":"http://developers.google.com/apps-script/reference/ui/#getType()","!doc":"Gets the type of this object."},"setCommand":{"!type":"fn(handler: ui.Handler) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#setCommand(Handler)","!doc":"Sets the handler to execute when the menu is clicked."},"setHTML":{"!type":"fn(html: string) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#setHTML(String)","!doc":"Sets the HTML content of this MenuItem."},"setHeight":{"!type":"fn(height: string) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#setHeight(String)","!doc":"Sets the height of this MenuItem."},"setId":{"!type":"fn(id: string) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#setId(String)","!doc":"Sets the id of this MenuItem."},"setPixelSize":{"!type":"fn(width: number, height: number) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#setPixelSize(Integer,Integer)","!doc":"Sets the size of this MenuItem in pixels."},"setSize":{"!type":"fn(width: string, height: string) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#setSize(String,String)","!doc":"Sets the size of this MenuItem."},"setStyleAttribute":{"!type":"fn(attribute: string, value: string) -> +ui.MenuItem","!url":"http://developers.google.com/apps-script/reference/ui/#setStyleAttribute(String,String)","!doc":"Sets one o