/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ajdt.ui.xref;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.springframework.ide.eclipse.ajdt.ui.xref.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReferenceViewPreferenceUtils {
    public static final String XREF_CHECKED_FILTERS = "org.springframework.ide.eclipse.aop.ui.xref.checked.filters";
    public static final String XREF_CHECKED_FILTERS_INPLACE = "org.springframework.ide.eclipse.aop.ui.xref.checked.filters.inplace";

    public static void setCheckedInplaceFilters(List l) {
        StringBuffer sb = new StringBuffer();
        sb.append("set: ");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sb.append(name);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        IPreferenceStore pstoreInplace = Activator.getDefault().getPreferenceStore();
        pstoreInplace.setValue(XREF_CHECKED_FILTERS_INPLACE, sb.toString());
    }

    public static List<Object> getFilterCheckedInplaceList() {
        IPreferenceStore pstoreInplace = Activator.getDefault().getPreferenceStore();
        String xRefCheckedFilters = pstoreInplace.getString(XREF_CHECKED_FILTERS_INPLACE);
        if (!xRefCheckedFilters.startsWith("set: ")) {
            return null;
        }
        xRefCheckedFilters = xRefCheckedFilters.substring("set: ".length());
        ArrayList<Object> checkedList = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(xRefCheckedFilters, ",");
        while (tokenizer.hasMoreTokens()) {
            checkedList.add(tokenizer.nextElement());
        }
        return checkedList;
    }

    public static void setCheckedFilters(List l) {
        StringBuffer sb = new StringBuffer();
        sb.append("set: ");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sb.append(name);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        pstore.setValue(XREF_CHECKED_FILTERS, sb.toString());
    }

    public static List<Object> getFilterCheckedList() {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        String xRefCheckedFilters = pstore.getString(XREF_CHECKED_FILTERS);
        if (!xRefCheckedFilters.startsWith("set: ")) {
            return null;
        }
        xRefCheckedFilters = xRefCheckedFilters.substring("set: ".length());
        ArrayList<Object> checkedList = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(xRefCheckedFilters, ",");
        while (tokenizer.hasMoreTokens()) {
            checkedList.add(tokenizer.nextElement());
        }
        return checkedList;
    }
}

