/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ajdt.ui.actions;

import java.util.regex.Pattern;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.internal.ui.lazystart.Utils;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.springframework.ide.eclipse.core.SpringCore;

public class SpringAspectsToolingEnabler {
    private static final Pattern SPRING_ASPECTS_JAR_PATTERN = Pattern.compile(".*spring-aspects.*\\.jar");
    private static final String SPRING_ASPECTS_JAR_NAME = "spring-aspects.jar";
    private static final Pattern SPRING_ASPECTS_PATTERN = Pattern.compile(".*org\\.springframework\\.aspects-.*\\.jar");
    private final IProject project;
    private final IJavaProject jProject;
    private final Shell shell;
    private final boolean askToChangeDefaultEditor;

    public SpringAspectsToolingEnabler(IProject project, Shell shell) {
        this(project, shell, false);
    }

    public SpringAspectsToolingEnabler(IProject project, Shell shell, boolean askToChangeDefaultEditor) {
        this.project = project;
        this.jProject = JavaCore.create((IProject)project);
        this.askToChangeDefaultEditor = askToChangeDefaultEditor;
        this.shell = shell;
    }

    boolean run() {
        boolean isAJEditorDefault = false;
        try {
            if (this.hasSpringAspectsJar(this.jProject.getRawClasspath())) {
                if (!this.hasAJNature()) {
                    AJDTUtils.addAspectJNature((IProject)this.project, (boolean)false);
                }
                if (!this.isJarOnAspectPath(this.jProject.getRawClasspath())) {
                    IClasspathEntry springAspectsEntry = this.findSpringAspectsJar(this.jProject.getRawClasspath());
                    AspectJCorePreferences.addToAspectPath((IProject)this.project, (IClasspathEntry)springAspectsEntry);
                }
                if (this.askToChangeDefaultEditor) {
                    if (!this.isAJEditorDefault()) {
                        isAJEditorDefault = MessageDialog.openQuestion((Shell)this.shell, (String)"Make AspectJ editor default?", (String)"Do you want to make the AspectJ editor the default editor for editing Java files?\n\nThis option can be changed by going to Preferences -> General-> Editors -> File Associations");
                        if (isAJEditorDefault) {
                            this.makeAJEditorDefault();
                        }
                    } else {
                        isAJEditorDefault = true;
                    }
                }
            } else {
                MessageDialog.openInformation((Shell)this.shell, (String)"Add spring-aspects.jar to build path", (String)("Please add a version of spring-aspects.jar\nto build path of " + this.project.getName() + " and run this command again."));
            }
        }
        catch (CoreException e) {
            SpringCore.log((String)("Error adding Spring tools to project " + this.project), (Throwable)e);
        }
        return isAJEditorDefault;
    }

    private void makeAJEditorDefault() {
        IFileEditorMapping[] mappings;
        EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        IFileEditorMapping[] iFileEditorMappingArray = mappings = registry.getFileEditorMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            IFileEditorMapping mapping = iFileEditorMappingArray[n2];
            if (mapping.getExtension().equals("java") && mapping instanceof FileEditorMapping) {
                IEditorDescriptor desc = registry.findEditor("org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor");
                ((FileEditorMapping)mapping).setDefaultEditor((EditorDescriptor)desc);
            }
            ++n2;
        }
        registry.setFileEditorMappings((FileEditorMapping[])mappings);
        registry.saveAssociations();
    }

    private IClasspathEntry findSpringAspectsJar(IClasspathEntry[] entries) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry containedEntry;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (this.isSpringAspectsEntry(entry)) {
                return entry;
            }
            if (entry.getEntryKind() == 5 && (containedEntry = this.findSpringAspectsJar(this.extractEntriesFomContainer(entry))) != null) {
                return containedEntry;
            }
            ++n2;
        }
        return null;
    }

    private boolean hasSpringAspectsJar(IClasspathEntry[] entries) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (this.isSpringAspectsEntry(entry)) {
                return true;
            }
            if (entry.getEntryKind() == 5 && this.hasSpringAspectsJar(this.extractEntriesFomContainer(entry))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isJarOnAspectPath(IClasspathEntry[] entries) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (this.isSpringAspectsEntry(entry) ? AspectJCorePreferences.isOnAspectpath((IClasspathEntry)entry) : entry.getEntryKind() == 5 && this.isJarOnAspectPath(this.extractEntriesFomContainer(entry))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasAJNature() {
        return Utils.isAJProject((IProject)this.project);
    }

    private boolean isSpringAspectsEntry(IClasspathEntry entry) {
        String path = entry.getPath().toOSString();
        return SPRING_ASPECTS_JAR_PATTERN.matcher(path).matches() || SPRING_ASPECTS_PATTERN.matcher(path).matches();
    }

    private IClasspathEntry[] extractEntriesFomContainer(IClasspathEntry containerEntry) {
        try {
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerEntry.getPath(), (IJavaProject)this.jProject);
            return container.getClasspathEntries();
        }
        catch (JavaModelException e) {
            SpringCore.log((String)("Error accessing classpath container " + containerEntry.getPath() + " from project " + this.project), (Throwable)e);
            return new IClasspathEntry[0];
        }
    }

    private boolean isAJEditorDefault() {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(".java", ContentTypeManager.getInstance().getContentType("org.eclipse.jdt.core.javaSource"));
        return desc.getId().equals("org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor");
    }
}

