/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelector;

public class ProjectSelector
implements IProjectSelector {
    private Shell shell;
    private Composite parent;
    private String projectName;

    protected ProjectSelector(Shell shell, Composite parent) {
        this.shell = shell;
        this.parent = parent;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void setSelectedProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public boolean setProject(IProject project) {
        if (project != null) {
            this.setSelectedProjectName(project.getName());
            return true;
        }
        return false;
    }

    @Override
    public Composite createProjectArea() {
        Composite projectNameArea = new Composite(this.parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(projectNameArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)projectNameArea);
        Label projectLabel = new Label(projectNameArea, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)projectLabel);
        projectLabel.setText("Project: ");
        return projectNameArea;
    }

    protected String getSelectedProjectName() {
        return this.projectName;
    }

    @Override
    public IProject getSelectedProject() {
        String selectionName = this.getSelectedProjectName();
        if (selectionName == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(selectionName);
    }
}

