/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.SearchPattern;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.plugins.BasePluginData;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.plugins.Plugin;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.plugins.PluginVersion;
import org.springsource.ide.eclipse.commons.frameworks.ui.FrameworkUIActivator;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.icons.IconManager;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.AbstractTreeElement;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.CommandDialog;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.IPluginListColumn;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.ITreeElement;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.PluginOperation;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.PluginState;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.TreeViewerColumnComparator;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.plugins.TreeViewerComposite;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelectionHandler;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelector;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ProjectSelectionPart;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ProjectSelectorFactory;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.SWTFactory;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ViewerSearchPart;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.tasks.IUIRunnable;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.tasks.TaskManager;

public abstract class PluginManagerDialog
extends CommandDialog {
    public static final String INITIAL_REFRESH_DEPENDENCIES_DIALOGUE_TITLE = "No local plugin list found";
    private GrailsBrowserViewer pluginViewer;
    private IProject selectedProject;
    private Text descriptionLabel;
    private Label authorLabel;
    private Link documentationLink;
    private IconManager iconManager;
    private static final int MIN_DESCRIPTION_HEIGHT = 65;
    private static final int MIN_DESCRIPTION_WIDTH = -1;
    private Map<Plugin, RootTreeElement> rootElementMap;
    private Map<PluginVersion, VersionTreeElement> childElementMap;
    private Collection<? extends Plugin> pluginList;
    private static final String DATA_NOT_AVAILABLE = "n/a";
    private LinkedHashSet<PluginVersion> selectedToInstall = new LinkedHashSet();
    private LinkedHashSet<PluginVersion> selectedToUninstall = new LinkedHashSet();
    private List<Button> selectionBasedOperationButtons;
    private ViewerSearchPart searchPart;

    public PluginManagerDialog(Shell parentShell, List<IProject> projects) {
        super(parentShell, projects);
    }

    protected void createSearchArea(Composite parent) {
        this.searchPart = new ViewerSearchPart(parent){

            @Override
            protected boolean matches(Object element, Object parentElement, String pattern) {
                if (element instanceof ITreeElement) {
                    ITreeElement treeElement = (ITreeElement)element;
                    PluginVersion version = treeElement.getVersionModel();
                    if (PluginManagerDialog.this.matches(version, pattern)) {
                        return true;
                    }
                    List versions = version.getParent().getVersions();
                    if (versions != null) {
                        for (PluginVersion ver : versions) {
                            if (!PluginManagerDialog.this.matches(ver, pattern)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
    }

    protected void initIconManager() {
        this.iconManager = new IconManager();
    }

    protected boolean matches(PluginVersion version, String pattern) {
        if (version == null || pattern == null) {
            return false;
        }
        String lowerCasePattern = pattern.toLowerCase();
        String name = version.getName();
        SearchPattern filter = new SearchPattern();
        filter.setPattern(lowerCasePattern);
        if (name != null && filter.matches(name)) {
            return true;
        }
        String title = version.getTitle();
        return title != null && filter.matches(title);
    }

    @Override
    protected void createCommandArea(Composite parent) {
        this.createProjectArea(parent);
        this.createPluginViewerArea(parent);
        this.resynchPluginsList(false);
        this.pluginViewer.getTreeViewer().getTree().setFocus();
    }

    protected void createProjectArea(Composite parent) {
        Collection<IProject> allProjects;
        List<IProject> selectedProjects = this.getProjects();
        LinkedHashSet<IProject> availableProjects = new LinkedHashSet<IProject>();
        if (selectedProjects != null && !selectedProjects.isEmpty()) {
            availableProjects.addAll(selectedProjects);
        }
        if (!(allProjects = this.updateProjects()).isEmpty()) {
            availableProjects.addAll(allProjects);
        }
        IProjectSelectionHandler handler = new IProjectSelectionHandler(){

            @Override
            public void handleProjectSelectionChange(IProject project) {
                PluginManagerDialog.this.selectedProject = project;
                PluginManagerDialog.this.resynchPluginsList(false);
            }
        };
        IProjectSelector selector = new ProjectSelectorFactory(this.getShell(), parent, availableProjects, handler).getProjectSelector();
        if (selector != null) {
            selector.createProjectArea();
            if (selector instanceof ProjectSelectionPart) {
                ((ProjectSelectionPart)selector).showProjectSwitchDialogue(true);
            }
            if (!availableProjects.isEmpty()) {
                this.selectedProject = (IProject)availableProjects.iterator().next();
                selector.setProject(this.selectedProject);
            }
        }
    }

    protected abstract Collection<IProject> updateProjects();

    protected void clearAllPluginChanges() {
        if (this.selectedToInstall != null) {
            this.selectedToInstall.clear();
        }
        if (this.selectedToUninstall != null) {
            this.selectedToUninstall.clear();
        }
    }

    public boolean hasPluginChanges() {
        return this.selectedToInstall != null && !this.selectedToInstall.isEmpty() || this.selectedToUninstall != null && !this.selectedToUninstall.isEmpty();
    }

    protected void createFilterOptionsArea(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)optionsGroup);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(this.getDefaultCompositeHMargin(), this.getDefaultCompositeVMargin()).applyTo((Composite)optionsGroup);
        optionsGroup.setText("Filters");
        Composite filterOptionsArea = new Composite((Composite)optionsGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filterOptionsArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterOptionsArea);
        if (optionsGroup != null) {
            GrailsFilterType[] types;
            GrailsFilterType[] grailsFilterTypeArray = types = GrailsFilterType.values();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Button button;
                GrailsFilterType type = grailsFilterTypeArray[n2];
                String filterName = type.getFilterName();
                if (filterName != null && (button = SWTFactory.createRadialButton(filterOptionsArea, filterName, type.getDefaultSelection())) != null) {
                    button.addSelectionListener((SelectionListener)new ViewerFilterButtonListener());
                    button.setData((Object)type);
                }
                ++n2;
            }
        }
    }

    protected void createDescriptionArea(Composite parent) {
        Composite descriptionArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(descriptionArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)descriptionArea);
        Group descriptionGroup = new Group(descriptionArea, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)descriptionGroup);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(this.getDefaultCompositeHMargin(), this.getDefaultCompositeVMargin()).applyTo((Composite)descriptionGroup);
        descriptionGroup.setText("Published Plugin Information");
        Label desLabel = new Label((Composite)descriptionGroup, 16384);
        desLabel.setText("Description:");
        this.descriptionLabel = new Text((Composite)descriptionGroup, 2632);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 65).applyTo((Control)this.descriptionLabel);
        Composite authorArea = new Composite((Composite)descriptionGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(authorArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)authorArea);
        Label authLab = new Label(authorArea, 16384);
        authLab.setText("Author:");
        this.authorLabel = new Label(authorArea, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.authorLabel);
        Composite linkArea = new Composite((Composite)descriptionGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(linkArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)linkArea);
        Label descLinkLabel = new Label(linkArea, 16384);
        descLinkLabel.setText("Documentation:");
        this.documentationLink = new Link(linkArea, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.documentationLink);
        this.documentationLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object dataObj = PluginManagerDialog.this.documentationLink.getData();
                if (dataObj instanceof BasePluginData) {
                    String urlExpression = ((BasePluginData)dataObj).getDocumentation();
                    PluginManagerDialog.this.handleNavigation(urlExpression);
                }
            }
        });
        this.refreshDescriptionArea();
    }

    protected void handleNavigation(String urlExpression) {
        String errorMessage;
        block7: {
            errorMessage = null;
            try {
                URL url = new URL(urlExpression);
                boolean launched = Program.launch((String)url.toString());
                if (launched) break block7;
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    if (support != null) {
                        IWebBrowser browser = support.getExternalBrowser();
                        if (browser != null) {
                            browser.openURL(url);
                            return;
                        }
                        errorMessage = "Unable to find browser support to navigate to URL. Check default browser support in Eclipse or OS";
                    }
                }
                catch (PartInitException e) {
                    errorMessage = "Unable to navigate to URL: " + e.getLocalizedMessage();
                }
            }
            catch (MalformedURLException e) {
                errorMessage = "Unable to navigate to URL: " + e.getLocalizedMessage();
            }
        }
        if (errorMessage != null) {
            InternalMessageDialogue dialog = new InternalMessageDialogue("Problems navigating to URL", String.valueOf(errorMessage) + ": " + urlExpression, 1, false);
            dialog.open();
        }
    }

    protected void refreshDescriptionArea() {
        PluginVersion version = this.getSingleSelectedPluginVersion();
        if (version != null) {
            String description = version.getDescription();
            if (description != null && description.length() > 0) {
                this.descriptionLabel.setText(description);
            } else {
                this.descriptionLabel.setText(DATA_NOT_AVAILABLE);
            }
            String author = version.getAuthor();
            if (author != null && author.length() > 0) {
                this.authorLabel.setText(author);
            } else {
                this.authorLabel.setText(DATA_NOT_AVAILABLE);
            }
            String documentation = version.getDocumentation();
            if (documentation != null && documentation.length() > 0) {
                documentation = "<a href=\"" + documentation + "\">" + documentation + "</a>";
                this.documentationLink.setText(documentation);
            } else {
                this.documentationLink.setText(DATA_NOT_AVAILABLE);
            }
            this.documentationLink.setData((Object)version);
            return;
        }
        this.descriptionLabel.setText(DATA_NOT_AVAILABLE);
        this.authorLabel.setText(DATA_NOT_AVAILABLE);
        this.documentationLink.setText(DATA_NOT_AVAILABLE);
        this.documentationLink.setData(null);
    }

    protected PluginVersion getSingleSelectedPluginVersion() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.pluginViewer.getTreeViewer().getSelection();
        if (selection != null && selection.size() == 1 && (element = selection.getFirstElement()) instanceof ITreeElement) {
            return ((ITreeElement)element).getVersionModel();
        }
        return null;
    }

    protected void createPluginViewerArea(Composite parent) {
        this.createSearchArea(parent);
        Composite viewerArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(viewerArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerArea);
        Composite treeArea = new Composite(viewerArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(treeArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeArea);
        this.pluginViewer = new GrailsBrowserViewer(this.getColumns());
        this.pluginViewer.createControls(treeArea);
        TreeViewer viewer = this.pluginViewer.getTreeViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PluginManagerDialog.this.refreshDescriptionArea();
                PluginManagerDialog.this.validateOperationButtons();
            }
        });
        viewer.addFilter((ViewerFilter)new PluginStatusFilter());
        viewer.setContentProvider((IContentProvider)new GrailsViewerContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new GrailsViewerLabelProvider());
        viewer.setSorter((ViewerSorter)new GrailsViewerColumnSorter());
        this.createDescriptionArea(treeArea);
        this.createFilterOptionsArea(treeArea);
        this.createOperationButtonArea(viewerArea);
        this.searchPart.connectViewer((StructuredViewer)this.pluginViewer.getTreeViewer());
        this.initIconManager();
    }

    protected void validateOperationButtons() {
        List<ITreeElement> selectedElements = this.getSelectedTreeElements();
        List<Button> operationButtons = this.getPluginOperationButtons();
        boolean disableAll = selectedElements.isEmpty();
        block0: for (Button button : operationButtons) {
            if (disableAll) {
                button.setEnabled(false);
                continue;
            }
            for (ITreeElement element : selectedElements) {
                if (!this.enableOperationButtonState(button, element)) continue block0;
            }
        }
    }

    protected boolean enableOperationButtonState(Button button, ITreeElement element) {
        Object data = button.getData();
        boolean isEnabled = button.getEnabled();
        if (data instanceof PluginOperation) {
            PluginOperation operation = (PluginOperation)((Object)data);
            isEnabled = element.isValidOperation(operation);
            button.setEnabled(isEnabled);
        }
        return isEnabled;
    }

    protected void createOperationButtonArea(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(2, 1).applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        PluginOperation[] types = PluginOperation.values();
        this.selectionBasedOperationButtons = new ArrayList<Button>(types.length);
        PluginOperation[] pluginOperationArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            PluginOperation type = pluginOperationArray[n2];
            Button button = this.createSelectionButton(buttons, type);
            if (button != null && this.isSelectionBasedOperation(type)) {
                this.selectionBasedOperationButtons.add(button);
            }
            ++n2;
        }
    }

    protected boolean isSelectionBasedOperation(PluginOperation operation) {
        if (operation == null) {
            return false;
        }
        switch (operation) {
            case INSTALL: 
            case UNINSTALL: 
            case UPDATE: {
                return true;
            }
        }
        return false;
    }

    protected List<Button> getPluginOperationButtons() {
        return this.selectionBasedOperationButtons;
    }

    protected Button createSelectionButton(Composite parent, PluginOperation type) {
        if (type == null) {
            return null;
        }
        Button button = new Button(parent, 8);
        button.setText(type.getName());
        Point minSize = button.computeSize(-1, -1, true);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        GridDataFactory.fillDefaults().hint(Math.max(widthHint, minSize.x), -1).applyTo((Control)button);
        button.setData((Object)type);
        button.addSelectionListener((SelectionListener)new PluginSelectionButtonListener());
        return button;
    }

    protected PluginColumnType getColumnType(String name) {
        PluginColumnType[] types;
        if (name == null) {
            return null;
        }
        PluginColumnType[] pluginColumnTypeArray = types = PluginColumnType.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            PluginColumnType type = pluginColumnTypeArray[n2];
            if (type.getName().equals(name)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    protected IPluginListColumn[] getColumns() {
        PluginColumnType[] type = PluginColumnType.values();
        IPluginListColumn[] columns = new IPluginListColumn[type.length];
        int i = 0;
        while (i < columns.length && i < type.length) {
            columns[i] = type[i];
            ++i;
        }
        return columns;
    }

    protected void resynchPluginsList(final boolean aggressive) {
        IUIRunnable pluginListCommand = new IUIRunnable(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                PluginManagerDialog.this.pluginList = PluginManagerDialog.this.updatePlugins(aggressive, monitor);
            }

            @Override
            public Shell getShell() {
                return PluginManagerDialog.this.getShell();
            }
        };
        TaskManager.runSynch(pluginListCommand, "Resolving list of available plugins.");
        this.setViewerInput();
    }

    protected abstract Collection<? extends Plugin> updatePlugins(boolean var1, IProgressMonitor var2);

    protected RootTreeElement getRootElement(Plugin plugin) {
        if (plugin == null || this.rootElementMap == null) {
            return null;
        }
        RootTreeElement element = this.rootElementMap.get(plugin);
        if (element == null) {
            element = new RootTreeElement(plugin.getLatestReleasedVersion());
            this.rootElementMap.put(plugin, element);
        }
        return element;
    }

    protected VersionTreeElement getVersionElement(PluginVersion version) {
        if (version == null || this.childElementMap == null) {
            return null;
        }
        VersionTreeElement element = this.childElementMap.get(version);
        if (element == null) {
            RootTreeElement rootElement = this.getRootElement(version.getParent());
            if (rootElement != null) {
                element = new VersionTreeElement(version, rootElement);
                this.childElementMap.put(version, element);
            } else {
                FrameworkUIActivator.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.frameworks.ui", "Orphaned version: " + version.getName() + " " + version.getVersion() + ". Cannot find a published plugin. Omitting from manager plugin's list"));
            }
        }
        return element;
    }

    public Collection<PluginVersion> getSelectedToInstall() {
        return this.selectedToInstall;
    }

    public Collection<PluginVersion> getSelectedtoUninstall() {
        return this.selectedToUninstall;
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    protected void uninstallRoot(RootTreeElement root) {
        if (root == null) {
            return;
        }
        PluginState currentState = root.getPluginState();
        if (currentState == PluginState.SELECT_INSTALL) {
            this.restoreOriginalState(root);
        } else if (currentState == PluginState.INSTALLED || currentState == PluginState.UPDATE_AVAILABLE) {
            VersionTreeElement associatedVersion = root.getSelectedVersionTreeElement();
            this.uninstallVersion(associatedVersion);
        }
    }

    protected void installVersion(VersionTreeElement selectedVersionElement) {
        if (selectedVersionElement == null) {
            return;
        }
        RootTreeElement root = selectedVersionElement.getParent();
        if (root != null) {
            this.restoreOriginalState(root);
            selectedVersionElement.setState(PluginState.SELECT_INSTALL);
            this.addToInstallSelection(selectedVersionElement.getVersionModel());
            root.setSelectedVersionTreeElement(selectedVersionElement);
            root.setState(PluginState.SELECT_INSTALL);
        }
    }

    protected void uninstallVersion(VersionTreeElement selectedVersionElement) {
        if (selectedVersionElement == null) {
            return;
        }
        RootTreeElement root = selectedVersionElement.getParent();
        if (root != null) {
            this.restoreOriginalState(root);
            selectedVersionElement.setState(PluginState.SELECT_UNINSTALL);
            this.addToUninstallSelection(selectedVersionElement.getVersionModel());
            root.setSelectedVersionTreeElement(selectedVersionElement);
            root.setState(PluginState.SELECT_UNINSTALL);
        }
    }

    protected void addToInstallSelection(PluginVersion version) {
        if (version != null && !this.selectedToInstall.contains(version)) {
            this.selectedToInstall.add(version);
            this.removeFromUninstallSelection(version);
        }
    }

    protected void addToUninstallSelection(PluginVersion version) {
        if (version != null && !this.selectedToUninstall.contains(version)) {
            this.selectedToUninstall.add(version);
            this.removeFromInstallSelection(version);
        }
    }

    protected void removeFromInstallSelection(PluginVersion version) {
        this.selectedToInstall.remove(version);
    }

    protected void removeFromUninstallSelection(PluginVersion version) {
        this.selectedToUninstall.remove(version);
    }

    protected void restoreOriginalState(RootTreeElement element) {
        if (element == null) {
            return;
        }
        VersionTreeElement currentSelection = element.getSelectedVersionTreeElement();
        if (currentSelection != null) {
            PluginVersion currentSelectionVersion = currentSelection.getVersionModel();
            this.removeFromInstallSelection(currentSelectionVersion);
            this.removeFromUninstallSelection(currentSelectionVersion);
            currentSelection.setState(null);
            element.setSelectedVersionTreeElement(null);
        }
        PluginState rootState = null;
        Plugin plugin = element.getVersionModel().getParent();
        PluginVersion childVersion = plugin.getInstalled();
        PluginState childState = null;
        if (childVersion != null) {
            rootState = this.getOriginalStateOfRootPlugin(childVersion);
            childState = PluginState.INSTALLED;
        } else {
            childVersion = plugin.getLatestReleasedVersion();
        }
        VersionTreeElement associatedElement = this.getVersionElement(childVersion);
        associatedElement.setState(childState);
        element.setSelectedVersionTreeElement(associatedElement);
        element.setState(rootState);
    }

    protected PluginState getOriginalStateOfRootPlugin(PluginVersion version) {
        if (version == null) {
            return null;
        }
        if (version.getParent().isInstalled()) {
            return this.hasUpdate(version) ? PluginState.UPDATE_AVAILABLE : PluginState.INSTALLED;
        }
        return null;
    }

    protected void updateRootElement(RootTreeElement selectedElement) {
        if (selectedElement == null) {
            return;
        }
        VersionTreeElement latestVersionElement = this.getVersionElement(selectedElement.getVersionModel().getParent().getLatestReleasedVersion());
        this.installVersion(latestVersionElement);
    }

    protected void handleUpdateAll() {
        List rootElements = (List)this.pluginViewer.getTreeViewer().getInput();
        for (ITreeElement rootElement : rootElements) {
            if (rootElement.getPluginState() != PluginState.UPDATE_AVAILABLE || !(rootElement instanceof RootTreeElement)) continue;
            this.updateRootElement((RootTreeElement)rootElement);
        }
        this.validateOperationButtons();
        this.refreshViewer(true);
    }

    protected boolean hasUpdate(PluginVersion version) {
        boolean isPreinstalledPlugin = this.isPreinstalled(version);
        return !isPreinstalledPlugin && version.getParent().hasUpdate();
    }

    protected abstract boolean isPreinstalled(PluginVersion var1);

    protected boolean isViewerDisposed() {
        if (this.pluginViewer == null) {
            return true;
        }
        Tree tree = this.pluginViewer.getTreeViewer().getTree();
        if (tree == null) {
            return true;
        }
        return tree.isDisposed();
    }

    protected void setViewerInput() {
        this.clearAllPluginChanges();
        this.rootElementMap = new HashMap<Plugin, RootTreeElement>();
        this.childElementMap = new HashMap<PluginVersion, VersionTreeElement>();
        ArrayList<RootTreeElement> input = new ArrayList<RootTreeElement>();
        if (this.pluginList != null && !this.pluginList.isEmpty()) {
            for (Plugin plugin : this.pluginList) {
                RootTreeElement treeElement = this.getRootElement(plugin);
                if (treeElement == null) continue;
                this.restoreOriginalState(treeElement);
                input.add(treeElement);
            }
        }
        if (!this.isViewerDisposed()) {
            this.pluginViewer.getTreeViewer().setInput(input);
            this.refreshViewer(true);
        }
    }

    protected void refreshViewer(boolean updateLabel) {
        if (!this.isViewerDisposed()) {
            this.pluginViewer.getTreeViewer().refresh(updateLabel);
        }
    }

    protected List<ITreeElement> getSelectedTreeElements() {
        IStructuredSelection selection = (IStructuredSelection)this.pluginViewer.getTreeViewer().getSelection();
        ArrayList<ITreeElement> selectedElements = new ArrayList<ITreeElement>();
        if (selection != null) {
            for (Object selectedObj : selection) {
                if (!(selectedObj instanceof ITreeElement)) continue;
                selectedElements.add((ITreeElement)selectedObj);
            }
        }
        return selectedElements;
    }

    protected void handleSelectionBasedOperations(PluginOperation type) {
        if (type == null) {
            return;
        }
        List<ITreeElement> selectedElements = this.getSelectedTreeElements();
        for (ITreeElement element : selectedElements) {
            if (!element.isValidOperation(type)) continue;
            element.performOperation(type);
        }
        this.validateOperationButtons();
    }

    protected void collapseAll() {
        this.pluginViewer.getTreeViewer().collapseAll();
    }

    protected class GrailsBrowserViewer
    extends TreeViewerComposite {
        public GrailsBrowserViewer(IPluginListColumn[] columns) {
            super(columns, columns[PluginColumnType.PLUGIN_NAME.ordinal()]);
        }

        public void refreshFilter(GrailsFilterType type) {
            PluginStatusFilter filter = this.getPluginStatusFilter();
            if (filter != null) {
                filter.setFilterType(type);
                PluginManagerDialog.this.refreshViewer(false);
            }
        }

        protected PluginStatusFilter getPluginStatusFilter() {
            ViewerFilter[] filters = this.getTreeViewer().getFilters();
            if (filters != null) {
                ViewerFilter[] viewerFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter filter = viewerFilterArray[n2];
                    if (filter instanceof PluginStatusFilter) {
                        return (PluginStatusFilter)filter;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static enum GrailsFilterType {
        SHOW_ALL("Show all", true),
        SHOW_INSTALLED_ONLY("Show installed only", false),
        SHOW_AVAILABLE_UPDATES_ONLY("Show available updates only", false),
        SHOW_CHANGES_ONLY("Show pending changes only", false);

        private String filterName;
        private boolean defaultSelection;

        private GrailsFilterType(String filterName, boolean defaultSelection) {
            this.filterName = filterName;
            this.defaultSelection = defaultSelection;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public boolean getDefaultSelection() {
            return this.defaultSelection;
        }
    }

    protected class GrailsViewerColumnSorter
    extends TreeViewerColumnComparator {
        protected GrailsViewerColumnSorter() {
        }

        @Override
        protected String getCompareString(TreeColumn column, Object rowItem) {
            if (rowItem instanceof ITreeElement) {
                ITreeElement element = (ITreeElement)rowItem;
                PluginColumnType type = PluginManagerDialog.this.getColumnType(column.getText());
                PluginVersion version = element.getVersionModel();
                if (type != null) {
                    switch (type) {
                        case PLUGIN_STATE: 
                        case PLUGIN_NAME: {
                            return version.getName();
                        }
                        case TITLE: {
                            return version.getTitle();
                        }
                        case VERSION: {
                            return version.getVersion();
                        }
                    }
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(viewer instanceof TreeViewer)) return super.compare(viewer, e1, e2);
            Tree tree = ((TreeViewer)viewer).getTree();
            if (!(e1 instanceof ITreeElement) || !(e2 instanceof ITreeElement)) return super.compare(viewer, e1, e2);
            ITreeElement treeElement1 = (ITreeElement)e1;
            ITreeElement treeElement2 = (ITreeElement)e2;
            PluginVersion pluginVersion1 = treeElement1.getVersionModel();
            PluginVersion pluginVersion2 = treeElement2.getVersionModel();
            PluginState state1 = treeElement1.getPluginState();
            PluginState state2 = treeElement2.getPluginState();
            if (e1 instanceof RootTreeElement && e2 instanceof RootTreeElement) {
                int sortOrder = -1;
                int sortDirection = tree.getSortDirection();
                boolean isInPlaceElement1 = treeElement1.getVersionModel().getParent().isInPlace();
                boolean isInPlaceElement2 = treeElement2.getVersionModel().getParent().isInPlace();
                if (isInPlaceElement1) {
                    if (isInPlaceElement2) {
                        return super.compare(viewer, e1, e2);
                    }
                    sortOrder = -1;
                    return sortDirection == 128 ? sortOrder : -sortOrder;
                } else if (isInPlaceElement2) {
                    sortOrder = 1;
                    return sortDirection == 128 ? sortOrder : -sortOrder;
                } else {
                    TreeColumn sortColumn = tree.getSortColumn();
                    if (sortColumn == null) {
                        return 0;
                    }
                    PluginColumnType type = PluginManagerDialog.this.getColumnType(sortColumn.getText());
                    if (type != PluginColumnType.PLUGIN_STATE) return super.compare(viewer, e1, e2);
                    if (state1 != null) {
                        if (state2 != null) {
                            int stateComparison = state1.ordinal() - state2.ordinal();
                            if (stateComparison == 0) {
                                return super.compare(viewer, e1, e2);
                            }
                            sortOrder = stateComparison;
                            return sortDirection == 128 ? sortOrder : -sortOrder;
                        } else {
                            sortOrder = -1;
                        }
                        return sortDirection == 128 ? sortOrder : -sortOrder;
                    } else {
                        if (state2 == null) return super.compare(viewer, e1, e2);
                        sortOrder = 1;
                    }
                }
                return sortDirection == 128 ? sortOrder : -sortOrder;
            }
            if (!(e1 instanceof VersionTreeElement) || !(e2 instanceof VersionTreeElement)) return super.compare(viewer, e1, e2);
            String versionID1 = pluginVersion1.getVersion();
            String versionID2 = pluginVersion2.getVersion();
            if (versionID1 != null) {
                if (versionID2 == null) return -1;
                return versionID2.compareTo(versionID1);
            }
            if (versionID2 == null) return super.compare(viewer, e1, e2);
            return 1;
        }
    }

    protected class GrailsViewerContentProvider
    implements ITreePathContentProvider {
        protected GrailsViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                ArrayList publishedPlugins = new ArrayList();
                Collection topLevel = (Collection)inputElement;
                for (Object possibleTreeElement : topLevel) {
                    if (!(possibleTreeElement instanceof RootTreeElement)) continue;
                    publishedPlugins.add(possibleTreeElement);
                }
                return publishedPlugins.toArray();
            }
            return null;
        }

        public Object[] getChildren(TreePath path) {
            RootTreeElement treeElement;
            PluginVersion topLevelPlugin;
            List versions;
            Object lastElement = path.getLastSegment();
            if (lastElement instanceof RootTreeElement && (versions = (topLevelPlugin = (treeElement = (RootTreeElement)lastElement).getVersionModel()).getParent().getVersions()) != null) {
                ArrayList<VersionTreeElement> children = new ArrayList<VersionTreeElement>();
                for (PluginVersion version : versions) {
                    VersionTreeElement versionTreeElement = PluginManagerDialog.this.getVersionElement(version);
                    if (versionTreeElement == null) continue;
                    children.add(versionTreeElement);
                }
                return children.toArray();
            }
            return null;
        }

        public TreePath[] getParents(Object element) {
            VersionTreeElement pluginElement;
            RootTreeElement parentElementElement;
            if (element instanceof VersionTreeElement && (parentElementElement = (pluginElement = (VersionTreeElement)element).getParent()) != null) {
                TreePath path = new TreePath(new Object[]{parentElementElement});
                return new TreePath[]{path};
            }
            return new TreePath[0];
        }

        public boolean hasChildren(TreePath path) {
            return this.getChildren(path) != null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object e1, Object e2) {
        }
    }

    protected class GrailsViewerLabelProvider
    extends ColumnLabelProvider {
        protected GrailsViewerLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            int index = cell.getColumnIndex();
            cell.setText(this.getColumnText(element, index));
            cell.setImage(this.getColumnImage(element, index));
            cell.setFont(this.getFont(element));
        }

        public Image getColumnImage(Object element, int index) {
            PluginState state;
            PluginColumnType type;
            PluginColumnType[] values;
            if (element instanceof ITreeElement && index < (values = PluginColumnType.values()).length && (type = values[index]) == PluginColumnType.PLUGIN_STATE && (state = ((ITreeElement)element).getPluginState()) != null && PluginManagerDialog.this.iconManager != null) {
                return PluginManagerDialog.this.iconManager.getIcon(state);
            }
            return null;
        }

        public Font getFont(Object element) {
            Plugin pluginModel;
            if (element instanceof ITreeElement && (pluginModel = ((ITreeElement)element).getVersionModel().getParent()).isInPlace()) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return super.getFont(element);
        }

        public String getColumnText(Object element, int index) {
            PluginColumnType[] values;
            if (element instanceof ITreeElement && index < (values = PluginColumnType.values()).length) {
                PluginColumnType type = values[index];
                PluginVersion version = ((ITreeElement)element).getVersionModel();
                String text = null;
                switch (type) {
                    case PLUGIN_NAME: {
                        text = version.getName();
                        break;
                    }
                    case TITLE: {
                        text = version.getTitle();
                        break;
                    }
                    case VERSION: {
                        text = version.getVersion();
                    }
                }
                if (text != null) {
                    return text;
                }
            }
            return null;
        }
    }

    protected class InternalMessageDialogue
    extends MessageDialog {
        private boolean closeManager;

        public InternalMessageDialogue(String title, String dialogMessage, int dialogueType, boolean closeManager) {
            super(PluginManagerDialog.this.getShell(), title, null, dialogMessage, dialogueType, new String[]{"OK"}, 0);
            this.closeManager = closeManager;
        }

        public boolean close() {
            boolean messageClose = super.close();
            if (this.closeManager) {
                PluginManagerDialog.this.cancelPressed();
            }
            return messageClose;
        }
    }

    public static enum PluginColumnType implements IPluginListColumn
    {
        PLUGIN_STATE("", 12),
        PLUGIN_NAME("Name", 20),
        TITLE("Title", 80),
        VERSION("Version", 10);

        private String name;
        private int weight;

        private PluginColumnType(String name, int weight) {
            this.name = name;
            this.weight = weight;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getWidth() {
            return this.weight;
        }
    }

    protected class PluginSelectionButtonListener
    extends SelectionAdapter {
        protected PluginSelectionButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object dataObj;
            Widget widget = e.widget;
            if (widget instanceof Button && (dataObj = ((Button)widget).getData()) instanceof PluginOperation) {
                PluginOperation type = (PluginOperation)((Object)dataObj);
                switch (type) {
                    case REFRESH: {
                        PluginManagerDialog.this.resynchPluginsList(true);
                        break;
                    }
                    case UPDATE_ALL: {
                        PluginManagerDialog.this.handleUpdateAll();
                        break;
                    }
                    case RESET: {
                        PluginManagerDialog.this.setViewerInput();
                        break;
                    }
                    case COLLAPSE_ALL: {
                        PluginManagerDialog.this.collapseAll();
                        break;
                    }
                    default: {
                        PluginManagerDialog.this.handleSelectionBasedOperations(type);
                    }
                }
            }
        }
    }

    protected class PluginStatusFilter
    extends ViewerFilter {
        private GrailsFilterType option = GrailsFilterType.SHOW_ALL;

        protected PluginStatusFilter() {
        }

        public void setFilterType(GrailsFilterType option) {
            this.option = option;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof RootTreeElement) {
                RootTreeElement treeElement = (RootTreeElement)element;
                PluginState state = treeElement.getPluginState();
                if (this.option != null) {
                    switch (this.option) {
                        case SHOW_AVAILABLE_UPDATES_ONLY: {
                            if (state == PluginState.UPDATE_AVAILABLE) break;
                            return PluginManagerDialog.this.hasUpdate(treeElement.getVersionModel());
                        }
                        case SHOW_CHANGES_ONLY: {
                            if (state == PluginState.SELECT_INSTALL || state == PluginState.SELECT_UNINSTALL) break;
                            return false;
                        }
                        case SHOW_INSTALLED_ONLY: {
                            if (state == null) {
                                return false;
                            }
                            return treeElement.getVersionModel().getParent().isInstalled();
                        }
                    }
                }
            }
            return true;
        }
    }

    public class RootTreeElement
    extends TreeElement {
        private VersionTreeElement associatedVersion;

        public RootTreeElement(PluginVersion version) {
            super(version);
        }

        public void setSelectedVersionTreeElement(VersionTreeElement associatedVersion) {
            this.associatedVersion = associatedVersion;
        }

        public VersionTreeElement getSelectedVersionTreeElement() {
            return this.associatedVersion;
        }

        @Override
        public PluginVersion getVersionModel() {
            return this.getSelectedVersionTreeElement() != null ? this.getSelectedVersionTreeElement().getVersionModel() : super.getVersionModel();
        }

        @Override
        protected boolean canHandleInstall(PluginState state) {
            return state == PluginState.SELECT_UNINSTALL || state == null;
        }

        @Override
        protected boolean canHandleUninstall(PluginState state) {
            return state != PluginState.SELECT_UNINSTALL && state != null;
        }

        @Override
        protected boolean canHandleUpdate(PluginState currentState) {
            PluginVersion associatedModelVersion;
            PluginVersion latestVersion;
            if (currentState == null || currentState == PluginState.INSTALLED) {
                return false;
            }
            if (currentState == PluginState.UPDATE_AVAILABLE) {
                return true;
            }
            PluginState originalState = PluginManagerDialog.this.getOriginalStateOfRootPlugin(this.getVersionModel());
            return originalState == PluginState.UPDATE_AVAILABLE && (currentState == PluginState.SELECT_INSTALL ? Plugin.isVersionHigher((PluginVersion)(latestVersion = this.getVersionModel().getParent().getLatestReleasedVersion()), (PluginVersion)(associatedModelVersion = this.getSelectedVersionTreeElement().getVersionModel())) : currentState == PluginState.SELECT_UNINSTALL);
        }

        @Override
        protected void handleInstall(PluginState state) {
            if (state == PluginState.SELECT_UNINSTALL) {
                PluginManagerDialog.this.restoreOriginalState(this);
            } else if (state == null) {
                VersionTreeElement associatedVersion = this.getSelectedVersionTreeElement();
                PluginManagerDialog.this.installVersion(associatedVersion);
            }
        }

        @Override
        protected void handleUninstall(PluginState state) {
            PluginManagerDialog.this.uninstallRoot(this);
        }

        @Override
        protected void handleUpdate(PluginState state) {
            PluginManagerDialog.this.updateRootElement(this);
        }
    }

    public abstract class TreeElement
    extends AbstractTreeElement {
        public TreeElement(PluginVersion version) {
            super(version);
        }

        @Override
        public void performOperation(PluginOperation type) {
            super.performOperation(type);
            PluginManagerDialog.this.refreshViewer(true);
        }
    }

    public class VersionTreeElement
    extends TreeElement {
        private RootTreeElement parent;

        public VersionTreeElement(PluginVersion version, RootTreeElement parent) {
            super(version);
            this.parent = parent;
        }

        public RootTreeElement getParent() {
            return this.parent;
        }

        @Override
        protected boolean canHandleInstall(PluginState state) {
            if (state == null) {
                PluginState rootState = this.getParent().getPluginState();
                if (rootState == null) {
                    return true;
                }
                PluginState originalState = PluginManagerDialog.this.getOriginalStateOfRootPlugin(this.getVersionModel());
                if (originalState == null) {
                    return true;
                }
            } else if (state == PluginState.SELECT_UNINSTALL) {
                return true;
            }
            return false;
        }

        @Override
        protected boolean canHandleUninstall(PluginState state) {
            return state == PluginState.SELECT_INSTALL || state == PluginState.INSTALLED;
        }

        @Override
        protected boolean canHandleUpdate(PluginState state) {
            if (state == null) {
                PluginState currentRootState = this.getParent().getPluginState();
                if (currentRootState == PluginState.UPDATE_AVAILABLE || currentRootState == PluginState.INSTALLED) {
                    return true;
                }
                PluginState originalPluginState = PluginManagerDialog.this.getOriginalStateOfRootPlugin(this.getVersionModel());
                if (originalPluginState == PluginState.UPDATE_AVAILABLE || originalPluginState == PluginState.INSTALLED) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void handleInstall(PluginState state) {
            RootTreeElement rootElement = this.getParent();
            if (state == PluginState.SELECT_UNINSTALL) {
                PluginManagerDialog.this.restoreOriginalState(rootElement);
            } else {
                PluginManagerDialog.this.installVersion(this);
            }
        }

        @Override
        protected void handleUninstall(PluginState state) {
            if (state == PluginState.INSTALLED) {
                PluginManagerDialog.this.uninstallVersion(this);
            } else {
                RootTreeElement root = this.getParent();
                PluginManagerDialog.this.restoreOriginalState(root);
            }
        }

        @Override
        protected void handleUpdate(PluginState state) {
            PluginManagerDialog.this.installVersion(this);
        }
    }

    protected class ViewerFilterButtonListener
    extends SelectionAdapter {
        protected ViewerFilterButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object dataObj;
            Button button;
            Widget widget = e.widget;
            if (widget instanceof Button && (button = (Button)widget).getSelection() && (dataObj = button.getData()) instanceof GrailsFilterType) {
                PluginManagerDialog.this.pluginViewer.refreshFilter((GrailsFilterType)((Object)dataObj));
            }
        }
    }
}

