/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors;

import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterKind;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist.JavaContentAssistUIAdapter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.BaseParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.BooleanParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.ComboParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.IParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.JavaParameterEditor;

public class ParameterEditorFactory {
    public static IParameterEditor getParameterEditor(ICommandParameter parameter, boolean showLabel) {
        if (parameter == null) {
            return null;
        }
        ParameterKind kind = parameter.getParameterDescriptor().getParameterKind();
        switch (kind) {
            case BASE: {
                return new BaseParameterEditor(parameter, showLabel);
            }
            case COMBO: {
                return new ComboParameterEditor(parameter, showLabel);
            }
        }
        return null;
    }

    public static IParameterEditor getBooleanParameterEditor(ICommandParameter parameter) {
        ParameterKind kind = parameter.getParameterDescriptor().getParameterKind();
        if (kind == ParameterKind.BOOLEAN) {
            return new BooleanParameterEditor(parameter);
        }
        return null;
    }

    public static IParameterEditor getJavaParameterEditor(ICommandParameter parameter, JavaContentAssistUIAdapter adapter, boolean showLabel) {
        if (parameter == null || parameter.getParameterDescriptor().getParameterKind() != ParameterKind.JAVA_TYPE) {
            return null;
        }
        return new JavaParameterEditor(parameter, adapter, showLabel);
    }
}

