/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.autowire.internal.provider;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.autowire.IFactoryBeanTypeResolver;

public class FactoryBeanTypeResolverExtensions {
    private static final String FACTORY_TYPE_RESOLVERS_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.core.autowire.factorybeantyperesolvers";
    private static final Object FACTORY_TYPE_RESOLVER_ELEMENT = "factoryBeanTypeResolver";
    private static final String CLASS_ATTRIBUTE = "class";
    private static IFactoryBeanTypeResolver[] resolvers;

    public static void setFactoryBeanTypeResolvers(IFactoryBeanTypeResolver[] resolvers) {
        FactoryBeanTypeResolverExtensions.resolvers = resolvers;
    }

    public static IFactoryBeanTypeResolver[] getFactoryBeanTypeResolvers() {
        if (resolvers == null) {
            FactoryBeanTypeResolverExtensions.initializeResolvers();
        }
        return resolvers;
    }

    private static void initializeResolvers() {
        ArrayList<IFactoryBeanTypeResolver> resolverExtensions = new ArrayList<IFactoryBeanTypeResolver>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(FACTORY_TYPE_RESOLVERS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (FACTORY_TYPE_RESOLVER_ELEMENT.equals(config.getName()) && config.getAttribute(CLASS_ATTRIBUTE) != null) {
                        try {
                            Object handler = config.createExecutableExtension(CLASS_ATTRIBUTE);
                            if (handler instanceof IFactoryBeanTypeResolver) {
                                resolverExtensions.add((IFactoryBeanTypeResolver)handler);
                            }
                        }
                        catch (CoreException e) {
                            BeansCorePlugin.log((Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        resolvers = resolverExtensions.toArray(new IFactoryBeanTypeResolver[resolverExtensions.size()]);
    }
}

