/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.autowire;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.AutowireUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.util.ObjectUtils;

public class AutowireBeanReference
extends org.springframework.ide.eclipse.beans.core.internal.model.BeanReference {
    private IJavaElement source;
    private ISourceModelElement parent;
    private int parameterIndex = -1;

    public AutowireBeanReference(ISourceModelElement parent, BeanReference beanRef) {
        super(parent, beanRef);
        this.parent = parent;
    }

    public void setSource(Field field) {
        this.setSource(field, -1);
    }

    public void setSource(Member member, int index) {
        IResource resource = ((IResourceModelElement)BeansModelUtils.getParentOfClass((IModelElement)this.parent, IResourceModelElement.class)).getElementResource();
        this.source = AutowireUtils.getJavaElement(resource, member, index);
        if (this.source != null) {
            try {
                this.parameterIndex = index;
                this.setElementSourceLocation((IModelSourceLocation)new JavaModelSourceLocation(this.source));
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public IJavaElement getSource() {
        return this.source;
    }

    public int hashCode() {
        return super.hashCode() * 31 ^ ObjectUtils.nullSafeHashCode((Object)this.source) * this.parameterIndex;
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.source.equals(((AutowireBeanReference)((Object)other)).source) && this.parameterIndex == ((AutowireBeanReference)((Object)other)).parameterIndex;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [" + this.source + "]";
    }
}

