/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeanRelation;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansGroup;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansModel;
import org.springframework.ide.eclipse.beans.ui.livegraph.views.LiveBeansGraphView;

public class LiveBeansTreeContentProvider
implements ITreeContentProvider {
    private final LiveBeansGraphView view;

    public LiveBeansTreeContentProvider(LiveBeansGraphView view) {
        this.view = view;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LiveBeansGroup) {
            LiveBeansGroup group = (LiveBeansGroup)parentElement;
            return group.getBeans().toArray();
        }
        if (parentElement instanceof LiveBean) {
            HashSet<LiveBeanRelation> children = new HashSet<LiveBeanRelation>();
            LiveBean bean = (LiveBean)parentElement;
            Set<LiveBean> dependencies = bean.getDependencies();
            for (LiveBean child : dependencies) {
                children.add(new LiveBeanRelation(child, true));
            }
            Set<LiveBean> injectInto = bean.getInjectedInto();
            for (LiveBean child : injectInto) {
                children.add(new LiveBeanRelation(child));
            }
            return children.toArray();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof LiveBeansModel) {
            LiveBeansModel model = (LiveBeansModel)inputElement;
            if (this.view.getGroupByMode() == 0) {
                return model.getBeansByResource().toArray();
            }
            if (this.view.getGroupByMode() == 1) {
                return model.getBeansByContext().toArray();
            }
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof LiveBeansGroup) {
            return true;
        }
        if (element instanceof LiveBean) {
            LiveBean bean = (LiveBean)element;
            return !bean.getDependencies().isEmpty() || !bean.getInjectedInto().isEmpty();
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

