/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CauseParameterInExceptionCheck
extends Check {
    private static final String WARNING_MSG_KEY = "cause.parameter.in.exception";
    private Pattern mClassNamesRegexp = Pattern.compile(".+Exception");
    private Pattern mIgnoredClassNamesRegexp = Pattern.compile("");
    private Set<String> mAllowedCauseTypes = new HashSet<String>();
    private List<DetailAST> mExceptionClassesToWarn = new LinkedList<DetailAST>();

    public CauseParameterInExceptionCheck() {
        this.mAllowedCauseTypes.add("Exception");
        this.mAllowedCauseTypes.add("Throwable");
    }

    public void setClassNamesRegexp(String aClassNamesRegexp) {
        String regexp = aClassNamesRegexp == null ? "" : aClassNamesRegexp;
        this.mClassNamesRegexp = Pattern.compile(regexp);
    }

    public void setIgnoredClassNamesRegexp(String aIgnoredClassNamesRegexp) {
        String regexp = aIgnoredClassNamesRegexp == null ? "" : aIgnoredClassNamesRegexp;
        this.mIgnoredClassNamesRegexp = Pattern.compile(regexp);
    }

    public void setAllowedCauseTypes(String[] aAllowedCauseTypes) {
        this.mAllowedCauseTypes.clear();
        if (aAllowedCauseTypes != null) {
            for (String name : aAllowedCauseTypes) {
                this.mAllowedCauseTypes.add(name);
            }
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{14, 8};
    }

    public void visitToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 14: {
                String exceptionClassName = CauseParameterInExceptionCheck.getName(aAst);
                if (!this.mClassNamesRegexp.matcher(exceptionClassName).matches() || this.mIgnoredClassNamesRegexp.matcher(exceptionClassName).matches()) break;
                this.mExceptionClassesToWarn.add(aAst);
                break;
            }
            case 8: {
                DetailAST exceptionClass = CauseParameterInExceptionCheck.getClassDef(aAst);
                if (!this.mExceptionClassesToWarn.contains(exceptionClass) || !this.hasCauseAsParameter(aAst)) break;
                this.mExceptionClassesToWarn.remove(exceptionClass);
                break;
            }
            default: {
                String className = ((Object)((Object)this)).getClass().getSimpleName();
                String tokenType = TokenTypes.getTokenName((int)aAst.getType());
                String tokenDescription = aAst.toString();
                String message = String.format("%s got the wrong input token: %s (%s)", className, tokenType, tokenDescription);
                throw new IllegalArgumentException(message);
            }
        }
    }

    public void finishTree(DetailAST aTreeRootAST) {
        for (DetailAST classDefNode : this.mExceptionClassesToWarn) {
            this.log(classDefNode, WARNING_MSG_KEY, new Object[]{CauseParameterInExceptionCheck.getName(classDefNode)});
        }
        this.mExceptionClassesToWarn.clear();
    }

    private boolean hasCauseAsParameter(DetailAST aCtorDefNode) {
        boolean result = false;
        DetailAST parameters = aCtorDefNode.findFirstToken(20);
        for (String parameterType : CauseParameterInExceptionCheck.getParameterTypes(parameters)) {
            if (!this.mAllowedCauseTypes.contains(parameterType)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<String> getParameterTypes(DetailAST aParametersAST) {
        LinkedList<String> result = new LinkedList<String>();
        for (DetailAST parametersChild : CauseParameterInExceptionCheck.getChildren(aParametersAST)) {
            if (parametersChild.getType() != 21) continue;
            DetailAST parameterType = parametersChild.findFirstToken(13);
            String parameter = parameterType.getFirstChild().getText();
            result.add(parameter);
        }
        return result;
    }

    private static String getName(DetailAST aClassOrCtorDefNode) {
        DetailAST classNameIdent = aClassOrCtorDefNode.findFirstToken(58);
        return classNameIdent.getText();
    }

    private static DetailAST getClassDef(DetailAST aNode) {
        DetailAST curNode;
        for (curNode = aNode; curNode != null && curNode.getType() != 14; curNode = curNode.getParent()) {
        }
        return curNode;
    }

    private static List<DetailAST> getChildren(DetailAST aNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = aNode.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

