/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class SimpleAccessorNameNotationCheck
extends Check {
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private String prefix = "";

    public void setPrefix(String aPrefix) {
        this.prefix = aPrefix;
    }

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST aMethodDef) {
        String methodName = aMethodDef.findFirstToken(58).getText();
        if (SimpleAccessorNameNotationCheck.hasBody(aMethodDef) && !SimpleAccessorNameNotationCheck.isMethodAtAnonymousClass(aMethodDef)) {
            if (methodName.startsWith(BOOLEAN_GETTER_PREFIX)) {
                if (!this.isGetterCorrect(aMethodDef, methodName.substring(BOOLEAN_GETTER_PREFIX.length()))) {
                    this.log(aMethodDef.getLineNo(), "incorrect.getter.name", new Object[0]);
                }
            } else if (methodName.startsWith(SETTER_PREFIX)) {
                if (!this.isSetterCorrect(aMethodDef, methodName.substring(SETTER_PREFIX.length()))) {
                    this.log(aMethodDef.getLineNo(), "incorrect.setter.name", new Object[0]);
                }
            } else if (methodName.startsWith(GETTER_PREFIX) && !this.isGetterCorrect(aMethodDef, methodName.substring(GETTER_PREFIX.length()))) {
                this.log(aMethodDef.getLineNo(), "incorrect.getter.name", new Object[0]);
            }
        }
    }

    private boolean isSetterCorrect(DetailAST aMethodDef, String aMethodName) {
        DetailAST currentVerifiedTop;
        DetailAST methodType = aMethodDef.findFirstToken(13);
        boolean result = true;
        if (methodType.branchContains(49) && SimpleAccessorNameNotationCheck.containsOnlyExpression(currentVerifiedTop = aMethodDef.findFirstToken(7))) {
            DetailAST parameters;
            String nameOfSettingField;
            boolean containsOnlyOneAssignment;
            boolean bl = containsOnlyOneAssignment = (currentVerifiedTop = currentVerifiedTop.getFirstChild()).getChildCount() == 1 && currentVerifiedTop.getFirstChild().getType() == 80;
            if (containsOnlyOneAssignment && (nameOfSettingField = SimpleAccessorNameNotationCheck.getNameOfSettingField(currentVerifiedTop = currentVerifiedTop.getFirstChild(), parameters = aMethodDef.findFirstToken(20))) != null && this.verifyFieldAndMethodName(nameOfSettingField, aMethodName)) {
                result = false;
            }
        }
        return result;
    }

    private boolean isGetterCorrect(DetailAST aMethodDef, String aMethodName) {
        String nameOfGettingField;
        DetailAST currentVerifiedTop;
        DetailAST parameters = aMethodDef.findFirstToken(20);
        boolean result = true;
        if (parameters.getChildCount() == 0 && SimpleAccessorNameNotationCheck.containsOnlyReturn(currentVerifiedTop = aMethodDef.findFirstToken(7)) && SimpleAccessorNameNotationCheck.isCorrectReturn(currentVerifiedTop = currentVerifiedTop.getFirstChild()) && (nameOfGettingField = SimpleAccessorNameNotationCheck.getNameOfGettingField(currentVerifiedTop = currentVerifiedTop.getFirstChild())) != null && this.verifyFieldAndMethodName(nameOfGettingField, aMethodName)) {
            result = false;
        }
        return result;
    }

    private static boolean containsOnlyExpression(DetailAST aObjectBlock) {
        return aObjectBlock.getChildCount() == 3 && aObjectBlock.getFirstChild().getType() == 28 && aObjectBlock.findFirstToken(45) != null;
    }

    private static String getNameOfSettingField(DetailAST aAssign, DetailAST aParameters) {
        String nameOfSettingField = null;
        DetailAST assigningFirstChild = aAssign.getFirstChild();
        if (aAssign.getChildCount() == 2 && aAssign.getLastChild().getType() == 58) {
            if (assigningFirstChild.getType() == 58) {
                nameOfSettingField = assigningFirstChild.getText();
                if (SimpleAccessorNameNotationCheck.checkNameOfParameters(aParameters, nameOfSettingField)) {
                    nameOfSettingField = null;
                }
            } else if (assigningFirstChild.getType() == 59 && assigningFirstChild.getChildCount() == 2 && "this".equals(assigningFirstChild.getFirstChild().getText()) && assigningFirstChild.getLastChild().getType() == 58) {
                nameOfSettingField = assigningFirstChild.getLastChild().getText();
            }
        }
        return nameOfSettingField;
    }

    private boolean verifyFieldAndMethodName(String aFieldName, String aMethodName) {
        String methodName = this.prefix + aMethodName;
        return !aFieldName.equalsIgnoreCase(methodName);
    }

    private static boolean containsOnlyReturn(DetailAST aMethodBody) {
        return aMethodBody.getFirstChild().getType() == 88;
    }

    private static boolean isCorrectReturn(DetailAST aReturn) {
        return aReturn.getChildCount() == 2 && aReturn.getFirstChild().getType() == 28 && aReturn.getLastChild().getType() == 45;
    }

    private static String getNameOfGettingField(DetailAST aExpr) {
        String nameOfGettingField = null;
        if (aExpr.getChildCount() == 1) {
            DetailAST exprFirstChild = aExpr.getFirstChild();
            if (exprFirstChild.getType() == 58) {
                nameOfGettingField = exprFirstChild.getText();
            } else if (exprFirstChild.getType() == 59 && exprFirstChild.getChildCount() == 2 && exprFirstChild.getFirstChild().getType() == 78 && exprFirstChild.getLastChild().getType() == 58) {
                nameOfGettingField = exprFirstChild.getLastChild().getText();
            }
        }
        return nameOfGettingField;
    }

    private static boolean checkNameOfParameters(DetailAST aParamrters, String aFieldName) {
        boolean isNameOfParameter = false;
        int parametersChildCount = aParamrters.getChildCount();
        DetailAST parameterDef = aParamrters.findFirstToken(21);
        for (int i = 0; i < parametersChildCount && !isNameOfParameter; ++i) {
            isNameOfParameter = parameterDef.findFirstToken(58).getText().equals(aFieldName);
        }
        return isNameOfParameter;
    }

    private static boolean isMethodAtAnonymousClass(DetailAST aMethodDef) {
        DetailAST classObjBlock = aMethodDef.getParent();
        return classObjBlock.getParent().getType() == 136;
    }

    private static boolean hasBody(DetailAST aMethodDef) {
        DetailAST body = aMethodDef.findFirstToken(7);
        return body != null;
    }
}

