/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnCountExtendedCheck
extends Check {
    private static final String WARNING_MSG_KEY_METHOD = "return.count.extended.method";
    private static final String WARNING_MSG_KEY_CTOR = "return.count.extended.ctor";
    private static final int DEFAULT_MAX_RETURN_COUNT = 1;
    private static final int DEFAULT_IGNORE_METHOD_LINES_COUNT = 20;
    private static final int DEFAULT_MIN_IGNORE_RETURN_DEPTH = 4;
    private static final int DEFAULT_TOP_LINES_TO_IGNORE_COUNT = 5;
    private Set<String> mIgnoreMethodsNames = new HashSet<String>();
    private int mMaxReturnCount = 1;
    private int mIgnoreMethodLinesCount = 20;
    private int mMinIgnoreReturnDepth = 4;
    private boolean mIgnoreEmptyReturns = true;
    private int mTopLinesToIgnoreCount = 5;

    public void setIgnoreMethodsNames(String[] aIgnoreMethodNames) {
        this.mIgnoreMethodsNames.clear();
        if (aIgnoreMethodNames != null) {
            for (String name : aIgnoreMethodNames) {
                this.mIgnoreMethodsNames.add(name);
            }
        }
    }

    public void setMaxReturnCount(int aMaxReturnCount) {
        this.mMaxReturnCount = aMaxReturnCount;
    }

    public void setIgnoreMethodLinesCount(int aIgnoreMethodLinesCount) {
        this.mIgnoreMethodLinesCount = aIgnoreMethodLinesCount;
    }

    public void setMinIgnoreReturnDepth(int aMinIgnoreReturnDepth) {
        this.mMinIgnoreReturnDepth = aMinIgnoreReturnDepth;
    }

    public void setIgnoreEmptyReturns(boolean aIgnoreEmptyReturns) {
        this.mIgnoreEmptyReturns = aIgnoreEmptyReturns;
    }

    public void setTopLinesToIgnoreCount(int aTopLinesToIgnoreCount) {
        this.mTopLinesToIgnoreCount = aTopLinesToIgnoreCount;
    }

    public ReturnCountExtendedCheck() {
        this.mIgnoreMethodsNames.add("equals");
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    public void visitToken(DetailAST aMethodDefNode) {
        DetailAST openingBrace = aMethodDefNode.findFirstToken(7);
        String methodName = ReturnCountExtendedCheck.getMethodName(aMethodDefNode);
        if (!(openingBrace == null || methodName != null && ReturnCountExtendedCheck.matches(methodName, this.mIgnoreMethodsNames))) {
            int mCurReturnCount;
            DetailAST closingBrace = openingBrace.getLastChild();
            int curMethodLinesCount = ReturnCountExtendedCheck.getLinesCount(openingBrace, closingBrace);
            if (curMethodLinesCount != 0) {
                --curMethodLinesCount;
            }
            if (curMethodLinesCount >= this.mIgnoreMethodLinesCount && (mCurReturnCount = this.getReturnCount(aMethodDefNode, openingBrace)) > this.mMaxReturnCount) {
                String mKey = aMethodDefNode.getType() == 9 ? WARNING_MSG_KEY_METHOD : WARNING_MSG_KEY_CTOR;
                DetailAST methodNameToken = aMethodDefNode.findFirstToken(58);
                this.log(methodNameToken, mKey, new Object[]{methodName, mCurReturnCount, this.mMaxReturnCount});
            }
        }
    }

    private int getReturnCount(DetailAST aMethodDefNode, DetailAST aMethodOpeningBrace) {
        int result = 0;
        DetailAST curNode = aMethodOpeningBrace;
        while (curNode != null && (curNode.getType() != 73 || curNode.getParent() != aMethodOpeningBrace)) {
            if (curNode.getType() == 88 && ReturnCountExtendedCheck.getDepth(aMethodDefNode, curNode) < this.mMinIgnoreReturnDepth && this.shouldEmptyReturnStatementBeCounted(curNode) && ReturnCountExtendedCheck.getLinesCount(aMethodOpeningBrace, curNode) > this.mTopLinesToIgnoreCount) {
                ++result;
            }
            DetailAST nextNode = curNode.getFirstChild();
            int type = curNode.getType();
            if (type == 9 || type == 14) {
                nextNode = curNode.getNextSibling();
            }
            while (curNode != null && nextNode == null) {
                nextNode = curNode.getNextSibling();
                if (nextNode != null) continue;
                curNode = curNode.getParent();
            }
            curNode = nextNode;
        }
        return result;
    }

    private boolean shouldEmptyReturnStatementBeCounted(DetailAST aReturnNode) {
        DetailAST returnChildNode = aReturnNode.getFirstChild();
        return !this.mIgnoreEmptyReturns || returnChildNode == null || returnChildNode.getType() != 45;
    }

    private static int getDepth(DetailAST aMethodDefNode, DetailAST aReturnStmtNode) {
        int result = 0;
        DetailAST curNode = aReturnStmtNode;
        while (!curNode.equals((AST)aMethodDefNode)) {
            int type = (curNode = curNode.getParent()).getType();
            if (type != 83 && type != 89 && type != 91 && type != 85 && type != 84 && type != 95) continue;
            ++result;
        }
        return result;
    }

    private static String getMethodName(DetailAST aMethodDefNode) {
        String result = null;
        for (DetailAST curNode : ReturnCountExtendedCheck.getChildren(aMethodDefNode)) {
            if (curNode.getType() != 58) continue;
            result = curNode.getText();
            break;
        }
        return result;
    }

    private static int getLinesCount(DetailAST aBeginAst, DetailAST aEndAST) {
        return aEndAST.getLineNo() - aBeginAst.getLineNo();
    }

    private static List<DetailAST> getChildren(DetailAST aNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = aNode.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }

    private static boolean matches(String string, Collection<String> patterns) {
        boolean result = false;
        if (string != null && patterns != null && patterns.size() > 0) {
            for (String pattern : patterns) {
                if (!string.matches(pattern)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

