/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class RedundantReturnCheck
extends Check {
    private boolean mAllowReturnInEmptyMethodsAndConstructors = true;

    public void setAllowReturnInEmptyMethodsAndConstructors(boolean aAllowEmptyBlocks) {
        this.mAllowReturnInEmptyMethodsAndConstructors = aAllowEmptyBlocks;
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void visitToken(DetailAST aAst) {
        DetailAST methodObjectBlock = aAst.getLastChild();
        switch (aAst.getType()) {
            case 8: {
                this.checkForRedundantReturn(methodObjectBlock);
                break;
            }
            case 9: {
                if (aAst.findFirstToken(13).findFirstToken(49) == null) break;
                this.checkForRedundantReturn(methodObjectBlock);
                break;
            }
            default: {
                String exception = " Unexpected TokenType -  ";
                throw new IllegalStateException(" Unexpected TokenType -  " + aAst.getText());
            }
        }
    }

    private void checkForRedundantReturn(DetailAST aMethodObjectBlock) {
        int methodChildCount = aMethodObjectBlock.getChildCount();
        if (methodChildCount != 1) {
            int placeForRedundantReturn = aMethodObjectBlock.getLastChild().getPreviousSibling().getType();
            int methodWithSingleChild = 2;
            if (methodChildCount > 2) {
                this.handlePlacesForRedundantReturn(placeForRedundantReturn, aMethodObjectBlock);
            } else {
                if (!this.mAllowReturnInEmptyMethodsAndConstructors) {
                    this.handlePlacesForRedundantReturn(placeForRedundantReturn, aMethodObjectBlock);
                }
                if (placeForRedundantReturn == 95) {
                    this.submitRedundantReturnInTryCatch(aMethodObjectBlock.getFirstChild());
                }
            }
        }
    }

    private void handlePlacesForRedundantReturn(int aType, DetailAST aMethodObjectBlock) {
        if (aType == 88) {
            DetailAST aLastChild = aMethodObjectBlock.getLastChild();
            this.log(aLastChild.getPreviousSibling().getLineNo());
        } else if (aType == 95) {
            this.submitRedundantReturnInTryCatch(aMethodObjectBlock.getFirstChild());
        }
    }

    private void submitRedundantReturnInTryCatch(DetailAST aTryAst) {
        DetailAST astBlockTry = aTryAst.getFirstChild();
        this.handleBlocksTryCatchFinally(astBlockTry.getLastChild().getPreviousSibling());
        int catchBlocksAmount = aTryAst.getChildCount(96);
        for (int i = 0; i < catchBlocksAmount; ++i) {
            astBlockTry = astBlockTry.getNextSibling();
            this.handleBlocksTryCatchFinally(astBlockTry.getLastChild().getLastChild().getPreviousSibling());
        }
        if (astBlockTry.getNextSibling() != null) {
            this.handleBlocksTryCatchFinally(astBlockTry.getNextSibling().getLastChild().getLastChild().getPreviousSibling());
        }
    }

    private void handleBlocksTryCatchFinally(DetailAST aAstReturn) {
        if (aAstReturn != null && aAstReturn.getType() == 88) {
            this.log(aAstReturn.getLineNo());
        }
    }

    private void log(int lineNumber) {
        this.log(lineNumber, "redundant.return", new Object[0]);
    }
}

