/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.Arrays;

public class AvoidConstantAsFirstOperandInConditionCheck
extends Check {
    private int[] mTargetConstantTypes = new int[]{133, 134, 135, 137, 140, 141, 142};

    public void setTargetConstantTypes(String[] aTargets) {
        if (aTargets != null) {
            this.mTargetConstantTypes = new int[aTargets.length];
            for (int i = 0; i < aTargets.length; ++i) {
                this.mTargetConstantTypes[i] = TokenTypes.getTokenId((String)aTargets[i]);
            }
            Arrays.sort(this.mTargetConstantTypes);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{116, 115};
    }

    public void visitToken(DetailAST aDetailAST) {
        if (this.isRefactoringRequired(aDetailAST)) {
            this.log(aDetailAST.getLineNo(), "avoid.constant.as.first.operand.in.condition", new Object[]{aDetailAST.getText()});
        }
    }

    private boolean isRefactoringRequired(DetailAST aLogicNode) {
        DetailAST[] children = this.getBothChildren(aLogicNode);
        DetailAST firstOperand = children[0];
        DetailAST secondOperand = children[1];
        int constantType = firstOperand.getType();
        return this.isTargetConstantType(constantType) && firstOperand.branchContains(constantType) && !secondOperand.branchContains(constantType);
    }

    private DetailAST[] getBothChildren(DetailAST aLogicNode) {
        DetailAST[] children = new DetailAST[2];
        int i = 0;
        for (DetailAST child = aLogicNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() == 76 || child.getType() == 77) continue;
            children[i++] = child;
        }
        return children;
    }

    private boolean isTargetConstantType(int aTargetType) {
        return Arrays.binarySearch(this.mTargetConstantTypes, aTargetType) > -1;
    }
}

